<?php
/**
 * @package     Joomla.Site
 * @subpackage  com_remsearch
 *
 * @copyright   (C) 2011 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\MVC\View\HtmlView;
use Joomla\CMS\Document\Opensearch\OpensearchUrl;

/**
 * OpenSearch View class for the Search component
 *
 * @since  1.7
 */
class SearchViewSearch extends HtmlView
{
	/**
	 * Execute and display a template script.
	 *
	 * @param   string  $tpl  name of the template
	 *
	 * @throws Exception
	 * @return  mixed  A string if successful, otherwise an Error object.
	 */
	public function display($tpl = null)
	{
		$doc = Factory::getDocument();
		$app = Factory::getApplication();

		$params = ComponentHelper::getParams('com_remsearch');
		$doc->setShortName($params->get('opensearch_name', $app->get('sitename')));
		$doc->setDescription($params->get('opensearch_description', $app->get('MetaDesc')));

		// Add the URL for the search
		$searchUri = Uri::base() . 'index.php?option=com_remsearch&searchword={searchTerms}';

		// Find the menu item for the search
		$menu  = $app->getMenu();
		$items = $menu->getItems('link', 'index.php?option=com_remsearch&view=search');

		if (isset($items[0]))
		{
			$searchUri .= '&Itemid=' . $items[0]->id;
		}

		$htmlSearch           = new OpensearchUrl;
		$htmlSearch->template = Route::_($searchUri);
		$doc->addUrl($htmlSearch);
	}
}
