<?php

/**
 * @package     Joomla.Site
 * @subpackage  com_remsearch
 *
 * @copyright   (C) 2006 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Component\Router\RouterBase;

/**
 * Routing class from com_remsearch
 *
 * @since  3.3
 */
class RemsearchRouter extends RouterBase {

    /**
     * Build the route for the com_remsearch component
     *
     * @param   array  &$query  An array of URL arguments
     *
     * @return  array  The URL arguments to use to assemble the subsequent URL.
     *
     * @since   3.3
     */
    public function build(&$query) {
        $segments = array();

        if (isset($query['view'])) {
            unset($query['view']);
        }

        return $segments;
    }

    /**
     * Parse the segments of a URL.
     *
     * @param   array  &$segments  The segments of the URL to parse.
     *
     * @return  array  The URL attributes to be used by the application.
     *
     * @since   3.3
     */
    public function parse(&$segments) {
        $vars = array();

        // Fix up search for URL
        $total = count($segments);

        for ($i = 0; $i < $total; $i++) {
            // Urldecode twice because it is encoded twice
            $stripped = stripcslashes($segments[$i]);
            $decode = urldecode($stripped);
            $segments[$i] = urldecode($decode);
        }

        $searchword = array_shift($segments);
        $vars['searchword'] = $searchword;
        $vars['view'] = 'search';

        return $vars;
    }

    public function preprocess($query) {
        return $query;
    }
}

if (!ComponentHelper::getComponent('com_remsearch', true)->enabled) {

    /**
     * searchBuildRoute
     *
     * These functions are proxies for the new router interface
     * for old SEF extensions.
     *
     * @param   array  &$query  An array of URL arguments
     *
     * @return array
     *
     * @deprecated  4.0  Use Class based routers instead
     */
    function searchBuildRoute(&$query) {
        $router = new RemsearchRouter;

        return $router->build($query);
    }

    /**
     * searchParseRoute
     *
     * These functions are proxies for the new router interface
     * for old SEF extensions.
     *
     * @param   array  $segments  The segments of the URL to parse.
     *
     * @return array
     *
     * @deprecated  4.0  Use Class based routers instead
     */
    function searchParseRoute($segments) {
        $router = new RemsearchRouter;

        return $router->parse($segments);
    }

}