<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_remsearch
 *
 * @copyright   (C) 2009 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Helper\ContentHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\CMS\MVC\View\HtmlView;

/**
 * View class for a list of search terms.
 *
 * @since  1.5
 */
class SearchViewSearches extends HtmlView
{
	protected $enabled;

	protected $items;

	protected $pagination;

	protected $state;

	/**
	 * Display the view.
	 *
	 * @param   string  $tpl  The name of the template file to parse; automatically searches through the template paths.
	 *
	 * @return  mixed  A string if successful, otherwise an Error object.
	 */
	public function display($tpl = null)
	{
		$app                 = Factory::getApplication();
		$this->items         = $this->get('Items');
		$this->pagination    = $this->get('Pagination');
		$this->state         = $this->get('State');
		$this->filterForm    = $this->get('FilterForm');
		$this->activeFilters = $this->get('ActiveFilters');
		$this->enabled       = $this->state->params->get('enabled');
		$this->canDo         = ContentHelper::getActions('com_remsearch');

		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			throw new Exception(implode("\n", $errors), 500);
		}

		// Check if plugin is enabled
		if ($this->enabled)
		{
			$app->enqueueMessage(Text::_('COM_REMSEARCH_LOGGING_ENABLED'), 'notice');
		}
		else
		{
			$app->enqueueMessage(Text::_('COM_REMSEARCH_LOGGING_DISABLED'), 'warning');
		}

		$this->addToolbar();
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @return  void
	 *
	 * @since   1.6
	 */
	protected function addToolbar()
	{
		$canDo = $this->canDo;

		ToolbarHelper::title(Text::_('COM_REMSEARCH_MANAGER_SEARCHES'), 'search');

		$showResults = $this->state->get('show_results', 1, 'int');

		if ($showResults === 0)
		{
			ToolbarHelper::custom('searches.toggleresults', 'zoom-in.png', null, 'COM_REMSEARCH_SHOW_SEARCH_RESULTS', false);
		}
		else
		{
			ToolbarHelper::custom('searches.toggleresults', 'zoom-out.png', null, 'COM_REMSEARCH_HIDE_SEARCH_RESULTS', false);
		}

		if ($canDo->get('core.edit.state'))
		{
			ToolbarHelper::custom('searches.reset', 'refresh.png', 'refresh_f2.png', 'JSEARCH_RESET', false);
		}

		ToolbarHelper::divider();

		if ($canDo->get('core.admin') || $canDo->get('core.options'))
		{
			ToolbarHelper::preferences('com_remsearch');
		}

		ToolbarHelper::divider();
		ToolbarHelper::help('JHELP_COMPONENTS_SEARCH');
	}
}
