<?php

/**
 * @package     Joomla.Administrator
 * @subpackage  com_remsearch
 *
 * @copyright   (C) 2007 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

Use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Controller\BaseController;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Access\Exception\NotAllowed;

JLoader::register('SearchControllerSearches', JPATH_ADMINISTRATOR . '/components/com_remsearch/controllers/remsearches.php');
$controller = BaseController::getInstance('Search');
$userobj = new \Joomla\CMS\User\User();
$application = Factory::getApplication();
$userinfo = $application->getIdentity();
if (empty($userinfo)) {
    $application->loadIdentity();
    $userinfo = $application->getIdentity();
}
$user = empty($userinfo) ? $userobj : $userinfo;

if (!$user->authorise('core.manage', 'com_remsearch')) {
    throw new NotAllowed(Text::_('JERROR_ALERTNOAUTHOR'), 403);
}

$controller->execute($application->input->get('task'));
$controller->redirect();
