<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_remsearch
 *
 * @copyright   (C) 2009 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Controller\BaseController;

/**
 * Methods supporting a list of search terms.
 *
 * @since  1.6
 */
class SearchControllerSearches extends BaseController
{
	/**
	 * Method to reset the search log table.
	 *
	 * @return  boolean
	 */
	public function reset()
	{
		// Check for request forgeries.
		$this->checkToken();

		$model = $this->getModel('Searches');

		if (!$model->reset())
		{
			Factory::getApplication()->enqueueMessage($model->getError(), 'warning');
		}

		$this->setRedirect('index.php?option=com_remsearch&view=searches');
	}

	/**
	 * Method to toggle the view of results.
	 *
	 * @return  boolean
	 */
	public function toggleResults()
	{
		// Check for request forgeries.
		$this->checkToken();

		if ($this->getModel('Searches')->getState('show_results', 1, 'int') === 0)
		{
			$this->setRedirect('index.php?option=com_remsearch&view=searches&show_results=1');
		}
		else
		{
			$this->setRedirect('index.php?option=com_remsearch&view=searches&show_results=0');
		}
	}
}
