<?php

/*
 * The Black Sheep Research Plugin for setting namespace in Joomla < v4
 *
 * This plugin sets the namespace connection
 *
 * Copyright (c) 2024 Black Sheep Research
 * Author: Martin Brampton martin@black-sheep-research.com
 * Web: https://black-sheep-research.com
 * License: GNU General Public License version 2
 */

use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Log\Log;
use BlackSheepResearch\Plugin\System\Diagnostic\Recorder;

\defined('_JEXEC') or die;

class PlgSystemDiagnostic extends CMSPlugin {

    private static $active = false;
    private static $ipaddress = '';
    private static $trace = false;
    private $originalExceptionHandler;
    private $originalErrorHandler;

    public function onAfterInitialise() {
        $pluginNamespace = 'BlackSheepResearch\\Plugin\\System\\Diagnostic';
        $pluginPath = JPATH_SITE . '/plugins/system/diagnostic/';
        \JLoader::registerNamespace($pluginNamespace, $pluginPath, false, false, 'psr4');

        if (Factory::getConfig()->get('debug')) {
            $allowedIps = array_map('trim', explode(',', $this->params->get('ipaddress')));
            self::$active = empty($allowedIps) || in_array(self::getIP(), $allowedIps);
        } else {
            self::$active = false;
        }
    }

    public function onIsActive(): bool {
        return self::$active;
    }

    public function onTraceAll(): bool {
        return self::$trace;
    }

    private static function getIP(): string {
        if (!self::$ipaddress) {
            self::$ipaddress = filter_input(INPUT_SERVER, 'HTTP_CLIENT_IP', FILTER_VALIDATE_IP);
            if (!self::$ipaddress) {
                self::setIPfromForwarder();
            }
            if (!self::$ipaddress) {
                self::$ipaddress = filter_input(INPUT_SERVER, 'REMOTE_ADDR', FILTER_VALIDATE_IP);
                if (!self::$ipaddress) {
                    self::$ipaddress = filter_var(getenv('REMOTE_ADDR'), FILTER_VALIDATE_IP);
                }
            }
        }
        return self::$ipaddress;
    }

    private static function setIPfromForwarder(): void {
        $forwardedIpList = (string) filter_input(INPUT_SERVER, 'HTTP_X_FORWARDED_FOR');
        $forwardIps = array_map('\\trim', explode(',', $forwardedIpList));
        foreach ($forwardIps as $ip) {
            if (filter_var($ip, FILTER_VALIDATE_IP)) {
                self::$ipaddress = $ip;
                return;
            }
        }
    }

    public function onError($error) {
        // Custom error handling code here
        echo Recorder::displayError($error);
        echo Recorder::getFormatted();
        exit;
    }
}
