<?php
/********************************************************************
Product		: LADkit
Date		: 1 December 2023
Copyright	: Les Arbres Design 2017-2023
Contact		: https://www.lesarbresdesign.info
Licence		: GNU General Public License
*********************************************************************/
defined('_JEXEC') or die('Restricted Access'); 

use Joomla\CMS\MVC\View\HtmlView;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Toolbar\ToolbarHelper;

class LadkitViewTime extends HtmlView
{
function display($tpl = null)
{
	LAK_helper::viewStart();
	ToolBarHelper::title("LadKit: ".Text::_('COM_LADKIT_TIME_FUNCTIONS'), 'lad.png');

// set selected timestamp and timezone, if any

    $input = Factory::getApplication()->input;
    $timezone = $input->get('timezone', '', 'STRING');
    if (empty($timezone))
        $timezone = date_default_timezone_get();
    else
        date_default_timezone_set($timezone);
    $timestamp = $input->get('timestamp', '', 'STRING');
    $timezones = self::get_timezones();

// allow selection of timestamp and timezone

	echo '<form method="post" name="adminForm" id="adminForm" class="lad-filterform">';
	echo HTMLHelper::_('form.token');
	echo '<input type="hidden" name="option" value="com_ladkit">';
	echo '<input type="hidden" name="task" value="display">';
	echo '<input type="hidden" name="view" value="time">';
    echo '<div class="regex ladkit-background" style="padding:10px 5px;margin-bottom:6px"> ';
    echo '<div class="lad-filterform-left">'; 
    echo '<label for="timestamp">'.Text::_('COM_LADKIT_TIME').'</label> ';
    echo '<input type="text" name="timestamp" value="'.$timestamp.'" class="form-control lad-input-inline input-medium"> ';
    echo LAK_helper::make_list('timezone', $timezone, $timezones,'style="display:inline-block"');
	echo ' <input id="go" type="submit" name="go" value="'.Text::_('COM_LADKIT_GO').'" class="btn btn-info">';
    echo '</div>';
    echo '<div class="clearfix"></div>';
    echo '</div></form>';

// if user hit the Go button, check the token

    $go = $input->get('go', '', 'string');
    if (!empty($go))
        LAK_helper::checkToken();

// PHP time functions

    if (empty($timestamp))
        $timestamp = time();
   
	echo '<fieldset class="lad-fieldset lad-border width-auto"><legend>PHP</legend>';
    echo '<table class="table table-striped table-bordered table-condensed">';

    echo '<tr><td>time(&nbsp;)</td><td>'.$timestamp.'</td></tr>';
    if (version_compare(PHP_VERSION,"8.1.0","<"))
        {
        echo '<tr><td>strftime(&nbsp;)</td><td>'.strftime("%d %B %Y %H:%M:%S",$timestamp).'</td></tr>';
        echo '<tr><td>gmstrftime(&nbsp;)</td><td>'.gmstrftime("%d %B %Y %H:%M:%S",$timestamp).'</td></tr>';
        }
    echo '<tr><td>date(&nbsp;)</td><td>'.date("d F Y H:i:s",$timestamp).'</td></tr>';
    echo '<tr><td>gmdate(&nbsp;)</td><td>'.gmdate("d F Y H:i:s",$timestamp).'</td></tr>';
    
    echo '<tr><td>Locale</td><td>'.setlocale(LC_ALL,0).'</td></tr>';
    $default_timezone = date_default_timezone_get();
    echo '<tr><td>'.Text::_('COM_LADKIT_TIMEZONE').'</td><td>'.$default_timezone.'</td></tr>';
    $time_zone_object = timezone_open($default_timezone);
    $time_zone_array = timezone_location_get($time_zone_object);
    echo '<tr><td>'.'Country code'.'</td><td>'.$time_zone_array['country_code'].'</td></tr>';
    echo '<tr><td>'.'Latitude'.'</td><td>'.$time_zone_array['latitude'].'</td></tr>';
    echo '<tr><td>'.'Longitude'.'</td><td>'.$time_zone_array['longitude'].'</td></tr>';
    if (($time_zone_array['latitude'] != 0) || ($time_zone_array['longitude'] != 0))
        {
        $date_sun_array = date_sun_info($timestamp,$time_zone_array['latitude'],$time_zone_array['longitude']);
        echo '<tr><td>'.'Sunrise'.'</td><td>'.date("H:i A",$date_sun_array['sunrise']).'</td></tr>';
        echo '<tr><td>'.'Sunset'.'</td><td>'.date("H:i A",$date_sun_array['sunset']).'</td></tr>';
        }
    echo '</table>';
    echo '</fieldset>';

// database time

    $db_version = LAK_helper::db_get_object("SELECT version() as version");
    $db_system_time_zone = LAK_helper::db_get_object("SHOW VARIABLES LIKE 'system_time_zone'");
    $db_time_zone = LAK_helper::db_get_object("SHOW VARIABLES LIKE 'time_zone'");
    $db_time_difference = LAK_helper::db_get_object("SELECT TIMEDIFF(NOW(),UTC_TIMESTAMP()) as time_diff");
    $db_unix_timestamp = LAK_helper::db_get_object("SELECT UNIX_TIMESTAMP() AS timestamp");
    $db_utc_timestamp = LAK_helper::db_get_object("SELECT UTC_TIMESTAMP() AS timestamp");
    $db_now = LAK_helper::db_get_object("SELECT NOW() AS now");

	echo '<fieldset class="lad-fieldset lad-border width-auto"><legend>'.Text::_('COM_LADKIT_DATABASE').'</legend>';
    echo '<table class="table table-striped table-bordered table-condensed">';
    echo '<tr><td>MySql Version</td><td>'.$db_version->version.'</td></tr>';
    echo '<tr><td>System Time Zone</td><td>'.$db_system_time_zone->Value.'</td></tr>';
    echo '<tr><td>Time Zone</td><td>'.$db_time_zone->Value.'</td></tr>';
    echo '<tr><td>TIMEDIFF(NOW(&nbsp;),UTC_TIMESTAMP(&nbsp;))</td><td>'.$db_time_difference->time_diff.'</td></tr>';
    echo '<tr><td>UNIX_TIMESTAMP(&nbsp;)</td><td>'.$db_unix_timestamp->timestamp.'</td></tr>';
    echo '<tr><td>UTC_TIMESTAMP(&nbsp;)</td><td>'.$db_utc_timestamp->timestamp.'</td></tr>';
    echo '<tr><td>NOW(&nbsp;)</td><td>'.$db_now->now.'</td></tr>';
    echo '</table>';
    echo '</fieldset>';

    LAK_helper::viewEnd();
}

static function get_timezones()
{
    $php_timezones = DateTimeZone::listIdentifiers(DateTimeZone::ALL);
    $timezones['UTC'] = 'UTC (GMT)';
    $now = new DateTime('now', new DateTimeZone('UTC'));
    foreach ($php_timezones as $tz) 
        {
        $now->setTimezone(new DateTimeZone($tz));
        $offset = $now->getOffset();
        $timezones[$tz] = self::format_timezone_name($tz).' ('.self::format_GMT_offset($offset).')';
        }
    return $timezones;
}

static function format_GMT_offset($offset) 
{
    $hours = intval($offset / 3600);
    $minutes = abs(intval($offset % 3600 / 60));
    return 'GMT'.($offset ? sprintf('%+03d:%02d', $hours, $minutes) : '');
}

static function format_timezone_name($name) 
{
    $name = str_replace('/', ', ', $name);
    $name = str_replace('_', ' ', $name);
    $name = str_replace('St ', 'St. ', $name);
    return $name;
}

}