<?php
/********************************************************************
Product		: LADkit
Date		: 1 December 2023
Copyright	: Les Arbres Design 2023
Contact		: https://www.lesarbresdesign.info
Licence		: GNU General Public License
*********************************************************************/
defined('_JEXEC') or die('Restricted Access'); 

use Joomla\CMS\MVC\View\HtmlView;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Toolbar\ToolbarHelper;

class LadkitViewFlock extends HtmlView
{
function display($tpl = null)
{
	LAK_helper::viewStart();
	ToolBarHelper::title("LadKit: ".Text::_('COM_LADKIT_FLOCK_FUNCTIONS'), 'lad.png');
    
	$app = Factory::getApplication();
	$tmp_path = $app->get('tmp_path');
	$lock_file_path = $tmp_path.'/ladkit.lock';
	if (!file_exists($lock_file_path))
        {
        if (@touch($lock_file_path) === false)
            {
            echo '<h4>'.Text::sprintf('COM_LADKIT_FLOCK_CREATE_ERROR',$lock_file_path).'</h4>';
            return;
            }
        }

// open file for reading 

    $lock_handle = @fopen($lock_file_path, 'r');
    if ($lock_handle === false) 
        {
        echo '<h4>'.Text::sprintf('COM_LADKIT_FLOCK_OPEN_READ_ERROR',$lock_file_path).'</h4>';
        return false;
        }

// Test exclusive non-blocking lock on a file opened for reading

    $ret = flock($lock_handle, (LOCK_EX | LOCK_NB), $wouldblock);
    echo '<h4>read flock (LOCK_EX | LOCK_NB) => '.($ret ? 'true':'false').', '.($wouldblock ? 'true':'false').'</h4>';
    flock ($lock_handle, LOCK_UN);

// Test exclusive blocking lock on a file opened for reading

    $ret = flock($lock_handle, LOCK_EX, $wouldblock);
    echo '<h4>read flock (LOCK_EX) => '.($ret ? 'true':'false').', '.($wouldblock ? 'true':'false').'</h4>';
    flock ($lock_handle, LOCK_UN);
    fclose($lock_handle);

// open file for writing    

    $lock_handle = @fopen($lock_file_path, 'w');
    if ($lock_handle === false) 
        {
        echo '<h4>'.Text::sprintf('COM_LADKIT_FLOCK_OPEN_READ_ERROR',$lock_file_path).'</h4>';
        return false;
        }

// Test exclusive non-blocking lock on a file opened for writing

    $ret = flock($lock_handle, (LOCK_EX | LOCK_NB), $wouldblock);
    echo '<h4>write flock (LOCK_EX | LOCK_NB) => '.($ret ? 'true':'false').', '.($wouldblock ? 'true':'false').'</h4>';
    flock ($lock_handle, LOCK_UN);

// Test exclusive blocking lock on a file opened for writing

    $ret = flock($lock_handle, LOCK_EX, $wouldblock);
    echo '<h4>write flock (LOCK_EX) => '.($ret ? 'true':'false').', '.($wouldblock ? 'true':'false').'</h4>';
    flock ($lock_handle, LOCK_UN);
    fclose($lock_handle);

// now try to lock the file in two iframes for 1 second - the lock should fail for one of them
// in order to get the iframes to load asynchronously, we have to set their src after the page has loaded
// - and the url's have to be different
// - if the url's are the same, the iframes load consecutively - presumably the browser (Chrome) trying to be clever

    echo '<iframe id="frame1" src="about:blank" width="100%" height="150" style="border:1px solid lightgray;">nf</iframe>';
    echo '<iframe id="frame2" src="about:blank" width="100%" height="150" style="border:1px solid lightgray;">nf</iframe>';

    $app = Factory::getApplication();
    $secret = $app->get('secret');

    $url = Uri::root().'?option=com_ladkit&entry='.$secret.'&tmpl=component&format=raw&task=lock_test';
    $js  = "jQuery('#frame1').attr('src','".$url."&f=1');";
    $js .= "jQuery('#frame2').attr('src','".$url."&f=2');";
    self::domready($js);
}

//-------------------------------------------------------------------------------
// Add some Javascript that will fire when the page is fully loaded
//
static function domready($js)
{
	$document = Factory::getDocument();
	$dom_ready = "\njQuery(document).ready(function() { $js; });";
	$document->addScriptDeclaration($dom_ready);
}
}