<?php
/********************************************************************
Product		: LADkit
Date		: 1 December 2023
Copyright	: Les Arbres Design 2016-2023
Contact		: https://www.lesarbresdesign.info
Licence		: GNU General Public License
*********************************************************************/
defined('_JEXEC') or die('Restricted Access');

use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Uri\Uri;

require_once JPATH_ADMINISTRATOR.'/components/com_ladkit/helpers/ladkit_helper.php';

// Super-user only

if (!Factory::getApplication()->getIdentity()->authorise('core.admin'))
    {
	$app = Factory::getApplication();
    $app->enqueueMessage(Text::_('JERROR_ALERTNOAUTHOR'), 'error');
    return;
    }

HTMLHelper::_('jquery.framework');    

// load our css

$document = Factory::getDocument();
if (substr(JVERSION,0,1) == '3')
    $document->addStyleSheet(Uri::base().'components/com_ladkit/assets/com_ladkit_3x.css?'.filemtime(LAK_ADMIN_ASSETS_PATH.'/com_ladkit_3x.css'));
else
    $document->addStyleSheet(Uri::base().'components/com_ladkit/assets/com_ladkit_4x.css?'.filemtime(LAK_ADMIN_ASSETS_PATH.'/com_ladkit_4x.css'));

$input = Factory::getApplication()->input;
$task = $input->get('task','display', 'STRING');

// create an instance of the controller and tell it to execute $task

require_once(JPATH_ADMINISTRATOR.'/components/com_ladkit/controller.php' );
$controller	= new LADkitController( );
$controller->execute($task);
$controller->redirect();
