<?php
/********************************************************************
Product		: LADkit
Date		: 1 December 2023
Copyright	: Les Arbres Design 2016-2023
Contact		: https://www.lesarbresdesign.info
Licence		: GNU General Public License
*********************************************************************/
//
// The file manager and database manager are called directly as the "src" of an iframe
// To prevent unauthorised users running those scripts, this file is included at the top of both of them
// We must instantiate Joomla and check that the user is logged in as a Joomla administrator
// JVERSION is not initialised yet so we must find another way to know if this is Joomla 3 or 4/5 ...
//
use Joomla\CMS\Factory;

define('_JEXEC', 1);

// get the Joomla version

define('JPATH_BASE', realpath(dirname(__FILE__).'/../../../'));  // the administrator directory
$v = file_get_contents(JPATH_BASE.'/../libraries/src/Version.php');
$major_version = preg_match("/MAJOR_VERSION = (\d+);/",$v, $output_array);
$major_version = $output_array[1];

// instantiate Joomla

require_once JPATH_BASE.'/includes/defines.php';
require_once JPATH_BASE.'/includes/framework.php';
if ($major_version == 3)
    {
    Factory::getApplication('administrator');
    $app = Joomla\CMS\Factory::getApplication();
    }
else
    {
    $container = Factory::getContainer();
    $container->alias('session.web', 'session.web.administrator')
        ->alias('session', 'session.web.administrator')
        ->alias('Session', 'session.web.administrator')
        ->alias(\Joomla\CMS\Session\Session::class, 'session.web.administrator')
        ->alias(\Joomla\Session\Session::class, 'session.web.administrator')
        ->alias(\Joomla\Session\SessionInterface::class, 'session.web.administrator');
    $app = $container->get(\Joomla\CMS\Application\AdministratorApplication::class);
    Factory::$application = $app;
    }

// get the logged in user
// Factory::getUser() no longer works in Joomla 5 and $app->getIdentity() doesn't work before calling $app->execute()

$user = $app->getSession()->get('user');
if (empty($user))
    die('Not logged in');
if (!$user->authorise('core.admin'))
    die('You are not a Super User'); 