<?php
/********************************************************************
Product		: Multiple
Date		: 4 December 2023
Copyright	: Les Arbres Design 2010-2023
Contact		: https://www.lesarbresdesign.info
Licence		: GNU General Public License
*********************************************************************/
defined('_JEXEC') or die('Restricted Access');

use Joomla\CMS\Form\Field\ListField;

class JFormFieldLadtimezone extends ListField
{
protected $type = 'ladtimezone';

protected function getOptions()
{
	$options = parent::getOptions();                    // array of objects
    foreach ($options as $option)
        $timezones[$option->value] = $option->text;     // array of texts
    $php_timezones = DateTimeZone::listIdentifiers(DateTimeZone::ALL);
    $timezones['UTC'] = 'UTC (GMT)';
    $now = new DateTime('now', new DateTimeZone('UTC'));
    foreach ($php_timezones as $timezone) 
        {
        $now->setTimezone(new DateTimeZone($timezone));
        $offset = $now->getOffset();
        $timezones[$timezone] = self::format_timezone_name($timezone).' ('.self::format_GMT_offset($offset).')';
        }
	return $timezones;
}

static function format_GMT_offset($offset) 
{
    $hours = intval($offset / 3600);
    $minutes = abs(intval($offset % 3600 / 60));
    return 'GMT'.($offset ? sprintf('%+03d:%02d', $hours, $minutes) : '');
}

static function format_timezone_name($name) 
{
    $name = str_replace('/', ', ', $name);
    $name = str_replace('_', ' ', $name);
    $name = str_replace('St ', 'St. ', $name);
    return $name;
}

}