<?php
/********************************************************************
Product		: LadKit
Date		: 25 January 2024
Copyright	: Les Arbres Design 2017-2024
Contact		: https://www.lesarbresdesign.info
Licence		: GNU General Public License
*********************************************************************/
defined('_JEXEC') or die('Restricted Access');

use Joomla\CMS\MVC\Controller\BaseController;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;

class LadKitController extends BaseController
{
function display($cachable = false, $urlparams = false)
{		
    $input = Factory::getApplication()->input;
    $view_name = $input->get('view','', 'string');	
	$view = $this->getView($view_name,'html');
	$view->display();
}

// -------------------------------------------------------------------------------
// handle input from the front end error view
// - produce the PHP error required
//
function error()
{
    $input = Factory::getApplication()->input;
    $error_type = $input->get('error_type',0, 'int');	
	switch ($error_type)
		{
		case 1: $a = $b; break;                                 // Undefined variable
		case 2: require(dirname(__FILE__).'/inc.php'); break;   // Array and string offset access syntax with curly braces is deprecated in PHP 7.4
		case 3: $a->x = 1; break;                               // Creating default object from empty value
		case 4: abc(); break;                                   // Call to undefined function
		case 5: $a = 0; $b = 1; $c = $b/$a; break;              // divide by zero
		case 6: throw new Exception('LADkit Exception Test'); break;
		case 7: $a = 'a' + 1;									// PHP 8 Unsupported operand types: string + int
		case 8: $a = strftime('Y');								// PHP 8.1 Function strftime() is deprecated
		}
	$view = $this->getView('error','html');
	$view->display();
}

// -------------------------------------------------------------------------------
// delete the front end session data
//
function delete_session()
{
	$session = Factory::getApplication()->getSession();
	$session->destroy();
	$app = Factory::getApplication();
	$secret = $app->get('secret');
	$this->setRedirect(Uri::root().'index.php?option=com_ladkit&task=session&tmpl=component&entry='.$secret);
}

// -------------------------------------------------------------------------------
// show the front end session data - in an iframe in the back end
//
function session()
{
	$this->load_css();
	$session = Factory::getSession();
	if (substr(JVERSION,0,1) == '3')
		$sd = $session->getData();      // this only works in Joomla 3
	else
		$sd = $session->all();          // this only works in Joomla 4/5
	echo '<form method="post" >';
	echo '<input type="hidden" name="option" value="com_ladkit">';
	echo '<input type="hidden" name="task" value="delete_session">';
	echo '<div style="text-align:right"><button type="submit">'.Text::_('JCLEAR').'</button></div>';
	echo '</form>';
	echo '<pre style="font-size:12px;line-height:15px">';
	print_r($sd);
	echo '</pre>';
}

// -------------------------------------------------------------------------------
// show the front end user data
// Factory::getUser() is superceded by Factory::getApplication()->getIdentity() 
// but Factory::getApplication()->getIdentity() does not work properly in Joomla 3 front end
//  (in Joomla 3 it returns null if no user is logged in)
// Factory::getApplication()->getIdentity() does work properly in in Joomla 4 and 5
//
function user()
{
	$this->load_css();
	$user = Factory::getApplication()->getIdentity();	// returns null in Joomla 3 front end if no user logged in
	echo "<pre>";
	echo "getIdentity() returned ".gettype($user);
	if (empty($user) || ($user->guest))
		echo " - no user logged in";
	else
		echo " - a user is logged in";
	echo "<br>";
	print_r($user);
	echo "</pre>";
	if (substr(JVERSION,0,1) == '3')
		{
		$user = Factory::getUser();
		echo "<pre>";
		echo "getUser() returned ".gettype($user);
		if (empty($user) || ($user->guest))
			echo " - no user logged in";
		else
			echo " - a user is logged in";
		echo "<br>";
		print_r($user);
		echo "</pre>";
		}
	echo "user->id is type ".gettype($user->id).'<br>';
	echo "user->name is type ".gettype($user->name).'<br>';
	echo "user->username is type ".gettype($user->username).'<br>';
}

// -------------------------------------------------------------------------------
// show the front end $_SERVER array
//
function server()
{
	$this->load_css();
    $input = Factory::getApplication()->input;
	echo "<pre>";
	print_r($input->server->getArray());
	echo "</pre>";
}

// -------------------------------------------------------------------------------
// show the front end Cookies
//
function cookies()
{
	$this->load_css();
    $input = Factory::getApplication()->input;
	echo "<pre>";
	print_r($input->cookie->getArray());
	echo "</pre>";
}

// -------------------------------------------------------------------------------
// called by the two iframes in the file lock test view
//
function lock_test()
{
	echo 'iframe load starting at '.date('H:i:s');
	$app = Factory::getApplication();
	$tmp_path = $app->get('tmp_path');
	$lock_file_path = $tmp_path.'/ladkit.lock';

// test with the file open for reading

	$lock_handle = @fopen($lock_file_path, 'r');
	if ($lock_handle === false) 
		{
		echo "fopen failed, cannot continue.";
		return;
		}
	$ret = flock($lock_handle, (LOCK_EX | LOCK_NB), $wouldblock);
	echo '<br>Read flock (LOCK_EX | LOCK_NB) '.($ret ? 'true':'false').', '.($wouldblock ? 'true':'false').' at '.date('H:i:s');
	if (!$ret || $wouldblock)
		echo '<br>Read flock: <span style="color:red">Failed to acquire lock</span>';
	else
		{
		echo '<br>Read flock: <span style="color:green">Lock acquired</span>';
		sleep(1);
		}
	if ($lock_handle !== false) 
		{
		flock ($lock_handle, LOCK_UN);
		echo '<br>Unlocked at '.date('H:i:s');
		fclose($lock_handle);
		}

// test with the file open for writing

	$lock_handle = @fopen($lock_file_path, 'w');
	if ($lock_handle === false) 
		{
		echo "fopen failed, cannot continue.";
		return;
		}
	$ret = flock($lock_handle, (LOCK_EX | LOCK_NB), $wouldblock);
	echo '<br>Write flock (LOCK_EX | LOCK_NB) '.($ret ? 'true':'false').', '.($wouldblock ? 'true':'false').' at '.date('H:i:s');
	if (!$ret || $wouldblock)
		echo '<br>Write flock: <span style="color:red">Failed to acquire lock</span>';
	else
		{
		echo '<br>Write flock: <span style="color:green">Lock acquired</span>';
		sleep(1);
		}
	if ($lock_handle !== false) 
		{
		flock ($lock_handle, LOCK_UN);
		echo '<br>Unlocked at '.date('H:i:s');
		fclose($lock_handle);
		}
}

function load_css()
{
$css = '<style>
	pre {
    padding: 8.5px;
    line-height: 18px;
    word-break: break-all;
    word-wrap: break-word;
    white-space: pre;
    white-space: pre-wrap;
    background-color: #f5f5f5;
    border: 1px solid #ccc;
    border-radius: 3px;
}
    </style>';
	$document = Factory::getDocument();
	$document->addCustomTag($css);	
}

}