<?php
/********************************************************************
Product		: LADkit
Date		: 1 December 2023
Copyright	: Les Arbres Design 2016-2023
Contact		: https://www.lesarbresdesign.info
Licence		: GNU General Public License
*********************************************************************/
defined('_JEXEC') or die('Restricted Access'); 

use Joomla\CMS\MVC\View\HtmlView;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Toolbar\ToolbarHelper;

class LadkitViewSite extends HtmlView
{
function display($tpl = null)
{
    $app = Factory::getApplication();
    $secret = $app->get('secret');

	LAK_helper::viewStart();
	ToolBarHelper::title("LadKit: ".Text::_('COM_LADKIT_SITE_VIEW'), 'lad.png');
    
    if (substr(JVERSION,0,1) == '3')
       	HTMLHelper::_('behavior.tabstate');
    echo HTMLHelper::_(LAK_TAB_UI.'.startTabSet','info_tabs', array('active' => 'tab1'));

// Show the contents of the front end session

    echo HTMLHelper::_(LAK_TAB_UI.'.addTab', 'info_tabs', 'tab1', Text::_('COM_LADKIT_FRONT_SESSION'));    
    $url = Uri::root().'?option=com_ladkit&entry='.$secret.'&tmpl=component&task=session';
    echo '<iframe src="'.$url.'" width="100%" height="750" style="border:1px solid lightgray;">nf</iframe>';
    echo HTMLHelper::_(LAK_TAB_UI.'.endTab');
        
// Show the contents of the front end user data structure

    echo HTMLHelper::_(LAK_TAB_UI.'.addTab', 'info_tabs', 'tab2', Text::_('COM_LADKIT_FRONT_USER'));
    $url = Uri::root().'?option=com_ladkit&entry='.$secret.'&tmpl=component&task=user';
    echo '<iframe src="'.$url.'" width="100%" height="750" style="border:1px solid lightgray;">nf</iframe>';
    echo HTMLHelper::_(LAK_TAB_UI.'.endTab');

// Show the contents of the front end $_SERVER array

    echo HTMLHelper::_(LAK_TAB_UI.'.addTab', 'info_tabs', 'tab3', '$_SERVER');
    $url = Uri::root().'?option=com_ladkit&entry='.$secret.'&tmpl=component&task=server';
    echo '<iframe src="'.$url.'" width="100%" height="750" style="border:1px solid lightgray;">nf</iframe>';
    echo HTMLHelper::_(LAK_TAB_UI.'.endTab');

// Show the contents of the front end Cookies

    echo HTMLHelper::_(LAK_TAB_UI.'.addTab', 'info_tabs', 'tab4', 'Cookies');
    $url = Uri::root().'?option=com_ladkit&entry='.$secret.'&tmpl=component&task=cookies';
    echo '<iframe src="'.$url.'" width="100%" height="750" style="border:1px solid lightgray;">nf</iframe>';
    echo HTMLHelper::_(LAK_TAB_UI.'.endTab');

    echo HTMLHelper::_(LAK_TAB_UI.'.endTabSet');
    LAK_helper::viewEnd();
}

}