<?php
/********************************************************************
Product		: LADkit
Date		: 1 December 2023
Copyright	: Les Arbres Design 2017-2023
Contact		: https://www.lesarbresdesign.info
Licence		: GNU General Public License
*********************************************************************/
defined('_JEXEC') or die('Restricted Access'); 

use Joomla\CMS\MVC\View\HtmlView;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;
use Joomla\CMS\Form\Form;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Editor\Editor;
use Joomla\CMS\Session\Session;
use Joomla\CMS\Toolbar\ToolbarHelper;

class LadkitViewJform extends HtmlView
{
function display($tpl = null)
{
	LAK_helper::viewStart();
	ToolBarHelper::title("LadKit: ".Text::_('COM_LADKIT_JFORM'), 'lad.png');
	ToolBarHelper::preferences(LAK_COMPONENT);

    $default_file = '<?xml version="1.0" encoding="utf-8"?>
<form>
   <fieldset name="main" class="lad-fieldset lad-border width-auto">
      <field name="text" type="text" label="Plain Text"/>
      <field name="time_zone" type="ladtimezone" label="Time Zone"/>
   </fieldset>
</form>';
    $form_classes = array('0'=>Text::_('JNONE'), '1'=>'form-horizontal', '2'=>'form-vertical', '3'=>'form-inline', 
                          '4'=>'form-horizontal form-inline', '5'=>'form-vertical form-inline');

    $input = Factory::getApplication()->input;
    $next_tab = 'tab1';
    $form_class = $input->get('form_class', '', 'string');
    $tab = $input->get('tab', '', 'string');
    if (empty($tab))
        {
        if (substr(JVERSION,0,1) == '3')
            $field_path = 'administrator/components/com_ladkit/fields_j3';
        else
            $field_path = 'administrator/components/com_ladkit/fields';
        }
    else
        $field_path = $input->get('field_path', '', 'string');
    if (!is_dir(JPATH_SITE.'/'.$field_path))
        Factory::getApplication()->enqueueMessage(Text::_('COM_LADKIT_DIR_NOT_FOUND').': '.JPATH_SITE.'/'.$field_path, 'error');
    if ($tab == 'edit')
        {
        LAK_helper::checkToken();
        $file_contents = $input->get('file_contents', '', 'raw');
        if (empty($file_contents))
            $file_contents = $default_file;
        file_put_contents(JPATH_ROOT.'/tmp/ladkit_form.xml', $file_contents);
        $next_tab = 'tab2';
        }
    if ($tab == 'form_data')
        $next_tab = 'tab3';

// XML File tab

    echo HTMLHelper::_(LAK_TAB_UI.'.startTabSet', 'form_tabs', array('active' => $next_tab));
    echo HTMLHelper::_(LAK_TAB_UI.'.addTab', 'form_tabs', 'tab1', Text::_('COM_LADKIT_XML_FILE'));
    $select_list = LAK_helper::make_list('form_class', $form_class, $form_classes, 'style="display:inline-block"');
    $editor = Editor::getInstance('codemirror');
    if (file_exists(JPATH_ROOT.'/tmp/ladkit_form.xml'))
        $file_contents = file_get_contents(JPATH_ROOT.'/tmp/ladkit_form.xml');
    else
        $file_contents = $default_file;
	echo '<form method="post" name="adminForm" id="adminForm" class="lad-filterform">';
	echo HTMLHelper::_('form.token');
	echo '<input type="hidden" name="option" value="com_ladkit">';
	echo '<input type="hidden" name="view" value="jform">';
	echo '<input type="hidden" name="tab" value="edit">';
    echo '<div class="ladkit-background" style="padding:10px 5px;margin-bottom:6px"> ';
    echo '<div class="lad-filterform-left">'; 
    echo Text::_('COM_LADKIT_FIELD_PATH').': JPATH_SITE/';
    echo '<input type="text" name="field_path" value="'.$field_path.'" class="form-control lad-input-inline input-xlarge">';
    echo ' '.Text::_('COM_LADKIT_FORM_CLASS').' '.$select_list;
	echo '</div>'; 
	echo '<div class="lad-filterform-right">';
	echo ' <input id="go" type="submit" name="go" value="'.Text::_('COM_LADKIT_GO').'" class="btn btn-info">';
	echo '</div>'; 
    echo '<div class="clearfix"></div>';
    echo '</div>';  // ladkit-background
    echo $editor->display('file_contents', $file_contents,'98%','','','',false,'','','',array('syntax' => 'xml'));
    echo '</form>';
    echo HTMLHelper::_(LAK_TAB_UI.'.endTab');

// Rendered Form tab

    echo HTMLHelper::_(LAK_TAB_UI.'.addTab', 'form_tabs', 'tab2', Text::_('COM_LADKIT_RENDERED_FORM'));
    if (!empty($field_path))
    	Form::addFieldPath(JPATH_SITE.'/'.$field_path);
    try {
        $form = Form::getInstance('test', JPATH_ROOT.'/tmp/ladkit_form.xml');
        $form_ok = true;
        }
    catch (RuntimeException $e) {
        echo "<br>Form::getInstance() exception: ".$e->getMessage();
        $form_ok = false;
        }
    if ($form_ok)
        {
        if (empty($form_class))
            {
            $class_attribute = 'class="lad-filterform"';
            $class = '';
            }
        else
            {
            $class_attribute=' class="lad-filterform '.$form_classes[$form_class].'"';
            $class = $form_classes[$form_class];
            }
        echo '<form method="post" name="adminForm" id="adminForm"'.$class_attribute.'>';
    	echo HTMLHelper::_('form.token');
        echo '<input type="hidden" name="option" value="com_ladkit">';
        echo '<input type="hidden" name="view" value="jform">';
        echo '<input type="hidden" name="tab" value="form_data">';
        echo '<input type="hidden" name="form_class" value="'.$form_class.'">';
        echo '<input type="hidden" name="field_path" value="'.$field_path.'">';
        echo '<div class="ladkit-background" style="padding:10px 5px;margin-bottom:6px"> ';
        echo '<div class="lad-filterform-left">'; 
        if (empty($field_path))
            echo Text::_('COM_LADKIT_FIELD_PATH').': '.Text::_('JNONE');
        else
            echo Text::_('COM_LADKIT_FIELD_PATH').': JPATH_SITE/'.$field_path;
        echo '<br>';
        if (empty($class))
            echo Text::_('COM_LADKIT_FORM_CLASS').': '.Text::_('JNONE');
        else
            echo Text::_('COM_LADKIT_FORM_CLASS').': '.$class;
        echo '</div>'; 
        echo '<div class="lad-filterform-right">';
        echo ' <input id="go" type="submit" name="go" value="'.Text::_('COM_LADKIT_GO').'" class="btn btn-info">';
        echo '</div>'; 
        echo '<div class="clearfix"></div>';
        echo '</div>';  // ladkit-background
        $field_sets = $form->getFieldsets();        
        foreach ($field_sets as $fieldset_name => $fieldset)
            {
            if (isset($fieldset->class))
                echo '<fieldset class="'.$fieldset->class.'">';
            else
                echo '<fieldset>';
            if (!empty($fieldset->label))
                echo '<legend>'.Text::_($fieldset->label).'</legend>';
            try {
                echo $form->renderFieldset($fieldset_name);
                }
            catch (\Exception $e) {
                $ec = get_class($e);
                echo '<span style="color:red;">'.'Fieldset "'.$fieldset_name.'" error: '.$e->getMessage().'</span>';
                }
            echo '</fieldset>';
            }
        echo '</form>';
        }
    echo HTMLHelper::_(LAK_TAB_UI.'.endTab');
        
// Post Data tab

    echo HTMLHelper::_(LAK_TAB_UI.'.addTab', 'form_tabs', 'tab3', Text::_('COM_LADKIT_POST_DATA'));
    if ($tab == 'form_data')
        {
        LAK_helper::checkToken();
        $input = Factory::getApplication()->input;
        $post = $input->post->getArray();
        $token = Session::getFormToken();
        unset($post[$token]);
        unset($post['option']);
        unset($post['view']);
        unset($post['tab']);
        unset($post['form_class']);
        echo '<pre>'.htmlspecialchars(print_r($post,true)).'</pre>';
        }
    else
        echo Text::_('COM_LADKIT_SUBMIT_FOR_DATA');
    echo HTMLHelper::_(LAK_TAB_UI.'.endTab');

    echo HTMLHelper::_(LAK_TAB_UI.'.endTabSet');
    LAK_helper::viewEnd();
}

}