<?php
/********************************************************************
Product		: LADkit
Date		: 16 May 2024
Copyright	: Les Arbres Design 2017-2024
Contact		: https://www.lesarbresdesign.info
Licence		: GNU General Public License
*********************************************************************/
defined('_JEXEC') or die('Restricted Access'); 

use Joomla\CMS\MVC\View\HtmlView;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Toolbar\ToolbarHelper;

class LadkitViewIcons extends HtmlView
{
function display($tpl = null)
{
	LAK_helper::viewStart();
	ToolBarHelper::title("LadKit: ".Text::_('COM_LADKIT_ICON_CLASSES'), 'lad.png');

// allow selection of font size and colour

    $input = Factory::getApplication()->input;
    $class = '';
    if ($input->get('btn_blue',0, 'int'))
        $class = ' blue';
    if ($input->get('btn_red',0, 'int'))
        $class = ' red';
	echo '<form method="post" name="adminForm" id="adminForm" class="lad-filterform">';
	echo HTMLHelper::_('form.token');
	echo '<input type="hidden" name="option" value="com_ladkit">';
	echo '<input type="hidden" name="task" value="display">';
	echo '<input type="hidden" name="view" value="icons">';
    echo '<div class="lad-filterform-right">'; 
	echo ' <button type="submit" class="btn btn-lad-dark btn-inverse" name="btn-black" value="1">&nbsp;</button>'; // btn-inverse for Joomla 3
	echo ' <button type="submit" class="btn btn-lad-blue" name="btn_blue" value="1">&nbsp;</button>';
	echo ' <button type="submit" class="btn btn-lad-red" name="btn_red" value="1">&nbsp;</button>';
    echo '</div></form>';

    $template = Factory::getApplication()->getTemplate();
    self::show_icons(JPATH_ROOT.'/administrator/templates/'.$template.'/css/vendor/fontawesome-free/fontawesome.css',$class);
    self::show_icons(JPATH_ROOT.'/media/templates/administrator/'.$template.'/css/vendor/fontawesome-free/fontawesome.css',$class);    
    self::show_icons(JPATH_ROOT.'/administrator/templates/'.$template.'/css/template.css',$class);
    self::show_icons(JPATH_ROOT.'/media/templates/administrator/'.$template.'/css/template.css',$class);
    self::show_icons(JPATH_ROOT.'/media/jui/css/icomoon.css',$class);

    LAK_helper::viewEnd();
}

//------------------------------------------------------------------------------
// Show a table of the icon classes in a css file
//
function show_icons($file_path, $class, $minified=false)
{
	if (!file_exists($file_path))
        return;

    if ($minified)
        {
        $file_contents = file_get_contents($file_path);
        $file_contents = str_replace('}.', '},.', $file_contents);
        $lines = explode(',', $file_contents);
        }
    else
        $lines = file($file_path,FILE_SKIP_EMPTY_LINES);
        
    $icon_array = array();
    $match_array = array();
    foreach ($lines as $line)
        {
        $sublines = explode(',', $line);        // handle lines like .icon-plus-2::before, .icon-new::before,
        foreach ($sublines as $subline)
            if (preg_match("/\.icon-(.*?):/",$subline, $match_array))  // ? is the "lazy" operator, so the regex grabs as little as possible before matching the :
                {
                if ($match_array[1] == 'link-hover')
                    continue;
                $icon_array[] = $match_array[1];                     // (otherwise it gets confused by things like .icon-exit:before{content:""}
                }
        }
    if (empty($icon_array))
        return;

    sort($icon_array);
    echo '<br>'.Text::sprintf('COM_LADKIT_X_ICONS_IN_X',count($icon_array),$file_path).'<br><br>';
    
    foreach ($icon_array as $icon)
        {
        echo '<div class="ladcell'.$class.'">';
        echo '<i class="icon-'.$icon.'"></i><span>'.$icon.'</span>';
        echo '</div>';
        }
    echo '<br>';
}

}