<?php
/********************************************************************
Product		: Ladkit
Date		: 1 December 2023
Copyright	: Les Arbres Design 2016-2023
Contact		: https://www.lesarbresdesign.info
Licence		: GNU General Public License
*********************************************************************/
defined('_JEXEC') or die('Restricted Access');

use Joomla\CMS\Factory;
use Joomla\CMS\Installer\Installer;
use Joomla\CMS\HTML\HTMLHelper;

class com_ladkitInstallerScript
{
var $db;
var $previous_component_version;

public function preflight($type, $parent) 
{
    if (defined('JVERSION'))
        $joomla_version = JVERSION;         // get the Joomla version (JVERSION did not exist before Joomla 2.5)
    else
        $joomla_version = '1.x';
        
    $app = Factory::getApplication();

	if (version_compare(PHP_VERSION,"5.3.0","<"))
		{
        $app->enqueueMessage("LADkit requires at least PHP 5.3.0. Your version is ".PHP_VERSION, 'error');
		return false;
		}

	if (version_compare($joomla_version,"3.10.0","<"))
		{
        $app->enqueueMessage("Ladkit requires at least Joomla 3.10.0 This is $joomla_version ", 'error');
		return false;
		}

// get the previously installed version, if any

	if (file_exists(JPATH_ADMINISTRATOR.'/components/com_ladkit/ladkit.xml'))
		{
		$xml_array = Installer::parseXMLInstallFile(JPATH_ADMINISTRATOR.'/components/com_ladkit/ladkit.xml');
		$this->previous_component_version = $xml_array['version'];
		}

	return true;
}

public function uninstall($parent)
{ 
	$app = Factory::getApplication();
	$tmp_path = $app->get('tmp_path');
    @unlink($tmp_path.'/ladkit.lock');
    @unlink($tmp_path.'/ladkit.txt');
    @unlink($tmp_path.'/ladkit_run.php');
    $app->enqueueMessage("You uninstalled the LADkit component. All of LADkit has been removed", 'notice');
	return true;
}

//-------------------------------------------------------------------------------
// The main install function
//
public function postflight($type, $parent)
{
	if ($type == 'uninstall')
		return;

    $app = Factory::getApplication();

// check the Joomla version

	if (substr(JVERSION,0,1) > "5")
        $app->enqueueMessage("This version of Ladkit has not been tested on this version of Joomla.", 'notice');
		
// get the component version from the component manifest xml file		

    $component_version = $parent->getManifest()->version;

// delete redundant files from older versions

	@unlink(JPATH_SITE.'/administrator/components/com_ladkit/assets/com_ladkit.css');
	@unlink(JPATH_SITE.'/administrator/components/com_ladkit/helpers/loader3.php');
	@unlink(JPATH_SITE.'/administrator/components/com_ladkit/helpers/loader4.php');
	@unlink(JPATH_SITE.'/administrator/components/com_ladkit/helpers/phpFileManager.php');
    self::recurse_delete(JPATH_SITE.'/administrator/components/com_ladkit/helpers/adminer');

    $tmp_path = $app->get('tmp_path');
    $old_code_file = $tmp_path.'/ladkit.txt';
    $new_code_file = $tmp_path.'/ladkit_run.php';
	if (file_exists($old_code_file) && !file_exists($new_code_file))
		{
		$code = file_get_contents($old_code_file);
		file_put_contents($new_code_file, "<?php\n".$code);
		unlink($old_code_file);
		}

// remove redundant http update site, if present

	$this->db = Factory::getDBO();
	$this->ladb_execute_ignore("DELETE FROM `#__update_sites` WHERE `name`= 'LADkit' AND SUBSTRING(`location`,1,5) = 'http:'");

// show the update or install message

	if (isset($this->previous_component_version) && version_compare($this->previous_component_version,$component_version,"<"))
		{
		$url = 'https://www.lesarbresdesign.info/version-history/ladkit';
		$link = HTMLHelper::link($url, $url, 'target="_blank"');
        $app->enqueueMessage("Ladkit updated to version $component_version. Here's what changed: $link", 'message');
		}
    else
	    $app->enqueueMessage("Ladkit version $component_version installed.", 'message');

	return true;
}

//-------------------------------------------------------------------------------
// Execute a SQL query ignoring any errors
//
function ladb_execute_ignore($query)
{
	try
		{
		$this->db->setQuery($query);
		$this->db->execute();
		}
	catch (RuntimeException $e)
		{
		return;
		}
	return;
}

//-------------------------------------------------------------------------------
// Recursively delete a folder and all its contents
//
static function recurse_delete($dir)
{ 
	if (!file_exists($dir))
		return;
    $files = array_diff(scandir($dir), array('.','..')); 
    foreach ($files as $file)
        if (is_dir($dir.'/'.$file))
            self::recurse_delete($dir.'/'.$file);
        else
            unlink($dir.'/'.$file); 
    rmdir($dir); 
}

}