<?php
/********************************************************************
Product		: LADkit
Date		: 1 December 2023
Copyright	: Les Arbres Design 2017-2023
Contact		: https://www.lesarbresdesign.info
Licence		: GNU General Public License
*********************************************************************/
defined('_JEXEC') or die('Restricted Access'); 

use Joomla\CMS\MVC\View\HtmlView;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;
use Joomla\CMS\Http\HttpFactory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Toolbar\ToolbarHelper;

class LadkitViewUrl extends HtmlView
{
function display($tpl = null)
{
	LAK_helper::viewStart();
	ToolBarHelper::title("LadKit: ".Text::_('COM_LADKIT_URL_FUNCTIONS'), 'lad.png');
    $methods = array(1 => 'get_headers', 2 => 'cURL with headers', 3 => 'cURL no headers', 4 => 'file_get_contents', 5 => 'fsockopen/fgets', 6 => 'Joomla getHttp');
    $input = Factory::getApplication()->input;
    $url = $input->get('url','', 'string');
    $method = $input->get('method','', 'string');
	echo '<form method="post" name="adminForm" id="adminForm" class="lad-filterform">';
	echo HTMLHelper::_('form.token');
	echo '<input type="hidden" name="option" value="com_ladkit">';
	echo '<input type="hidden" name="task" value="display">';
	echo '<input type="hidden" name="view" value="url">';
    echo '<div class="ladkit-background" style="padding:10px 5px;margin-bottom:6px"> ';
    echo '<div class="lad-filterform-left">'; 
    echo 'URL: <input type="text" name="url" value="'.$url.'" class="form-control lad-input-inline input-xxlarge">';
    echo ' Method: '.LAK_helper::make_list('method', $method, $methods, 'style="display:inline-block"');
	echo ' <input id="go" type="submit" name="go" value="'.Text::_('COM_LADKIT_GO').'" class="btn btn-info">';
	echo '</div>'; 
	echo '<div class="lad-filterform-right"><span id="time_result"></span></div>';
    echo '<div class="clearfix"></div>';
    echo '</div>'; // ladkit-background
    
// if the form hasn't been submitted yet, don't go any further

    $go = $input->get('go', '', 'string');     // $go will be non-blank if we came here as a result of the Go button
    if (empty($go))
        return;
    LAK_helper::checkToken();
    if (empty($url))
        return;         // nothing to do

    error_reporting(E_ERROR | E_WARNING | E_PARSE);     // make sure we see any errors
    $start_time = microtime(true);
    switch ($method)
        {
        case 1:
            $result = @get_headers($url);
            if ($result === false)
                $result = 'get_headers() returned false';
            else
                $result = print_r($result, true);
            break;
            
        case 2:
            $result = self::get_page_curl($url, true);
            break;

        case 3:
            $result = self::get_page_curl($url, false);
            break;
                        
        case 4:
        	$url = str_replace(" ", "+", $url);
            $result = false;
//            set_error_handler(create_function('$severity, $message, $file, $line','throw new ErrorException($message, $severity, $severity, $file, $line);'));
            try
                {
                $result = @file_get_contents($url);
                }
            catch (Exception $e)
                {
                echo $e->getMessage();
                }
//            restore_error_handler();
            if ($result == false)
                $result = "file_get_contents() returned false";
            break;
        
        case 5:  
            $result = self::get_page_sockets($url, true);
            break;
            
        case 6:  
            $result = self::get_page_joomla($url);
            break;
        }

    echo '<div class="lad-border-pad">';
    echo '<pre style="overflow: scroll">'.htmlspecialchars($result).'</pre>';
    echo '</div>';
    $end_time = microtime(true);    
    $runtime = round(($end_time - $start_time),2);
    echo "<script>document.getElementById('time_result').innerHTML = '$runtime seconds'</script>";    
    LAK_helper::viewEnd();
}

//------------------------------------------------------------------------------
// get a web page with cURL
//
static function get_page_curl($url, $headers)
{
	if (!function_exists('curl_init'))
        return Text::_('COM_LADKIT_CURL_NOT_INSTALLED');
    
    $handle = curl_init($url);
    if ($handle === false)
		return Text::_('COM_LADKIT_CURL_INIT_FAILED');

	curl_setopt($handle, CURLOPT_HEADER, $headers);         // include headers in response
	curl_setopt($handle, CURLOPT_RETURNTRANSFER, true);     // don't echo the content out
	curl_setopt($handle, CURLOPT_SSL_VERIFYHOST, false);    // don't verify SSL certificate
	curl_setopt($handle, CURLOPT_SSL_VERIFYPEER, false);    // don't verify the peer's certificate
	curl_setopt($handle, CURLOPT_CONNECTTIMEOUT, 20);       // seconds to wait for connect
	curl_setopt($handle, CURLOPT_TIMEOUT, 20);              // seconds to wait for data
	curl_setopt($handle, CURLOPT_FOLLOWLOCATION, true);     // follow "Location: " redirects
    curl_setopt($handle, CURLOPT_USERAGENT, "LADkit");
//    curl_setopt($handle, CURLOPT_REFERER, 'https://www.domain.com/');

    $response = curl_exec($handle);
    if ($response === false)
    	return curl_error($handle);
    else
        {
        $curl_info = curl_getinfo($handle);
    	echo '<div class="lad-border-pad"><pre>curl_getinfo() '.print_r($curl_info,true).'</pre></div>';
        $content = curl_multi_getcontent($handle);
        return $content;
        }
        
	curl_close($handle);
	return $response;
}

//------------------------------------------------------------------------------
// get a web page with sockets
//
static function get_page_sockets($url)
{
    $scheme = parse_url($url,PHP_URL_SCHEME);
    $host = parse_url($url,PHP_URL_HOST);
	$path = parse_url($url,PHP_URL_PATH);
	$query = parse_url($url,PHP_URL_QUERY);
	if (!empty($query))
		$path .= '?'.$query;
	$errno = 0;
	$errdesc = '';
    switch ($scheme)
        {
        case 'http':
            $sock = @fsockopen($host, 80, $errno, $errdesc);
            break;
        case 'https':
        	$sock = @fsockopen('tls://'.$host, 443, $errno, $errdesc);
            break;
        case 'udp':
        	$sock = @fsockopen('udp://'.$host, 13, $errno, $errdesc);
            break;
        default:
            return "Unsupported scheme: $scheme";
        }

	if (!$sock)
		return "fsockopen failed $errno $errdesc";

	$request = "GET $path HTTP/1.0\r\n";
	$request .= "Host: $host\r\n";
	$request .= "User-Agent: Joomla\r\n\r\n";
	$length = fwrite($sock, $request);
	if ($length === false)
		return("fwrite failed");
	$hdrs = fgets($sock, 1024);
	if (strstr($hdrs,"200 OK") === false)
		{
		fclose($sock);
		return $hdrs;		// e.g. "HTTP/1.0 400 Bad Request " or "HTTP/1.1 301 Moved Permanently" - you don't get the rest of the headers
		}
	$page = '';
	$headerdone = false;
	while (!feof($sock))
		{
		$buffer = fgets($sock, 1024);
		if ($headerdone)
			$page .= $buffer;					// accummulate the response
		if (strcmp($buffer, "\r\n") == 0)		// blank line indicates end of http header
			$headerdone = true;
		}
	fclose($sock);
	return $page;
}

//------------------------------------------------------------------------------
// get a web page with Joomla
//  $http->get($url, array $headers = null, $timeout = null)
//  $http->post($url, $data, array $headers = null, $timeout = null)
//
static function get_page_joomla($url)
{
    try
        {
        $http = HttpFactory::getHttp();
        $headers = array('userAgent' => 'LADkit');
        $response = $http->get($url, $headers, 20);
        }
    catch (RuntimeException $e)
        {
        $response = new stdClass();
        $response->code = $e->getCode();
        $response->body = $e->getMessage();
        $response->headers = null;
        }
    echo '<div class="lad-border-pad"><pre>Response code: '.$response->code.'</p>';
    echo "Headers: ".print_r($response->headers,true).'</pre></div>';
    return $response->body;
}

}