<?php
/********************************************************************
Product		: LADkit
Date		: 1 December 2023
Copyright	: Les Arbres Design 2017-2023
Contact		: https://www.lesarbresdesign.info
Licence		: GNU General Public License
*********************************************************************/
defined('_JEXEC') or die('Restricted Access'); 

use Joomla\CMS\MVC\View\HtmlView;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Toolbar\ToolbarHelper;

class LadkitViewRegex extends HtmlView
{
function display($tpl = null)
{
	LAK_helper::viewStart();
	ToolBarHelper::title("LadKit: ".Text::_('COM_LADKIT_REGEX_TEST'), 'lad.png');
    
    $input = Factory::getApplication()->input;
    $regex = $input->get('regex','', 'raw');
    $options = $input->get('options','', 'string');
    $delimiter = $input->get('delimiter','/', 'string');
    $search_area = $input->get('search_area','', 'raw');
    $full_regex = $delimiter.$regex.$delimiter.$options;
    $search_array = explode(PHP_EOL,$search_area);
	echo '<form method="post" name="adminForm" id="adminForm" class="lad-filterform">';
	echo HTMLHelper::_('form.token');
	echo '<input type="hidden" name="option" value="com_ladkit">';
	echo '<input type="hidden" name="task" value="display">';
	echo '<input type="hidden" name="view" value="regex">';

// top section - the regex

    echo '<div class="ladkit-background" style="padding:10px 5px;margin-bottom: 6px">';
    echo '<div class="lad-filterform-left">'; 
    echo '<span class="lad-larger lad-bold">Regex: '.$delimiter.'</span>';
    echo '<input type="text" name="regex" value="'.htmlspecialchars($regex).'" class="form-control lad-input-inline input-xxlarge">';
    echo '<span class="lad-larger lad-bold">'.$delimiter.' '.Text::_('JOPTIONS').':</span> ';
    echo '<input type="text" name="options" class="form-control lad-input-inline input-mini" value="'.$options.'">';
	echo ' <input id="go" type="submit" name="go" value="'.Text::_('COM_LADKIT_GO').'" class="btn btn-info">';
    echo LAK_helper::make_help(self::quick_ref());
	echo '</div>'; 
	echo '<div class="lad-filterform-right">';
    echo '<span class="lad-larger lad-bold">'.Text::_('COM_LADKIT_DELIMITER').':</span> <input type="text" name="delimiter" class="form-control lad-input-inline input-mini" value="'.$delimiter.'">';
	echo '</div>';
    echo '<div class="clearfix"></div>';
    echo '</div>';

// left hand side - the input strings to test

    echo '<div class="regex ladkit-background" style="display:inline-block;width:49%;margin-right:1%;padding:6px">';
    echo Text::_('COM_LADKIT_SEARCH_STRINGS').'<br>';
    echo '<textarea name="search_area" class="lad-full-width lad-fixed-font lad-larger" style="height:30em">';
    echo htmlspecialchars($search_area);
    echo '</textarea>';
    echo '</div>';

// if user hit the Go button, check the token

    $go = $input->get('go', '', 'string');
    if (!empty($go))
        LAK_helper::checkToken();
    
// right hand side - the results

    echo '<div class="regex ladkit-background" style="display:inline-block;width:50%;padding:6px;vertical-align:top">';
    echo 'preg_match("'.$full_regex.'",$input_line, $output_array);<br>';
    echo '<hr>';
    set_error_handler(array($this, 'handle_error'));
    foreach ($search_array as $search)
        {
        $search = trim($search);
        $output_array = array();
        $result = preg_match($full_regex,$search,$output_array);
        echo '<span class="result">'.$search.' => '.$result.'</span>';
        if ($result > 0)
            echo '<pre>'.print_r($output_array,true).'</pre>';
        echo '<hr>';
        }
    echo '</div>';
    
    echo '</form>';
    LAK_helper::viewEnd();
}

function handle_error($errno, $errstr, $errfile, $errline)
{
    if ($errno == 16384)    // don't show Joomla deprecations
        return;
    echo $errstr;
}

//-------------------------------------------------------------------------
// Make the Quick Reference text
//
function quick_ref()
{
    $html = '<div class="regex"><strong>'.Text::_('COM_LADKIT_QUICK_REF').'</strong><br>';
    $html .= '<table class="lad-full-width lad-fixed-font ladkit-regex-table">';
    $html .= '<tbody><tr>';
    $html .= '<td>';
    $html .= '<table><tbody>';
    $html .= '<tr><td><code>[abc]</code></td><td>A single character of: a, b or c</td></tr>';
    $html .= '<tr><td><code>[^abc]</code></td><td>Any single character except: a, b, or c</td></tr>';
    $html .= '<tr><td><code>[a-z]</code></td><td>Any single character in the range a-z</td></tr>';
    $html .= '<tr><td><code>[a-zA-Z]</code></td><td>Any single character in the range a-z or A-Z</td></tr>';
    $html .= '<tr><td><code>^</code></td><td>Start of line</td></tr>';
    $html .= '<tr><td><code>$</code></td><td>End of line</td></tr>';
    $html .= '<tr><td><code>\A</code></td><td>Start of string</td></tr>';
    $html .= '<tr><td><code>\z</code></td><td>End of string</td></tr>';
    $html .= '</tbody></table>';
    $html .= '</td>';
    $html .= '<td>';
    $html .= '<table><tbody>';
    $html .= '<tr><td><code>.</code></td><td>Any single character</td></tr>';
    $html .= '<tr><td><code>\s</code></td><td>Any whitespace character</td></tr>';
    $html .= '<tr><td><code>\S</code></td><td>Any non-whitespace character</td></tr>';
    $html .= '<tr><td><code>\d</code></td><td>Any digit</td></tr>';
    $html .= '<tr><td><code>\D</code></td><td>Any non-digit</td></tr>';
    $html .= '<tr><td><code>\w</code></td><td>Any word character (letter, number, underscore)</td></tr>';
    $html .= '<tr><td><code>\pL</code></td><td>Any Unicode character</td></tr>';
    $html .= '<tr><td><code>\W</code></td><td>Any non-word character</td></tr>';
    $html .= '<tr><td><code>\b</code></td><td>Any word boundary</td></tr>';
    $html .= '</tbody></table>';
    $html .= '</td>';
    $html .= '<td>';
    $html .= '<table><tbody>';
    $html .= '<tr><td><code>(...)</code></td><td>Capture everything enclosed</td></tr>';
    $html .= '<tr><td><code>(a|b)</code></td><td>a or b</td></tr>';
    $html .= '<tr><td><code>a?</code></td><td>Zero or one of a</td></tr>';
    $html .= '<tr><td><code>a*</code></td><td>Zero or more of a</td></tr>';
    $html .= '<tr><td><code>a+</code></td><td>One or more of a</td></tr>';
    $html .= '<tr><td><code>a{3}</code></td><td>Exactly 3 of a</td></tr>';
    $html .= '<tr><td><code>a{3,}</code></td><td>3 or more of a</td></tr>';
    $html .= '<tr><td><code>a{3,6}</code></td><td>Between 3 and 6 of a</td></tr>';
    $html .= '</tbody></table>';
    $html .= '</td>';
    $html .= '</tr></tbody></table>';
    $html .= '<br>';
    $html .= '<strong>Options</strong>';
    $html .= '<div>';
    $html .= '<span style="display: inline-block"><code>i</code> case insensitive </span>';
    $html .= '<span style="display: inline-block"><code>m</code> treat as multi-line string </span>';
    $html .= '<span style="display: inline-block"><code>s</code> dot matches newline </span>';
    $html .= '<span style="display: inline-block"><code>x</code> ignore whitespace in regex </span>';
    $html .= '<span style="display: inline-block"><code>A</code> matches only at the start of string </span>';
    $html .= '<span style="display: inline-block"><code>D</code> matches only at the end of string </span>';
    $html .= '<span style="display: inline-block"><code>U</code> non-greedy matching by default</span>';
    $html .= '</div>';
    $html .= '</div>';
    return $html;
}


}