<?php
/********************************************************************
Product		: LADkit
Date		: 1 December 2023
Copyright	: Les Arbres Design 2016-2023
Contact		: https://www.lesarbresdesign.info
Licence		: GNU General Public License
*********************************************************************/
defined('_JEXEC') or die('Restricted Access'); 

use Joomla\CMS\MVC\View\HtmlView;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Toolbar\ToolbarHelper;

class LadkitViewJsmin extends HtmlView
{
function display($tpl = null)
{
	LAK_helper::viewStart();
	ToolBarHelper::title("LadKit: ".Text::_('COM_LADKIT_JS_MIN'), 'lad.png');

// load jsmin.js, and some Javascript to call it

	$document = Factory::getDocument();
	$document->addScript(Uri::base(true).'/components/com_ladkit/assets/jsmin.js');

    $js = "function do_jsmin() {
			document.getElementById('output').value = jsmin('', document.getElementById('input').value, document.getElementById('level').value).trim();
			document.getElementById('stats').style.display = 'block';
			document.getElementById('oldsize').value = jsmin.oldSize;
			document.getElementById('newsize').value = jsmin.newSize;
			document.getElementById('ratio').value = (Math.round(jsmin.newSize / jsmin.oldSize * 1000) / 10) + '%';
		}";
	$document->addScriptDeclaration($js);

    echo '<div class="ladkit-background">';
	echo '<h2>'.Text::_('COM_LADKIT_CODE_INPUT').'</h2>';
    echo '<div>';
	echo '<textarea id="input" name="input" class="lad-full-width lad-fixed-font lad-larger" style="height:14em;"></textarea>';
	echo '</div>';
    echo '<div style="margin-top:6px;">';
	echo '<select id="level" class="form-control" style="width:auto;display:inline-block">';
	echo '<option value="1">'.Text::_('COM_LADKIT_JS_OPT_KEEP').'</option>';
	echo '<option value="2">'.Text::_('COM_LADKIT_JS_OPT_REMOVE').'</option>';
	echo '</select>';
	echo ' <input id="go" type="submit" value="'.Text::_('COM_LADKIT_GO').'" class="btn btn-info" onclick="do_jsmin();return false;">';
    echo '</div>';
	echo '<h2>'.Text::_('COM_LADKIT_OUTPUT').'</h2>';
    echo '<div>';
	echo '<textarea id="output" name="output" class="lad-full-width lad-fixed-font lad-larger" style="height:14em;"></textarea>';
    echo '</div>';
    echo '<div id="stats" style="display:none">';
	echo '<h2>'.Text::_('COM_LADKIT_STATS').'</h2>';
	echo '<input id="oldsize"> '.Text::_('COM_LADKIT_NEW_SIZE').': <input id="newsize"> '.Text::_('COM_LADKIT_RATIO').': <input id="ratio">';
    echo '</div>';
    echo '</div>';
    LAK_helper::viewEnd();
}

}