<?php
/********************************************************************
Product		: LADkit
Date		: 1 December 2023
Copyright	: Les Arbres Design 2016-2023
Contact		: https://www.lesarbresdesign.info
Licence		: GNU General Public License
*********************************************************************/
defined('_JEXEC') or die('Restricted Access'); 

use Joomla\CMS\MVC\View\HtmlView;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Http\HttpFactory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Toolbar\ToolbarHelper;

class LadkitViewIpLoc extends HtmlView
{
function display($tpl = null)
{
	LAK_helper::viewStart();
	ToolBarHelper::title("LadKit: ".Text::_('COM_LADKIT_IP_LOCATION'), 'lad.png');
	ToolBarHelper::preferences(LAK_COMPONENT);

    $browser_ip_address = self::getIPaddress();
    $external_ip_address = self::getExternalIPaddress();
    $host_name = gethostbyaddr($external_ip_address);

    echo '<table class="table table-striped table-bordered table-condensed width-auto">';
    echo '<tr><td>'.Text::_('COM_LADKIT_IP_BROWSER').'</td><td>'.$browser_ip_address.'</td></tr>';
    echo '<tr><td>'.Text::_('COM_LADKIT_IP_SERVER').'</td><td>'.$external_ip_address.'</td></tr>';
    echo '<tr><td>'.Text::_('COM_LADKIT_HOST_NAME').'</td><td>'.$host_name.'</td></tr>';
    echo '</table>';
    
// the default IP address in the input field should be the browser address, unless it is a LAN address,
// in which case it should be the external address

    if (($browser_ip_address == '') or ($browser_ip_address == '::1') or ($browser_ip_address == '127.0.0.1'))
        $default_ip_address = $external_ip_address;
    else
        $default_ip_address = $browser_ip_address;
        
// if we have an IPinfoDB Key in Component Configuration, default it into the input field
// if not, tell the user to go and get a key

    $params = ComponentHelper::getParams(LAK_COMPONENT);
    $ipinfodb_key = $params->get('ipinfodb_key','');
	if ($ipinfodb_key == '')
        {
        $here = '<a href="https://ipinfodb.com/register.php" target="_blank">'.Text::_('COM_LADKIT_HERE').'</a>';
        echo '<p>'.Text::sprintf('COM_LADKIT_INFO_DB_KEY_INFO_X', $here).'</p>';
        }
    $google_maps_key = $params->get('google_maps_key','');
	if ($google_maps_key == '')
        {
        $here = '<a href="https://developers.google.com/maps/documentation/javascript/get-api-key#key" target="_blank">'.Text::_('COM_LADKIT_HERE').'</a>';
        echo '<p>'.Text::sprintf('COM_LADKIT_INFO_DB_KEY_INFO_X', $here).'</p>';
        }

// get input from the form

    $input = Factory::getApplication()->input;
    $input_ip_address = $input->get('ip_address', '', 'string');
    $submit = $input->get('submit', '', 'string');

    if (!empty($input_ip_address))
        $default_ip_address = $input_ip_address;
        
	echo '<form method="post" name="adminForm" id="adminForm">';
	echo HTMLHelper::_('form.token');
	echo '<input type="hidden" name="option" value="com_ladkit">';
	echo '<input type="hidden" name="task" value="display">';
	echo '<input type="hidden" name="view" value="iploc">';
    echo '<h3>'.Text::_('COM_LADKIT_LOCATE_IP_ADDRESS').'</h3>';
    echo Text::_('COM_LADKIT_IP_ADDRESS').': ';
    echo '<input type="text" name="ip_address" value="'.$default_ip_address.'" class="form-control lad-input-inline input-medium" style="vertical-align:middle">';
	echo ' <input id="go" type="submit" name="go" value="'.Text::_('COM_LADKIT_GO').'" class="btn btn-info">';
    echo '</form>';

// if the form hasn't been submitted yet, don't go any further

    $go = $input->get('go', '', 'string');     // $go will be non-blank if we came here as a result of the Go button
    if (empty($go))
        return;
    LAK_helper::checkToken();
        
// if we got here, the user has hit the Go button
// we can't do anything without an IPinfoDB Key
    
    if ($ipinfodb_key == '')
        return;
        
// no point trying to get the location of a local ip address

    if (($input_ip_address == '') || ($input_ip_address == '::1') || ($input_ip_address == '127.0.0.1'))
		return '';

// ok, we have an ip address and an IPinfoDB Key - try to get a location

    $ip_info = self::get_location($ipinfodb_key, $input_ip_address);
    
    if (!is_array($ip_info))
        {
        echo '<br>'.$ip_info;
        return;
        }
   
    echo '<div style="display:inline-block; width:30%; padding: 6px; vertical-align:top;">';
    echo '<table class="table table-striped table-bordered table-condensed width-auto">';
    echo '<tr><td>'.'Country'.'</td><td>'.$ip_info[4].'</td></tr>';
    echo '<tr><td>'.'State/Province'.'</td><td>'.$ip_info[5].'</td></tr>';
    echo '<tr><td>'.'City'.'</td><td>'.$ip_info[6].'</td></tr>';
    echo '<tr><td>'.'Zip or postal code'.'</td><td>'.$ip_info[7].'</td></tr>';
    echo '<tr><td>'.'Timezone'.'</td><td>'.$ip_info[10].'</td></tr>';
    echo '</table>';
    echo '</div>';
    $latitude = $ip_info[8];
    $longitude = $ip_info[9];

// if we have a location, draw a map

    if (($latitude == 0) && ($longitude == 0))
        return;
    
    echo '<div style="display:inline-block; width:65%; padding: 6px; vertical-align:top;">';
    echo self::draw_map($ip_info[6], $latitude, $longitude);
    echo '</div>';
    LAK_helper::viewEnd();
}

//-------------------------------------------------------------------------------
// Get client's IP address
//
static function getIPaddress()
{
	$input = Factory::getApplication()->input;
	if (!empty($input->server->getString('REMOTE_ADDR','')))
		$ip = $input->server->getString('REMOTE_ADDR','');
	elseif (!empty($input->server->getString('HTTP_X_FORWARDED_FOR','')))
		$ip = $input->server->getString('HTTP_X_FORWARDED_FOR','');
	else $ip = $input->server->getString('HTTP_CLIENT_IP','');
	return filter_var($ip, FILTER_VALIDATE_IP);
} 

//-------------------------------------------------------------------------------
// Get our internet IP address
//
static function getExternalIPaddress()
{
	$url = 'https://ipecho.net/plain';
	
    try
        {
        $http = HttpFactory::getHttp();
        $response_array = $http->get($url, array(), 20);
        }
    catch (RuntimeException $e)
        {
        return "getExternalIPaddress: $url failed";
        }

	return $response_array->body;
}

// -------------------------------------------------------------------------------
// Get a location for a given IP address
//
static function get_location($ipinfodb_key, $ip_address)
{
	if ($ipinfodb_key == '')
		return '';
	if ($ip_address == '')
		return '';
		
	$url = 'https://api.ipinfodb.com/v3/ip-city/?key='.$ipinfodb_key.'&ip='.$ip_address;
	
// The response should be something like this: "OK;;183.89.119.34;FR;France"

    try
        {
        $http = HttpFactory::getHttp();
        $response_array = $http->get($url, array(), 20);
        }
    catch (RuntimeException $e)
        {
        return "get_country_by_IP: $url failed";
        }

	$response = $response_array->body;

	if ($response == '?')
		return 'Failed to get page from ipinfodb.com';
	if (substr($response,0,2) != 'OK')
		return 'Bad response from ipinfodb.com: '.$response;
	$parts = explode(';',$response);
//echo '<pre>'.print_r($parts,true).'</pre>';
	if (count($parts) < 5)
		return 'Bad response from ipinfodb.com: '.$response;
	if (strlen($parts[3]) != 2)     // country code should be 2 characters
		return 'Bad response from ipinfodb.com: '.$response;
	return $parts;				    // ok, it's probably correct
}

//-------------------------------------------------------------------------------
// Draw a Google map of the location
//
static function draw_map($marker_title, $latitude, $longitude)
{
    $params = ComponentHelper::getParams(LAK_COMPONENT);
    $key = $params->get('mapbox_key','');
    if (!empty($key))
        return self::draw_mapbox_map($marker_title, $latitude, $longitude, $key);
    $key = $params->get('google_maps_key','');
    if (!empty($key))
        return self::draw_google_map($marker_title, $latitude, $longitude, $key);
    return '';
}

//-------------------------------------------------------------------------------
// Draw a Google map of the location
//
static function draw_google_map($marker_title, $latitude, $longitude, $google_maps_key)
{
	$map_script = '<script>
function initMap() {
   var mapProps = {center:new google.maps.LatLng('.$latitude.','.$longitude.'), zoom:6, mapTypeId:google.maps.MapTypeId.ROADMAP};
   var map=new google.maps.Map(document.getElementById("map"),mapProps);
   var marker1 = new google.maps.Marker({position:{lat:'.$latitude.',lng:'.$longitude.'},map:map,title:"'.$marker_title.'"});
   }
google.maps.event.addDomListener(window, \'load\', initMap);
</script>';
	$document = Factory::getDocument();
    if ($google_maps_key == '')
        $document->addScript("https://maps.googleapis.com/maps/api/js");
    else
        $document->addScript("https://maps.googleapis.com/maps/api/js?key=".$google_maps_key);
	$document->addCustomTag($map_script);
	return '<div id="map" style="width:600px;height:400px"></div>';
}

//-------------------------------------------------------------------------------
// Draw a Mapbox map of the location
//
static function draw_mapbox_map($marker_title, $latitude, $longitude, $mapbox_key)
{
	$map_script = "<script>
function initMap() {
   mapboxgl.accessToken = '".$mapbox_key."';
   var map = new mapboxgl.Map({container:'map', style:'mapbox://styles/mapbox/streets-v12', center:[".$longitude.", ".$latitude."], zoom:9});
   var marker1 = new mapboxgl.Marker().setLngLat([".$longitude.", ".$latitude."]).addTo(map);
   }
jQuery(document).ready(function(){initMap()});   
</script>";
	$document = Factory::getDocument();
    $document->addScript("https://api.mapbox.com/mapbox-gl-js/v2.12.0/mapbox-gl.js");
	$document->addCustomTag($map_script);
    $document->addStyleSheet("https://api.mapbox.com/mapbox-gl-js/v2.12.0/mapbox-gl.css");
	return '<div id="map" style="width:600px;height:400px"></div>';
}

}