<?php
/********************************************************************
Product		: LADkit
Date		: 24 January 2024
Copyright	: Les Arbres Design 2017-2024
Contact		: https://www.lesarbresdesign.info
Licence		: GNU General Public License
*********************************************************************/
defined('_JEXEC') or die('Restricted Access'); 

use Joomla\CMS\MVC\View\HtmlView;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\LanguageHelper;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Toolbar\ToolbarHelper;

class LadkitViewInfo extends HtmlView
{
function display($tpl = null)
{
	LAK_helper::viewStart();
	ToolBarHelper::title("LadKit: ".Text::_('COM_LADKIT_SYSTEM_INFO'), 'lad.png');
	ToolBarHelper::preferences(LAK_COMPONENT);
    $input = Factory::getApplication()->input;

    echo HTMLHelper::_(LAK_TAB_UI.'.startTabSet', 'info_tabs', array('active' => 'tab1'));
    echo HTMLHelper::_(LAK_TAB_UI.'.addTab', 'info_tabs', 'tab1', Text::_('COM_LADKIT_MAIN'));
    self::main_info();
    echo HTMLHelper::_(LAK_TAB_UI.'.endTab');
        
// Show the contents of configuration.php in a separate tab

    echo HTMLHelper::_(LAK_TAB_UI.'.addTab', 'info_tabs', 'tab2', 'configuration.php');
    $config_file = htmlspecialchars(file_get_contents(JPATH_ROOT.'/configuration.php'));
    echo '<pre>'.$config_file.'</pre>';
    echo HTMLHelper::_(LAK_TAB_UI.'.endTab');

// Show the contents of $_SERVER in a separate tab

    echo HTMLHelper::_(LAK_TAB_UI.'.addTab', 'info_tabs', 'tab3', '$_SERVER');
    echo '<pre>'.print_r($input->server->getArray(),true).'</pre>';
    echo HTMLHelper::_(LAK_TAB_UI.'.endTab');

// Show the contents of .htaccess in a separate tab

    echo HTMLHelper::_(LAK_TAB_UI.'.addTab', 'info_tabs', 'tab4', '.htaccess');
	$app = Factory::getApplication();
    $sef_rewrite = $app->get('sef_rewrite');
    if ($sef_rewrite)
        echo "SEF rewrite ON<br>";
    else
        echo "SEF rewrite OFF<br>";
    $htaccess = @file_get_contents(JPATH_SITE.'/.htaccess');
    if (empty($htaccess))
        $htaccess = ".htaccess file not found";
    else
        if (preg_match("/RewriteCond.*tmpl.*component/i", $htaccess))
            echo '<span style="color:red">The .htaccess file has a RewriteRule that may prevent the "tmpl=component" URL parameter from working properly</span><br>';
    $htaccess_safe = htmlspecialchars($htaccess);
    echo '<pre>'.$htaccess_safe.'</pre>';
    echo HTMLHelper::_(LAK_TAB_UI.'.endTab');

// Show the contents of the current session in a separate tab

    echo HTMLHelper::_(LAK_TAB_UI.'.addTab', 'info_tabs', 'tab5', 'Session');
    $session = Factory::getApplication()->getSession();
    if (substr(JVERSION,0,1) == '3')
        $sd = $session->getData();      // this only works in Joomla 3
    else
        $sd = $session->all();          // this only works in Joomla 4/5
    $sd_printable = print_r($sd,true);
    echo '<pre>'.$sd_printable.'</pre>';
    echo HTMLHelper::_(LAK_TAB_UI.'.endTab');

// Show Cookies in a separate tab

    echo HTMLHelper::_(LAK_TAB_UI.'.addTab', 'info_tabs', 'tab6', 'Cookies');
    echo '<pre>';
    print_r($input->cookie->getArray());
    echo '</pre>';
    echo HTMLHelper::_(LAK_TAB_UI.'.endTab');

// Show DNS info in a separate tab

	$host = Uri::getInstance()->getHost();
    if (!strstr($host, 'localhost'))
        {
        echo HTMLHelper::_(LAK_TAB_UI.'.addTab', 'info_tabs', 'tab7', 'DNS');
        $dns = dns_get_record($host, DNS_ALL);
        echo '<pre>';
        print_r($dns);
        echo '</pre>';
        echo HTMLHelper::_(LAK_TAB_UI.'.endTab');
        }

// end of tabs

    echo HTMLHelper::_(LAK_TAB_UI.'.endTabSet');
    LAK_helper::viewEnd();
    self::check_caching();
}

static function main_info()
{
	$langObj = Factory::getLanguage();
	$app = Factory::getApplication();

    echo '<table class="table table-striped table-bordered table-condensed width-auto">';
    $compat_plugin = '';
    if (substr(JVERSION,0,1) == "5")    
        {
        if (PluginHelper::isEnabled('behaviour', 'compat'))
            $compat_plugin = " - compatibility plugin ENABLED";
        else
            $compat_plugin = " - compatibility plugin DISABLED";
        }

    echo '<tr><td>'.'Joomla version'.'</td><td>'.JVERSION.$compat_plugin.'</td></tr>';
    echo '<tr><td>'.'PHP version'.'</td><td>'.phpversion().'</td></tr>';
    echo '<tr><td>'.'PHP Locale'.'</td><td>'.setlocale(LC_ALL,0).'</td></tr>';
    echo '<tr><td>'.'PHP Timezone'.'</td><td>'.date_default_timezone_get().'</td></tr>';

    $db_version = LAK_helper::db_get_object("SELECT version() as version");
    echo '<tr><td>'.'MySql version'.'</td><td>'.$db_version->version.'</td></tr>';
    $db_mode = LAK_helper::db_get_object("SELECT @@SESSION.sql_mode as mode;");
    $db_mode = str_replace(',',', ',$db_mode->mode);
    echo '<tr><td>'.'MySql mode'.'</td><td>'.print_r($db_mode,true).'</td></tr>';


    echo '<tr><td>'.'Server'.'</td><td>'.PHP_OS.'</td></tr>';
    echo '<tr><td>'.'Session'.'</td><td>'.$app->get('lifetime').' minutes ('.$app->get('session_handler').')'.'</td></tr>';
    echo '<tr><td>'.'Joomla Caching'.'</td><td>'.$app->get('caching').'</td></tr>';
	if (PluginHelper::isEnabled('system', 'cache'))
        echo '<tr><td>'.'Sys Cache Plugin'.'</td><td style="color:red;">Enabled</td></tr>';
    else
        echo '<tr><td>'.'Sys Cache Plugin'.'</td><td>Not enabled</td></tr>';
	if (function_exists('get_magic_quotes_gpc') && @get_magic_quotes_gpc())
        echo '<tr><td>'.'Magic Quotes'.'</td><td style="color:red;">'.ON.'</td></tr>';
    echo '<tr><td>'.'Joomla Mailer'.'</td><td>'.$app->get('mailer').'</td></tr>';
    echo '<tr><td>'.'Joomla Mail From'.'</td><td>'.$app->get('mailfrom').'</td></tr>';
    echo '<tr><td>'.'Joomla From Name'.'</td><td>'.$app->get('fromname').'</td></tr>';
    echo '<tr><td>'.'Max upload file size'.'</td><td>'.ini_get('upload_max_filesize').'</td></tr>';
    echo '<tr><td>'.'Uri::root( )'.'</td><td>'.Uri::root().'</td></tr>';
    echo '<tr><td>'.'Uri::root(true)'.'</td><td>'.Uri::root(true).'</td></tr>';
    echo '<tr><td>'.'JPATH_ROOT'.'</td><td>'.JPATH_ROOT.'</td></tr>';
    echo '<tr><td>'.'JPATH_SITE'.'</td><td>'.JPATH_SITE.'</td></tr>';
    echo '<tr><td>'.'JPATH_ADMINISTRATOR'.'</td><td>'.JPATH_ADMINISTRATOR.'</td></tr>';
    echo '<tr><td>'.'Joomla Live_site'.'</td><td>'.$app->get('live_site').'</td></tr>';
	$tmp_dir = $app->get('tmp_path');
	if (is_writable($tmp_dir))
        echo '<tr><td>'.'Temp directory'.'</td><td>'.'Writeable '.$tmp_dir.'</td></tr>';
    else
        echo '<tr><td>'.'Temp directory'.'</td><td style="color:red;">'.'Not Writeable '.$tmp_dir.'</td></tr>';
    echo '<tr><td>'.'Installed languages - site'.'</td><td>';
    $langs = self::get_languages(0);
    $comma = '';
	foreach ($langs as $lang => $name)
        {
		echo $comma.$name;
        $comma = ', ';
        }
    echo '</td></tr>';
    echo '<tr><td>'.'Installed languages - admin'.'</td><td>';
    $langs = self::get_languages(1);
    $comma = '';
	foreach ($langs as $lang => $name)
        {
		echo $comma.$name;
        $comma = ', ';
        }
    echo '</td></tr>';
    
// this is redundant because entry to LADkit backend is only allowed for core.admin

    if (Factory::getApplication()->getIdentity()->authorise('core.admin'))
        $core_admin = Text::_('JYES');
    else
        $core_admin = Text::_('JNO');
    echo '<tr><td>'.'core.admin permission'.'</td><td>'.$core_admin.'</td></tr>';
    echo '<tr><td>'.'DATE_FORMAT_CALENDAR_DATE'.'</td><td>'.Text::_('DATE_FORMAT_CALENDAR_DATE').'</td></tr>';
    
    echo '</table>';
}

// -------------------------------------------------------------------------------
// get an array of languages published on the front end
// this is (more or less) the way the Joomla language switcher does it
// $clientId is 0 for front end, 1 for back end
//
static function get_languages($clientId)
{
    $published_languages = array();
    $languages	= LanguageHelper::getLanguages();
    $sitelangs = LanguageHelper::getInstalledLanguages($clientId);
    foreach ($languages as $i => $language)
        if (array_key_exists($language->lang_code, $sitelangs))
            $published_languages[$language->lang_code] = $language->title;
            
    return $published_languages;
}

//--------------------------------------------------------------------------------------
// if Update Caching is zero, disable our update server as it can cause hundreds of requests per day to our server
//
static function check_caching()
{
    $component = ComponentHelper::getComponent('com_installer');
    $params = $component->params;
    $cache_timeout = $params->get('cachetimeout', 6, 'int');
    if ($cache_timeout == 0)
        {
        $db = Factory::getDBO();
        $query = $db->getQuery(true);
        $query->update($db->quoteName('#__update_sites'));
        $query->set($db->quoteName('enabled') . ' = 0');
        $query->where($db->quoteName('name').' like '.$db->quote('%LADkit%'));
        $db->setQuery($query);
        $db->execute();
        }
}

}