<?php
/********************************************************************
Product		: LADkit
Date		: 16 May 2024
Copyright	: Les Arbres Design 2017-2024
Contact		: https://www.lesarbresdesign.info
Licence		: GNU General Public License
*********************************************************************/
defined('_JEXEC') or die('Restricted Access'); 

use Joomla\CMS\MVC\View\HtmlView;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Editor\Editor;
use Joomla\CMS\Toolbar\ToolbarHelper;

class LadkitViewEval extends HtmlView
{
function display($tpl = null)
{
	LAK_helper::viewStart();
	ToolBarHelper::title("LadKit: ".Text::_('COM_LADKIT_EVAL_PHP'), 'lad.png');
    $app = Factory::getApplication();
    $tmp_path = $app->get('tmp_path');
    $code_file = $tmp_path.'/ladkit_run.php';
	echo '<form method="post" name="adminForm" id="adminForm">';
	echo HTMLHelper::_('form.token');
	echo '<input type="hidden" name="option" value="com_ladkit">';
	echo '<input type="hidden" name="task" value="display">';
	echo '<input type="hidden" name="view" value="eval">';

    $input = Factory::getApplication()->input;
    $php_code = $input->get('php_code', '', 'raw');
    $editor = $input->get('editor', '0', 'string');
    $go = $input->get('go', '', 'string');     // $go will be non-blank if we came here as a result of the Go button
    if (empty($go))
        {
        if (file_exists($code_file))
            {
            $php_code = file_get_contents($code_file); // not the go button so load code from file
            if (substr($php_code,0,6) == "<?php\n")
                $php_code = substr($php_code,6);
            }
        }
    else
        {
        LAK_helper::checkToken();
        if (!empty($php_code))
            file_put_contents($code_file, "<?php\n".$php_code);
        }

    echo '<div class="ladkit-background">';
    if ($editor == 0)
        echo ' <button type="button" class="btn btn-primary" style="float:right;margin-left:5px" onclick="jQuery(\'#php_code\').val(\'\')">'.Text::_('JCLEAR').'</button> ';
    echo ' <div style="float:right;">'.self::editor_selector($editor).'</div>';
	echo '<h2>'.Text::_('COM_LADKIT_CODE_INPUT').'</h2>';
    echo '<div style="clear:both"></div>';
    echo '<div>';
    if ($editor == 1)
        {
        $editor = Editor::getInstance('codemirror');
    	echo $editor->display('php_code', $php_code,'98%','','','',false,'','','',array('syntax' => 'php'));
        }
    else
    	echo '<textarea id="php_code" name="php_code" class="lad-full-width lad-fixed-font" style="height:25em">'.$php_code.'</textarea>';
    
	echo '</div>';
    echo '<div style="margin-top:6px;">';
	echo ' <input id="go" type="submit" name="go" value="'.Text::_('COM_LADKIT_GO').'" class="btn btn-info">';
    echo '</div>';
	echo '<h2>'.Text::_('COM_LADKIT_OUTPUT').'</h2>';
    echo '<div>';
    if (!empty($go) && !empty($php_code))
        {
        if (substr(trim($php_code),-1) != ';')
            $php_code .= ';';
        echo '<pre class="ladkit-pre">';
		ini_set('display_errors', false);   // Prevent PHP displaying runtime errors on its own
        set_error_handler(array($this, 'handle_error'));
        register_shutdown_function(array($this, 'fatal_handler'));
        set_exception_handler(array($this, 'exception_handler'));
       	$start_time = microtime(true);
        try {
            require_once $code_file;
            }
        catch (ParseError $e) { // introduced in PHP 7 but does not cause a problem in older versions of PHP
            echo '<span style="color:red;">-- ParseError '.$e->getMessage().' on line '.$e->getLine().'</span>';
            }
        catch (\Throwable $e) { // PHP 7+
            $ec = get_class($e);
            echo '<span style="color:red;">-- Throwable ['.$ec.'] '.$e->getMessage().' on line '.$e->getLine().'</span>';
            }
        catch (\Exception $e) { // PHP 5
            $ec = get_class($e);
            echo '<span style="color:red;">-- Exception ['.$ec.'] '.$e->getMessage().' on line '.$e->getLine().'</span>';
            }
        restore_error_handler();        // or see lots of errors in Joomla 4
       	$end_time = microtime(true);
        echo '</pre>';
        $runtime = 	($end_time - $start_time) * 1000;   // make it microseconds
        $runtime = round($runtime,4);
        echo Text::sprintf('COM_LADKIT_RUNTIME',$runtime);
        }
    echo '</div>';
    echo '</div>';   // class="ladkit-background"
    echo '</form>';
    LAK_helper::viewEnd();
}

function handle_error($errno, $errstr, $errfile, $errline)
{
    if ($errno == 16384)    // don't show Joomla deprecations
        return;
    echo "-- Error $errno [$errstr] line $errline of $errfile";
}

function fatal_handler() 
{
    $error = error_get_last();
    if (isset($error['type']) == 16384)     // Joomla deprecations
        return;
    if (isset($errno))
        {
        echo "-- Fatal Error $errno [$errstr] line $errline of $errfile";
        return;
        }
    echo "-- Unknown Fatal Error";
}

function exception_handler($e)
{
    echo '<span style="color:red;">-- Fatal Exception '.$e->getMessage().' on line '.$e->getLine().'</span>';
}

//---------------------------------------------------------------------------------------------------------
// if CodeMirror is available show the editor select list
//
function editor_selector($editor)
{
    if (!class_exists('Editor'))
		return '';
        
	if (!file_exists(JPATH_ROOT.'/plugins/editors/codemirror'))
		return '<span style="font-size:smaller;">'.Text::sprintf('COM_LADKIT_X_NOT_INSTALLED','CodeMirror').'</span>';
        
    if (!PluginHelper::isEnabled('editors', 'codemirror'))
		return '<span style="font-size:smaller;">'.Text::sprintf('COM_LADKIT_X_PLUGIN_DISABLED','CodeMirror').'</span>';
        
    $choices = array(0 => 'Textarea', 1=> 'CodeMirror');
    $extra = 'onchange="this.form.submit();"';        
    return LAK_helper::make_list('editor', $editor, $choices, $extra);
}

}