<?php
/********************************************************************
Product		: LADkit
Date		: 1 December 2023
Copyright	: Les Arbres Design 2017-2023
Contact		: https://www.lesarbresdesign.info
Licence		: GNU General Public License
*********************************************************************/
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\MVC\View\HtmlView;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Installer\Installer;
use Joomla\CMS\Http\HttpFactory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Toolbar\ToolbarHelper;

class LadkitViewAbout extends HtmlView
{
function display($tpl = null)
{
	LAK_helper::viewStart();
	ToolBarHelper::title("LadKit: ".Text::_('COM_LADKIT_ABOUT'), 'lad.png');
		
// get the installed version

	$xml_array = Installer::parseXMLInstallFile(JPATH_ADMINISTRATOR.'/components/com_ladkit/ladkit.xml');
	$component_version = $xml_array['version'];

// build the help screen

	$about['name'] = LAK_COMPONENT_NAME;
	$about['prefix'] = 'COM_LADKIT';
	$about['current_version'] = $component_version;
    $about['latest_version'] = $this->get_version('ladkit');      // get the latest version
	$about['reference'] = 'ladkit';
	$about['link_version'] = "https://www.lesarbresdesign.info/version-history/ladkit";
	$about['link_doc'] = "https://www.lesarbresdesign.info/extensions/ladkit";
	$about['link_rating'] = "";
    
    $about['extra'][0]['left'] = '<strong>Simple PHP file manager</strong><br>
        Original code by John Campbell, forked by diego95root to add file editing.<br>
        Licensed under the MIT License.<br>
        Modified by Les Arbres Design under the GPL Licence.';
    $about['extra'][0]['right'] = 'Edit Version<br>'.HTMLHelper::link('https://github.com/diego95root/File-manager-php', 'https://github.com/diego95root/File-manager-php', 'target="_blank"').'<br>'.
        'Original Version<br>'.HTMLHelper::link('https://github.com/jcampbell1/simple-file-manager', 'https://github.com/jcampbell1/simple-file-manager', 'target="_blank"');
   
    $about['extra'][1]['left'] = '<strong>PHP Mini MySQL Admin</strong><br>
        (c) 2004-2017 Oleg Savchuk <osalabs@gmail.com> https://osalabs.com/ <br>
        Light standalone PHP script for quick and easy access MySQL databases.<br>
        Dual licensed: GPL v2 and MIT.';
    $about['extra'][1]['right'] = 'Version 1.9.170730<br>'.HTMLHelper::link('https://sourceforge.net/projects/phpminiadmin/', 'https://sourceforge.net/projects/phpminiadmin/', 'target="_blank"');

    $about['extra'][2]['left'] = '<strong>JSmin - The JavaScript Minifier</strong><br>
        Copyright (c) 2002 Douglas Crockford<br>
        Permission is hereby granted, free of charge, to any person obtaining a copy of
        this software and associated documentation files (the "Software"), to deal in
        the Software without restriction, including without limitation the rights to
        use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
        of the Software, and to permit persons to whom the Software is furnished to do
        so, subject to the following conditions:<br>
         - The above copyright notice and this permission notice shall be included in all
        copies or substantial portions of the Software.<br>
        Javascript version by Franck Marcia, Billy Hoffman, and NanaLich
        under the same conditions as the jsmin.c on which it is based.';
    $about['extra'][2]['right'] = HTMLHelper::link('https://www.crockford.com/jsmin.html', 'https://www.crockford.com/jsmin.html', 'target="_blank"');
   
	$this->draw_about($about);

	LAK_helper::viewEnd();
}

//------------------------------------------------------------------------------
// draw the about screen - this is the same in all our components
//
function draw_about($about)
{
	echo '<h3>'.$about['name'].': '.Text::_($about['prefix'].'_HELP_TITLE').'</h3>';

	if ($about['link_rating'] != '')
		{
		echo '<p><span style="font-size:120%;font-weight:bold;">'.Text::_($about['prefix'].'_HELP_RATING').' ';
		echo HTMLHelper::link($about['link_rating'], 'Joomla Extensions Directory', 'target="_blank"').'</span></p>';
		}

	echo '<table class="table table-striped table-bordered width-auto">';
	
	echo '<tr><td style="width:65%">'.Text::_($about['prefix'].'_VERSION').'</td>';
	echo '<td>'.$about['current_version'].'</td></tr>';
	
	if ($about['latest_version'] != '')
		echo '<tr><td>'.Text::_($about['prefix'].'_LATEST_VERSION').'</td><td>'.$about['latest_version'].'</td></tr>';

	echo '<tr><td>'.Text::_($about['prefix'].'_HELP_CHECK').'</td>';
	echo '<td>'.HTMLHelper::link($about['link_version'], 'Les Arbres Design - '.$about['name'], 'target="_blank"').'</td></tr>';

	echo '<tr><td>'.Text::_($about['prefix'].'_HELP_DOC').'</td>';
	echo '<td>'.HTMLHelper::link($about['link_doc'], "www.lesarbresdesign.info", 'target="_blank"').'</td></tr>';

	echo '<tr><td>'.Text::_($about['prefix'].'_HELP_LES_ARBRES').'</td>';
	echo '<td>'.HTMLHelper::link("https://www.lesarbresdesign.info/", 'Les Arbres Design', 'target="_blank"').'</td></tr>';
		
	if (!empty($about['extra']))
		foreach($about['extra'] as $row)
			echo '<tr><td>'.$row['left'].'</td><td>'.$row['right'].'</td></tr>';

	echo '</table>';
}
	
//------------------------------------------------------------------------------
// get the latest version info
//
function get_version($product)
{
    $url = 'https://www.lesarbresdesign.info/jupdate?product='.$product.'&src=about';
    try
        {
        $http = HttpFactory::getHttp();
        $response = $http->get($url, array(), 20);
        }
    catch (RuntimeException $e)
        {
        return '';
        }
    $version = self::str_between($response->body,'<version>','</version>');
	return $version;
}
				
function str_between($string, $start, $end)
{
    $string = ' '.$string;
    $pos = strpos($string, $start);
    if ($pos == 0)
        return '';
    $pos += strlen($start);
    $len = strpos($string, $end, $pos) - $pos;
    return substr($string, $pos, $len);
}

}