<?php
/********************************************************************
Product		: LADkit
Date		: 1 December 2023
Copyright	: Les Arbres Design 2017-2023
Contact		: https://www.lesarbresdesign.info
Licence		: GNU General Public License
*********************************************************************/
defined('_JEXEC') or die('Restricted Access');

use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Session\Session;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\HTML\Helpers\Sidebar;

define("LAK_COMPONENT", "com_ladkit");
define("LAK_COMPONENT_NAME", "LadKit");
define("LAK_ADMIN_ASSETS_URL", Uri::root(true).'/administrator/components/com_ladkit/assets/');
define("LAK_ADMIN_ASSETS_PATH", JPATH_ROOT.'/administrator/components/com_ladkit/assets/');
if (substr(JVERSION,0,1) == '3')
	define("LAK_TAB_UI", "bootstrap");
else
	define("LAK_TAB_UI", "uitab");

class LAK_helper
{

// -------------------------------------------------------------------------------
// Create the component menu and make the current item active
//
static function addSubMenu($submenu = '')
{
	$component_params = ComponentHelper::getParams(LAK_COMPONENT);
	$params = $component_params->toObject();	
	if (!empty($params->hide_submenu))
		return;
    if (substr(JVERSION,0,1) == '3')
		{
        JHtmlSidebar::addEntry(Text::_('COM_LADKIT_SYSTEM_INFO'), 'index.php?option=com_ladkit&task=display&view=info', $submenu == 'info');
        JHtmlSidebar::addEntry(Text::_('COM_LADKIT_FILE_MANAGER'), 'index.php?option=com_ladkit&task=display&view=diradmin', $submenu == 'diradmin');
        JHtmlSidebar::addEntry(Text::_('COM_LADKIT_DB_MANAGER'), 'index.php?option=com_ladkit&task=display&view=dbadmin', $submenu == 'dbadmin');
        JHtmlSidebar::addEntry(Text::_('COM_LADKIT_ICON_CLASSES'), 'index.php?option=com_ladkit&task=display&view=icons', $submenu == 'icons');
        JHtmlSidebar::addEntry(Text::_('COM_LADKIT_JS_MIN'), 'index.php?option=com_ladkit&task=display&view=jsmin', $submenu == 'jsmin');
        JHtmlSidebar::addEntry(Text::_('COM_LADKIT_REGEXES'), 'index.php?option=com_ladkit&task=display&view=regex', $submenu == 'regex');
        JHtmlSidebar::addEntry(Text::_('COM_LADKIT_TIME_FUNCTIONS'), 'index.php?option=com_ladkit&task=display&view=time', $submenu == 'time');
        JHtmlSidebar::addEntry(Text::_('COM_LADKIT_URL_FUNCTIONS'), 'index.php?option=com_ladkit&task=display&view=url', $submenu == 'url');
        JHtmlSidebar::addEntry(Text::_('COM_LADKIT_IP_LOCATION'), 'index.php?option=com_ladkit&task=display&view=iploc', $submenu == 'iploc');
        JHtmlSidebar::addEntry(Text::_('COM_LADKIT_EVAL_PHP'), 'index.php?option=com_ladkit&task=display&view=eval', $submenu == 'eval');
        JHtmlSidebar::addEntry(Text::_('COM_LADKIT_FLOCK_FUNCTIONS'), 'index.php?option=com_ladkit&task=display&view=flock', $submenu == 'flock');
        JHtmlSidebar::addEntry(Text::_('COM_LADKIT_SITE_VIEW'), 'index.php?option=com_ladkit&task=display&view=site', $submenu == 'site');
        JHtmlSidebar::addEntry(Text::_('COM_LADKIT_JFORM'), 'index.php?option=com_ladkit&task=display&view=jform', $submenu == 'jform');
        JHtmlSidebar::addEntry(Text::_('COM_LADKIT_ABOUT'), 'index.php?option=com_ladkit&task=display&view=about', $submenu == 'about');
        }
    else
		{
        Sidebar::addEntry(Text::_('COM_LADKIT_SYSTEM_INFO'), 'index.php?option=com_ladkit&task=display&view=info', $submenu == 'info');
        Sidebar::addEntry(Text::_('COM_LADKIT_FILE_MANAGER'), 'index.php?option=com_ladkit&task=display&view=diradmin', $submenu == 'diradmin');
        Sidebar::addEntry(Text::_('COM_LADKIT_DB_MANAGER'), 'index.php?option=com_ladkit&task=display&view=dbadmin', $submenu == 'dbadmin');
        Sidebar::addEntry(Text::_('COM_LADKIT_ICON_CLASSES'), 'index.php?option=com_ladkit&task=display&view=icons', $submenu == 'icons');
        Sidebar::addEntry(Text::_('COM_LADKIT_JS_MIN'), 'index.php?option=com_ladkit&task=display&view=jsmin', $submenu == 'jsmin');
        Sidebar::addEntry(Text::_('COM_LADKIT_REGEXES'), 'index.php?option=com_ladkit&task=display&view=regex', $submenu == 'regex');
        Sidebar::addEntry(Text::_('COM_LADKIT_TIME_FUNCTIONS'), 'index.php?option=com_ladkit&task=display&view=time', $submenu == 'time');
        Sidebar::addEntry(Text::_('COM_LADKIT_URL_FUNCTIONS'), 'index.php?option=com_ladkit&task=display&view=url', $submenu == 'url');
        Sidebar::addEntry(Text::_('COM_LADKIT_IP_LOCATION'), 'index.php?option=com_ladkit&task=display&view=iploc', $submenu == 'iploc');
        Sidebar::addEntry(Text::_('COM_LADKIT_EVAL_PHP'), 'index.php?option=com_ladkit&task=display&view=eval', $submenu == 'eval');
        Sidebar::addEntry(Text::_('COM_LADKIT_FLOCK_FUNCTIONS'), 'index.php?option=com_ladkit&task=display&view=flock', $submenu == 'flock');
        Sidebar::addEntry(Text::_('COM_LADKIT_SITE_VIEW'), 'index.php?option=com_ladkit&task=display&view=site', $submenu == 'site');
        Sidebar::addEntry(Text::_('COM_LADKIT_JFORM'), 'index.php?option=com_ladkit&task=display&view=jform', $submenu == 'jform');
        Sidebar::addEntry(Text::_('COM_LADKIT_ABOUT'), 'index.php?option=com_ladkit&task=display&view=about', $submenu == 'about');
        }
}
  
// -------------------------------------------------------------------------------
// Draw the component menu
// - called at the start of every view
//
static function viewStart()
{
    if (substr(JVERSION,0,1) == '3')
        {
    	$entries = JHtmlSidebar::getEntries();
        if (empty($entries))
            echo '<div id="j-main-container">';
        else
            {
            $sidebar = JHtmlSidebar::render();
            echo '<div id="j-sidebar-container" class="span2">'.$sidebar.'</div>';
            echo '<div id="j-main-container" class="span10">';
            }
        }
    else        // Joomla 4/5
        {
    	$entries = Sidebar::getEntries();
		$component_params = ComponentHelper::getParams(LAK_COMPONENT);
		$params = $component_params->toObject();	
		if (empty($params->compact_mode))
	        echo '<div class="row">';
		else
	        echo '<div class="row lad-compact">';
        if (empty($entries))
			echo '<div class="col-md-12">';
        else
            {
            $sidebar = Sidebar::render();
            echo '<div id="j-sidebar-container" class="col-md-2">'.$sidebar.'</div>';
            echo '<div class="col-md-10">';
            echo '<div id="j-main-container" class="j-main-container">';
            }
        }
}

// -------------------------------------------------------------------------------
// Called at the end of every view that calls viewStart()
//
static function viewEnd()
{
    if (substr(JVERSION,0,1) == '3')
    	echo "</div>";                          // close "j-main-container"
    else        // Joomla 4/5
        {
       	echo "</div>";                          // close "j-main-container"
    	$entries = Sidebar::getEntries();
        if (!empty($entries))
        	echo "</div>";                      // close "col-md-10"
       	echo "</div>";                          // close "row"
        }
}

//-------------------------------------------------------------------------------
// Make a checkbox
// $name          : Field name
// $current_value : Current value (boolean)
// $label         : optional label to be added left of checkbox
//
static function make_checkbox($name, $current_value, $label='')
{
	if ($label != '')
		$html .= "\n".'<label for="'.$name.'">'.$label.'&nbsp;'.'</label>';
	if ($current_value)
		$checked = 'checked="checked" ';
	else
		$checked = '';
	$html .= '<input type="checkbox" name="'.$name.'" value="1" id="'.$name.'" '.$checked.'>';
	return $html;
}

//-------------------------------------------------------------------------------
// Make a select list
//
static function make_list($name, $current_value, $items, $extra='')
{
	$html = '<select name="'.$name.'" id="'.$name.'" class="form-control form-select width-auto" '.$extra.'>';
	if ($items == null)
		return '';
	foreach ($items as $key => $value)
		{
		$selected = '';
		if ($current_value == $key)
			$selected = ' selected="selected"';
		$html .= '<option value="'.$key.'"'.$selected.'>'.$value.'</option>';
		}
	$html .= '</select>';
	return $html;
}

//-------------------------------------------------------------------------------
// Make a help button
//
static function make_help($text)
{
    return '<div class="helptip"><span class="icon-info-circle"></span><div>'.$text.'</div></div>';
}

//------------------------------------------------------------------------------
// Save a component parameter
//
static function save_component_param($name, $value)
{
    $params = ComponentHelper::getParams(LAK_COMPONENT);
    $params->set($name, $value);

    $db = Factory::getDBO();
    $query = $db->getQuery(true);
    $query->update($db->quoteName('#__extensions'));
    $query->set($db->quoteName('params').' = '.$db->quote(json_encode($params)));
    $query->where($db->quoteName('element').' = '.$db->quote(LAK_COMPONENT));
    $db->setQuery($query);
    $db->execute();
}

//------------------------------------------------------------------------------
// Get the result of a SQL query
//
static function db_get_object($query)
{
    $db = Factory::getDBO();
	try
		{
		$db->setQuery($query);
		$result = $db->loadObject();
		}
	catch (RuntimeException $e)
		{
    	$app = Factory::getApplication();
		$app->enqueueMessage($e->getMessage(), 'error');
		return false;
		}
	return $result;
}

//------------------------------------------------------------------------------
// check the CSRF token for the back end
//
static function checkToken($method = 'post', $redirect = true)
{
    $valid = Session::checkToken($method);
    if (!$valid && $redirect)
        {
        $input = Factory::getApplication()->input;
        $referrer = $input->server->getString('HTTP_REFERER');
        if (!Uri::isInternal($referrer))
            $referrer = 'index.php';
        $app = Factory::getApplication();
        $app->enqueueMessage(Text::_('JINVALID_TOKEN_NOTICE'), 'warning');
        $app->redirect($referrer);
        }
    return $valid;
}

}