<?php

/**************************************************************
* This file is part of Remository
* Copyright (c) 2006-17 Martin Brampton
* 
* License: GNU General Public License version 2 or later; see LICENSE.txt
* 
* For support and other information, visit http://remository.com
* To contact Martin Brampton, write to martin@remository.com
*
* Remository started life as the psx-dude script by psx-dude@psx-dude.net
* It was enhanced by Matt Smith up to version 2.10
* Since then development has been primarily by Martin Brampton,
* with contributions from other people gratefully accepted
*/

defined('_JEXEC') or die;

class remositorySearchBoxHTML extends remositoryCustomUserHTML {

	public function searchBoxHTML($categories, $catselector, $search_words='', $dropdown=false, $seek_fields_tick=array('search_filetitle'=>true,'search_filedesc'=>true)) {
		$formurl = remositoryRepository::getInstance()->RemositoryBasicFunctionURL('search');
		echo $this->pathwayHTML(null);
		if ($dropdown) echo <<<DROP_DOWN

		<form method="get" action="$formurl">
			<div id="remositorysearch" class="ddpanel">
				<div id="remositorysearchcontent" class="ddpanelcontent">
					<h2>{$this->showHTML(_DOWN_SEARCH)}</h2>
					<p class="remositoryformentry">
						<label for="search_text">{$this->showHTML(_DOWN_SEARCH_TEXT)}</label>
						<input class="inputbox" type="text" name="search_text" id="search_text" value="{$this->show($search_words)}" />
						<input class="button" type="submit" name="submit" value="{$this->showHTML(_DOWN_SUB_BUTTON)}" />
					</p>
					{$this->simpleTickBox(_DOWN_SEARCH_FILETITLE, 'search_filetitle', $seek_fields_tick['search_filetitle'])}
					{$this->simpleTickBox(_DOWN_SEARCH_FILEDESC, 'search_filedesc', $seek_fields_tick['search_filedesc'])}
					{$this->showCategorySelector($categories, $catselector)}
				</div>
				<div id="remositorysearchtab" class="ddpaneltab">
					<a href="#"><span>{$this->showHTML(_DOWN_SEARCH)}</span></a>
				</div>
				<input type="hidden" name="submit" value="submit" />
                		<input type="hidden" name="option" value="com_remository" />
                                <input type="hidden" name="func" value="search" />
			</div>
		</form>

		
DROP_DOWN;

		else echo <<<SEARCH_FORM

		<form method="get" id="searchadminForm" action="$formurl">
		<input type="hidden" name="submit_search" value="submit" />
		<input type="hidden" name="option" value="com_remository" />
		<input type="hidden" name="func" value="search" />
			<div id="remositorysearch">
				<h2>{$this->showHTML(_DOWN_SEARCH)}</h2>
				<p class="remositoryformentry">
					<label for="search_text">{$this->showHTML(_DOWN_SEARCH_TEXT)}</label>
					<input class="inputbox" type="text" name="search_text" id="search_text" value="{$this->show($search_words)}" />
					<button onclick="document.getElementById('searchadminForm').submit();" class="btn btn-primary" type="button">
                        <span class="icon-search"></span>&nbsp;{$this->show(_DOWN_SUB_BUTTON)}
                    </button>

				</p>
				{$this->simpleTickBox(_DOWN_SEARCH_FILETITLE, 'search_filetitle', $seek_fields_tick['search_filetitle'])}
				{$this->simpleTickBox(_DOWN_SEARCH_FILEDESC, 'search_filedesc', $seek_fields_tick['search_filedesc'])}
				{$this->showCategorySelector($categories, $catselector)}
			</div>
		</form>
		
SEARCH_FORM;

	}
	
	protected function showCategorySelector ($categories, $catselector) {
		$cathtml = '';
		foreach ($categories as $category) {
			$selected = (0 == count($catselector) OR isset($catselector[$category->id])) ? true : false;
			$cathtml .= $this->simpleTickBox($category->name, "catsearch[$category->id]", $selected);
		}
		if ($cathtml) return <<<CAT_SELECT
		
			<div>
				<h3>{$this->showHTML(_DOWN_SEARCH_CATEGORY_SELECT)}</h3>
				$cathtml
			</div>
		
CAT_SELECT;
		
	}
}