<?php

/**************************************************************
* This file is part of Remository
* Copyright (c) 2006-17 Martin Brampton
* 
* License: GNU General Public License version 2 or later; see LICENSE.txt
* 
* For support and other information, visit http://remository.com
* To contact Martin Brampton, write to martin@remository.com
*
* Remository started life as the psx-dude script by psx-dude@psx-dude.net
* It was enhanced by Matt Smith up to version 2.10
* Since then development has been primarily by Martin Brampton,
* with contributions from other people gratefully accepted
*/

defined('_JEXEC') or die;


// These settings are dummy values to suppress errors when the language file is used in a context where the real values have not been set
if (!isset($Large_Text_Len)) $Large_Text_Len = 500;
if (!isset($Small_Text_Len)) $Small_Text_Len = 150;
if (!isset($mosConfig_sitename)) $mosConfig_sitename = 'Nombre del sitio';

// Remository 3.47 Español UTF-8
// Traducción corregida y completada por Hefesto - http://www.gnumla.com - Marzo 2009
// Remository 3.55.J2 Español UTF-8
// Traducción completada por Euskalweb - http://www.euskalweb.net - octubre 2012

// Add your own definitions here, just using plain DEFINE
// e.g. define ('_DOWNLOADS_TITLE', 'The name of my Repository');
// Your definitions will override the standard ones if placed ahead of them

// Prototype for standard definitions: if (!defined('')) DEFINE ('', '');
//
// Note that the definition of _DOWN_NEW_UPDATED_MSG changed in version 3.54.07
// 
// Additions in 3.54
if (!defined('_DOWN_CONFIRM')) DEFINE('_DOWN_CONFIRM','Confirmar');
if (!defined('_DOWN_CONFIRM_MSG')) DEFINE('_DOWN_CONFIRM_MSG','¿Quieres ir más allá?');
if (!defined('_DOWN_RENAME')) DEFINE('_DOWN_RENAME','Renombrar');
if (!defined('_DOWN_CONTAINER_RENAME_INSTRUCTION')) DEFINE('_DOWN_CONTAINER_RENAME_INSTRUCTION','Importante: si modifica el nombre de la carpeta, no cambiará su carpeta física. Renombrar el nombre de carpetas físicas, sólo está disponible en backoffice.');
if (!defined('_DOWN_CONTAINER_DELETE_NOT_EMPTY')) DEFINE('_DOWN_CONTAINER_DELETE_NOT_EMPTY','Cuidado, esta categoría no está vacía. Todos los archivos y subcategorías también se eliminarán.');
if (!defined('_DOWN_CONTAINER_DELETE_INVALID_GROUP')) DEFINE('_DOWN_CONTAINER_DELETE_INVALID_GROUP','Usted no tiene derechos de borrado en esta categoría');
if (!defined('_DOWN_CONTAINER_UPDATE_INVALID_GROUP')) DEFINE('_DOWN_CONTAINER_UPDATE_INVALID_GROUP','Usted no tiene derechos de edición en esta categoría.');
if (!defined('_DOWN_SUBCONTAINER_CREATE_LABEL')) DEFINE('_DOWN_SUBCONTAINER_CREATE_LABEL','Añadir una subcategoría');
if (!defined('_DOWN_SUBCONTAINER_CREATE_INVALID_GROUP')) DEFINE('_DOWN_SUBCONTAINER_CREATE_INVALID_GROUP','Usted no tiene derechos para crear subcategorías en esta categoría.');
if (!defined('_DOWN_SUBCONTAINER_CREATE_ERR_TITLE')) DEFINE('_DOWN_SUBCONTAINER_CREATE_ERR_TITLE', 'La categoría no se puede crear');
if (!defined('_DOWN_SUBCONTAINER_CREATE_FOLDER_WARN01')) DEFINE('_DOWN_SUBCONTAINER_CREATE_FOLDER_WARN01','El título elegido no es válido: no hay ninguna carpeta física, que pueda ser creada a partir de la misma.');
if (!defined('_DOWN_SUBCONTAINER_CREATE_FOLDER_ERR01')) DEFINE('_DOWN_SUBCONTAINER_CREATE_FOLDER_ERR01','La carpeta física no se puede crear: carpeta principal de la categoría física no se puede encontrar.');
if (!defined('_DOWN_SUBCONTAINER_CREATE_FOLDER_ERR02')) DEFINE('_DOWN_SUBCONTAINER_CREATE_FOLDER_ERR02','La carpeta física no se puede crear: por favor compruebe los permisos de las carpetas físicas.');
if (!defined('_DOWN_CONFIG_TITLE_FRONT_OFFICE_MGT')) DEFINE('_DOWN_CONFIG_TITLE_FRONT_OFFICE_MGT','Administración del Front office');
if (!defined('_DOWN_CONFIG_TITLE_RIGHTS')) DEFINE('_DOWN_CONFIG_TITLE_RIGHTS','Gestión de permisos');
if (!defined('_DOWN_CONFIG_TITLE_DISPLAY')) DEFINE('_DOWN_CONFIG_TITLE_DISPLAY','Pantalla de gestión');
if (!defined('_DOWN_CONFIG108')) DEFINE ('_DOWN_CONFIG108', '<b>Permitir editar categorías:</b> <br/><em>(Permitir a los usuarios editar (en este caso, basta con cambiar el nombre del título) las categorías para las que tienen permisos para subir archivos)</em>');
if (!defined('_DOWN_CONFIG107')) DEFINE ('_DOWN_CONFIG107', '<b>Permitir borrar categorías: </b><br /><em>(Permitir a los usuarios eliminar las categorías qpara las que tienen permisos para subir archivos)</em>');
if (!defined('_DOWN_CONFIG106')) DEFINE ('_DOWN_CONFIG106', '<b>Permitir agregar subcategorías: </b><br /><em>(Permitir a los usuarios agregar subcategorías en las categorías para las que tienen permisos para subir archivos)</em>');

// Additions in 3.53+
if (!defined('_DOWN_UPLOAD_NEW_FOLDER')) DEFINE ('_DOWN_UPLOAD_NEW_FOLDER', 'Crear carpeta bajo la carpeta seleccionada:');
if (!defined('_DOWN_EMAIL_NOTIFY_PREFIX')) DEFINE ('_DOWN_EMAIL_NOTIFY_PREFIX', 'Los siguientes archivos pueden ser de su interés:');
if (!defined('_DOWN_EMAIL_NOTIFY_POSTFIX')) DEFINE ('_DOWN_EMAIL_NOTIFY_POSTFIX', 'Si usted tiene preguntas sobre el archivo superior, por favor póngase en contacto con el remitente.');
if (!defined('_DOWN_COULD_NOT_SEND')) DEFINE ('_DOWN_COULD_NOT_SEND', 'No se pudo enviar %s a %s, no se permite.');
if (!defined('_DOWN_EMAIL_NOTIFY')) DEFINE ('_DOWN_EMAIL_NOTIFY', 'Me gustaría notificarle de %s y se la puede descargar en %s');
if (!defined('_DOWN_ATTEMPTING_MAIL')) DEFINE ('_DOWN_ATTEMPTING_MAIL', 'Intento de correo %s con %s');
if (!defined('_DOWN_LINKS_TO_FILES')) DEFINE ('_DOWN_LINKS_TO_FILES', 'Enlaces a archivos de interés');
if (!defined('_DOWN_EMAIL_SUCCESSFUL')) DEFINE ('_DOWN_EMAIL_SUCCESSFUL', 'Email enviado con éxito a %s');
if (!defined('_DOWN_EMAIL_FAILED')) DEFINE ('_DOWN_EMAIL_FAILED', 'El Intento de enviar un correo electrónico a %s al email %s falló');
if (!defined('_DOWN_NOTHING_TO_DO')) DEFINE ('_DOWN_NOTHING_TO_DO', 'Nada que hacer');

// Additions in 3.53
if (!defined('_DOWN_ALL_CATEGORIES')) DEFINE ('_DOWN_ALL_CATEGORIES', 'Todas las categorías');
if (!defined('_DOWN_THANKS_FOR_VOTING')) DEFINE ('_DOWN_THANKS_FOR_VOTING', 'Gracias por votar');
if (!defined('_DOWN_CAST_YOUR_VOTE')) DEFINE ('_DOWN_CAST_YOUR_VOTE', '¿Por qué no emitir su voto?');
if (!defined('_DOWN_LOGIN_TO_VOTE')) DEFINE ('_DOWN_LOGIN_TO_VOTE', 'Ingrese para emitir su voto');
if (!defined('_DOWN_CONFIG_EXPLAIN_5')) DEFINE ('_DOWN_CONFIG_EXPLAIN_5', 'E = Seleccionar campos para cargar o modificar archivos');
if (!defined('_DOWN_SEARCH_ALL_FOLDERS')) DEFINE ('_DOWN_SEARCH_ALL_FOLDERS', 'Buscar en todas las carpetas');
if (!defined('_DOWN_UPLOAD_BLOCKED_GROUPS')) DEFINE ('_DOWN_UPLOAD_BLOCKED_GROUPS', 'Lo siento, no está autorizado para subir archivos en la actualidad.');
if (!defined('_DOWN_NO_REMOSITORY_GROUPS')) DEFINE ('_DOWN_NO_REMOSITORY_GROUPS', 'Los permisos de grupo de Remository no están disponibles - Configuración dice que use los permisos de grupo del CMS');
if (!defined('_DOWN_POSSIBLE_DUPLICATE_NAMES')) DEFINE ('_DOWN_POSSIBLE_DUPLICATE_NAMES', 'Configuración guardada, pero es necesaria la ID de archivo debido a los nombres de archivos duplicados');
if (!defined('_DOWN_CONFIG105')) DEFINE ('_DOWN_CONFIG105', '<b>Desactivar la acción por defecto del navegador para la apertura de un archivo descargado.</b></em>');
if (!defined('_DOWN_CONFIG104')) DEFINE ('_DOWN_CONFIG104', '<b>Usar permisos de grupos del CMS: </b><br /><em>(Utilice los permisos de grupo del CMS para el control de acceso, en lugar de los de los grupos de Remository.)</em>');
if (!defined('_DOWN_CONFIG103')) DEFINE ('_DOWN_CONFIG103', '<b>Descarga inmediata: </b><br /><em>(Saltar página de información de archivo, ir directamente a la descarga.)</em>');
if (!defined('_DOWN_CONFIG72')) DEFINE ('_DOWN_CONFIG72', '<b>Nombre Real con ID: </b><br /><em>(Los actuales nombres de los archivos en el disco, se harán únicos, mediante la inserción de número ID de archivo.)</em>');
if (!defined('_DOWN_DETAILS')) DEFINE('_DOWN_DETAILS','Detalles');
if (!defined('_DOWN_THIS_FILE_TODAY')) DEFINE ('_DOWN_THIS_FILE_TODAY', 'Usted ha descargado este archivo %d veces en las últimas 24 horas; el límite es %d.');
if (!defined('_DOWN_ALL_FILES_TODAY')) DEFINE ('_DOWN_ALL_FILES_TODAY', 'Sus descargas de archivos en total han sido %d en las últimas 24 horas; el límite es %d.');
if (!defined('_DOWN_YOUR_CREDITS')) DEFINE ('_DOWN_YOUR_CREDITS', 'Actualmente tiene %d créditos disponibles.');
if (!defined('_DOWN_TOO_FEW_CREDITS')) DEFINE ('_DOWN_TOO_FEW_CREDITS', '¡No tien suficientes créditos para descargar!');
if (!defined('_DOWN_CONFIG71')) DEFINE ('_DOWN_CONFIG71', '<b>Mostrar Subcategorías: </b><br /><em>(Mostrar categorías hijo, bajo categorías padre.)</em>');
if (!defined('_DOWN_PRICE_LABEL')) DEFINE ('_DOWN_PRICE_LABEL', 'Precio:');

// Additions in 3.52
if (!defined('_DOWN_MANY_CONTAINERS')) DEFINE('_DOWN_MANY_CONTAINERS', 'Demasiados contenedores para la lista - por favor navegue a través de los enlaces de contenedores »');
if (!defined('_DOWN_DELETE_SURE')) DEFINE ('_DOWN_DELETE_SURE', '¿Está seguro que quieres eliminar este archivo?');
if (!defined('_DOWN_SEARCH_CATEGORY_SELECT')) DEFINE ('_DOWN_SEARCH_CATEGORY_SELECT', 'Elija las categorías que incluye');
if (!defined('_DOWN_SEARCH_FILES')) DEFINE ('_DOWN_SEARCH_FILES', 'Buscar archivo... ');

// Additions in 3.51
if (!defined('_DOWN_NOT_ABSOLUTE')) DEFINE ('_DOWN_NOT_ABSOLUTE', 'Ruta absoluta no válida');
if (!defined('_DOWN_NEW_OR_UPDATED')) DEFINE ('_DOWN_NEW_OR_UPDATED', 'Archivo nuevo o actualizado');
if (!defined('_DOWN_NEW_FILE_COMMENT')) DEFINE ('_DOWN_NEW_FILE_COMMENT', 'Nuevo comentario en archivo');
if (!defined('_DOWN_MAIL_MESSAGE_PREFIX')) DEFINE ('_DOWN_MAIL_MESSAGE_PREFIX', "Hola %s\n\n");
if (!defined('_DOWN_NEW_UPDATED_MSG')) DEFINE ('_DOWN_NEW_UPDATED_MSG',
					"En %s un archivo ha sido añadido o actualizado. El título del archivo es %s. El nombre del archivo es %s."
					."\n\nPor favor, no responda a este mensaje, ya que se genera automáticamente y es sólo con fines informativos\n"
					);
if (!defined('_DOWN_NEW_COMMENT_MSG')) DEFINE ('_DOWN_NEW_COMMENT_MSG',
					"En %s un nuevo comentario ha sido hecho acerca del arhcivo.  El título del archivo es %s.  "
					."El nuevo comentario fue hecho por %s y es:\n\n%s"
					."\n\nPor favor, no responda a este mensaje, ya que se genera automáticamente y es sólo con fines informativos\n"
					);

// Modifications in 3.51
if (!defined('_DOWN_MAIL_MSG')) DEFINE('_DOWN_MAIL_MSG','Hola, un archivo para Descargar ha sido subido por %s'
                   ." para el Sitio Web %s.\n"
                   ."Por favor, inicie sesión como administrador para ver y aprobar la presente comunicación.\n\n"
                   ."Por favor no responda a este mensaje, ya que se genera automáticamente y es sólo con fines informativos\n");
if (!defined('_DOWN_MAIL_MSG_APP')) DEFINE('_DOWN_MAIL_MSG_APP','Hola, un archivo para Descargar ha sido subido por %s'
                   ." para el Sitio Web %s.\n"
                   ."De acuerdo con las opciones de configuración, se ha auto-aprovado.\n\n"
                   ."Por favor no responda a este mensaje, ya que se genera automáticamente y es sólo con fines informativos\n");
if (!defined('_DOWN_LINK_TO_FILE')) DEFINE ('_DOWN_LINK_TO_FILE', "\n\nNo se puede encontrar el archivo en %s");
if (!defined('_DOWN_LINK_TO_CONTAINER')) DEFINE ('_DOWN_LINK_TO_CONTAINER', "\n\no se puede encontrar en el contenedor %s");

// Additions in 3.50
if (!defined('_DOWN_APPROVE_ROLES')) DEFINE ('_DOWN_APPROVE_ROLES', 'Roles para auto-aprovar');
if (!defined('_DOWN_ACCESS_REFUSED')) DEFINE ('_DOWN_ACCESS_REFUSED', 'Lo siento, su solicitud es rechazada');
if (!defined('_DOWN_MAYBE_LOGIN')) DEFINE ('_DOWN_MAYBE_LOGIN', 'Tal vez usted necesita ingresar o registrar una cuenta.');
if (!defined('_DOWN_CONFIG70')) DEFINE ('_DOWN_CONFIG70', '<b>Mostrar ruta de la categoría: </b><br /><em>(en los resultados de búsqueda, se mostrará la ruta del contenedor completa)</em>');
if (!defined('_DOWN_CONFIG69')) DEFINE ('_DOWN_CONFIG69', '<b>Formato de fecha: </b><br /><em>(Elija una configuración regional para el manejo de la fecha)</em>');
if (!defined('_DOWN_CONFIG68')) DEFINE ('_DOWN_CONFIG68', '<b>Forzar Lenguaje: </b><br /><em>(Fuerza el código de idioma para este valor, ignorar la CMS)</em>');

// Additions in 3.47 to fix missed items in earlier versions
if (!defined('_DOWN_NO_FILE_RECEIVED')) DEFINE ('_DOWN_NO_FILE_RECEIVED', 'A pesar de que intentó subir un archivo, no se recibió ninguno.');
if (!defined('_DOWN_SAMPLE')) DEFINE ('_DOWN_SAMPLE', 'Muestra');
if (!defined('_DOWN_SAMPLE_DESCRIPTION')) DEFINE ('_DOWN_SAMPLE_DESCRIPTION', 'Reemplazar o modificar este contendor de muestra según sea necesario');
if (!defined('_DOWN_INSTALL_DONE1')) DEFINE ('_DOWN_INSTALL_DONE1', 'Se recomienda encarecidamente que eche un vistazo a las notas de lanzamiento (Release notes) en el archivo read_me.txt');
if (!defined('_DOWN_INSTALL_DONE2')) DEFINE ('_DOWN_INSTALL_DONE2', 'Puede encontrar más información en el <a href="http://remository.com">sitio web de Remository</a>.');
if (!defined('_DOWN_INSTALL_DONE3')) DEFINE ('_DOWN_INSTALL_DONE3', 'Mantenga Remository');
if (!defined('_DOWN_INSTALL_DONE4')) DEFINE ('_DOWN_INSTALL_DONE4', 'Desarrollar y mantener Remository lleva mucho tiempo y una cierta cantidad de'
		.' dinero para proporcionar el entorno de desarrollo. Si está obteniendo beneficio económico '
		.' de su uso de Remository, por favor considere hacer una donación para apoyar al proyecto.'
		.' Haga clic en el botón a continuación para efectuar un pago inmediato:');
if (!defined('_DOWN_LOCAL_OR_REMOTE')) DEFINE ('_DOWN_LOCAL_OR_REMOTE', 'Local o Remoto');
if (!defined('_DOWN_IS_LOCAL')) DEFINE ('_DOWN_IS_LOCAL', 'Local');
if (!defined('_DOWN_IS_REMOTE')) DEFINE ('_DOWN_IS_REMOTE', 'Remoto');
if (!defined('_DOWN_LOCALISE_REMOTE_FILE')) DEFINE ('_DOWN_LOCALISE_REMOTE_FILE', 'Hacer local');
if (!defined('_DOWN_CANCEL_UPLOAD')) DEFINE ('_DOWN_CANCEL_UPLOAD', 'Cancelar subida');
if (!defined('_DOWN_NOT_YET_IMPLEMENTED')) DEFINE ('_DOWN_NOT_YET_IMPLEMENTED', 'ESTA FUNCIONALIDAD AÚN NO HA SIDO IMPLEMENTADA	');
if (!defined('_DOWN_ADMIN_CPANEL_CACHEPATH')) DEFINE ('_DOWN_ADMIN_CPANEL_CACHEPATH', 'Ruta a la caché del CMS - importante para las RSS y el control de acceso:');
if (!defined('_DOWN_CONFIG_EXPLAIN_4')) DEFINE ('_DOWN_CONFIG_EXPLAIN_4', 'D = Campos que se mostrarán en la página de información detallada, del archivo');
if (!defined('_DOWN_CONFIG67')) DEFINE ('_DOWN_CONFIG67', '<b>Perfil URI:</b> <br /><em>(URI no-SEF relativa al perfil con %u donde la ID de usuario debería estar)</em>');
if (!defined('_DOWN_CONFIG66')) DEFINE ('_DOWN_CONFIG66', '<b>Activar AEC:</b> <br /><em>(Activar integración con AEC para el control de acceso)</em>');
if (!defined('_DOWN_AEC_OPTION_A')) DEFINE ('_DOWN_AEC_OPTION_A', 'Aplicar solo al grupo (o a los grupos) a continuación.');
if (!defined('_DOWN_AEC_OPTION_B')) DEFINE ('_DOWN_AEC_OPTION_B', 'Borrar TODO, y a continuación aplicar siguiente(s) grupo(s).');
if (!defined('_DOWN_AEC_OPTION_C')) DEFINE ('_DOWN_AEC_OPTION_C', 'Borrar grupo establecido en la aplicación, y a continuación aplicar el (los) grupo(s) siguientes:.');
if (!defined('_DOWN_CONFIG65')) DEFINE ('_DOWN_CONFIG65', '<b>Título de la página principal:</b><br /><em>(Entrada de la barra de título del navegador para la página principal del repositorio)</em>');
if (!defined('_DOWN_NEXT')) DEFINE ('_DOWN_NEXT', 'Siguiente');
if (!defined('_DOWN_PREVIOUS')) DEFINE ('_DOWN_PREVIOUS', 'Anterior');
if (!defined('_DOWN_DOWNLOAD_LC')) DEFINE ('_DOWN_DOWNLOAD_LC', 'descargar');
if (!defined('_DOWN_EMPTY_REPOSITORY')) DEFINE ('_DOWN_EMPTY_REPOSITORY', 'Vaciar repositorio');
if (!defined('_DOWN_OVERVIEW_LATEST')) DEFINE ('_DOWN_OVERVIEW_LATEST', 'Últimos archivos en el repositorio');
if (!defined('_DOWN_SPECIFY_AUTHOR')) DEFINE ('_DOWN_SPECIFY_AUTHOR', 'Otro autor');
if (!defined('_DOWN_CONFIG64')) DEFINE ('_DOWN_CONFIG64', '<b>Umbral de autores:</b><br /><em>(Listados de autor mínimos a incluir en la lista desplegable)</em>');
if (!defined('_DOWN_CONFIG63')) DEFINE ('_DOWN_CONFIG63', '<b>Autores seleccionables:</b><br /><em>(Lista de autores seleccionables, separados por comas)</em>');
if (!defined('_DOWN_CONFIG62')) DEFINE ('_DOWN_CONFIG62', '<b>Longitud de comentarios:</b><br /><em>(Longitud mínima para un comentario de un archivo, o ignorarlo)</em>');
if (!defined('_DOWN_CONFIG61')) DEFINE ('_DOWN_CONFIG61', '<b>Descargar Video:</b><br /><em>(Permitir la descarga de archivos de vídeo)</em>');
if (!defined('_DOWN_CONFIG60')) DEFINE ('_DOWN_CONFIG60', '<b>Descargar audio:</b><br /><em>(Permitir la descarga de archivos de audio)</em>');
if (!defined('_DOWN_CONFIG59')) DEFINE ('_DOWN_CONFIG59', '<b>Alias:</b><br /><em>(Alias del repositorio)</em>');
if (!defined('_DOWN_CONFIG58')) DEFINE ('_DOWN_CONFIG58', '<b>Nombre:</b><br /><em>(Nombre del repositorio)</em>');
if (!defined('_DOWN_PLAY')) DEFINE ('_DOWN_PLAY', 'Reproducir');
if (!defined('_DOWN_PLAY_THANK_YOU')) DEFINE ('_DOWN_PLAY_THANK_YOU', 'Gracias por reproducir ');
if (!defined('_DOWN_CONFIG57')) DEFINE ('_DOWN_CONFIG57', '<b>Extensiones de archivos de vídeo:</b><br /><em>(Archivos de vídeo que serán reproducidos, no descargados)</em>');
if (!defined('_DOWN_CONFIG56')) DEFINE ('_DOWN_CONFIG56', '<b>Extensiones de archivos de audio:</b><br /><em>(Archivos de audio que serán reproducidos, no descargados)</em>');
if (!defined('_DOWN_FEATURED')) DEFINE ('_DOWN_FEATURED', 'Destacado');
if (!defined('_DOWN_IS_FEATURED')) DEFINE ('_DOWN_IS_FEATURED', 'Archivo destacado:');
if (!defined('_DOWN_FEATURE_START')) DEFINE ('_DOWN_FEATURE_START', 'Fecha de inicio:');
if (!defined('_DOWN_FEATURE_END')) DEFINE ('_DOWN_FEATURE_END', 'Fecha de finalización (en blanco = para siempre)');
if (!defined('_DOWN_PUBLISH_FROM')) DEFINE ('_DOWN_PUBLISH_FROM', 'Publicar desde:');
if (!defined('_DOWN_PUBLISH_TO')) DEFINE ('_DOWN_PUBLISH_TO', 'Publicar hasta (en blanco = para siempre):');
if (!defined('_DOWN_FIELD_NAME')) DEFINE ('_DOWN_FIELD_NAME', 'Nombre del campo');
if (!defined('_DOWN_FIELD_TITLE')) DEFINE ('_DOWN_FIELD_TITLE', 'Título del campo');
if (!defined('_DOWN_CUSTOM_UPLOAD')) DEFINE ('_DOWN_CUSTOM_UPLOAD', 'En la subida');
if (!defined('_DOWN_CUSTOM_LIST')) DEFINE ('_DOWN_CUSTOM_LIST', 'En la lista del archivo');
if (!defined('_DOWN_CUSTOM_INFO_PAGE')) DEFINE ('_DOWN_CUSTOM_INFO_PAGE', 'En la página de información');
if (!defined('_DOWN_FIELD_OPTIONS')) DEFINE ('_DOWN_FIELD_OPTIONS', 'Limitar valores a los de esta lista (sep. por comas)');
if (!defined('_DOWN_CUSTOM_INFO')) DEFINE ('_DOWN_CUSTOM_INFO', 'El nombre del campo será usado en la base de datos y debe ser único para la tabla xxx_downloads_files.  El título del campo será usado para etiquetarlo cuando sea usado.');
if (!defined('_DOWN_CUSTOM_FIELDS_TAB')) DEFINE ('_DOWN_CUSTOM_FIELDS_TAB', 'Añadir campos');
if (!defined('_DOWN_CUSTOM_FIELDS_HEAD')) DEFINE ('_DOWN_CUSTOM_FIELDS_HEAD', 'Campos personalizados');
if (!defined('_DOWN_CONFIG55')) DEFINE ('_DOWN_CONFIG55', '<b>Elementos destacados:</b><br /><em>(Número de elementos a ser destacados)</em>');
if (!defined('_DOWN_IS_VISIBLE')) DEFINE ('_DOWN_IS_VISIBLE', '¿Visible?');
if (!defined('_DOWN_FREQUENCY')) DEFINE ('_DOWN_FREQUENCY', 'Frecuencia');
if (!defined('_DOWN_TYPE')) DEFINE ('_DOWN_TYPE', 'Tipo');
if (!defined('_DOWN_DESCRIPTION')) DEFINE ('_DOWN_DESCRIPTION', 'Descripción');
if (!defined('_DOWN_CLASSIFICATIONS')) DEFINE ('_DOWN_CLASSIFICATIONS', 'Clasificaciones');
if (!defined('_DOWN_SAVE')) DEFINE ('_DOWN_SAVE', 'Guardar');
if (!defined('_DOWN_FILE_STRUCTURE')) DEFINE ('_DOWN_FILE_STRUCTURE', 'Estructura de archivo');
if (!defined('_DOWN_PRUNE')) DEFINE ('_DOWN_PRUNE', '- purgar');
if (!defined('_DOWN_DELETE_MISSING')) DEFINE ('_DOWN_DELETE_MISSING', 'Borrar archivos que faltan');
if (!defined('_DOWN_APPLY')) DEFINE ('_DOWN_APPLY', 'Aplicar');
if (!defined('_DOWN_CLASSIFICATION_NAME')) DEFINE ('_DOWN_CLASSIFICATION_NAME', 'Nombre de la clasificación');
if (!defined('_DOWN_DISPLAY_LISTS')) DEFINE ('_DOWN_DISPLAY_LISTS', 'Mostrar nombre en las listas:');
if (!defined('_DOWN_NOT_PUBLISHED')) DEFINE ('_DOWN_NOT_PUBLISHED', 'No publicado');
if (!defined('_DOWN_PUBLISH')) DEFINE ('_DOWN_PUBLISH', 'Publicar');
if (!defined('_DOWN_UNPUBLISH')) DEFINE ('_DOWN_UNPUBLISH', 'Despublicar');
if (!defined('_DOWN_FILE')) DEFINE ('_DOWN_FILE', 'Archivo');
if (!defined('_DOWN_ADD')) DEFINE ('_DOWN_ADD', 'Añadir');
if (!defined('_DOWN_CLASSIFN')) DEFINE ('_DOWN_CLASSIFN', 'Classif\'n');
if (!defined('_DOWN_ROLES')) DEFINE ('_DOWN_ROLES', 'roles:');
if (!defined('_DOWN_DELETE')) DEFINE ('_DOWN_DELETE', 'Borrar');
if (!defined('_DOWN_ADD_USERS_NEW_ROLE')) DEFINE ('_DOWN_ADD_USERS_NEW_ROLE', 'Añadir usuarios al nuevo rol');
if (!defined('_DOWN_ADD_MEMBERS')) DEFINE ('_DOWN_ADD_MEMBERS', 'Añadir miembros');
if (!defined('_DOWN_ADD_LOCAL')) DEFINE ('_DOWN_ADD_LOCAL', 'Añadir local');
if (!defined('_DOWN_ADD_REMOTE')) DEFINE ('_DOWN_ADD_REMOTE', 'Añadir remoto');
if (!defined('_DOWN_EDIT_APPROVAL')) DEFINE ('_DOWN_EDIT_APPROVAL', 'Editar aprobación');
if (!defined('_DOWN_DELETE_SUBMISSION')) DEFINE ('_DOWN_DELETE_SUBMISSION', 'Borrar envío');
if (!defined('_DOWN_CONTAINER')) DEFINE ('_DOWN_CONTAINER', 'Contenedor');
if (!defined('_DOWN_PUBLISH_FILES')) DEFINE ('_DOWN_PUBLISH_FILES', 'Publicar archivos');
if (!defined('_DOWN_DELETE_ORPHANS')) DEFINE ('_DOWN_DELETE_ORPHANS', 'Borrar huérfanos');
if (!defined('_DOWN_ORPHAN')) DEFINE ('_DOWN_ORPHAN', 'Huérfano');
if (!defined('_DOWN_MISSING')) DEFINE ('_DOWN_MISSING', 'Falta');
if (!defined('_DOWN_ADD_USERS_ROLE')) DEFINE ('_DOWN_ADD_USERS_ROLE', 'Añadir usuarios al rol');
if (!defined('_DOWN_REMOVE_USERS_ROLE')) DEFINE ('_DOWN_REMOVE_USERS_ROLE', 'Eliminar usuarios del rol');
if (!defined('_DOWN_PUBLISHING')) DEFINE ('_DOWN_PUBLISHING', 'Publicando');
if (!defined('_DOWN_EDIT_CONTAINER')) DEFINE ('_DOWN_EDIT_CONTAINER', 'Editar contenedor');
if (!defined('_DOWN_REMOSITORY')) DEFINE ('_DOWN_REMOSITORY', 'Remository');
if (!defined('_DOWN_PHYSICAL_FILE')) DEFINE ('_DOWN_PHYSICAL_FILE', 'Archivo físico');
if (!defined('_DOWN_METADATA')) DEFINE ('_DOWN_METADATA', 'Metadatos');
if (!defined('_DOWN_SHORT_DESCRIPTION')) DEFINE ('_DOWN_SHORT_DESCRIPTION', 'Descripción corta');
if (!defined('_DOWN_LICENSE_HEADING')) DEFINE ('_DOWN_LICENSE_HEADING', 'Licencia');
if (!defined('_DOWN_ABOUT_FILE')) DEFINE ('_DOWN_ABOUT_FILE', 'Acerca del archivo');
if (!defined('_DOWN_COMMENTS_HEADING')) DEFINE ('_DOWN_COMMENTS_HEADING', 'Comentarios');
if (!defined('_DOWN_STORAGE')) DEFINE ('_DOWN_STORAGE', 'Almacenamiento');
if (!defined('_DOWN_ACCESS_CONTROL')) DEFINE ('_DOWN_ACCESS_CONTROL', 'Control de acceso');
if (!defined('_DOWN_DOWNLOAD_ROLES')) DEFINE ('_DOWN_DOWNLOAD_ROLES', 'Roles de descarga');
if (!defined('_DOWN_UPLOAD_ROLES')) DEFINE ('_DOWN_UPLOAD_ROLES', 'Roles de subida');
if (!defined('_DOWN_EDIT_ROLES')) DEFINE ('_DOWN_EDIT_ROLES', 'Editar roles');
if (!defined('_DOWN_ADD_NEW_ROLE')) DEFINE ('_DOWN_ADD_NEW_ROLE', 'Añadir nuevo rol:');
// Recent additions 3.46+
if (!defined('_DOWN_DOWNLOAD_FROM')) DEFINE ('_DOWN_DOWNLOAD_FROM', 'Descargar desde');
if (!defined('_DOWN_UPLOAD_TO')) DEFINE ('_DOWN_UPLOAD_TO', 'Subir a');
if (!defined('_DOWN_EDIT_IN')) DEFINE ('_DOWN_EDIT_IN', 'Editar en');
if (!defined('_DOWN_SUBS_EVERYTHING')) DEFINE ('_DOWN_SUBS_EVERYTHING', 'Contar todas las descargas de archivos');
if (!defined('_DOWN_SUBS_COUNT_DOWNLOAD')) DEFINE ('_DOWN_SUBS_COUNT_DOWNLOAD', 'Contar las decargas de un contenedor específico');
if (!defined('_DOWN_SUBS_COUNT_UPLOAD')) DEFINE ('_DOWN_SUBS_COUNT_UPLOAD', 'Contar las subidas a un contenedor específico');
if (!defined('_DOWN_SUBS_COUNT_DOWNLOAD_PLUS')) DEFINE ('_DOWN_SUBS_COUNT_DOWNLOAD_PLUS', 'Contar las descargas de un contenedor y todos sus descendientes (subcontenedores)');
if (!defined('_DOWN_SUBS_COUNT_UPLOAD_PLUS')) DEFINE ('_DOWN_SUBS_COUNT_UPLOAD_PLUS', 'Contar las subidas a un contenedor y todos sus descendientes (subcontenedores)');
if (!defined('_DOWN_COUNT_DOWN')) DEFINE ('_DOWN_COUNT_DOWN', 'Gestor de suscriptores para contar las descargas');
if (!defined('_DOWN_COUNT_DOWN_CHILD')) DEFINE ('_DOWN_COUNT_DOWN_CHILD', 'Incluir los descendientes en el conteo de descargas');
if (!defined('_DOWN_COUNT_UP')) DEFINE ('_DOWN_COUNT_UP', 'Gestor de suscriptores para contar las subidas');
if (!defined('_DOWN_COUNT_UP_CHILD')) DEFINE ('_DOWN_COUNT_UP_CHILD', 'Incluir los descendientes en el conteo de subidas');
if (!defined('_DOWN_CONFIG54')) DEFINE ('_DOWN_CONFIG54', '<b>Contador de descargas:</b><br /><em>(Restringir todas las descargas usando el gestor de suscriptores)</em>');
if (!defined('_DOWN_CONFIG53')) DEFINE ('_DOWN_CONFIG53', '<b>Mostrar contador:</b><br /><em>(Mostrar los conteos de archivo y carpeta)</em>');
if (!defined('_DOWN_CONFIG52')) DEFINE ('_DOWN_CONFIG52', '<b>Mostrar pie:</b><br /><em>(Mostrar el pie de Remository (Buscar/Enviar/Créditos))</em>');
if (!defined('_DOWN_CONFIG51')) DEFINE ('_DOWN_CONFIG51', '<b>Información detallada:</b><br /><em>(Enlace a información detallada del archivo desde la lista de archivos)</em>');
if (!defined('_DOWN_IS_ACTIVE')) DEFINE ('_DOWN_IS_ACTIVE', '¿Activo?');
if (!defined('_DOWN_NEW_REPOSITORY')) DEFINE ('_DOWN_NEW_REPOSITORY', 'Crear un nuevo repositorio como el actual');
if (!defined('_DOWN_REPOSITORY_NAME')) DEFINE ('_DOWN_REPOSITORY_NAME', 'Nombre del repositorio');
if (!defined('_DOWN_REPOSITORY_NUMBER')) DEFINE ('_DOWN_REPOSITORY_NUMBER', 'Número del repositorio');
if (!defined('_DOWN_REPOSITORY_ALIAS')) DEFINE ('_DOWN_REPOSITORY_ALIAS', 'Alias del repositorio');
// Recent additions 3.46
if (!defined('_DOWN_SUBTITLE')) DEFINE ('_DOWN_SUBTITLE', 'Subtítulo del archivo:');
if (!defined('_DOWN_PUBLISHER_ID')) DEFINE ('_DOWN_PUBLISHER_ID', 'ID del publicador:');
if (!defined('_DOWN_PUBLISHED_DATE')) DEFINE ('_DOWN_PUBLISHED_DATE', 'Fecha de publicación:');
if (!defined('_DOWN_ALIAS')) DEFINE ('_DOWN_ALIAS', 'Alias');
if (!defined('_DOWN_BOTH')) DEFINE ('_DOWN_BOTH', 'Ambos');
if (!defined('_DOWN_CONFIG50')) DEFINE ('_DOWN_CONFIG50', '<b>Usar \'breadcrumb\' de Remository (pathway)</b>');
if (!defined('_DOWN_SEARCHING_BY')) DEFINE ('_DOWN_SEARCHING_BY', 'Buscando por');
if (!defined('_DOWN_FILTERING_BY')) DEFINE ('_DOWN_FILTERING_BY', 'Filtrando por');
if (!defined('_DOWN_REMOVE_TERM')) DEFINE ('_DOWN_REMOVE_TERM', 'eliminar término');
if (!defined('_DOWN_NO_FILTERS')) DEFINE ('_DOWN_NO_FILTERS', 'Ningún filtro activo - todos los ítems mostrados');
if (!defined('_DOWN_REVIEW_TAGS')) DEFINE ('_DOWN_REVIEW_TAGS', 'Revisar etiquetas en el grupo');
if (!defined('_DOWN_NO_RESULTS_1')) DEFINE ('_DOWN_NO_RESULTS_1', 'Disculpe, su búsqueda no devolvió ningún resultado.');
if (!defined('_DOWN_NO_RESULTS_2')) DEFINE ('_DOWN_NO_RESULTS_2', '¿No puede encontrar lo que busca?');
if (!defined('_DOWN_CONTACT_US')) DEFINE ('_DOWN_CONTACT_US', 'Contacte con nosotos y díganos qué es lo que busca.');
if (!defined('_DOWN_ALL_CATS_RETRY')) DEFINE ('_DOWN_ALL_CATS_RETRY', '¿Volver a intentar esta búsqueda con todas las categorías seleccionadas?');
if (!defined('_DOWN_ADD_ALL_CATS')) DEFINE ('_DOWN_ADD_ALL_CATS', 'Añadir todas las categorías');
if (!defined('_DOWN_CONFIG49')) DEFINE ('_DOWN_CONFIG49', '<b>Tipos de clasificación:</b><br /><em>(valores separados por comas)</em>');

// Recent additions 3.45
if (!defined('_DOWN_GROUP_NO_NAME')) DEFINE ('_DOWN_GROUP_NO_NAME', 'Grupo no guardado - sin nombre');
if (!defined('_DOWN_GROUP_SAVED')) DEFINE ('_DOWN_GROUP_SAVED', 'El grupo ha sido guardado');
if (!defined('_DOWN_CONFIG48')) DEFINE ('_DOWN_CONFIG48', '<b>Mostrar feeds RSS</b>');
if (!defined('_DOWN_CONFIG46')) DEFINE ('_DOWN_CONFIG46', '<b>Mostrar extensiones: </b><br/><i>(Extensiones que pueden ser mostradas online (Lista separada por comas))</i>');
if (!defined('_DOWN_DISPLAY_NOW')) DEFINE ('_DOWN_DISPLAY_NOW', 'Mostrar este archivo ahora');
if (!defined('_DOWN_CONFIG47')) DEFINE ('_DOWN_CONFIG47', '<b>Clave para publicar en Scribd</b>');
if (!defined('')) DEFINE ('', '');
// Recent addition 3.44.1
if (!defined('_DOWN_AEC_REFUSED')) DEFINE ('_DOWN_AEC_REFUSED', 'Según AEC su límite de descargas ha sido alcanzado');
// Recent additions 3.44
if (!defined('_DOWN_FIELD')) DEFINE ('_DOWN_FIELD', 'Campo');
if (!defined('_DOWN_SEQUENCE')) DEFINE ('_DOWN_SEQUENCE', 'Posición');
if (!defined('_DOWN_CONFIG_EXPLAIN_1')) DEFINE ('_DOWN_CONFIG_EXPLAIN_1', 'A = Campos que se mostrarán en la lista de archivos de una carpeta');
if (!defined('_DOWN_CONFIG_EXPLAIN_2')) DEFINE ('_DOWN_CONFIG_EXPLAIN_2', 'B = Campos que se mostrarán en los resultados de las búsquedas');
if (!defined('_DOWN_CONFIG_EXPLAIN_3')) DEFINE ('_DOWN_CONFIG_EXPLAIN_3', 'C = Campos que se mostrarán en los resultados de la subida de múltiples archivos');
// Recent additions 3.43:
if (!defined('_DOWN_ADDFILE_THUMBNAIL')) DEFINE ('_DOWN_ADDFILE_THUMBNAIL', 'Miniatura %u (opcional):');
if (!defined('_DOWN_CONFIG45')) DEFINE("_DOWN_CONFIG45","Licencia por defecto:<br/><i>(Opcional - si se define se usará para cualquier elemento que no tenga una específica)</i>");
if (!defined('_DOWN_CONFIG_TITLE_LICENCE')) DEFINE('_DOWN_CONFIG_TITLE_LICENCE', 'Licencia');
if (!defined('_DOWN_VISIT')) DEFINE('_DOWN_VISIT','Visitar');
if (!defined('_DOWN_EDIT')) DEFINE('_DOWN_EDIT','Editar');
if (!defined('_DOWN_STRUCT_RECURSE_ALL')) DEFINE('_DOWN_STRUCT_RECURSE_ALL','Incluir todos los subdirectorios y sus archivos');
if (!defined('_DOWN_STRUCT_RECURSE_DIR')) DEFINE('_DOWN_STRUCT_RECURSE_DIR','Incluir solo los ficheros y subdirectorios del nivel superior');
if (!defined('_DOWN_STRUCT_RECURSE_NONE')) DEFINE('_DOWN_STRUCT_RECURSE_NONE','Incluir sólo los ficheros del nivel superior');
if (!defined('_DOWN_STRUCT_NO_DIR')) DEFINE ('_DOWN_STRUCT_NO_DIR', 'El directorio especificado no existe');
if (!defined('_DOWN_ADMINISTRATOR')) DEFINE ('_DOWN_ADMINISTRATOR', 'Administrador');
// Recent modifications 3.43:
if (!defined('_DOWN_ADMIN_ACT_ADDSTRUCTURE')) DEFINE('_DOWN_ADMIN_ACT_ADDSTRUCTURE','Añadir archivos que ya están en el servidor');
if (!defined('_DOWN_STRUCTURE_ADDED')) DEFINE('_DOWN_STRUCTURE_ADDED','Archivos añadidos al repositorio');
if (!defined('_DOWN_ADDSTRUCTURE_TITLE')) DEFINE('_DOWN_ADDSTRUCTURE_TITLE','Añadir archivos que ya están en el servidor');
//
if (!defined('_REM_INTERNAL')) DEFINE('_REM_INTERNAL','Error Interno de Remository');
if (!defined('_DOWNLOADS_TITLE')) DEFINE("_DOWNLOADS_TITLE","Descargas de $mosConfig_sitename");
if (!defined('_UP_FILE')) DEFINE('_UP_FILE','Subir Archivo');
if (!defined('_ADD_FILE_BUTTON')) DEFINE('_ADD_FILE_BUTTON','Agregar Archivo');
if (!defined('_SUBMIT_FILE_BUTTON')) DEFINE('_SUBMIT_FILE_BUTTON','Enviar Archivo');
if (!defined('_DOWN_ROLE_REGISTERED')) DEFINE('_DOWN_ROLE_REGISTERED','Registrado');
if (!defined('_DOWN_ROLE_VISITOR')) DEFINE('_DOWN_ROLE_VISITOR','Visitante');
if (!defined('_DOWN_ROLE_NOBODY')) DEFINE('_DOWN_ROLE_NOBODY','Nadie');
if (!defined('_DOWN_ROLE_NONE_THESE')) DEFINE('_DOWN_ROLE_NONE_THESE','Ninguno de estos');
if (!defined('_DOWN_PAGE_TEXT')) DEFINE ('_DOWN_PAGE_TEXT', 'Página');
if (!defined('_DOWN_PAGE_SHOW_RESULTS')) DEFINE('_DOWN_PAGE_SHOW_RESULTS','Mostrar resultados ');
if (!defined('_DOWN_PAGE_SHOW_RANGE')) DEFINE('_DOWN_PAGE_SHOW_RANGE','%s a %s de %s');
if (!defined('_SUBMIT_FILE_NOLOG')) DEFINE('_SUBMIT_FILE_NOLOG', 'Envío denegado - no estás logueado');
if (!defined('_SUBMIT_FILE_NOUSER')) DEFINE('_SUBMIT_FILE_NOUSER', 'Envío denegado - sólo administradores');
if (!defined('_SUBMIT_FILE_NOLIMIT')) DEFINE('_SUBMIT_FILE_NOLIMIT', 'Envío denegado - llegó al límite');
if (!defined('_SUBMIT_FILE_NOSPACE')) DEFINE('_SUBMIT_FILE_NOSPACE', 'Envío denegado - no queda espacio');
if (!defined('_SUBMIT_NO_DDIR')) DEFINE('_SUBMIT_NO_DDIR', 'Envío denegado - no hay directorio de descarga');
if (!defined('_SUBMIT_NO_UDDIR')) DEFINE('_SUBMIT_NO_UDDIR', 'Envío denegado - no hay directorio de subida-bajada');
if (!defined('_SUBMIT_HEADING')) DEFINE('_SUBMIT_HEADING', 'Subir archivo a Descargas');
if (!defined('_SUBMIT_INSTRUCT1')) DEFINE('_SUBMIT_INSTRUCT1', 'Para subir un archivo nuevo, búsquelo y selecciónelo aquí.');
if (!defined('_SUBMIT_INSTRUCT2')) DEFINE('_SUBMIT_INSTRUCT2', 'Si va a hospedarlo en otro destino, ponga la URL del archivo y otros detalles.');
if (!defined('_SUBMIT_INSTRUCT3')) DEFINE('_SUBMIT_INSTRUCT3', 'Elija el archivo a subir, e incluya otros datos relevantes.');
if (!defined('_DOWN_FILE_SUBMIT_NOCHOICES')) DEFINE('_DOWN_FILE_SUBMIT_NOCHOICES','No tiene permisos para subir archivos a ninguna categoría - contacte con el administrador');
if (!defined('_SUBMIT_NEW_FILE')) DEFINE('_SUBMIT_NEW_FILE', 'Archivo nuevo');
if (!defined('_SUBMIT_UPLOAD_BUTTON')) DEFINE('_SUBMIT_UPLOAD_BUTTON', 'Subir Archivo &amp; Guardar');
if (!defined('_MAIN_DOWNLOADS')) DEFINE('_MAIN_DOWNLOADS','Página Principal de Descargas');
if (!defined('_BACK_CAT')) DEFINE('_BACK_CAT','Regresar a la Categoría Original');
if (!defined('_BACK_FOLDER')) DEFINE('_BACK_FOLDER','Regresar a la Carpeta Original');
if (!defined('_DOWN_START')) DEFINE('_DOWN_START','Su descarga comenzará en 2 segundos.');
if (!defined('_DOWN_CLICK')) DEFINE('_DOWN_CLICK','Haga clic aquí si no comienza.');
if (!defined('_INVALID_ID')) DEFINE('_INVALID_ID','ID inválido');
if (!defined('_DOWN_CATEGORY')) DEFINE('_DOWN_CATEGORY','Categoría');
if (!defined('_DOWN_NO_PARENT')) DEFINE('_DOWN_NO_PARENT','Sin categoría padre - nivel superior **');
if (!defined('_DOWN_FOLDER')) DEFINE('_DOWN_FOLDER','Carpeta');
if (!defined('_DOWN_FOLDERS')) DEFINE('_DOWN_FOLDERS','Carpetas');
if (!defined('_DOWN_FILES')) DEFINE('_DOWN_FILES','Archivos');
if (!defined('_DOWN_FOLDERS_FILES')) DEFINE('_DOWN_FOLDERS_FILES','Subcarpetas/Archivos');
if (!defined('_DOWN_NO_CATS')) DEFINE("_DOWN_NO_CATS","El directorio descargas no ha sido establecido para <i>$mosConfig_sitename</i>.<br/>&nbsp;<br/>Sin categorías definidas .");
if (!defined('_DOWN_NO_VISITOR_CATS')) DEFINE('_DOWN_NO_VISITOR_CATS','El repositorio no está disponible para visitantes - Por favor, inicie sesión');
if (!defined('_DOWN_ADMIN_FUNC')) DEFINE('_DOWN_ADMIN_FUNC','Funciones de Administrador:');
if (!defined('_DOWN_ADD_CAT')) DEFINE('_DOWN_ADD_CAT','Agregar Categoría');
if (!defined('_DOWN_DEL_CAT')) DEFINE('_DOWN_DEL_CAT','Eliminar Categoría');
if (!defined('_DOWN_EDIT_CAT')) DEFINE('_DOWN_EDIT_CAT','Editar Categoría');
if (!defined('_DOWN_UP_NEITHER')) DEFINE('_DOWN_UP_NEITHER','Ni unos ni otros');
if (!defined('_DOWN_UP_DOWNLOAD_ONLY')) DEFINE('_DOWN_UP_DOWNLOAD_ONLY','Sólo Descargas');
if (!defined('_DOWN_UP_UPLOAD_ONLY')) DEFINE('_DOWN_UP_UPLOAD_ONLY','Sólo Subidas');
if (!defined('_DOWN_UP_BOTH')) DEFINE('_DOWN_UP_BOTH','Ambos');
if (!defined('_DOWN_USERS_PERMITTED')) DEFINE('_DOWN_USERS_PERMITTED','Usuarios autorizados:');
if (!defined('_DOWN_VISITORS_PERMITTED')) DEFINE('_DOWN_VISITORS_PERMITTED','Visitantes autorizados:');
if (!defined('_DOWN_UP_ABSOLUTE_PATH')) DEFINE('_DOWN_UP_ABSOLUTE_PATH','Ruta Absoluta (opcional):');
if (!defined('_DOWN_ADD_FOLDER')) DEFINE('_DOWN_ADD_FOLDER','Agregar Carpeta');
if (!defined('_DOWN_DEL_FOLDER')) DEFINE('_DOWN_DEL_FOLDER','Borrar Carpeta');
if (!defined('_DOWN_EDIT_FOLDER')) DEFINE('_DOWN_EDIT_FOLDER','Editar Carpeta');
if (!defined('_DOWN_ADD_FILE')) DEFINE('_DOWN_ADD_FILE','Agregar Archivo');
if (!defined('_DOWN_DEL_FILE')) DEFINE('_DOWN_DEL_FILE','Borrar Archivo');
if (!defined('_DOWN_EDIT_FILE')) DEFINE('_DOWN_EDIT_FILE','Editar Archivo');
if (!defined('_DOWN_PUB')) DEFINE('_DOWN_PUB','Publicado:');
if (!defined('_DOWN_SUBMIT_ANOTHER')) DEFINE('_DOWN_SUBMIT_ANOTHER','¿Enviar otro archivo ahora?');
if (!defined('_DOWN_SUBMIT_INSPECT')) DEFINE('_DOWN_SUBMIT_INSPECT','¿Ver el archivo recién enviado?');
if (!defined('_YES')) DEFINE('_YES','Sí');
if (!defined('_NO')) DEFINE('_NO','No');
if (!defined('_GLOBAL')) DEFINE('_GLOBAL','Global');
if (!defined('_DOWN_DESC')) DEFINE('_DOWN_DESC','Descripción:');
if (!defined('_DOWN_DOWNLOADS')) DEFINE('_DOWN_DOWNLOADS','Descargas:');
if (!defined('_DOWN_THUMBNAILS')) DEFINE('_DOWN_THUMBNAILS','Miniaturas:');
if (!defined('_DOWN_RATING')) DEFINE('_DOWN_RATING','Valoración:');
if (!defined('_DOWN_VOTES')) DEFINE('_DOWN_VOTES','Votos Totales:');
if (!defined('_DOWN_YOUR_VOTE')) DEFINE('_DOWN_YOUR_VOTE','Su Voto:');
if (!defined('_DOWN_RATE_BUTTON')) DEFINE('_DOWN_RATE_BUTTON','Evaluar');
if (!defined('_DOWN_ALREADY_VOTE')) DEFINE('_DOWN_ALREADY_VOTE','Ya ha votado por este archivo. Gracias.');
if (!defined('_DOWN_FILE_TITLE')) DEFINE('_DOWN_FILE_TITLE','Título del archivo:');
if (!defined('_DOWN_FILE_TITLE_SORT')) DEFINE('_DOWN_FILE_TITLE_SORT','Título archivo');
if (!defined('_DOWN_REAL_NAME')) DEFINE('_DOWN_REAL_NAME','Nombre físico del archivo:');
if (!defined('_DOWNLOAD')) DEFINE('_DOWNLOAD','Descarga');
if (!defined('_DOWN_DOWNLOADS_SORT')) DEFINE('_DOWN_DOWNLOADS_SORT','Descargas');
if (!defined('_DOWN_SUB_BY')) DEFINE('_DOWN_SUB_BY','Enviado por:');
if (!defined('_DOWN_FILE_DATE')) DEFINE('_DOWN_FILE_DATE','Fecha del archivo:');
if (!defined('_DOWN_FILE_AUTHOR')) DEFINE('_DOWN_FILE_AUTHOR','Autor del archivo:');
if (!defined('_DOWN_FILE_VER')) DEFINE('_DOWN_FILE_VER','Versión del archivo:');
if (!defined('_DOWN_FILE_SIZE')) DEFINE('_DOWN_FILE_SIZE','Tamaño del archivo:');
if (!defined('_DOWN_FILE_TYPE')) DEFINE('_DOWN_FILE_TYPE','Tipo de archivo:');
if (!defined('_DOWN_FILE_COMPANY')) DEFINE('_DOWN_FILE_COMPANY','Compañía:');
if (!defined('_DOWN_FILE_COMPANY_URL')) DEFINE('_DOWN_FILE_COMPANY_URL','Sitio Web de la compañía:');
if (!defined('_DOWN_FILE_AUTHOR_URL')) DEFINE('_DOWN_FILE_AUTHOR_URL','Autor del Sitio Web:');
if (!defined('_DOWN_FILE_RELEASE_DATE')) DEFINE('_DOWN_FILE_RELEASE_DATE','Fecha del lanzamiento (YYYY-MM-DD):');
if (!defined('_DOWN_FILE_STATUS')) DEFINE('_DOWN_FILE_STATUS','Estado:');
if (!defined('_DOWN_FILE_LANGUAGES')) DEFINE('_DOWN_FILE_LANGUAGES','Lengua:');
if (!defined('_DOWN_FILE_REQUIREMENTS')) DEFINE('_DOWN_FILE_REQUIREMENTS','Requerimiento:');
if (!defined('_DOWN_FILE_OPERATING_SYSTEM')) DEFINE('_DOWN_FILE_OPERATING_SYSTEM','Sistema operativo:');
if (!defined('_DOWN_SCREEN')) DEFINE('_DOWN_SCREEN','Captura de Pantalla:');
if (!defined('_DOWN_SCREEN_CLICK')) DEFINE('_DOWN_SCREEN_CLICK','Haz clic para ver');
if (!defined('_DOWN_NA')) DEFINE('_DOWN_NA','No disponible');
if (!defined('_DOWN_CAT_NAME')) DEFINE('_DOWN_CAT_NAME','Nombre Categoría:');
if (!defined('_DOWN_SUB_BUTTON')) DEFINE('_DOWN_SUB_BUTTON','Ir');
if (!defined('_DOWN_ALL_DONE')) DEFINE('_DOWN_ALL_DONE','¡Hecho!');
if (!defined('_DOWN_NOT_AUTH')) DEFINE('_DOWN_NOT_AUTH','Sin Autorización!');
if (!defined('_DOWN_FOLDER_NAME')) DEFINE('_DOWN_FOLDER_NAME','Nombre carpeta:');
if (!defined('_DOWN_FOLDER_ADD_BUT')) DEFINE('_DOWN_FOLDER_ADD_BUT','Añadir carpeta');
if (!defined('_DOWN_UP_WAIT')) DEFINE('_DOWN_UP_WAIT','Nota: todos los envíos se revisan antes de publicarlos.');
if (!defined('_DOWN_AUTOAPP')) DEFINE('_DOWN_AUTOAPP','Su archivo fue automáticamente aprobado y publicado.');
if (!defined('_DOWN_APPROVE_PUB')) DEFINE('_DOWN_APPROVE_PUB','Aprobar + publicar');
if (!defined('_DOWN_SUGGEST_LOC')) DEFINE('_DOWN_SUGGEST_LOC','Sugerir ubicación:');
if (!defined('_DOWNLOAD_URL')) DEFINE('_DOWNLOAD_URL','URL de descarga:');
if (!defined('_DOWN_ICON')) DEFINE('_DOWN_ICON','Icono:');
if (!defined('_DOWN_MOVE_FILE')) DEFINE('_DOWN_MOVE_FILE','Mover el archivo:');
if (!defined('_DOWN_MOVE_FILE_FAILED')) DEFINE('_DOWN_MOVE_FILE_FAILED','Error al mover el archivo');
if (!defined('_DOWN_FILE_NEW_LOC')) DEFINE('_DOWN_FILE_NEW_LOC','Nueva ubicación del archivo:');
if (!defined('_DOWN_AWAIT_APPROVE')) DEFINE('_DOWN_AWAIT_APPROVE','Archivos enviados en espera de aprobación:');
if (!defined('_DOWN_ADMIN_APPROVE')) DEFINE('_DOWN_ADMIN_APPROVE','Aprobar enviados');
if (!defined('_DOWN_ID')) DEFINE('_DOWN_ID','ID');
if (!defined('_DOWN_SUBMIT_DATE')) DEFINE('_DOWN_SUBMIT_DATE','Fecha de envío:');
if (!defined('_DOWN_APP_SUB_BUTTON')) DEFINE('_DOWN_APP_SUB_BUTTON','Aprobar enviado');
if (!defined('_DOWN_DEL_SUB_BUTTON')) DEFINE('_DOWN_DEL_SUB_BUTTON','Borrar enviado');
if (!defined('_DOWN_SUB_APPROVE')) DEFINE('_DOWN_SUB_APPROVE','El envío ha sido aprobado.');
if (!defined('_DOWN_SUB_DEL')) DEFINE('_DOWN_SUB_DEL','El envío ha sido borrado.');
if (!defined('_DOWN_NO_SUB')) DEFINE('_DOWN_NO_SUB','No hay más enviados para aprobar.');
if (!defined('_DOWN_REV_SUB')) DEFINE('_DOWN_REV_SUB','Revisar más enviados');
if (!defined('_DOWN_SEARCH')) DEFINE('_DOWN_SEARCH','Buscar descarga');
if (!defined('_DOWN_SEARCH_TEXT')) DEFINE('_DOWN_SEARCH_TEXT','Buscar:');
if (!defined('_DOWN_SEARCH_FILETITLE')) DEFINE('_DOWN_SEARCH_FILETITLE','Buscar en los títulos de los archivos:');
if (!defined('_DOWN_SEARCH_FILEDESC')) DEFINE('_DOWN_SEARCH_FILEDESC','Buscar en las descripciones de los archivos:');
if (!defined('_DOWN_SEARCH_ERR')) DEFINE('_DOWN_SEARCH_ERR','Tiene que especificar Título o Descripción de archivo para buscar, también con texto.');
if (!defined('_DOWN_SEARCH_NORES')) DEFINE('_DOWN_SEARCH_NORES','No se han encontrado archivos.');
if (!defined('_DOWN_FILE_HOMEPAGE')) DEFINE('_DOWN_FILE_HOMEPAGE','Páginas del documento:');
if (!defined('_DOWN_UPDATE_SUB')) DEFINE('_DOWN_UPDATE_SUB','Actualizar enviado');
if (!defined('_DOWN_UP_EDIT_ID')) DEFINE('_DOWN_UP_EDIT_ID','ID de archivo:');
if (!defined('_DOWN_FILE_DEL_NOTE')) DEFINE('_DOWN_FILE_DEL_NOTE','Nota: el listado del archivo fué eliminado de la base de datos, pero el archivo <b>puede</b> existir todavía. Por favor revise su directorio');
if (!defined('_DOWN_SUB_DATE')) DEFINE('_DOWN_SUB_DATE','Enviado el:');
if (!defined('_DOWN_SUB_DATE_SORT')) DEFINE('_DOWN_SUB_DATE_SORT','Fecha de envío');
if (!defined('_DOWN_SUB_ID_SORT')) DEFINE ('_DOWN_SUB_ID_SORT', 'Autor del envío');
if (!defined('_DOWN_COMMENTS')) DEFINE('_DOWN_COMMENTS','Comentarios:');
if (!defined('_DOWN_YOUR_COMM')) DEFINE('_DOWN_YOUR_COMM','Su comentario:');
if (!defined('_DOWN_LEAVE_COMM')) DEFINE('_DOWN_LEAVE_COMM','Dejar comentario');
if (!defined('_DOWN_FIRST_COMMENT')) DEFINE('_DOWN_FIRST_COMMENT','¡Sea el primero en comentar este archivo!');
if (!defined('_DOWN_FIRST_COMMENT_NL')) DEFINE('_DOWN_FIRST_COMMENT_NL','Para ser el primero en comentar este archivo, ingrese o regístrese.');
if (!defined('_DOWN_ALREADY_COMM')) DEFINE('_DOWN_ALREADY_COMM','Ya hizo un comentario sobre este archivo.');
if (!defined('_DOWN_MAX_COMM')) DEFINE("_DOWN_MAX_COMM","Máx: $Small_Text_Len caracteres");
if (!defined('_DOWN_DESC_MAX')) DEFINE("_DOWN_DESC_MAX","Máx: $Large_Text_Len caracteres");
if (!defined('_DOWN_MAIL_SUB')) DEFINE('_DOWN_MAIL_SUB','Nuevos enviados de Descargas');
if (!defined('_DOWN_MAIL_MSG')) DEFINE('_DOWN_MAIL_MSG','Hola - Hay un nuevo archivo de Descargas para revisar, enviado por $user_full'
                   .' para el sitio $mosConfig_sitename.\n'
                   .'Por favor vaya a $mosConfig_live_site/administrator/index.php como administrador para revisar y aprobar este envío.\n\n'
                   .'Por favor no responder a este mensaje - es un e-mail generado automáticamente, sólo para mandar una notificación\n');
if (!defined('_DOWN_MAIL_MSG_APP')) DEFINE('_DOWN_MAIL_MSG_APP','Hola - Hay un nuevo archivo de Descargas para revisar, enviado por $user_full'
                   .' para el sitio $mosConfig_sitename\n'
                   .'De acuerdo con las opciones de la configuración, ha sido auto-aprobado\n\n'
                   .'Por favor no responder a este mensaje - es un e-mail generado automáticamente, solo para mandar una notificación\n');
if (!defined('_DOWN_ORDER_BY')) DEFINE('_DOWN_ORDER_BY','Ordenar por :');
if (!defined('_DOWN_RESET')) DEFINE('_DOWN_RESET','Recalcular conteo de archivos');
if (!defined('_DOWN_RESET_GO')) DEFINE('_DOWN_RESET_GO','Recalculando conteo de archivos...');
if (!defined('_DOWN_RESET_DONE')) DEFINE('_DOWN_RESET_DONE','Recálculo de archivo terminado');
if (!defined('_DOWN_FIND_ORPHANS')) DEFINE('_DOWN_FIND_ORPHANS','Buscar archivos huérfanos');
if (!defined('_DOWN_DEL_ORPHANS')) DEFINE('_DOWN_DEL_ORPHANS','Borrar archivos huérfanos');
if (!defined('_DOWN_ORPHAN_SELECT')) DEFINE('_DOWN_ORPHAN_SELECT','Seleccionar');
if (!defined('_DOWN_ORPHAN_FILE_DEL')) DEFINE('_DOWN_ORPHAN_FILE_DEL','Archivo para borrar');
if (!defined('_DOWN_ORPHAN_NODEL')) DEFINE('_DOWN_ORPHAN_NODEL','No hay archivos para borrar');
if (!defined('_DOWN_ORPHAN_DONE')) DEFINE('_DOWN_ORPHAN_DONE','Archivos huérfanos borrados');
if (!defined('_DOWN_BAD_POST')) DEFINE('_DOWN_BAD_POST','Los parámetros no han sido enviados correctamente.');
if (!defined('_DOWN_SUB_WAIT')) DEFINE('_DOWN_SUB_WAIT','Un envío ya está en revisión para este archivo.');
if (!defined('_DOWN_REG_ONLY')) DEFINE('_DOWN_REG_ONLY','Sólo usuarios registrados:');
if (!defined('_DOWN_RESTRICTED_WARN')) DEFINE('_DOWN_RESTRICTED_WARN','Este área no existe o no está disponible');
if (!defined('_DOWN_MEMBER_ONLY_WARN')) DEFINE("_DOWN_MEMBER_ONLY_WARN","Este área es solamente para Usuarios Registrados.<BR />"
                            ."Por favor contacte con un administrador referente a este grupo ");
if (!defined('_DOWN_REG_ONLY_WARN')) DEFINE("_DOWN_REG_ONLY_WARN","Este área es solamente para Usuarios Registrados.<BR />"
                            ."Por favor, accede con tu cuenta o <a href='index.php?option=com_registration&task=register'>Regístrate</a>.");
if (!defined('_DOWN_COUNT_EXCEEDED')) DEFINE('_DOWN_COUNT_EXCEEDED',"Su límite de descargas ha sido alcanzado");
if (!defined('_DOWN_COUNT_EXCEEDED_FILE')) DEFINE('_DOWN_COUNT_EXCEEDED_FILE',"Su límite de descargas de este archivo ha sido alcanzado");
if (!defined('_DOWN_NO_FILEN')) DEFINE('_DOWN_NO_FILEN','Por favor debe introducir un título para el archivo');
if (!defined('_DOWN_MINI_SCREEN_PROMPT')) DEFINE('_DOWN_MINI_SCREEN_PROMPT','Mostrar captura de pantalla:');
if (!defined('_DOWN_SEL_LOC_PROMPT')) DEFINE('_DOWN_SEL_LOC_PROMPT','Elegir ubicación');
if (!defined('_DOWN_ALL_LOC_PROMPT')) DEFINE('_DOWN_ALL_LOC_PROMPT','Todas las ubicaciones');
if (!defined('_DOWN_SEL_CAT_DEL')) DEFINE('_DOWN_SEL_CAT_DEL','Elegir una categoría para borrar');
if (!defined('_DOWN_NO_CAT_DEF')) DEFINE('_DOWN_NO_CAT_DEF','No hay categorías definidas');
if (!defined('_DOWN_PUB_PROMPT')) DEFINE('_DOWN_PUB_PROMPT','Elegir una categoría para ');
if (!defined('_DOWN_SEL_FILE_DEL')) DEFINE('_DOWN_SEL_FILE_DEL','Elegir un archivo para borrar');
if (!defined('_DOWN_CONFIG_COMP')) DEFINE('_DOWN_CONFIG_COMP','Los detalles de configuración han sido actualizados.');
if (!defined('_DOWN_CONFIG_ERR')) DEFINE("_DOWN_CONFIG_ERR","Un error ha ocurrido.\nNo se pudo abrir el archivo de configuración para escribir.");
if (!defined('_DOWN_CATS')) DEFINE('_DOWN_CATS','Categorías');
if (!defined('_DOWN_PARENT_CAT')) DEFINE('_DOWN_PARENT_CAT','Categoría Padre');
if (!defined('_DOWN_PARENT_FOLDER')) DEFINE('_DOWN_PARENT_FOLDER','Carpeta');
if (!defined('_DOWN_PUB1')) DEFINE('_DOWN_PUB1','Publicado');
if (!defined('_DOWN_RECORDS')) DEFINE('_DOWN_RECORDS','Documentos');
if (!defined('_DOWN_ACCESS')) DEFINE('_DOWN_ACCESS','Acceso');
if (!defined('_DOWN_GROUP')) DEFINE('_DOWN_GROUP','Grupo');
if (!defined('_DOWN_FILE_SYSTEM')) DEFINE('_DOWN_FILE_SYSTEM','Sistema de archivos');
if (!defined('_DOWN_FILE_SYSTEM_OK')) DEFINE('_DOWN_FILE_SYSTEM_OK','Sistema de archivos - OK');
if (!defined('_DOWN_DIRECTORY_NON_EXISTENT')) DEFINE('_DOWN_DIRECTORY_NON_EXISTENT','Directorio inexistente');
if (!defined('_DOWN_NOT_WRITEABLE')) DEFINE('_DOWN_NOT_WRITEABLE','Directorio no escribible');
if (!defined('_DOWN_WRITEABLE')) DEFINE('_DOWN_WRITEABLE','Directorio escribible');
if (!defined('_DOWN_DATABASE')) DEFINE('_DOWN_DATABASE','Base de Datos');
if (!defined('_DOWN_ADMIN_CPANEL_STORE')) DEFINE ('_DOWN_ADMIN_CPANEL_STORE','Almacenaje por defecto para las nuevas carpetas:');
if (!defined('_DOWN_ADMIN_CPANEL_FILESTORE')) DEFINE ('_DOWN_ADMIN_CPANEL_FILESTORE','Almacén por defecto en el sistema de archivos:');
if (!defined('_DOWN_ADMIN_CPANEL_UPLOADS')) DEFINE ('_DOWN_ADMIN_CPANEL_UPLOADS','Directorio de subidas no aprobadas:');
if (!defined('_DOWN_CPANEL_RETURN')) DEFINE ('_DOWN_CPANEL_RETURN','Panel de control');
if (!defined('_DOWN_CPANEL_SUB_BASIC')) DEFINE ('_DOWN_CPANEL_SUB_BASIC','Gestión básica');
if (!defined('_DOWN_CPANEL_SUB_FILES')) DEFINE ('_DOWN_CPANEL_SUB_FILES','Manipulación de archivos');
if (!defined('_DOWN_CPANEL_SUB_HKEEP')) DEFINE ('_DOWN_CPANEL_SUB_HKEEP','Limpieza');
if (!defined('_DOWN_CPANEL_SUB_UTILS')) DEFINE ('_DOWN_CPANEL_SUB_UTILS','Utilidades');
if (!defined('_DOWN_CPANEL_SUB_INFO')) DEFINE ('_DOWN_CPANEL_SUB_INFO','Información');
if (!defined('_DOWN_ADMIN_ACT_CONTAINERS')) DEFINE('_DOWN_ADMIN_ACT_CONTAINERS','Gestionar carpetas');
if (!defined('_DOWN_ADMIN_ACT_FILES')) DEFINE('_DOWN_ADMIN_ACT_FILES','Gestionar archivos');
if (!defined('_DOWN_ADMIN_ACT_GROUPS')) DEFINE('_DOWN_ADMIN_ACT_GROUPS','Gestionar grupos');
if (!defined('_DOWN_ADMIN_ACT_UPLOADS')) DEFINE('_DOWN_ADMIN_ACT_UPLOADS','Aprobar subidas');
if (!defined('_DOWN_ADMIN_ACT_CONFIG')) DEFINE('_DOWN_ADMIN_ACT_CONFIG','Configuración');
if (!defined('_DOWN_ADMIN_ACT_UNLINKED')) DEFINE('_DOWN_ADMIN_ACT_UNLINKED','Gestionar no enlazados / huérfanos');
if (!defined('_DOWN_ADMIN_ACT_FTP')) DEFINE('_DOWN_ADMIN_ACT_FTP','Añadir archivos desde el servidor');
if (!defined('_DOWN_ADMIN_ACT_MISSING')) DEFINE('_DOWN_ADMIN_ACT_MISSING','Listar archivos que faltan');
if (!defined('_DOWN_ADMIN_ACT_COUNTS')) DEFINE('_DOWN_ADMIN_ACT_COUNTS','Recalcular conteos de archivos');
if (!defined('_DOWN_ADMIN_ACT_DOWNLOADS')) DEFINE('_DOWN_ADMIN_ACT_DOWNLOADS','Establecer conteos a cero');
if (!defined('_DOWN_ADMIN_ACT_PRUNE')) DEFINE('_DOWN_ADMIN_ACT_PRUNE','Eliminar registros antiguos');
if (!defined('_DOWN_ADMIN_ACT_THUMBS')) DEFINE('_DOWN_ADMIN_ACT_THUMBS','Comprobar integridad de miniaturas');
if (!defined('_DOWN_ADMIN_ACT_DBCONVERT')) DEFINE('_DOWN_ADMIN_ACT_DBCONVERT','Convertir base de datos pre 3.20');
if (!defined('_DOWN_ADMIN_ACT_DBCONVERT2')) DEFINE('_DOWN_ADMIN_ACT_DBCONVERT2','Convertir base de datos pre 3.40');
if (!defined('_DOWN_ADMIN_ACT_STATS')) DEFINE('_DOWN_ADMIN_ACT_STATS','Estadísticas');
if (!defined('_DOWN_ADMIN_ACT_ABOUT')) DEFINE('_DOWN_ADMIN_ACT_ABOUT','Acerca de Remository');
if (!defined('_DOWN_ADMIN_ACT_SUPPORT')) DEFINE('_DOWN_ADMIN_ACT_SUPPORT','Servicios de soporte y desarrollo');
if (!defined('_DOWN_MOST_DOWNLOADED')) DEFINE('_DOWN_MOST_DOWNLOADED','Más descargados');
if (!defined('_DOWN_MOST_DOWNLOADED_LONG')) DEFINE('_DOWN_MOST_DOWNLOADED_LONG','Archivos con mayor conteo de descargas');
if (!defined('_DOWN_POPULAR')) DEFINE ('_DOWN_POPULAR','Archivos más populares');
if (!defined('_DOWN_POPULAR_LONG')) DEFINE ('_DOWN_POPULAR_LONG','Archivos más descargados en los últimos %s días');
if (!defined('_DOWN_NEWEST')) DEFINE ('_DOWN_NEWEST','Archivos recientes');
if (!defined('_DOWN_NEWEST_LONG')) DEFINE ('_DOWN_NEWEST_LONG','Lo último de nuestro repositorio de archivos');
if (!defined('_DOWN_VISITORS')) DEFINE('_DOWN_VISITORS','Visitantes');
if (!defined('_DOWN_REG_USERS')) DEFINE ('_DOWN_REG_USERS','Usuarios');
if (!defined('_DOWN_OTHER_USERS')) DEFINE ('_DOWN_OTHER_USERS', 'Otros usuarios');
if (!defined('_DOWN_STORAGE_STATUS')) DEFINE ('_DOWN_STORAGE_STATUS','Estado del almacenamiento');
if (!defined('_DOWN_ALL_REGISTERED')) DEFINE('_DOWN_ALL_REGISTERED','Todos los usuarios registrados');
if (!defined('_DOWN_REG_ONLY_TITLE')) DEFINE('_DOWN_REG_ONLY_TITLE','Sólo registrados');
if (!defined('_DOWN_PUBLIC_TITLE')) DEFINE('_DOWN_PUBLIC_TITLE','Público');
if (!defined('_DOWN_APPROVE_TITLE')) DEFINE('_DOWN_APPROVE_TITLE','Archivos para aprobar');
if (!defined('_DOWN_DATE')) DEFINE('_DOWN_DATE','Fecha');
if (!defined('_DOWN_NAME_TITLE')) DEFINE('_DOWN_NAME_TITLE','Nombre');
if (!defined('_DOWN_CONFIG_TITLE')) DEFINE('_DOWN_CONFIG_TITLE','Configuración');
if (!defined('_DOWN_CONFIG_TITLE1')) DEFINE('_DOWN_CONFIG_TITLE1','Rutas y miscelánea');
if (!defined('_DOWN_CONFIG_TITLE2')) DEFINE('_DOWN_CONFIG_TITLE2','Permisos');
if (!defined('_DOWN_CONFIG_TITLE3')) DEFINE('_DOWN_CONFIG_TITLE3','Texto de descarga');
if (!defined('_DOWN_CONFIG_TITLE4')) DEFINE('_DOWN_CONFIG_TITLE4','Configurar páginas');
if (!defined('_DOWN_CONFIG_TITLE_PREAMBLE')) DEFINE('_DOWN_CONFIG_TITLE_PREAMBLE','Introducción');
if (!defined('_DOWN_CONFIG1')) DEFINE("_DOWN_CONFIG1","<b>Clases CSS para las filas:</b><br/><i>(Clases CSS para los colores de filas alternas - dos valores separados por coma)</i>");
if (!defined('_DOWN_CONFIG2')) DEFINE("_DOWN_CONFIG2","<b>Clases CSS para la cabecera:</b><br/><i>(Clase CSS de la cabecera de la página y del fondo del panel del Administrador)</i>");
if (!defined('_DOWN_CONFIG3')) DEFINE("_DOWN_CONFIG3","<b>Ruta directorio descargas:</b><br/><i>(Ruta del directorio de descargas - Webs - NO Trailing Slash)</i>");
if (!defined('_DOWN_CONFIG4')) DEFINE("_DOWN_CONFIG4","<b>Ruta directorio descargas:</b><br/><i>(Ruta del directorio de descargas - Archivos - NO Trailing Slash)</i>");
if (!defined('_DOWN_CONFIG5')) DEFINE("_DOWN_CONFIG5","<b>Ruta directorio enviados:</b><br/><i>(Ruta del directorio de archivos enviados - NO Trailing Slash)</i>");
if (!defined('_DOWN_CONFIG6')) DEFINE("_DOWN_CONFIG6","<b>Tamaño máximo:</b><br/><i>(Máximo tamaño para un archivos enviado - en Kb's)</i>");
if (!defined('_DOWN_CONFIG7')) DEFINE("_DOWN_CONFIG7","<b>Máximos archivos enviados por día:</b><br/><i>(Número máximo permitido de archivos enviados al día por un usuario (Administradores ilimitado))</i>");
if (!defined('_DOWN_CONFIG8')) DEFINE("_DOWN_CONFIG8","<b>Tamaño máximo para archivos enviados: </b><br/><i>(Tamaño máximo del directorio de subidas aprobadas - en Kb's)</i>");
if (!defined('_DOWN_CONFIG9')) DEFINE("_DOWN_CONFIG9","<b>Extensiones aprovadas: </b><br/><i>(Extensiones aprobadas para los archivos enviados - usar COMA como separador)</i>");
if (!defined('_DOWN_CONFIG10')) DEFINE("_DOWN_CONFIG10","<b>Etiquetas permitidas:</b><br/><i>(Etiquetas HTML permitidas en los textos de los archivos subidos - usar COMA como separador)</i>");
if (!defined('_DOWN_CONFIG11')) DEFINE("_DOWN_CONFIG11","<b>Permitir sobreescritura:</b><br/><i>(Permitir que los nuevos archivos enviados sobreescriban archivos existentes)</i>");
if (!defined('_DOWN_CONFIG12')) DEFINE("_DOWN_CONFIG12","<b>Permitir enviar archivos a los usuarios:</b><br/><i>(Permitir que los usuarios suban archivos - los archivos necesitarán ser aprobados por el Administrador)</i>");
if (!defined('_DOWN_CONFIG13')) DEFINE("_DOWN_CONFIG13","<b>Permitir correcciones: </b><br/><i>(Permitir que los usuarios corrijan sus archivos enviados - los archivos necesitarán ser Reaprobados por el Administrador)</i>");
if (!defined('_DOWN_CONFIG14')) DEFINE("_DOWN_CONFIG14","<b>Permitir envíos de archivos: </b><br/><i>(Permitir que los usuarios suban archivos - los archivos deben ser aprobados por el Administrador)</i>");
if (!defined('_DOWN_CONFIG15')) DEFINE("_DOWN_CONFIG15","<b>Permitir comentarios:</b><br/><i>(Permitir que los usuarios dejen comentarios en los archivos)</i>");
if (!defined('_DOWN_CONFIG16')) DEFINE("_DOWN_CONFIG16","<b>Enviar email:</b><br/><i>(Enviar un email al administrador (o al suplente) cuando un usuario suba un archivo)</i>");
if (!defined('_DOWN_CONFIG17')) DEFINE("_DOWN_CONFIG17","<b>Dirección alternativar:</b><br/><i>(Dirección de email alternativa para enviar avisos de archivos enviados - si no se define se utilizará el email del administrador del sitio)</i>");
if (!defined('_DOWN_CONFIG18')) DEFINE("_DOWN_CONFIG18","<b>Título alternativo:</b><br/><i>(Título alternativo para las notificaciones de subida)</i>");
if (!defined('_DOWN_CONFIG19')) DEFINE("_DOWN_CONFIG19","<b>Imagen para el encabezado:</b><br/><i>(Imagen del encabezado - URL)</i>");
if (!defined('_DOWN_CONFIG20')) DEFINE("_DOWN_CONFIG20","<b>Anti-Leach:</b><br/><i>(Máscara de archivos para prevenir el enlace directo)</i>");
if (!defined('_DOWN_CONFIG21')) DEFINE("_DOWN_CONFIG21","<b>Longitud de campos grandes:</b><br/><i>(Máxima longitud de los campos de texto grandes - Descripción, licencia))</i>");
if (!defined('_DOWN_CONFIG22')) DEFINE("_DOWN_CONFIG22","<b>Longitud de campos pequeños:</b><br/><i>(Máxima longitud de los campos de texto pequeños - Introducción, campo de texto)</i>");
if (!defined('_DOWN_CONFIG23')) DEFINE("_DOWN_CONFIG23","<b>Anchura de imágenes pequeñas:</b><br/><i>(Ancho de las capturas de pantalla pequeñas)</i>");
if (!defined('_DOWN_CONFIG24')) DEFINE("_DOWN_CONFIG24","<b>Altura de imágenes pequeñas:</b><br/><i>(Alto de las capturas de pantalla pequeñas)</i>");
if (!defined('_DOWN_CONFIG25')) DEFINE("_DOWN_CONFIG25","<b>Permitir votaciones: </b><br/><i>(Permitir que los usuarios voten los archivos)</i>");
if (!defined('_DOWN_CONFIG26')) DEFINE("_DOWN_CONFIG26","<b>Activar auto-publicación para Administradores:</b><br/><i>(Permitir que los archivos subidos por un ADMINISTRADOR se aprueben y publiquen automáticamente)</i>");
if (!defined('_DOWN_CONFIG27')) DEFINE("_DOWN_CONFIG27","<b>Permitir auto-publicación para usuarios:</b><br/><i>(Permitir que los archivos subidos por un USUARIO REGISTRADO que se aprueben y publiquen automáticamente)</i>");
if (!defined('_DOWN_CONFIG28')) DEFINE("_DOWN_CONFIG28","<b>Activar descargas en listados: </b><br/><i>(Permitir la descarga de la lista de archivos/categorias/directorios)</i>");
if (!defined('_DOWN_CONFIG29')) DEFINE("_DOWN_CONFIG29","<b>Archivos remotos</b><br/><i>(Permitir que los usuarios envíen archivos remotamente:</b><br/><i>(Archivos que se encuentran en otras webs)</i>");
if (!defined('_DOWN_CONFIG30')) DEFINE("_DOWN_CONFIG30","<b>Máximos archivos favoritos: </b><br/><i>(Permitir que los usuarios registren sus archivos favoritos)</i>");
if (!defined('_DOWN_CONFIG31')) DEFINE("_DOWN_CONFIG31","<b>Formato de fecha:</b><br/><i>(Ajuste el formato de las fechas de Descargas - parámetro 1 de la función de la fecha de PHP)</i>");
if (!defined('_DOWN_CONFIG32')) DEFINE("_DOWN_CONFIG32","<b>Versión por defecto:</b><br/><i>(Valor prefijado para dar la versión del archivo enviado)</i>");
if (!defined('_DOWN_CONFIG33')) DEFINE('_DOWN_CONFIG33','<b>Permitir ver  categorías sin permisos: </b><br/><i>(Permitir a los usuarios ver las categorías/carpetas de las que no pueden descargar)</i>');
if (!defined('_DOWN_CONFIG34')) DEFINE('_DOWN_CONFIG34','<b>Permitir ver archivos sin permisos: </b><br/><i>(Permitir a los usuarios ver los archivos que no pueden descargar)</i>');
if (!defined('_DOWN_CONFIG35')) DEFINE('_DOWN_CONFIG35','<b>Miniaturas máximas:</b><br/><i>(Número máximo de miniaturas que se almacenarán; 0 si sólo se permite URL)</i>');
if (!defined('_DOWN_CONFIG36')) DEFINE("_DOWN_CONFIG36","<b>Anchura de imagen:</b><br/><i>(Ancho de las capturas de pantalla grandes)</i>");
if (!defined('_DOWN_CONFIG37')) DEFINE("_DOWN_CONFIG37","<b>Altura de imagen:</b><br/><i>(Alto de las capturas de pantalla grandes)</i>");
if (!defined('_DOWN_CONFIG38')) DEFINE("_DOWN_CONFIG38","<b>Capturas de pantalla:</b><br/><i>(Permitir que las capturas de pantalla grandes se muestren en una ventana emergente)</i>");
if (!defined('_DOWN_CONFIG39')) DEFINE("_DOWN_CONFIG39","<b>Almacenar archivos en la base de datos, por defecto</b>");
if (!defined('_DOWN_CONFIG40')) DEFINE("_DOWN_CONFIG40","<b>Máximas descargas diarias:</b><br/><i>(Número máximo de descargas permitidas al día para un usuario - Administradores ilimitado)</i>");
if (!defined('_DOWN_CONFIG41')) DEFINE("_DOWN_CONFIG41","<b>Máximas descargas diarias:</b><br/><i>(Número máximo de descargas de un mismo archivo permitidas al día para un usuario. Administradores ilimitado)</i>");
if (!defined('_DOWN_CONFIG42')) DEFINE("_DOWN_CONFIG42","<b>Permitir borrar archivos:</b><br/><i>(Permitir borrar un archivo al usuario que lo envió)</i>");
if (!defined('_DOWN_CONFIG43')) DEFINE('_DOWN_CONFIG43','<b>Crear miniaturas de forma automática:</b><br/><i>(Crear miniaturas automáticamente para los archivos de imagen)</i>');
if (!defined('_DOWN_CONFIG44')) DEFINE("_DOWN_CONFIG44","<b>Máximas descargas diarias para un usuario registrado:</b><br/><i>(Número máximo de descargas permitidas al día para un usuario registrado - Administradores ilimitado)</i>");
if (!defined('_DOWN_STATS_TITLE')) DEFINE('_DOWN_STATS_TITLE','- Estadísticas');
if (!defined('_DOWN_TOP_TITLE')) DEFINE('_DOWN_TOP_TITLE','Top');
if (!defined('_DOWN_RATED_TITLE')) DEFINE('_DOWN_RATED_TITLE','- Más Valorados');
if (!defined('_DOWN_VOTED_ON')) DEFINE('_DOWN_VOTED_ON','- Más votados');
if (!defined('_DOWN_VOTES_TITLE')) DEFINE('_DOWN_VOTES_TITLE','Votos');
if (!defined('_DOWN_RATING_TITLE')) DEFINE('_DOWN_RATING_TITLE','Valoración');
if (!defined('_DOWN_ABOUT')) DEFINE('_DOWN_ABOUT','Acerca de');
if (!defined('_DOWN_SUPPORT')) DEFINE('_DOWN_SUPPORT','Soporte');
if (!defined('_DOWN_ABOUT_DESCRIBE')) DEFINE('_DOWN_ABOUT_DESCRIBE','Remository - Repositorio de archivos para Joomla/MamboOpenSource 4.5+');
if (!defined('_DOWN_TITLE_ABOUT')) DEFINE('_DOWN_TITLE_ABOUT','Título');
if (!defined('_DOWN_VERSION_ABOUT')) DEFINE('_DOWN_VERSION_ABOUT','Versión');
if (!defined('_DOWN_AUTHOR_ABOUT')) DEFINE('_DOWN_AUTHOR_ABOUT','Autor');
if (!defined('_DOWN_WEBSITE_ABOUT')) DEFINE('_DOWN_WEBSITE_ABOUT','Sitio web');
if (!defined('_DOWN_EMAIL_ABOUT')) DEFINE('_DOWN_EMAIL_ABOUT','E-mail');
if (!defined('_DOWN_SEL_FILE_APPROVE')) DEFINE('_DOWN_SEL_FILE_APPROVE','Elegir un archivo para aprobar');
if (!defined('_DOWN_DESC_SMALL')) DEFINE('_DOWN_DESC_SMALL','Reseña breve:');
if (!defined('_DOWN_DESC_SMALL_MAX')) DEFINE('_DOWN_DESC_SMALL_MAX','Máx: 150 Caracteres');
if (!defined('_DOWN_AUTO_SHORT')) DEFINE('_DOWN_AUTO_SHORT','Autogenerar descripción breve:');
if (!defined('_DOWN_LICENSE')) DEFINE('_DOWN_LICENSE','Licencia:');
if (!defined('_DOWN_LICENSE_AGREE')) DEFINE('_DOWN_LICENSE_AGREE','Debe aceptar la licencia:');
if (!defined('_DOWN_LEECH_WARN')) DEFINE('_DOWN_LEECH_WARN','Tu sesión no fue válida y las medidas de seguridad están vigentes.');
if (!defined('_DOWN_LICENSE_WARN')) DEFINE('_DOWN_LICENSE_WARN','Por favor, debe leer y aceptar la licencia para comenzar la descarga.');
if (!defined('_DOWN_LICENSE_CHECKBOX')) DEFINE('_DOWN_LICENSE_CHECKBOX','Estoy de acuerdo con los términos anteriores.');
if (!defined('_DOWN_DATE_FORMAT')) DEFINE("_DOWN_DATE_FORMAT","%d %B %Y"); //Uses PHP's strftime Command Format
if (!defined('_DOWN_FILE_NOTFOUND')) DEFINE('_DOWN_FILE_NOTFOUND','Archivo no encontrado');
if (!defined('_DOWN_ACCESS_GROUP')) DEFINE('_DOWN_ACCESS_GROUP','Grupo permitido:');
if (!defined('_DOWN_THUMB_WRONG_TYPE')) DEFINE('_DOWN_THUMB_WRONG_TYPE','<h3>Los archivos de la miniaturas deben ser png, jpg or jpeg</h3>');
if (!defined('_DOWN_EXTENSION_IN_TITLE')) DEFINE('_DOWN_EXTENSION_IN_TITLE','Extensión en el título');
if (!defined('_DOWN_INHERIT')) DEFINE('_DOWN_INHERIT','¿Heredarán la configuración todas las subcarpetas por debajo de esta?');
if (!defined('_DOWN_FORCE_INHERIT')) DEFINE('_DOWN_FORCE_INHERIT','Forzar a las subcarpetas por debajo de esta a heredar las configuraciones marcadas');
if (!defined('_DOWN_EXT_IN_TITLE')) DEFINE('_DOWN_EXT_IN_TITLE','Extensión en el título');
if (!defined('_DOWN_BULK_ADD_FILES')) DEFINE('_DOWN_BULK_ADD_FILES','añadir archivos desde el directorio de descargas');
if (!defined('_DOWN_NO_AVAILABLE_FILES')) DEFINE('_DOWN_NO_AVAILABLE_FILES','No hay archivos disponibles');
if (!defined('_DOWN_ABS_PATH_TO_FILES')) DEFINE('_DOWN_ABS_PATH_TO_FILES','Ruta absoluta hasta los archivos:');
if (!defined('_DOWN_ACCEPTABLE_EXTENSIONS')) DEFINE('_DOWN_ACCEPTABLE_EXTENSIONS','Extensiones aceptadas (comma separated):');
if (!defined('_DOWN_EXTENSION_IN_TITLE')) DEFINE('_DOWN_EXTENSION_IN_TITLE','Extensión incluída en el título:');
if (!defined('_DOWN_DOWNLOAD_TEXT_BOX')) DEFINE('_DOWN_DOWNLOAD_TEXT_BOX','Cuadro de texto de descarga');
if (!defined('_DOWN_MAIN_PREAMBLE')) DEFINE('_DOWN_MAIN_PREAMBLE', 'Texto para la página principal');
if (!defined('_DOWN_PRUNE_LOG')) DEFINE('_DOWN_PRUNE_LOG','Purgar el archivo de registro (logfile)');
if (!defined('_DOWN_LOGFILE_CUTOFF_DATE')) DEFINE('_DOWN_LOGFILE_CUTOFF_DATE','Las entradas del archivo de registro (logfile) anteriores a esta fecha serán borradas:');
if (!defined('_DOWN_PRESS_SAVE_ACTIVATE')) DEFINE('_DOWN_PRESS_SAVE_ACTIVATE','después presione "Guardar" para activar.');
if (!defined('_DOWN_METHOD_NOT_PRESENT')) DEFINE('_DOWN_METHOD_NOT_PRESENT','Error %s en el componente: intento de usar el método inexistente %s en %s');
if (!defined('_DOWN_CLASS_NOT_PRESENT')) DEFINE('_DOWN_CLASS_NOT_PRESENT','Error %s en el componente: intento de usar la clase inexistente %s');
if (!defined('_DOWN_NO_UPLOAD_TO_FILES')) DEFINE('_DOWN_NO_UPLOAD_TO_FILES','No se puede subir a una carpeta con una ruta de archivo');
if (!defined('_DOWN_COUNTS_RECALCULATED')) DEFINE('_DOWN_COUNTS_RECALCULATED','Conteos de archivos y carpetas recalculados');
if (!defined('_DOWN_COUNTS_RESET')) DEFINE('_DOWN_COUNTS_RESET','Conteos de descarga de archivos reseteados');
if (!defined('_DOWN_OLD_LOG_REMOVED')) DEFINE('_DOWN_OLD_LOG_REMOVED','Entradas del archivo de registro (logfile) anteriores a %s eliminadas.');
if (!defined('_DOWN_NONE_MISSING')) DEFINE('_DOWN_NONE_MISSING','No faltan archivos');
if (!defined('_DOWN_BLOB_NOCHUNKS')) DEFINE('_DOWN_BLOB_NOCHUNKS',' - LA TABLA BLOB TIENE 0 CHUNKS');
if (!defined('_DOWN_CHUNKS_DISCREPANCY')) DEFINE('_DOWN_CHUNKS_DISCREPANCY',' - LA TABLA BLOB TIENE %s CHUNKS, EL ARCHIVO DICE %s');
if (!defined('_DOWN_PLAINTEXT_DISCREPANCY')) DEFINE('_DOWN_PLAINTEXT_DISCREPANCY',' - LA TABLA DE TEXTO PLANO TIENE %s ENTRADAS, DEBERÍAN SER EXACTAMENTE 1');
if (!defined('_DOWN_NOT_FOUND_HERE')) DEFINE('_DOWN_NOT_FOUND_HERE',' - NO SE ENCONTRÓ EN ESTA LOCALIZACIÓN<br/>');
if (!defined('_DOWN_LOCAL_NO_URL')) DEFINE('_DOWN_LOCAL_NO_URL','ARCHIVO REMOTO, PERO NO SE ESPECIFICÓ URL');
if (!defined('_DOWN_NOT_VALID_BR')) DEFINE('_DOWN_NOT_VALID_BR',' - NO VALIDADO<br/>');
if (!defined('_DOWN_NO_RELEVANT_THUMB')) DEFINE('_DOWN_NO_RELEVANT_THUMB',' - no hay archivos relevantes - intento de eliminación.<br/>');
if (!defined('_DOWN_THUMB_NOT_BELONG')) DEFINE('_DOWN_THUMB_NOT_BELONG','El archivo %s del directorio %s no se corresponde - intento de eliminación.<br/>');
if (!defined('_DOWN_THUMB_NOT_IN_DB')) DEFINE('_DOWN_THUMB_NOT_IN_DB',' - no hay coincidencia en la base de datos - intento de eliminación.<br/>');
if (!defined('_DOWN_THUMB_OK')) DEFINE('_DOWN_THUMB_OK','No se encontraron problemas con los archivos de miniaturas');
if (!defined('_DOWN_DB_CONVERT_OK')) DEFINE('_DOWN_DB_CONVERT_OK','Conversión de la base de datos completada. Los archivos listados arriba no eran válidos.');
if (!defined('_DOWN_ADD_NUMBER_FILES')) DEFINE('_DOWN_ADD_NUMBER_FILES','Subir varios archivos de una vez');
if (!defined('_DOWN_DISPLAY_NUMBER')) DEFINE('_DOWN_DISPLAY_NUMBER','Mostrar #');
if (!defined('_DOWN_SEARCH_COLON')) DEFINE('_DOWN_SEARCH_COLON','Buscar:');
if (!defined('_DOWN_SHOW_DESCENDANTS')) DEFINE('_DOWN_SHOW_DESCENDANTS','Mostrar subcarpetas: ');
if (!defined('_DOWN_CLICK_TO_VISIT')) DEFINE('_DOWN_CLICK_TO_VISIT','Hacer clic para visitar la página');
if (!defined('_DOWN_CONTAINERS')) DEFINE('_DOWN_CONTAINERS','Carpetas');
if (!defined('_DOWN_UP_PLAIN_TEXT')) DEFINE('_DOWN_UP_PLAIN_TEXT','¿Guardar el archivo como texto plano?');
if (!defined('_GLOBAL')) DEFINE('_GLOBAL','Global');
if (!defined('_DOWN_KEYWORDS')) DEFINE('_DOWN_KEYWORDS', 'Palabras clave:');
if (!defined('_DOWN_WINDOW_TITLE')) DEFINE('_DOWN_WINDOW_TITLE','Título de la ventana:');
if (!defined('_DOWN_EDITOR_GROUP')) DEFINE('_DOWN_EDITOR_GROUP','Grupo editor:');
if (!defined('_DOWN_AUTO_FOR_ADMIN')) DEFINE('_DOWN_AUTO_FOR_ADMIN','Auto-aprobar envío de Administradores:');
if (!defined('_DOWN_AUTO_FOR_USERS')) DEFINE('_DOWN_AUTO_FOR_USERS','Auto-aprobar envío de Usuarios:');
if (!defined('_DOWN_AUTO_USER_GROUP')) DEFINE('_DOWN_AUTO_USER_GROUP','Auto-aprobar envío de grupo de usuarios:');
if (!defined('_DOWN_CONTAINER_CASCADE')) DEFINE('_DOWN_CONTAINER_CASCADE','Aplicar a todos los subdirectorios:');
if (!defined('_DOWN_THANK_YOU')) DEFINE('_DOWN_THANK_YOU','Gracias por descargar ');
if (!defined('_DOWN_WAIT_OR_CLICK')) DEFINE('_DOWN_WAIT_OR_CLICK','Si su descarga no comienza automáticamente en unos pocos segundos haga clic en el siguiente enlace');
if (!defined('_DOWN_UPDATE_THUMBNAILS')) DEFINE('_DOWN_UPDATE_THUMBNAILS','Actualizar miniaturas');
if (!defined('_DOWN_DELETE_THUMBNAIL')) DEFINE('_DOWN_DELETE_THUMBNAIL','Borrar miniatura');
if (!defined('_DOWN_SUBMIT_NEW_THUMBNAIL')) DEFINE('_DOWN_SUBMIT_NEW_THUMBNAIL','Enviar nueva miniatura');
if (!defined('_DOWN_NOT_LOGGED_UPLOAD')) DEFINE('_DOWN_NOT_LOGGED_UPLOAD','No tiene permisos para subir archivos. Debe registrarse');
if (!defined('_DOWN_NOT_LOGGED_COMMENT')) DEFINE('_DOWN_NOT_LOGGED_COMMENT','No tiene permisos para hace comentarios de los archivos. Debe registrarse');
if (!defined('_DOWN_NOT_LOGGED_VOTE')) DEFINE('_DOWN_NOT_LOGGED_VOTE','No tiene permisos para valorar los archivos. Debe registrarse');
if (!defined('_DOWN_COMMENT_NL')) DEFINE('_DOWN_COMMENT_NL','Acceda o regístrese para hacer su propio comentario');

// Define some summaries for tables
if (!defined('_TABLE_SUMMARY_GENHEAD')) DEFINE ('_TABLE_SUMMARY_GENHEAD', 'Listado de las categorías y el número de archivos en cada una de ellas disponible.');
if (!defined('_TABLE_SUMMARY_ADDMANYFILES')) DEFINE ('_TABLE_SUMMARY_ADDMANYFILES', 'Esta tabla le permite seleccionar varios archivos para ser subidos.');
if (!defined('_DOWNLOAD_UPLOAD_TITLE')) DEFINE('_DOWNLOAD_UPLOAD_TITLE','Enviar un archivo');
if (!defined('_HEAD')) DEFINE('_HEAD','Enviar un Archivo');
if (!defined('_FILE')) DEFINE('_FILE','Enviar Archivo:');
if (!defined('_CLOSE')) DEFINE('_CLOSE','Cerrar');
if (!defined('_SENDFILE')) DEFINE('_SENDFILE','Enviar archivo');
if (!defined('_ERR1')) DEFINE('_ERR1','Este archivo no fue especificado.');
if (!defined('_ERR2')) DEFINE('_ERR2','Ataque de envío de archivos');
if (!defined('_ERR3')) DEFINE('_ERR3','El archivo enviado no tiene ningún tamaño; no tiene contenido.');
if (!defined('_ERR4')) DEFINE('_ERR4','El archivo enviado contiene una extensión o sufijo no permitido');
if (!defined('_ERR5')) DEFINE('_ERR5','El archivo enviado excede el tamaño máximo de ');
if (!defined('_ERR6')) DEFINE('_ERR6','El archivo enviado ya existe. Por favor especificar un nuevo título.');
if (!defined('_ERR7')) DEFINE('_ERR7','El espacio de Descargas está actualmente lleno.');
if (!defined('_ERR8')) DEFINE('_ERR8','Tiene que ser un Administrador o Usuario Registrado para subir un archivo.');
if (!defined('_ERR9')) DEFINE('_ERR9','Has alcanzado tu límite diario de subida de archivos.');
if (!defined('_ERR10')) DEFINE('_ERR10','Enviar archivos por usuarios no está permitido.');
if (!defined('_ERR11')) DEFINE('_ERR11','Fallo de envío de archivo con código ');
if (!defined('_UP_SUCCESS')) DEFINE('_UP_SUCCESS','El envío del archivo ha sido exitoso.');
if (!defined('_UPLOAD_URL_LOCK')) DEFINE('_UPLOAD_URL_LOCK','-Archivo Enviado-');
if (!defined('_WARNING1')) DEFINE('_WARNING1','Ruta para los archivos cambiada - AVISO los archivos no fueron movidos');
if (!defined('_WARNING2')) DEFINE('_WARNING2','La ruta de archivo especificada no existe - Crear una nueva');
if (!defined('_APPROVE')) DEFINE('_APPROVE','Aprobar');
if (!defined('_CANCEL')) DEFINE('_CANCEL','Cancelar');
if (!defined('_DOWN_MISSING_TITLE')) DEFINE('_DOWN_MISSING_TITLE','Archivos que faltan');
if (!defined('_MBT_GROUP_MANAGER')) DEFINE('_MBT_GROUP_MANAGER','Gestor de grupos');
if (!defined('_MBT_GROUP_FILTER')) DEFINE('_MBT_GROUP_FILTER','Filtrar por nombre');
if (!defined('_MBT_GROUP_GROUP')) DEFINE('_MBT_GROUP_GROUP','Grupo');
if (!defined('_MBT_GROUP_DESCRIPTION')) DEFINE('_MBT_GROUP_DESCRIPTION','Descripción');
if (!defined('_MBT_GROUP_EMAIL')) DEFINE('_MBT_GROUP_EMAIL','Enviar un email al grupo');
if (!defined('_MBT_GROUP_ADD')) DEFINE('_MBT_GROUP_ADD','Añadir grupo');
if (!defined('_MBT_GROUP_EDIT')) DEFINE('_MBT_GROUP_EDIT','Editar grupo');
if (!defined('_MBT_GROUP_NAME')) DEFINE('_MBT_GROUP_NAME','Nombre');
if (!defined('_MBT_GROUP_AVAI_USER')) DEFINE('_MBT_GROUP_AVAI_USER','usuarios disponibles');
if (!defined('_MBT_GROUP_SEL_USER')) DEFINE('_MBT_GROUP_SEL_USER','Miembros en este grupo');
if (!defined('_MBT_GROUP_MEMBERS')) DEFINE('_MBT_GROUP_MEMBERS','Miembros');
if (!defined('_MBT_GROUP_SUBJECT')) DEFINE('_MBT_GROUP_SUBJECT','Asunto');
if (!defined('_MBT_GROUP_MESSAGE')) DEFINE('_MBT_GROUP_MESSAGE','Mensaje');
if (!defined('_MBT_GROUP_SEND')) DEFINE('_MBT_GROUP_SEND','Enviar');
if (!defined('_MBT_GROUP_MISS_SUB')) DEFINE('_MBT_GROUP_MISS_SUB','Introduzca un asunto');
if (!defined('_MBT_GROUP_MISS_MSG')) DEFINE('_MBT_GROUP_MISS_MSG','Introduzca un mensaje');
if (!defined('_MBT_GROUP_MISS_GROUP')) DEFINE('_MBT_GROUP_MISS_GROUP','Introduzca el nombre del grupo');
if (!defined('_MBT_GROUP_SEND_ADMIN')) DEFINE('_MBT_GROUP_SEND_ADMIN','Sólo los administradores tienen permiso para enviar emails');
if (!defined('_MBT_GROUP_SEND_NOTARGET')) DEFINE('_MBT_GROUP_SEND_NOTARGET','No hay un email de destino en el grupo');
if (!defined('_MBT_GROUP_SEND_OK')) DEFINE('_MBT_GROUP_SEND_OK','Correo enviado a');
if (!defined('_MBT_GROUP_SEND_USERS')) DEFINE('_MBT_GROUP_SEND_USERS','Usuarios');

// Recent additions 3.56
if (!defined('_DOWN_EDIT_CLASSIFICATION')) DEFINE ('_DOWN_EDIT_CLASSIFICATION', 'Edit Classification');
if (!defined('_DOWN_CLASSIFICATION')) DEFINE ('_DOWN_CLASSIFICATION', 'Classification');
if (!defined('_DOWN_CONTAINER_PUBLISHED')) DEFINE ('_DOWN_CONTAINER_PUBLISHED', 'Container successfully published');
if (!defined('_DOWN_CONTAINERS_PUBLISHED')) DEFINE ('_DOWN_CONTAINERS_PUBLISHED', 'Containers successfully published');
if (!defined('_DOWN_CONTAINER_UNPUBLISHED')) DEFINE ('_DOWN_CONTAINER_UNPUBLISHED', 'Container successfully unpublished');
if (!defined('_DOWN_CONTAINERS_UNPUBLISHED')) DEFINE ('_DOWN_CONTAINERS_UNPUBLISHED', 'Containers successfully unpublished');
if (!defined('_DOWN_CONTAINER_SAVED')) DEFINE ('_DOWN_CONTAINER_SAVED', 'Container saved successfully');
if (!defined('_DOWN_CONTAINER_DELETED')) DEFINE ('_DOWN_CONTAINER_DELETED', 'Container deleted successfully');
if (!defined('_DOWN_CONTAINERS_DELETED')) DEFINE ('_DOWN_CONTAINERS_DELETED', 'Containers deleted successfully');
if (!defined('_DOWN_FILE_PUBLISHED')) DEFINE ('_DOWN_FILE_PUBLISHED', 'File successfully published');
if (!defined('_DOWN_FILES_PUBLISHED')) DEFINE ('_DOWN_FILES_PUBLISHED', 'Files successfully published');
if (!defined('_DOWN_FILE_UNPUBLISHED')) DEFINE ('_DOWN_FILE_UNPUBLISHED', 'File successfully unpublished');
if (!defined('_DOWN_FILES_UNPUBLISHED')) DEFINE ('_DOWN_FILES_UNPUBLISHED', 'Files successfully unpublished');
if (!defined('_DOWN_FILE_SAVED')) DEFINE ('_DOWN_FILE_SAVED', 'File saved successfully');
if (!defined('_DOWN_FILE_DELETED')) DEFINE ('_DOWN_FILE_DELETED', 'File deleted successfully');
if (!defined('_DOWN_FILES_DELETED')) DEFINE ('_DOWN_FILES_DELETED', 'Files deleted successfully');
if (!defined('_DOWN_FILE_LOCALISED')) DEFINE ('_DOWN_FILE_LOCALISED', 'File localised successfully');
if (!defined('_DOWN_GROUP_MEMBER_SAVED')) DEFINE ('_DOWN_GROUP_MEMBER_SAVED', 'Group member added successfully');
if (!defined('_DOWN_GROUP_MEMBERS_SAVED')) DEFINE ('_DOWN_GROUP_MEMBERS_SAVED', 'Group members added successfully');
if (!defined('_DOWN_GROUP_MEMBER_DELETED')) DEFINE ('_DOWN_GROUP_MEMBER_DELETED', 'Member removed successfully');
if (!defined('_DOWN_GROUP_MEMBERS_DELETED')) DEFINE ('_DOWN_GROUP_MEMBERS_DELETED', 'Members removed successfully');
if (!defined('_DOWN_GROUP_DELETED')) DEFINE ('_DOWN_GROUP_DELETED', 'Group deleted successfully');
if (!defined('_DOWN_GROUPS_DELETED')) DEFINE ('_DOWN_GROUPS_DELETED', 'Groups deleted successfully');
if (!defined('_DOWN_ORPHAN_SINGLE_DONE')) DEFINE('_DOWN_ORPHAN_SINGLE_DONE','File Orphan Deleted');
if (!defined('_DOWN_CLASSIFICATION_PUBLISHED')) DEFINE ('_DOWN_CLASSIFICATION_PUBLISHED', 'Classification successfully published');
if (!defined('_DOWN_CLASSIFICATIONS_PUBLISHED')) DEFINE ('_DOWN_CLASSIFICATIONS_PUBLISHED', 'Classifications successfully published');
if (!defined('_DOWN_CLASSIFICATION_UNPUBLISHED')) DEFINE ('_DOWN_CLASSIFICATION_UNPUBLISHED', 'Classification successfully unpublished');
if (!defined('_DOWN_CLASSIFICATIONS_UNPUBLISHED')) DEFINE ('_DOWN_CLASSIFICATIONS_UNPUBLISHED', 'Classifications successfully unpublished');
if (!defined('_DOWN_CLASSIFICATION_SAVED')) DEFINE ('_DOWN_CLASSIFICATION_SAVED', 'Classification saved successfully');
if (!defined('_DOWN_CLASSIFICATION_DELETED')) DEFINE ('_DOWN_CLASSIFICATION_DELETED', 'Classification deleted successfully');
if (!defined('_DOWN_CLASSIFICATIONS_DELETED')) DEFINE ('_DOWN_CLASSIFICATIONS_DELETED', 'Classifications deleted successfully');
if (!defined('_DOWN_MISSING_DELETED')) DEFINE ('_DOWN_MISSING_DELETED', 'Missing file deleted successfully');
if (!defined('_DOWN_MISSINGS_DELETED')) DEFINE ('_DOWN_MISSINGS_DELETED', 'Missing files deleted successfully');
if (!defined('_SUBMIT_FILE_BUTTON_ADV')) DEFINE('_SUBMIT_FILE_BUTTON_ADV','AddFile');