<?php

/**************************************************************
* This file is part of Remository
* Copyright (c) 2006-17 Martin Brampton
* 
* License: GNU General Public License version 2 or later; see LICENSE.txt
* 
* For support and other information, visit http://remository.com
* To contact Martin Brampton, write to martin@remository.com
*
* Remository started life as the psx-dude script by psx-dude@psx-dude.net
* It was enhanced by Matt Smith up to version 2.10
* Since then development has been primarily by Martin Brampton,
* with contributions from other people gratefully accepted
*/

defined('_JEXEC') or die;


// These settings are dummy values to suppress errors when the language file is used in a context where the real values have not been set
if (!isset($Large_Text_Len)) $Large_Text_Len = 500;
if (!isset($Small_Text_Len)) $Small_Text_Len = 150;
if (!isset($mosConfig_sitename)) $mosConfig_sitename = 'nazwa strony';

// Add your own definitions here, just using plain DEFINE
// e.g. define ('_DOWNLOADS_TITLE', 'The name of my Repository');
// Your definitions will override the standard ones if placed ahead of them

// Prototype for standard definitions: if (!defined('')) DEFINE ('', '');

// Additions in 3.52
if (!defined('_DOWN_DELETE_SURE')) DEFINE ('_DOWN_DELETE_SURE', 'czy na pewno chcesz skasować ten plik?');
if (!defined('_DOWN_SEARCH_CATEGORY_SELECT')) DEFINE ('_DOWN_SEARCH_CATEGORY_SELECT', 'wybierz, które kategorie dołączyć');
if (!defined('_DOWN_SEARCH_FILES')) DEFINE ('_DOWN_SEARCH_FILES', 'szukaj plików');

// Additions in 3.51
if (!defined('_DOWN_NOT_ABSOLUTE')) DEFINE ('_DOWN_NOT_ABSOLUTE', 'błędna cieżka absolutna');
if (!defined('_DOWN_NEW_OR_UPDATED')) DEFINE ('_DOWN_NEW_OR_UPDATED', 'nowy lub uaktualniony plik');
if (!defined('_DOWN_NEW_FILE_COMMENT')) DEFINE ('_DOWN_NEW_FILE_COMMENT', 'nowy komentarz do pliku');
if (!defined('_DOWN_MAIL_MESSAGE_PREFIX')) DEFINE ('_DOWN_MAIL_MESSAGE_PREFIX', "witaj %s\n\n");
if (!defined('_DOWN_NEW_UPDATED_MSG')) DEFINE ('_DOWN_NEW_UPDATED_MSG', 
					"do %s plik został dodany lub uaktualniony. nazwa pliku to %s."
					."\n\nProszę nie odpowiadać na tą wiadomość, została ona wygenerowana automatycznie tylko w celach informacyjnych\n"
					);
if (!defined('_DOWN_NEW_COMMENT_MSG')) DEFINE ('_DOWN_NEW_COMMENT_MSG', 
					"do pliku %s wystawiono nowy komentarz.  nazwa pliku to %s.  "
					."komentarz wystawił %s i jest:\n\n%s"
					."\n\nProszę nie odpowiadać na tą wiadomość, została ona wygenerowana automatycznie tylko w celach informacyjnych\n"
					);

// Modifications in 3.51
if (!defined('_DOWN_MAIL_MSG')) DEFINE('_DOWN_MAIL_MSG','Witaj, propozycje pobrań nowego użytkownika zostały dodane przez %s'
                   ." ze strony %s.\n"
                   ."Zaloguj się jako administrator, aby zobaczyć i zatwierdzić propozycje.\n\n"
                   ."Proszę nie odpowiadać na tą wiadomość, została ona wygenerowana automatycznie tylko w celach informacyjnych\n");
if (!defined('_DOWN_MAIL_MSG_APP')) DEFINE('_DOWN_MAIL_MSG_APP','Witaj, propozycje pobrań nowego użytkownika zostały dodane przez %s'
                   ." ze strony %s.\n"
                   ."Zgodnie z ustawieniami w konfiguracji, zostały one auto-zatwierdzone.\n\n"
                   ."Proszę nie odpowiadać na tą wiadomość, została ona wygenerowana automatycznie tylko w celach informacyjnychy\n");
if (!defined('_DOWN_LINK_TO_FILE')) DEFINE ('_DOWN_LINK_TO_FILE', "\n\nZnajdziesz ten plik w %s");
if (!defined('_DOWN_LINK_TO_CONTAINER')) DEFINE ('_DOWN_LINK_TO_CONTAINER', "\n\nZnajdziesz folder w %s");

// Additions in 3.50
if (!defined('_DOWN_APPROVE_ROLES')) DEFINE ('_DOWN_APPROVE_ROLES', 'Autozatwierdzanie reguł');
if (!defined('_DOWN_ACCESS_REFUSED')) DEFINE ('_DOWN_ACCESS_REFUSED', 'Przepraszamy, twoje żądanie zostało odrzucone');
if (!defined('_DOWN_MAYBE_LOGIN')) DEFINE ('_DOWN_MAYBE_LOGIN', 'możliwe, że musisz się zalogować lub zarejestrować.');
if (!defined('_DOWN_CONFIG70')) DEFINE ('_DOWN_CONFIG70', 'Show_all_containers: <br /><em>(w wynikach wyszukiwania, pokaż wszystkie (scieżki) lokalizacje)</em>');
if (!defined('_DOWN_CONFIG69')) DEFINE ('_DOWN_CONFIG69', 'Set_date_locale: <br /><em>(wybierz ustawienia dla obsługi daty)</em>');
if (!defined('_DOWN_CONFIG68')) DEFINE ('_DOWN_CONFIG68', 'Force_Language: <br /><em>(wymuś wybór języka niezależnie od ustawień cmsa)</em>');

// Additions in 3.47 to fix missed items in earlier versions
if (!defined('_DOWN_NO_FILE_RECEIVED')) DEFINE ('_DOWN_NO_FILE_RECEIVED', 'Pomimo wybrania wczytywania pliku, żaden plik nie został wczytany.');
if (!defined('_DOWN_SAMPLE')) DEFINE ('_DOWN_SAMPLE', 'Przykładowy folder');
if (!defined('_DOWN_SAMPLE_DESCRIPTION')) DEFINE ('_DOWN_SAMPLE_DESCRIPTION', 'Usuń lub zmień przykładowy folder');
if (!defined('_DOWN_INSTALL_DONE1')) DEFINE ('_DOWN_INSTALL_DONE1', 'Zalecamy lekturę pliku read_me.txt');
if (!defined('_DOWN_INSTALL_DONE2')) DEFINE ('_DOWN_INSTALL_DONE2', 'więcej informacji <a href="http://remository.com">na stronie domowej remository</a>.');
if (!defined('_DOWN_INSTALL_DONE3')) DEFINE ('_DOWN_INSTALL_DONE3', 'wsparcie remository');
if (!defined('_DOWN_INSTALL_DONE4')) DEFINE ('_DOWN_INSTALL_DONE4', 'Rozwój i utrzymanie Remository pochłania dużo czasu i część funduszy'
		.' aby rozwijać środowisko.  Jeśli czerpiesz korzyści finansowe'
		.' z używania Remository, proszę rozważ wsparcie finansowe projektu.'
		.' Kliknij przycisk poniżej aby dokonać wpłaty:');
if (!defined('_DOWN_LOCAL_OR_REMOTE')) DEFINE ('_DOWN_LOCAL_OR_REMOTE', 'lokalnie czy zdalnie');
if (!defined('_DOWN_IS_LOCAL')) DEFINE ('_DOWN_IS_LOCAL', 'lokalnie');
if (!defined('_DOWN_IS_REMOTE')) DEFINE ('_DOWN_IS_REMOTE', 'zdalnie');
if (!defined('_DOWN_LOCALISE_REMOTE_FILE')) DEFINE ('_DOWN_LOCALISE_REMOTE_FILE', 'Wykonaj lokalnie');
if (!defined('_DOWN_CANCEL_UPLOAD')) DEFINE ('_DOWN_CANCEL_UPLOAD', 'Anuluj wczytywanie');
if (!defined('_DOWN_NOT_YET_IMPLEMENTED')) DEFINE ('_DOWN_NOT_YET_IMPLEMENTED', 'Opcja jeszcze nie zaimplementowana');
if (!defined('_DOWN_ADMIN_CPANEL_CACHEPATH')) DEFINE ('_DOWN_ADMIN_CPANEL_CACHEPATH', 'CMS cieżka cache - ważne dla rss i kontroli dostępu:');
if (!defined('_DOWN_CONFIG_EXPLAIN_4')) DEFINE ('_DOWN_CONFIG_EXPLAIN_4', 'D = wybierz pola dla strony ze szczegółowymi informacjami');
if (!defined('_DOWN_CONFIG67')) DEFINE ('_DOWN_CONFIG67', 'Profile_URI: <br /><em>(relatywne non-SEF URI do profilu z %u gdzie ID użytkownika być powinno)</em>');
if (!defined('_DOWN_CONFIG66')) DEFINE ('_DOWN_CONFIG66', 'Activate_AEC: <br /><em>(Aaktywuj integrację AEC dla kontroli dostępu)</em>');
if (!defined('_DOWN_AEC_OPTION_A')) DEFINE ('_DOWN_AEC_OPTION_A', 'Zastosuj dla gup(y) poniżej.');
if (!defined('_DOWN_AEC_OPTION_B')) DEFINE ('_DOWN_AEC_OPTION_B', 'Kasuj wszystkie, później zastosuj dla gup(y) poniżej.');
if (!defined('_DOWN_AEC_OPTION_C')) DEFINE ('_DOWN_AEC_OPTION_C', 'Kasuj ustawienia grupy dla aplikacji, później zastosuj dla gup(y) poniżej.');
if (!defined('_DOWN_CONFIG65')) DEFINE ('_DOWN_CONFIG65', 'Home_Page_Title:<br /><em>(wpis strony głównej na paseku tytułowym przeglądarki)</em>');
if (!defined('_DOWN_NEXT')) DEFINE ('_DOWN_NEXT', 'Następny');
if (!defined('_DOWN_PREVIOUS')) DEFINE ('_DOWN_PREVIOUS', 'Poprzedni');
if (!defined('_DOWN_DOWNLOAD_LC')) DEFINE ('_DOWN_DOWNLOAD_LC', 'Pobierz');
if (!defined('_DOWN_EMPTY_REPOSITORY')) DEFINE ('_DOWN_EMPTY_REPOSITORY', 'Puste repozytorium');
if (!defined('_DOWN_OVERVIEW_LATEST')) DEFINE ('_DOWN_OVERVIEW_LATEST', 'Ostatnie pliki w repozytorium');
if (!defined('_DOWN_SPECIFY_AUTHOR')) DEFINE ('_DOWN_SPECIFY_AUTHOR', 'Inny autor');
if (!defined('_DOWN_CONFIG64')) DEFINE ('_DOWN_CONFIG64', 'Author_Threshold:<br /><em>(minimalna lista wyboru autorów wywietlona przy rozwijanym menu)</em>');
if (!defined('_DOWN_CONFIG63')) DEFINE ('_DOWN_CONFIG63', 'Main_Authors:<br /><em>(lista wyboru autorów, oddzielona przecinkamid)</em>');
if (!defined('_DOWN_CONFIG62')) DEFINE ('_DOWN_CONFIG62', 'Min_Comment_length:<br /><em>(minimalna długość komentarza pliku, lub pomiń)</em>');
if (!defined('_DOWN_CONFIG61')) DEFINE ('_DOWN_CONFIG61', 'Video_Download:<br /><em>(pozwól pobierać pliki video)</em>');
if (!defined('_DOWN_CONFIG60')) DEFINE ('_DOWN_CONFIG60', 'Audio_Download:<br /><em>(pozwól pobierać pliki audio)</em>');
if (!defined('_DOWN_CONFIG59')) DEFINE ('_DOWN_CONFIG59', 'Alias:<br /><em>(alias repozytorium)</em>');
if (!defined('_DOWN_CONFIG58')) DEFINE ('_DOWN_CONFIG58', 'Name:<br /><em>(nazwa repozytorium)</em>');
if (!defined('_DOWN_PLAY')) DEFINE ('_DOWN_PLAY', 'odtwórz');
if (!defined('_DOWN_PLAY_THANK_YOU')) DEFINE ('_DOWN_PLAY_THANK_YOU', 'Dziekujemy za odtworzenie ');
if (!defined('_DOWN_CONFIG57')) DEFINE ('_DOWN_CONFIG57', 'Video File Extensions:<br /><em>(pliki video do odtworzenia, nie do pobrania)</em>');
if (!defined('_DOWN_CONFIG56')) DEFINE ('_DOWN_CONFIG56', 'Audio File Extensions:<br /><em>(pliki audio do odtworzenia, nie do pobrania)</em>');
if (!defined('_DOWN_FEATURED')) DEFINE ('_DOWN_FEATURED', 'Opis');
if (!defined('_DOWN_IS_FEATURED')) DEFINE ('_DOWN_IS_FEATURED', 'Opis pliku:');
if (!defined('_DOWN_FEATURE_START')) DEFINE ('_DOWN_FEATURE_START', 'Data początkowa:');
if (!defined('_DOWN_FEATURE_END')) DEFINE ('_DOWN_FEATURE_END', 'Data końcowa (puste = bez ograniczeń)');
if (!defined('_DOWN_PUBLISH_FROM')) DEFINE ('_DOWN_PUBLISH_FROM', 'Publikuj od:');
if (!defined('_DOWN_PUBLISH_TO')) DEFINE ('_DOWN_PUBLISH_TO', 'Publikuj do (puste = bez ograniczeń):');
if (!defined('_DOWN_FIELD_NAME')) DEFINE ('_DOWN_FIELD_NAME', 'Nazwa pola');
if (!defined('_DOWN_FIELD_TITLE')) DEFINE ('_DOWN_FIELD_TITLE', 'Tytuł pola');
if (!defined('_DOWN_CUSTOM_UPLOAD')) DEFINE ('_DOWN_CUSTOM_UPLOAD', 'Przy wczytywaniu');
if (!defined('_DOWN_CUSTOM_LIST')) DEFINE ('_DOWN_CUSTOM_LIST', 'Na stronie z lista plików');
if (!defined('_DOWN_CUSTOM_INFO_PAGE')) DEFINE ('_DOWN_CUSTOM_INFO_PAGE', 'Na stronie informacyjnej');
if (!defined('_DOWN_FIELD_OPTIONS')) DEFINE ('_DOWN_FIELD_OPTIONS', 'Ogranicz wartości do tej listy oddzielonej przecinkami');
if (!defined('_DOWN_CUSTOM_INFO')) DEFINE ('_DOWN_CUSTOM_INFO', 'Nazwa pola będzie używana w bazie danych i musi być unikalna dla tabeli xxx_downloads_files.  Tytuł pola będzie jako etykieta pola gdy będzie to pole używane.');
if (!defined('_DOWN_CUSTOM_FIELDS_TAB')) DEFINE ('_DOWN_CUSTOM_FIELDS_TAB', 'Dodaj pola');
if (!defined('_DOWN_CUSTOM_FIELDS_HEAD')) DEFINE ('_DOWN_CUSTOM_FIELDS_HEAD', 'Własne pola');
if (!defined('_DOWN_CONFIG55')) DEFINE ('_DOWN_CONFIG55', 'Featured_Number:<br /><em>(Ilość opisanych pozycji)</em>');
if (!defined('_DOWN_IS_VISIBLE')) DEFINE ('_DOWN_IS_VISIBLE', 'Widoczny?');
if (!defined('_DOWN_FREQUENCY')) DEFINE ('_DOWN_FREQUENCY', 'Częstość');
if (!defined('_DOWN_TYPE')) DEFINE ('_DOWN_TYPE', 'Typ');
if (!defined('_DOWN_DESCRIPTION')) DEFINE ('_DOWN_DESCRIPTION', 'Opis');
if (!defined('_DOWN_CLASSIFICATIONS')) DEFINE ('_DOWN_CLASSIFICATIONS', 'Klasyfikacje');
if (!defined('_DOWN_SAVE')) DEFINE ('_DOWN_SAVE', 'Zapisz');
if (!defined('_DOWN_FILE_STRUCTURE')) DEFINE ('_DOWN_FILE_STRUCTURE', 'Struktura pliku');
if (!defined('_DOWN_PRUNE')) DEFINE ('_DOWN_PRUNE', '- skróć');
if (!defined('_DOWN_DELETE_MISSING')) DEFINE ('_DOWN_DELETE_MISSING', 'Kasuj zagubione pliki');
if (!defined('_DOWN_APPLY')) DEFINE ('_DOWN_APPLY', 'Zastosuj');
if (!defined('_DOWN_CLASSIFICATION_NAME')) DEFINE ('_DOWN_CLASSIFICATION_NAME', 'Nazwa klasyfikacji');
if (!defined('_DOWN_DISPLAY_LISTS')) DEFINE ('_DOWN_DISPLAY_LISTS', 'Wyświetl nazwę w listach:');
if (!defined('_DOWN_NOT_PUBLISHED')) DEFINE ('_DOWN_NOT_PUBLISHED', 'Nieopublikowany');
if (!defined('_DOWN_PUBLISH')) DEFINE ('_DOWN_PUBLISH', 'Opublikowany');
if (!defined('_DOWN_UNPUBLISH')) DEFINE ('_DOWN_UNPUBLISH', 'Nie publikuj');
if (!defined('_DOWN_FILE')) DEFINE ('_DOWN_FILE', 'Plik');
if (!defined('_DOWN_ADD')) DEFINE ('_DOWN_ADD', 'Dodaj');
if (!defined('_DOWN_CLASSIFN')) DEFINE ('_DOWN_CLASSIFN', 'Klasyf\'n');
if (!defined('_DOWN_ROLES')) DEFINE ('_DOWN_ROLES', 'Role:');
if (!defined('_DOWN_DELETE')) DEFINE ('_DOWN_DELETE', 'Kasuj');
if (!defined('_DOWN_ADD_USERS_NEW_ROLE')) DEFINE ('_DOWN_ADD_USERS_NEW_ROLE', 'Dodaj użytkowników do nowej roli');
if (!defined('_DOWN_ADD_MEMBERS')) DEFINE ('_DOWN_ADD_MEMBERS', 'Dodaj członków');
if (!defined('_DOWN_ADD_LOCAL')) DEFINE ('_DOWN_ADD_LOCAL', 'Dodaj lokalnie');
if (!defined('_DOWN_ADD_REMOTE')) DEFINE ('_DOWN_ADD_REMOTE', 'Dodaj zdalnie');
if (!defined('_DOWN_EDIT_APPROVAL')) DEFINE ('_DOWN_EDIT_APPROVAL', 'Edytuj propozycje');
if (!defined('_DOWN_DELETE_SUBMISSION')) DEFINE ('_DOWN_DELETE_SUBMISSION', 'Kasuj propozycje');
if (!defined('_DOWN_CONTAINER')) DEFINE ('_DOWN_CONTAINER', 'Zawartość');
if (!defined('_DOWN_PUBLISH_FILES')) DEFINE ('_DOWN_PUBLISH_FILES', 'Publikuj pliki');
if (!defined('_DOWN_DELETE_ORPHANS')) DEFINE ('_DOWN_DELETE_ORPHANS', 'Kasuj nieprzypisane');
if (!defined('_DOWN_ORPHAN')) DEFINE ('_DOWN_ORPHAN', 'Nieprzypisane');
if (!defined('_DOWN_MISSING')) DEFINE ('_DOWN_MISSING', 'Zagubione');
if (!defined('_DOWN_ADD_USERS_ROLE')) DEFINE ('_DOWN_ADD_USERS_ROLE', 'Dodaj użytkowników do roli');
if (!defined('_DOWN_REMOVE_USERS_ROLE')) DEFINE ('_DOWN_REMOVE_USERS_ROLE', 'Usuń użytkowników z przypisanej roli');
if (!defined('_DOWN_PUBLISHING')) DEFINE ('_DOWN_PUBLISHING', 'Publikowanie');
if (!defined('_DOWN_EDIT_CONTAINER')) DEFINE ('_DOWN_EDIT_CONTAINER', 'Edytuj zawartość');
if (!defined('_DOWN_REMOSITORY')) DEFINE ('_DOWN_REMOSITORY', 'Dział plików');
if (!defined('_DOWN_PHYSICAL_FILE')) DEFINE ('_DOWN_PHYSICAL_FILE', 'Rzeczywisty plik');
if (!defined('_DOWN_METADATA')) DEFINE ('_DOWN_METADATA', 'Metadane');
if (!defined('_DOWN_SHORT_DESCRIPTION')) DEFINE ('_DOWN_SHORT_DESCRIPTION', 'Krótki opis');
if (!defined('_DOWN_LICENSE_HEADING')) DEFINE ('_DOWN_LICENSE_HEADING', 'Licencja');
if (!defined('_DOWN_ABOUT_FILE')) DEFINE ('_DOWN_ABOUT_FILE', 'O pliku');
if (!defined('_DOWN_COMMENTS_HEADING')) DEFINE ('_DOWN_COMMENTS_HEADING', 'Komentarze');
if (!defined('_DOWN_STORAGE')) DEFINE ('_DOWN_STORAGE', 'Magazyn');
if (!defined('_DOWN_ACCESS_CONTROL')) DEFINE ('_DOWN_ACCESS_CONTROL', 'Kontrola dostępu');
if (!defined('_DOWN_DOWNLOAD_ROLES')) DEFINE ('_DOWN_DOWNLOAD_ROLES', 'Role pobierania');
if (!defined('_DOWN_UPLOAD_ROLES')) DEFINE ('_DOWN_UPLOAD_ROLES', 'Role wczytywania');
if (!defined('_DOWN_EDIT_ROLES')) DEFINE ('_DOWN_EDIT_ROLES', 'Role edycji');
if (!defined('_DOWN_ADD_NEW_ROLE')) DEFINE ('_DOWN_ADD_NEW_ROLE', 'Dodaj nową rolę:');
// Recent additions 3.46+
if (!defined('_DOWN_DOWNLOAD_FROM')) DEFINE ('_DOWN_DOWNLOAD_FROM', 'Pobierz z');
if (!defined('_DOWN_UPLOAD_TO')) DEFINE ('_DOWN_UPLOAD_TO', 'Wczytaj do');
if (!defined('_DOWN_EDIT_IN')) DEFINE ('_DOWN_EDIT_IN', 'Edytuj w');
if (!defined('_DOWN_SUBS_EVERYTHING')) DEFINE ('_DOWN_SUBS_EVERYTHING', 'Zlicz wszystkie pobrania');
if (!defined('_DOWN_SUBS_COUNT_DOWNLOAD')) DEFINE ('_DOWN_SUBS_COUNT_DOWNLOAD', 'Zlicz pobrania z wybranego folderu');
if (!defined('_DOWN_SUBS_COUNT_UPLOAD')) DEFINE ('_DOWN_SUBS_COUNT_UPLOAD', 'Zlicz wczytania do wybranego folderu');
if (!defined('_DOWN_SUBS_COUNT_DOWNLOAD_PLUS')) DEFINE ('_DOWN_SUBS_COUNT_DOWNLOAD_PLUS', 'Zlicz foldery i podległe pobrania');
if (!defined('_DOWN_SUBS_COUNT_UPLOAD_PLUS')) DEFINE ('_DOWN_SUBS_COUNT_UPLOAD_PLUS', 'Zlicz foldery i podległe wczytania');
if (!defined('_DOWN_COUNT_DOWN')) DEFINE ('_DOWN_COUNT_DOWN', 'Zarządzanie propozycjami do liości pobrań');
if (!defined('_DOWN_COUNT_DOWN_CHILD')) DEFINE ('_DOWN_COUNT_DOWN_CHILD', 'Wliczając podrzędne do ilości pobrań');
if (!defined('_DOWN_COUNT_UP')) DEFINE ('_DOWN_COUNT_UP', 'Zarządzanie propozycjami do ilości wczytań');
if (!defined('_DOWN_COUNT_UP_CHILD')) DEFINE ('_DOWN_COUNT_UP_CHILD', 'Wliczając podrzędne do ilości wczytań');
if (!defined('_DOWN_CONFIG54')) DEFINE ('_DOWN_CONFIG54', 'Count_Down:<br /><em>(Ogranicz wszystkie pobrania używając Zarządzania propozycjami)</em>');
if (!defined('_DOWN_CONFIG53')) DEFINE ('_DOWN_CONFIG53', 'Show_File_Folder_Counts:<br /><em>(Pokaż plik i ilość folderów)</em>');
if (!defined('_DOWN_CONFIG52')) DEFINE ('_DOWN_CONFIG52', 'Show_Footer:<br /><em>(Pokaż stopkę Remository (Szukaj/Wyślij/Kredyt))</em>');
if (!defined('_DOWN_CONFIG51')) DEFINE ('_DOWN_CONFIG51', 'Allow_File_Info:<br /><em>(Odnośnik z listy plików do szczegółowych informacji o pliku)</em>');
if (!defined('_DOWN_IS_ACTIVE')) DEFINE ('_DOWN_IS_ACTIVE', 'Aktywny?');
if (!defined('_DOWN_NEW_REPOSITORY')) DEFINE ('_DOWN_NEW_REPOSITORY', 'Twórz nowe repozytorium takie jak obecne');
if (!defined('_DOWN_REPOSITORY_NAME')) DEFINE ('_DOWN_REPOSITORY_NAME', 'Nazwa repozytorium');
if (!defined('_DOWN_REPOSITORY_NUMBER')) DEFINE ('_DOWN_REPOSITORY_NUMBER', 'Numer repozytorium');
if (!defined('_DOWN_REPOSITORY_ALIAS')) DEFINE ('_DOWN_REPOSITORY_ALIAS', 'Alias repozytorium');
// Recent additions 3.46
if (!defined('_DOWN_SUBTITLE')) DEFINE ('_DOWN_SUBTITLE', 'Podtytuł pliku:');
if (!defined('_DOWN_PUBLISHER_ID')) DEFINE ('_DOWN_PUBLISHER_ID', 'ID publikującego:');
if (!defined('_DOWN_PUBLISHED_DATE')) DEFINE ('_DOWN_PUBLISHED_DATE', 'Data opublikowania:');
if (!defined('_DOWN_ALIAS')) DEFINE ('_DOWN_ALIAS', 'Alias');
if (!defined('_DOWN_BOTH')) DEFINE ('_DOWN_BOTH', 'Obydwa');
if (!defined('_DOWN_CONFIG50')) DEFINE ('_DOWN_CONFIG50', 'Remository_Pathway:<br /><em>(Używaj ścieżki powrotu Remository (pathway))</em>');
if (!defined('_DOWN_SEARCHING_BY')) DEFINE ('_DOWN_SEARCHING_BY', 'Szukaj po');
if (!defined('_DOWN_FILTERING_BY')) DEFINE ('_DOWN_FILTERING_BY', 'Filtruj po');
if (!defined('_DOWN_REMOVE_TERM')) DEFINE ('_DOWN_REMOVE_TERM', 'Usuń warunek');
if (!defined('_DOWN_NO_FILTERS')) DEFINE ('_DOWN_NO_FILTERS', 'Brak zastosowanych filtrów - wyświetli wszystkie pozycje');
if (!defined('_DOWN_REVIEW_TAGS')) DEFINE ('_DOWN_REVIEW_TAGS', 'Przeglad tagów w grupie');
if (!defined('_DOWN_NO_RESULTS_1')) DEFINE ('_DOWN_NO_RESULTS_1', 'Przepraszamy, twoje wyszukiwanie nie znalazło wyników.');
if (!defined('_DOWN_NO_RESULTS_2')) DEFINE ('_DOWN_NO_RESULTS_2', 'Nie znaleziono tego czego szukasz?');
if (!defined('_DOWN_CONTACT_US')) DEFINE ('_DOWN_CONTACT_US', 'Skontaktuj się z nami, aby sprecyzować czego szukasz.');
if (!defined('_DOWN_ALL_CATS_RETRY')) DEFINE ('_DOWN_ALL_CATS_RETRY', 'Ponowić szukanie z wybranymi wszystkimi kategoriami?');
if (!defined('_DOWN_ADD_ALL_CATS')) DEFINE ('_DOWN_ADD_ALL_CATS', 'Dodaj wszystkie kategorie');
if (!defined('_DOWN_CONFIG49')) DEFINE ('_DOWN_CONFIG49', 'Classification_Types:<br /><em>(Rodzaje klasyfikacji (oddzielone przecinkami))</em>');

// Recent additions 3.45
if (!defined('_DOWN_GROUP_NO_NAME')) DEFINE ('_DOWN_GROUP_NO_NAME', 'Nie zapisano grupy - brak nazwy');
if (!defined('_DOWN_GROUP_SAVED')) DEFINE ('_DOWN_GROUP_SAVED', 'Zapisano grupę');
if (!defined('_DOWN_CONFIG48')) DEFINE ('_DOWN_CONFIG48', 'Show_RSS_feeds:<br /><em>(Pokaż RSS feeds)</em>');
if (!defined('_DOWN_CONFIG46')) DEFINE ('_DOWN_CONFIG46', 'ExtsDisplay:<br /><em>(Rozszerzenia które będą wyświetlone online (lista oddzielona przecinkami))</em>');
if (!defined('_DOWN_DISPLAY_NOW')) DEFINE ('_DOWN_DISPLAY_NOW', 'Wyświetl teraz ten plik');
if (!defined('_DOWN_CONFIG47')) DEFINE ('_DOWN_CONFIG47', 'Scribd:<br /><em>(Scribd klucz publikacji)</em>');
if (!defined('')) DEFINE ('', '');
// Recent addition 3.44.1
if (!defined('_DOWN_AEC_REFUSED')) DEFINE ('_DOWN_AEC_REFUSED', 'Przepraszamy, na podstawie AEC limit pobierania wyczerpany');
// Recent additions 3.44
if (!defined('_DOWN_FIELD')) DEFINE ('_DOWN_FIELD', 'Pole');
if (!defined('_DOWN_SEQUENCE')) DEFINE ('_DOWN_SEQUENCE', 'Kolejność');
if (!defined('_DOWN_CONFIG_EXPLAIN_1')) DEFINE ('_DOWN_CONFIG_EXPLAIN_1', 'A = wybierz pola dla listy plików w folderze');
if (!defined('_DOWN_CONFIG_EXPLAIN_2')) DEFINE ('_DOWN_CONFIG_EXPLAIN_2', 'B = wybierz pola dla wyników wyszukiwania');
if (!defined('_DOWN_CONFIG_EXPLAIN_3')) DEFINE ('_DOWN_CONFIG_EXPLAIN_3', 'C = wybierz pola dla wyników masowego wczytywania plików');
// Recent additions 3.43:
if (!defined('_DOWN_ADDFILE_THUMBNAIL')) DEFINE ('_DOWN_ADDFILE_THUMBNAIL', 'Miniaturka %u (opcjonalnie):');
if (!defined('_DOWN_CONFIG45')) DEFINE("_DOWN_CONFIG45","Default_Licence:<br /><em>(Opcjonalnie - jeśli jest, będzie użyta dla każdej pozycji nie posiadającej przypisanej licencji)</em>");
if (!defined('_DOWN_CONFIG_TITLE_LICENCE')) DEFINE('_DOWN_CONFIG_TITLE_LICENCE', 'Licencja');
if (!defined('_DOWN_VISIT')) DEFINE('_DOWN_VISIT','Zobacz');
if (!defined('_DOWN_EDIT')) DEFINE('_DOWN_EDIT','Edutuj');
if (!defined('_DOWN_STRUCT_RECURSE_ALL')) DEFINE('_DOWN_STRUCT_RECURSE_ALL','Wliczając wszystkie podfoldery z plikami');
if (!defined('_DOWN_STRUCT_RECURSE_DIR')) DEFINE('_DOWN_STRUCT_RECURSE_DIR','Wliczając tylko pliki i foldery najwyższego poziomu');
if (!defined('_DOWN_STRUCT_RECURSE_NONE')) DEFINE('_DOWN_STRUCT_RECURSE_NONE','Wliczając tylko pliki najwyższego poziomu');
if (!defined('_DOWN_STRUCT_NO_DIR')) DEFINE ('_DOWN_STRUCT_NO_DIR', 'Wybrana lokalizacja nie istnieje');
if (!defined('_DOWN_ADMINISTRATOR')) DEFINE ('_DOWN_ADMINISTRATOR', 'Administrator');
// Recent modifications 3.43:
if (!defined('_DOWN_ADMIN_ACT_ADDSTRUCTURE')) DEFINE('_DOWN_ADMIN_ACT_ADDSTRUCTURE','Dodaj pliki juz znajdujące sie na serwerze');
if (!defined('_DOWN_STRUCTURE_ADDED')) DEFINE('_DOWN_STRUCTURE_ADDED','Dodano pliki do repozytorium');
if (!defined('_DOWN_ADDSTRUCTURE_TITLE')) DEFINE('_DOWN_ADDSTRUCTURE_TITLE','dodaj pliki juz znajdujące sie na serwerze');
//
if (!defined('_REM_INTERNAL')) DEFINE('_REM_INTERNAL','Błąd wewnętrzny Remository');
if (!defined('_DOWNLOADS_TITLE')) DEFINE('_DOWNLOADS_TITLE',"$mosConfig_sitename :: dział plików");
if (!defined('_UP_FILE')) DEFINE('_UP_FILE','Wczytaj plik');
if (!defined('_ADD_FILE_BUTTON')) DEFINE('_ADD_FILE_BUTTON','Dodaj plik');
if (!defined('_SUBMIT_FILE_BUTTON')) DEFINE('_SUBMIT_FILE_BUTTON','Zaproponuj plik');
if (!defined('_DOWN_ROLE_REGISTERED')) DEFINE('_DOWN_ROLE_REGISTERED','Zarejestrowani');
if (!defined('_DOWN_ROLE_VISITOR')) DEFINE('_DOWN_ROLE_VISITOR','Goście');
if (!defined('_DOWN_ROLE_NOBODY')) DEFINE('_DOWN_ROLE_NOBODY','Nikt');
if (!defined('_DOWN_ROLE_NONE_THESE')) DEFINE('_DOWN_ROLE_NONE_THESE','Zaden w możliwych');
if (!defined('_DOWN_PAGE_TEXT')) DEFINE ('_DOWN_PAGE_TEXT', 'Strona');
if (!defined('_DOWN_PAGE_SHOW_RESULTS')) DEFINE('_DOWN_PAGE_SHOW_RESULTS','Pokaż wyniki ');
if (!defined('_DOWN_PAGE_SHOW_RANGE')) DEFINE('_DOWN_PAGE_SHOW_RANGE','od %s do %s z %s');
if (!defined('_SUBMIT_FILE_NOLOG')) DEFINE('_SUBMIT_FILE_NOLOG', 'Proponowanie plików wyłączone - nie jesteś zalogowany(a)');
if (!defined('_SUBMIT_FILE_NOUSER')) DEFINE('_SUBMIT_FILE_NOUSER', 'Proponowanie plików wyłączone - tylko dla administratorów');
if (!defined('_SUBMIT_FILE_NOLIMIT')) DEFINE('_SUBMIT_FILE_NOLIMIT', 'Propozycja odrzucona - przekroczony limit');
if (!defined('_SUBMIT_FILE_NOSPACE')) DEFINE('_SUBMIT_FILE_NOSPACE', 'Propozycja odrzucona - brak miejsca');
if (!defined('_SUBMIT_NO_DDIR')) DEFINE('_SUBMIT_NO_DDIR', 'Propozycja odrzucona - brak katalogu download');
if (!defined('_SUBMIT_NO_UDDIR')) DEFINE('_SUBMIT_NO_UDDIR', 'Propozycja odrzucona - brak katalogów download i upload');
if (!defined('_SUBMIT_HEADING')) DEFINE('_SUBMIT_HEADING', 'Wyślij plik do repozytorium');
if (!defined('_SUBMIT_INSTRUCT1')) DEFINE('_SUBMIT_INSTRUCT1', 'Dla plików hostowanych tutaj - wybierz i wyślij plik, a następnie uzupełnij szczegóły.');
if (!defined('_SUBMIT_INSTRUCT2')) DEFINE('_SUBMIT_INSTRUCT2', 'Dla plików hostowanych poza serwisem wpisz URL pliku oraz inne szczegóły, a następnie wyślij formularz.');
if (!defined('_SUBMIT_INSTRUCT3')) DEFINE('_SUBMIT_INSTRUCT3', 'Wybierz plik do zatwierdzenia, i wypełnij istotne szczegóły.');
if (!defined('_DOWN_FILE_SUBMIT_NOCHOICES')) DEFINE('_DOWN_FILE_SUBMIT_NOCHOICES','Nie masz pozwolenia aby wczytywać pliki - zgłoś do webmastera');
if (!defined('_SUBMIT_NEW_FILE')) DEFINE('_SUBMIT_NEW_FILE', 'Nowy plik');
if (!defined('_SUBMIT_UPLOAD_BUTTON')) DEFINE('_SUBMIT_UPLOAD_BUTTON', 'Wyślij plik &amp; Zachowaj');
if (!defined('_MAIN_DOWNLOADS')) DEFINE('_MAIN_DOWNLOADS','Dział plików - strona główna');
if (!defined('_BACK_CAT')) DEFINE('_BACK_CAT','Wróć do kategorii');
if (!defined('_BACK_FOLDER')) DEFINE('_BACK_FOLDER','Wróć do folderu');
if (!defined('_DOWN_START')) DEFINE('_DOWN_START','Pobieranie rozpocznie się za 2 sekundy');
if (!defined('_DOWN_CLICK')) DEFINE('_DOWN_CLICK','Kliknij tutaj jeśli ściąganie nie rozpoczęło się automatycznie');
if (!defined('_INVALID_ID')) DEFINE('_INVALID_ID','Niewłaściwy identyfikator');
if (!defined('_DOWN_CATEGORY')) DEFINE('_DOWN_CATEGORY','Kategoria');
if (!defined('_DOWN_NO_PARENT')) DEFINE('_DOWN_NO_PARENT','Brak - strona główna **');
if (!defined('_DOWN_FOLDER')) DEFINE('_DOWN_FOLDER','Folder');
if (!defined('_DOWN_FOLDERS')) DEFINE('_DOWN_FOLDERS','Foldery');
if (!defined('_DOWN_FILES')) DEFINE('_DOWN_FILES','Pliki');
if (!defined('_DOWN_FOLDERS_FILES')) DEFINE('_DOWN_FOLDERS_FILES','Foldery/Pliki');
if (!defined('_DOWN_NO_CATS')) DEFINE('_DOWN_NO_CATS',"Dział plików nie został jeszcze skonfigurowany na <i>$mosConfig_sitename</i>.<br />&nbsp;<br />Brak zdefiniowanych kategorii.");
if (!defined('_DOWN_NO_VISITOR_CATS')) DEFINE('_DOWN_NO_VISITOR_CATS','Przepraszamy, dział plików dostępny tylko dla zarejestrowanych użytkowników - zaloguj się');
if (!defined('_DOWN_ADMIN_FUNC')) DEFINE('_DOWN_ADMIN_FUNC','Funkcje administracyjne:');
if (!defined('_DOWN_ADD_CAT')) DEFINE('_DOWN_ADD_CAT','Dodaj kategorię');
if (!defined('_DOWN_DEL_CAT')) DEFINE('_DOWN_DEL_CAT','Usuń kategorię');
if (!defined('_DOWN_EDIT_CAT')) DEFINE('_DOWN_EDIT_CAT','Edytuj kategorię');
if (!defined('_DOWN_UP_NEITHER')) DEFINE('_DOWN_UP_NEITHER','Brak pozwoleń');
if (!defined('_DOWN_UP_DOWNLOAD_ONLY')) DEFINE('_DOWN_UP_DOWNLOAD_ONLY','Tylko pobierz');
if (!defined('_DOWN_UP_UPLOAD_ONLY')) DEFINE('_DOWN_UP_UPLOAD_ONLY','Tylko wczytaj');
if (!defined('_DOWN_UP_BOTH')) DEFINE('_DOWN_UP_BOTH','Wczytaj i pobierz');
if (!defined('_DOWN_USERS_PERMITTED')) DEFINE('_DOWN_USERS_PERMITTED','Zezwalaj użytkownikom na:');
if (!defined('_DOWN_VISITORS_PERMITTED')) DEFINE('_DOWN_VISITORS_PERMITTED','Zezwalaj gościom na:');
if (!defined('_DOWN_UP_ABSOLUTE_PATH')) DEFINE('_DOWN_UP_ABSOLUTE_PATH','Ścieżka absolutna (opcjonalnie):');
if (!defined('_DOWN_ADD_FOLDER')) DEFINE('_DOWN_ADD_FOLDER','Dodaj folder');
if (!defined('_DOWN_DEL_FOLDER')) DEFINE('_DOWN_DEL_FOLDER','Kasuj folder');
if (!defined('_DOWN_EDIT_FOLDER')) DEFINE('_DOWN_EDIT_FOLDER','Edytuj folder');
if (!defined('_DOWN_ADD_FILE')) DEFINE('_DOWN_ADD_FILE','Dodaj plik');
if (!defined('_DOWN_DEL_FILE')) DEFINE('_DOWN_DEL_FILE','Usuń plik');
if (!defined('_DOWN_EDIT_FILE')) DEFINE('_DOWN_EDIT_FILE','Edytuj plik');
if (!defined('_DOWN_PUB')) DEFINE('_DOWN_PUB','Opublikowany:');
if (!defined('_DOWN_SUBMIT_ANOTHER')) DEFINE('_DOWN_SUBMIT_ANOTHER','Dodać kolejny plik?');
if (!defined('_DOWN_SUBMIT_INSPECT')) DEFINE('_DOWN_SUBMIT_INSPECT','Zobaczyć plik właśnie dodany?');
if (!defined('_YES')) DEFINE('_YES','Tak');
if (!defined('_NO')) DEFINE('_NO','Nie');
if (!defined('_GLOBAL')) DEFINE('_GLOBAL','Globalne');
if (!defined('_DOWN_DESC')) DEFINE('_DOWN_DESC','Opis:');
if (!defined('_DOWN_DOWNLOADS')) DEFINE('_DOWN_DOWNLOADS','Pobrań:');
if (!defined('_DOWN_THUMBNAILS')) DEFINE('_DOWN_THUMBNAILS','Miniaturki:');
if (!defined('_DOWN_RATING')) DEFINE('_DOWN_RATING','Ocena:');
if (!defined('_DOWN_VOTES')) DEFINE('_DOWN_VOTES','Głosów:');
if (!defined('_DOWN_YOUR_VOTE')) DEFINE('_DOWN_YOUR_VOTE','Twój głos:');
if (!defined('_DOWN_RATE_BUTTON')) DEFINE('_DOWN_RATE_BUTTON','Oceń');
if (!defined('_DOWN_ALREADY_VOTE')) DEFINE('_DOWN_ALREADY_VOTE','Już oddałeś swój głos. Dziękujemy.');
if (!defined('_DOWN_FILE_TITLE')) DEFINE('_DOWN_FILE_TITLE','Nazwa pliku:');
if (!defined('_DOWN_FILE_TITLE_SORT')) DEFINE('_DOWN_FILE_TITLE_SORT','Nazwy');
if (!defined('_DOWN_REAL_NAME')) DEFINE('_DOWN_REAL_NAME','Rzeczywista nazwa pliku:');
if (!defined('_DOWNLOAD')) DEFINE('_DOWNLOAD','Pobierz');
if (!defined('_DOWN_DOWNLOADS_SORT')) DEFINE('_DOWN_DOWNLOADS_SORT','Pobrań');
if (!defined('_DOWN_SUB_BY')) DEFINE('_DOWN_SUB_BY','Dodał:');
if (!defined('_DOWN_FILE_DATE')) DEFINE('_DOWN_FILE_DATE','Wersja z dnia:');
if (!defined('_DOWN_FILE_AUTHOR')) DEFINE('_DOWN_FILE_AUTHOR','Autor:');
if (!defined('_DOWN_FILE_VER')) DEFINE('_DOWN_FILE_VER','Wersja:');
if (!defined('_DOWN_FILE_SIZE')) DEFINE('_DOWN_FILE_SIZE','Rozmiar:');
if (!defined('_DOWN_FILE_TYPE')) DEFINE('_DOWN_FILE_TYPE','Typ:');
if (!defined('_DOWN_FILE_COMPANY')) DEFINE('_DOWN_FILE_COMPANY','Firma:');
if (!defined('_DOWN_FILE_COMPANY_URL')) DEFINE('_DOWN_FILE_COMPANY_URL','Strona firmowa:');
if (!defined('_DOWN_FILE_AUTHOR_URL')) DEFINE('_DOWN_FILE_AUTHOR_URL','Strona web autora:');
if (!defined('_DOWN_FILE_RELEASE_DATE')) DEFINE('_DOWN_FILE_RELEASE_DATE','Data wydania (YYYY-MM-DD):');
if (!defined('_DOWN_FILE_STATUS')) DEFINE('_DOWN_FILE_STATUS','Status:');
if (!defined('_DOWN_FILE_LANGUAGES')) DEFINE('_DOWN_FILE_LANGUAGES','Język:');
if (!defined('_DOWN_FILE_REQUIREMENTS')) DEFINE('_DOWN_FILE_REQUIREMENTS','Wymagania:');
if (!defined('_DOWN_FILE_OPERATING_SYSTEM')) DEFINE('_DOWN_FILE_OPERATING_SYSTEM','System operacyjny:');
if (!defined('_DOWN_SCREEN')) DEFINE('_DOWN_SCREEN','Wygląd:');
if (!defined('_DOWN_SCREEN_CLICK')) DEFINE('_DOWN_SCREEN_CLICK','Kliknij tutaj żeby odwiedzić stronę');
if (!defined('_DOWN_NA')) DEFINE('_DOWN_NA','Niedostępny');
if (!defined('_DOWN_CAT_NAME')) DEFINE('_DOWN_CAT_NAME','Nazwa kategorii:');
if (!defined('_DOWN_SUB_BUTTON')) DEFINE('_DOWN_SUB_BUTTON','Idź');
if (!defined('_DOWN_ALL_DONE')) DEFINE('_DOWN_ALL_DONE','Gotowe!');
if (!defined('_DOWN_NOT_AUTH')) DEFINE('_DOWN_NOT_AUTH','Brak uprawnień!');
if (!defined('_DOWN_FOLDER_NAME')) DEFINE('_DOWN_FOLDER_NAME','Nazwa folderu:');
if (!defined('_DOWN_FOLDER_ADD_BUT')) DEFINE('_DOWN_FOLDER_ADD_BUT','Dodaj folder');
if (!defined('_DOWN_UP_WAIT')) DEFINE('_DOWN_UP_WAIT','Uwaga: Wszystkie pliki będą wymagały zatwierdzenia przed ich publikacją.');
if (!defined('_DOWN_AUTOAPP')) DEFINE('_DOWN_AUTOAPP','Plik został automatycznie zatwierdzony i opublikowany.');
if (!defined('_DOWN_APPROVE_PUB')) DEFINE('_DOWN_APPROVE_PUB','Zatwierdź + publikuj');
if (!defined('_DOWN_SUGGEST_LOC')) DEFINE('_DOWN_SUGGEST_LOC','Sugerowana lokalizacja:');
if (!defined('_DOWNLOAD_URL')) DEFINE('_DOWNLOAD_URL','Adres URL pliku:');
if (!defined('_DOWN_ICON')) DEFINE('_DOWN_ICON','Ikonka:');
if (!defined('_DOWN_MOVE_FILE')) DEFINE('_DOWN_MOVE_FILE','Przenieś plik:');
if (!defined('_DOWN_MOVE_FILE_FAILED')) DEFINE('_DOWN_MOVE_FILE_FAILED','Przeniesienie pliku niepowiodło się');
if (!defined('_DOWN_FILE_NEW_LOC')) DEFINE('_DOWN_FILE_NEW_LOC','Nowa lokalizacja dla pliku:');
if (!defined('_DOWN_AWAIT_APPROVE')) DEFINE('_DOWN_AWAIT_APPROVE','Przysłane pliki oczekujące na zatwierdzenie:');
if (!defined('_DOWN_ADMIN_APPROVE')) DEFINE('_DOWN_ADMIN_APPROVE','Zatwierdź przysłane pliki');
if (!defined('_DOWN_ID')) DEFINE('_DOWN_ID','ID');
if (!defined('_DOWN_SUBMIT_DATE')) DEFINE('_DOWN_SUBMIT_DATE','Data dodania:');
if (!defined('_DOWN_APP_SUB_BUTTON')) DEFINE('_DOWN_APP_SUB_BUTTON','Zatwierdź przysłane pliki');
if (!defined('_DOWN_DEL_SUB_BUTTON')) DEFINE('_DOWN_DEL_SUB_BUTTON','Usuń przysłane pliki');
if (!defined('_DOWN_SUB_APPROVE')) DEFINE('_DOWN_SUB_APPROVE','Przysłane pliki zostały zatwierdzone.');
if (!defined('_DOWN_SUB_DEL')) DEFINE('_DOWN_SUB_DEL','Przysłane pliki zostały skasowane.');
if (!defined('_DOWN_NO_SUB')) DEFINE('_DOWN_NO_SUB','Brak plików do zatwierdzenia.');
if (!defined('_DOWN_REV_SUB')) DEFINE('_DOWN_REV_SUB','Przejrzyj więcej przysłanych plików');
if (!defined('_DOWN_SEARCH')) DEFINE('_DOWN_SEARCH','Szukaj');
if (!defined('_DOWN_SEARCH_TEXT')) DEFINE('_DOWN_SEARCH_TEXT','Szukaj:');
if (!defined('_DOWN_SEARCH_FILETITLE')) DEFINE('_DOWN_SEARCH_FILETITLE','Szukaj tytułów plików:');
if (!defined('_DOWN_SEARCH_FILEDESC')) DEFINE('_DOWN_SEARCH_FILEDESC','Szukaj opisów plików:');
if (!defined('_DOWN_SEARCH_ERR')) DEFINE('_DOWN_SEARCH_ERR','Musisz podać tytuł lub opis pliku aby móc prawidłowo wyszukiwać.');
if (!defined('_DOWN_SEARCH_NORES')) DEFINE('_DOWN_SEARCH_NORES','Nie znaleziono żadnych plików.');
if (!defined('_DOWN_FILE_HOMEPAGE')) DEFINE('_DOWN_FILE_HOMEPAGE','Strona WWW:');
if (!defined('_DOWN_UPDATE_SUB')) DEFINE('_DOWN_UPDATE_SUB','Zatwierdź nadesłane pliki');
if (!defined('_DOWN_UP_EDIT_ID')) DEFINE('_DOWN_UP_EDIT_ID','Numer ID:');
if (!defined('_DOWN_FILE_DEL_NOTE')) DEFINE('_DOWN_FILE_DEL_NOTE','Uwaga: stary zapis pliku został usunięty z bazy danych, ale plik <b>prawdopodobnie</b> wciąż istnieje.');
if (!defined('_DOWN_SUB_DATE')) DEFINE('_DOWN_SUB_DATE','Data dodania:');
if (!defined('_DOWN_SUB_DATE_SORT')) DEFINE('_DOWN_SUB_DATE_SORT','Daty dodania');
if (!defined('_DOWN_SUB_ID_SORT')) DEFINE ('_DOWN_SUB_ID_SORT', 'Osoby wysyłającej');
if (!defined('_DOWN_COMMENTS')) DEFINE('_DOWN_COMMENTS','Komentarze:');
if (!defined('_DOWN_YOUR_COMM')) DEFINE('_DOWN_YOUR_COMM','Twój komentarz:');
if (!defined('_DOWN_LEAVE_COMM')) DEFINE('_DOWN_LEAVE_COMM','Dodaj komentarz');
if (!defined('_DOWN_FIRST_COMMENT')) DEFINE('_DOWN_FIRST_COMMENT','Bądź pierwszą osobą komentującą ten plik!');
if (!defined('_DOWN_FIRST_COMMENT_NL')) DEFINE('_DOWN_FIRST_COMMENT_NL','Bądź pierwszą osobą komentującą!  Musisz się zalogować lub zarejestrować.');
if (!defined('_DOWN_ALREADY_COMM')) DEFINE('_DOWN_ALREADY_COMM','Już dodałeś swój komentarz.');
if (!defined('_DOWN_MAX_COMM')) DEFINE("_DOWN_MAX_COMM","Maks. $Small_Text_Len znaków");
if (!defined('_DOWN_DESC_MAX')) DEFINE("_DOWN_DESC_MAX","Maks. $Large_Text_Len znaków");
if (!defined('_DOWN_MAIL_SUB')) DEFINE('_DOWN_MAIL_SUB','Nowa propozycja pliku');
if (!defined('_DOWN_ORDER_BY')) DEFINE('_DOWN_ORDER_BY','Sortuj wg:');
if (!defined('_DOWN_RESET')) DEFINE('_DOWN_RESET','Przelicz liczbę plików');
if (!defined('_DOWN_RESET_GO')) DEFINE('_DOWN_RESET_GO','Przelicza liczbę plików...');
if (!defined('_DOWN_RESET_DONE')) DEFINE('_DOWN_RESET_DONE','Zakończono przeliczanie liczby plików');
if (!defined('_DOWN_FIND_ORPHANS')) DEFINE('_DOWN_FIND_ORPHANS','Znajdź pliki w katalogu docelowym uploadu');
if (!defined('_DOWN_DEL_ORPHANS')) DEFINE('_DOWN_DEL_ORPHANS','Kasuj pliki w katalogu docelowym uploadu');
if (!defined('_DOWN_ORPHAN_SELECT')) DEFINE('_DOWN_ORPHAN_SELECT','Zaznacz');
if (!defined('_DOWN_ORPHAN_FILE_DEL')) DEFINE('_DOWN_ORPHAN_FILE_DEL','Plik do skasowania');
if (!defined('_DOWN_ORPHAN_NODEL')) DEFINE('_DOWN_ORPHAN_NODEL','Brak plików do kasowania');
if (!defined('_DOWN_ORPHAN_DONE')) DEFINE('_DOWN_ORPHAN_DONE','Pliki skasowano');
if (!defined('_DOWN_BAD_POST')) DEFINE('_DOWN_BAD_POST','Ustawienia nie zostały prawidłowo wysłane z formularza.');
if (!defined('_DOWN_SUB_WAIT')) DEFINE('_DOWN_SUB_WAIT','Plik oczekuje w kolejce.');
if (!defined('_DOWN_REG_ONLY')) DEFINE('_DOWN_REG_ONLY','Tylko zarejestrowani użytkownicy:');
if (!defined('_DOWN_RESTRICTED_WARN')) DEFINE('_DOWN_RESTRICTED_WARN','Przepraszamy, lokalizacja nie istnieje bądź jast niedostępna');
if (!defined('_DOWN_MEMBER_ONLY_WARN')) DEFINE('_DOWN_MEMBER_ONLY_WARN',"To miejsce jest przeznaczone wyłącznie dla grup zarejestrowanych użytkowników.<BR />"
                             ."Proszę zgłosić się do admina w sprawie dotyczącej grup, które mają dostęp");
if (!defined('_DOWN_REG_ONLY_WARN')) DEFINE("_DOWN_REG_ONLY_WARN","To miejsce jest przeznaczone wyłącznie dla zarejestrowanych użytkowników.<BR />"
                             ."Proszę zaloguj się lub zarejestruj.");
if (!defined('_DOWN_COUNT_EXCEEDED')) DEFINE('_DOWN_COUNT_EXCEEDED',"Przepraszamy, przekroczyłeś dozwolony limit.");
if (!defined('_DOWN_COUNT_EXCEEDED_FILE')) DEFINE('_DOWN_COUNT_EXCEEDED_FILE',"Przepraszamy, przekroczyłeś dozwolony limit dla tego pliku.");
if (!defined('_DOWN_NO_FILEN')) DEFINE('_DOWN_NO_FILEN','Proszę podać nazwę pliku');
if (!defined('_DOWN_MINI_SCREEN_PROMPT')) DEFINE('_DOWN_MINI_SCREEN_PROMPT','Pokaż miniaturę na liście plików:');
if (!defined('_DOWN_SEL_LOC_PROMPT')) DEFINE('_DOWN_SEL_LOC_PROMPT','Wybierz miejsce');
if (!defined('_DOWN_ALL_LOC_PROMPT')) DEFINE('_DOWN_ALL_LOC_PROMPT','Wszystkie miejsca');
if (!defined('_DOWN_SEL_CAT_DEL')) DEFINE('_DOWN_SEL_CAT_DEL','Wybierz kategorię do skasowania');
if (!defined('_DOWN_NO_CAT_DEF')) DEFINE('_DOWN_NO_CAT_DEF','Nie określono żadnej kategorii');
if (!defined('_DOWN_PUB_PROMPT')) DEFINE('_DOWN_PUB_PROMPT','Wybierz kategorię do ');
if (!defined('_DOWN_SEL_FILE_DEL')) DEFINE('_DOWN_SEL_FILE_DEL','Wybierz plik do skasowania');
if (!defined('_DOWN_CONFIG_COMP')) DEFINE('_DOWN_CONFIG_COMP','Detale konfiguracyjne zostały zaktualizowane!');
if (!defined('_DOWN_CONFIG_ERR')) DEFINE("_DOWN_CONFIG_ERR","Wystąpił błąd!\nBrak możliwości otworzenia pliku do zapisu!");
if (!defined('_DOWN_CATS')) DEFINE('_DOWN_CATS','Kategorie');
if (!defined('_DOWN_PARENT_CAT')) DEFINE('_DOWN_PARENT_CAT','Kategoria główna');
if (!defined('_DOWN_PARENT_FOLDER')) DEFINE('_DOWN_PARENT_FOLDER','Folder główny');
if (!defined('_DOWN_PUB1')) DEFINE('_DOWN_PUB1','Opublikowane');
if (!defined('_DOWN_RECORDS')) DEFINE('_DOWN_RECORDS','Archiwa');
if (!defined('_DOWN_ACCESS')) DEFINE('_DOWN_ACCESS','Dostęp');
if (!defined('_DOWN_GROUP')) DEFINE('_DOWN_GROUP','Grupa');
if (!defined('_DOWN_FILE_SYSTEM')) DEFINE('_DOWN_FILE_SYSTEM','Plik systemowy');
if (!defined('_DOWN_FILE_SYSTEM_OK')) DEFINE('_DOWN_FILE_SYSTEM_OK','Plik systemowy - OK');
if (!defined('_DOWN_DIRECTORY_NON_EXISTENT')) DEFINE('_DOWN_DIRECTORY_NON_EXISTENT','Nieistniejąca lokalizacja');
if (!defined('_DOWN_NOT_WRITEABLE')) DEFINE('_DOWN_NOT_WRITEABLE','Brak praw zapisu w lokalizacji');
if (!defined('_DOWN_WRITEABLE')) DEFINE('_DOWN_WRITEABLE','Są prawa zapisu w lokalizacji');
if (!defined('_DOWN_DATABASE')) DEFINE('_DOWN_DATABASE','Baza danych');
if (!defined('_DOWN_ADMIN_CPANEL_STORE')) DEFINE ('_DOWN_ADMIN_CPANEL_STORE','Domyślna przechowalnia zawartości:');
if (!defined('_DOWN_ADMIN_CPANEL_FILESTORE')) DEFINE ('_DOWN_ADMIN_CPANEL_FILESTORE','Domyślna przechowalnia plików:');
if (!defined('_DOWN_ADMIN_CPANEL_UPLOADS')) DEFINE ('_DOWN_ADMIN_CPANEL_UPLOADS','Miejsce wczytywania plików:');
if (!defined('_DOWN_CPANEL_RETURN')) DEFINE ('_DOWN_CPANEL_RETURN','Panel kontrolny');
if (!defined('_DOWN_CPANEL_SUB_BASIC')) DEFINE ('_DOWN_CPANEL_SUB_BASIC','Zarządzanie podstawowe');
if (!defined('_DOWN_CPANEL_SUB_FILES')) DEFINE ('_DOWN_CPANEL_SUB_FILES','Zarządzanie plikami');
if (!defined('_DOWN_CPANEL_SUB_HKEEP')) DEFINE ('_DOWN_CPANEL_SUB_HKEEP','Zarządzanie pobraniami');
if (!defined('_DOWN_CPANEL_SUB_UTILS')) DEFINE ('_DOWN_CPANEL_SUB_UTILS','Zarządzanie konwersją');
if (!defined('_DOWN_CPANEL_SUB_INFO')) DEFINE ('_DOWN_CPANEL_SUB_INFO','Informacje');
if (!defined('_DOWN_ADMIN_ACT_CONTAINERS')) DEFINE('_DOWN_ADMIN_ACT_CONTAINERS','Zarządzaj zawartością');
if (!defined('_DOWN_ADMIN_ACT_FILES')) DEFINE('_DOWN_ADMIN_ACT_FILES','Zarządzaj plikami');
if (!defined('_DOWN_ADMIN_ACT_GROUPS')) DEFINE('_DOWN_ADMIN_ACT_GROUPS','Zarządzaj grupami');
if (!defined('_DOWN_ADMIN_ACT_UPLOADS')) DEFINE('_DOWN_ADMIN_ACT_UPLOADS','Zatwierdź wczytywania');
if (!defined('_DOWN_ADMIN_ACT_CONFIG')) DEFINE('_DOWN_ADMIN_ACT_CONFIG','Konfiguracja');
if (!defined('_DOWN_ADMIN_ACT_UNLINKED')) DEFINE('_DOWN_ADMIN_ACT_UNLINKED','Niepodlinkowane pliki');
if (!defined('_DOWN_ADMIN_ACT_FTP')) DEFINE('_DOWN_ADMIN_ACT_FTP','Zbiorowe dodanie plików z serwera');
if (!defined('_DOWN_ADMIN_ACT_MISSING')) DEFINE('_DOWN_ADMIN_ACT_MISSING','Lista zagubionych plików');
if (!defined('_DOWN_ADMIN_ACT_COUNTS')) DEFINE('_DOWN_ADMIN_ACT_COUNTS','Przelicz ilość pobrań');
if (!defined('_DOWN_ADMIN_ACT_DOWNLOADS')) DEFINE('_DOWN_ADMIN_ACT_DOWNLOADS','Wyzeruj wszystkie ilości pobrań');
if (!defined('_DOWN_ADMIN_ACT_PRUNE')) DEFINE('_DOWN_ADMIN_ACT_PRUNE','Usuń stare logi pobrań plików');
if (!defined('_DOWN_ADMIN_ACT_THUMBS')) DEFINE('_DOWN_ADMIN_ACT_THUMBS','Sprawdź integralność mianiaturek');
if (!defined('_DOWN_ADMIN_ACT_DBCONVERT')) DEFINE('_DOWN_ADMIN_ACT_DBCONVERT','Konwersja z bazy danych 3.20');
if (!defined('_DOWN_ADMIN_ACT_DBCONVERT2')) DEFINE('_DOWN_ADMIN_ACT_DBCONVERT2','Konwersja z bazy danych 3.40');
if (!defined('_DOWN_ADMIN_ACT_STATS')) DEFINE('_DOWN_ADMIN_ACT_STATS','Statystyki');
if (!defined('_DOWN_ADMIN_ACT_ABOUT')) DEFINE('_DOWN_ADMIN_ACT_ABOUT','O Remository');
if (!defined('_DOWN_ADMIN_ACT_SUPPORT')) DEFINE('_DOWN_ADMIN_ACT_SUPPORT','Wsparcie i serwis deweloperski');
if (!defined('_DOWN_MOST_DOWNLOADED')) DEFINE('_DOWN_MOST_DOWNLOADED','Najczęściej pobierane');
if (!defined('_DOWN_MOST_DOWNLOADED_LONG')) DEFINE('_DOWN_MOST_DOWNLOADED_LONG','Pliki z największą ilością pobrań');
if (!defined('_DOWN_POPULAR')) DEFINE ('_DOWN_POPULAR','Popularne pliki');
if (!defined('_DOWN_POPULAR_LONG')) DEFINE ('_DOWN_POPULAR_LONG','Najczęściej pobierane w przeciągu ostatnich %s dni');
if (!defined('_DOWN_NEWEST')) DEFINE ('_DOWN_NEWEST','Nowe pliki');
if (!defined('_DOWN_NEWEST_LONG')) DEFINE ('_DOWN_NEWEST_LONG','Ostatnie w repozytorium');
if (!defined('_DOWN_VISITORS')) DEFINE('_DOWN_VISITORS','Goście');
if (!defined('_DOWN_REG_USERS')) DEFINE ('_DOWN_REG_USERS','Zarejestrowani użytkownicy');
if (!defined('_DOWN_OTHER_USERS')) DEFINE ('_DOWN_OTHER_USERS', 'Inni użytkownicy');
if (!defined('_DOWN_STORAGE_STATUS')) DEFINE ('_DOWN_STORAGE_STATUS','Stan magazynu');
if (!defined('_DOWN_ALL_REGISTERED')) DEFINE('_DOWN_ALL_REGISTERED','Wszyscy zarejestrowani');
if (!defined('_DOWN_REG_ONLY_TITLE')) DEFINE('_DOWN_REG_ONLY_TITLE','Tylko zarejestrowani');
if (!defined('_DOWN_PUBLIC_TITLE')) DEFINE('_DOWN_PUBLIC_TITLE','Dostępne');
if (!defined('_DOWN_APPROVE_TITLE')) DEFINE('_DOWN_APPROVE_TITLE','Pliki do zatwierdzenia');
if (!defined('_DOWN_DATE')) DEFINE('_DOWN_DATE','Data');
if (!defined('_DOWN_NAME_TITLE')) DEFINE('_DOWN_NAME_TITLE','Nazwa');
if (!defined('_DOWN_CONFIG_TITLE')) DEFINE('_DOWN_CONFIG_TITLE','Konfiguracja');
if (!defined('_DOWN_CONFIG_TITLE1')) DEFINE('_DOWN_CONFIG_TITLE1','Ścieżki i inne');
if (!defined('_DOWN_CONFIG_TITLE2')) DEFINE('_DOWN_CONFIG_TITLE2','Pozwolenia');
if (!defined('_DOWN_CONFIG_TITLE3')) DEFINE('_DOWN_CONFIG_TITLE3','Tekst podczas pobierania');
if (!defined('_DOWN_CONFIG_TITLE4')) DEFINE('_DOWN_CONFIG_TITLE4','Konfiguruj strony');
if (!defined('_DOWN_CONFIG_TITLE_PREAMBLE')) DEFINE('_DOWN_CONFIG_TITLE_PREAMBLE','Wprowadzenie');
if (!defined('_DOWN_CONFIG1')) DEFINE("_DOWN_CONFIG1","TabClass:<br /><em>(CSS rozróżnianie rzędów kolorów (Wartości oddzielone przecinkami))</em>");
if (!defined('_DOWN_CONFIG2')) DEFINE("_DOWN_CONFIG2","TabHeader:<br /><em>(CSS Nagłówek Strony i tło panelu Admina)</em>");
if (!defined('_DOWN_CONFIG3')) DEFINE("_DOWN_CONFIG3","Ścieżka do plików - Web - bez końcowego slasha)");
if (!defined('_DOWN_CONFIG4')) DEFINE("_DOWN_CONFIG4","Ścieżka do plików - File - bez końcowego slasha");
if (!defined('_DOWN_CONFIG5')) DEFINE("_DOWN_CONFIG5","Ścieżka do wgrania plików - bez końcowego slasha");
if (!defined('_DOWN_CONFIG6')) DEFINE("_DOWN_CONFIG6","Maks. dozwolony rozmiar pliku w Kb");
if (!defined('_DOWN_CONFIG7')) DEFINE("_DOWN_CONFIG7","Maks. dozwolona ilość wczytań przez użytkownika w ciągu dnia (Admin nie ma limitów)");
if (!defined('_DOWN_CONFIG8')) DEFINE("_DOWN_CONFIG8","Maks. dostępny rozmiar katalogu na pliki w Kb");
if (!defined('_DOWN_CONFIG9')) DEFINE("_DOWN_CONFIG9","Dopuszczalne rozszerzenia plików (lista oddzielona przecinkami)");
if (!defined('_DOWN_CONFIG10')) DEFINE("_DOWN_CONFIG10","Dozwolone tagi HTML w opisie (lista oddzielona przecinkami)");
if (!defined('_DOWN_CONFIG11')) DEFINE("_DOWN_CONFIG11","Pozwól nowym plikom nadpisywać stare");
if (!defined('_DOWN_CONFIG12')) DEFINE("_DOWN_CONFIG12","Pozwól użytkownikom proponować pliki - muszą być jeszcze zatwierdzone przez admina przed opublikowaniem");
if (!defined('_DOWN_CONFIG13')) DEFINE("_DOWN_CONFIG13","Pozwól użytkownikom edytować ich opisy - opisy muszą być wtedy ponownie zatwierdzone przez admina");
if (!defined('_DOWN_CONFIG14')) DEFINE("_DOWN_CONFIG14","Pozwól użytkownikom wczytywać pliki - muszą być jeszcze zatwierdzone przez admina przed opublikowaniem");
if (!defined('_DOWN_CONFIG15')) DEFINE("_DOWN_CONFIG15","Pozwól użytkownikom komentować pliki");
if (!defined('_DOWN_CONFIG16')) DEFINE("_DOWN_CONFIG16","Powiadom przez e-mail o propozycji pliku");
if (!defined('_DOWN_CONFIG17')) DEFINE("_DOWN_CONFIG17","Alternatywny adres do powiadomień, w przeciwnym razie zostanie użyty adres administratora");
if (!defined('_DOWN_CONFIG18')) DEFINE("_DOWN_CONFIG18","Alternatywna nazwa odbiorcy");
if (!defined('_DOWN_CONFIG19')) DEFINE("_DOWN_CONFIG19","Grafika nagłówka");
if (!defined('_DOWN_CONFIG20')) DEFINE("_DOWN_CONFIG20","Anti-Leach: Chroń pliki przed podlinkowywaniem");
if (!defined('_DOWN_CONFIG21')) DEFINE("_DOWN_CONFIG21","Maksymalna długość opisów (Opis/Licencja)");
if (!defined('_DOWN_CONFIG22')) DEFINE("_DOWN_CONFIG22","Maksymalna długość krótkich pól opisowych");
if (!defined('_DOWN_CONFIG23')) DEFINE("_DOWN_CONFIG23","Szerokość miniatury wyglądu");
if (!defined('_DOWN_CONFIG24')) DEFINE("_DOWN_CONFIG24","Wysokość miniatury wyglądu");
if (!defined('_DOWN_CONFIG25')) DEFINE("_DOWN_CONFIG25","Pozwalaj użytkownikom głosować na pliki");
if (!defined('_DOWN_CONFIG26')) DEFINE("_DOWN_CONFIG26","Pliki dodane przez ADMINA będą automatycznie zatwierdzane i publikowane");
if (!defined('_DOWN_CONFIG27')) DEFINE("_DOWN_CONFIG27","Pliki dodane przez zarejestrowanych użytkowników będą automatycznie zatwierdzane i publikowane");
if (!defined('_DOWN_CONFIG28')) DEFINE("_DOWN_CONFIG28","Pozwól pobrać z listy plików w kategorii/folderach");
if (!defined('_DOWN_CONFIG29')) DEFINE("_DOWN_CONFIG29","Pozwól użytkownikom dodawać zdalnie pliki:<br /><em>(Pliki, które są hostowane w innych miejscach)</em>");
if (!defined('_DOWN_CONFIG30')) DEFINE("_DOWN_CONFIG30","Ilość ulubionych plików użytkowników, które moga zapisać");
if (!defined('_DOWN_CONFIG31')) DEFINE("_DOWN_CONFIG31","Format daty dla Remository - PHP funkcje daty parametr 1");
if (!defined('_DOWN_CONFIG32')) DEFINE("_DOWN_CONFIG32","Domyślna wartość wersji pliku, gdy jest proponowana nowa wersja");
if (!defined('_DOWN_CONFIG33')) DEFINE('_DOWN_CONFIG33','Pozwól użytkownikom przeglądać kategorie/foldery, do których nie mają praw aby pobierać');
if (!defined('_DOWN_CONFIG34')) DEFINE('_DOWN_CONFIG34','Pozwól użytkownikom przeglądać pliki, których nie mogą pobierać');
if (!defined('_DOWN_CONFIG35')) DEFINE('_DOWN_CONFIG35','Maks. obrazek miniaturki, jaki bedzie zapisany; 0 tylko adres URL');
if (!defined('_DOWN_CONFIG36')) DEFINE("_DOWN_CONFIG36","Szerokość dużego obrazka");
if (!defined('_DOWN_CONFIG37')) DEFINE("_DOWN_CONFIG37","Wysokość dużego obrazka");
if (!defined('_DOWN_CONFIG38')) DEFINE("_DOWN_CONFIG38","Pozwól wyświetlić duży obrazek:<br /><em>(Okno popup dużego obrazka)</em>");
if (!defined('_DOWN_CONFIG39')) DEFINE("_DOWN_CONFIG39","Domyślnie magazynuj pliki w bazie danych");
if (!defined('_DOWN_CONFIG40')) DEFINE("_DOWN_CONFIG40","Maksymalna dozwolona ilość pobrań dla użytkownika w ciągu dnia (Nie dotyczy Admina)");
if (!defined('_DOWN_CONFIG41')) DEFINE("_DOWN_CONFIG41","Maksymalna dozwolona ilość pobrań jednego pliku dla użytkownika w ciągu dnia (Nie dotyczy Admina)");
if (!defined('_DOWN_CONFIG42')) DEFINE("_DOWN_CONFIG42","Zezwalaj wysyłającemu kasować swoje pliki");
if (!defined('_DOWN_CONFIG43')) DEFINE('_DOWN_CONFIG43','Twórz automatycznie miniaturki do plików graficznych');
if (!defined('_DOWN_CONFIG44')) DEFINE("_DOWN_CONFIG44","Maksymalna dozwolona ilość pobrań dla zarejestrowanego użytkownika w ciągu dnia (Nie dotyczy Admina)");
if (!defined('_DOWN_STATS_TITLE')) DEFINE('_DOWN_STATS_TITLE','Statystyki');
if (!defined('_DOWN_TOP_TITLE')) DEFINE('_DOWN_TOP_TITLE','Top');
if (!defined('_DOWN_RATED_TITLE')) DEFINE('_DOWN_RATED_TITLE','Ocen');
if (!defined('_DOWN_VOTED_ON')) DEFINE('_DOWN_VOTED_ON','Zagłosował na');
if (!defined('_DOWN_VOTES_TITLE')) DEFINE('_DOWN_VOTES_TITLE','Głosy');
if (!defined('_DOWN_RATING_TITLE')) DEFINE('_DOWN_RATING_TITLE','Ocena');
if (!defined('_DOWN_ABOUT')) DEFINE('_DOWN_ABOUT','O');
if (!defined('_DOWN_SUPPORT')) DEFINE('_DOWN_SUPPORT','Wsparcie');
if (!defined('_DOWN_ABOUT_DESCRIBE')) DEFINE('_DOWN_ABOUT_DESCRIBE','Remository - Aliro/MiaCMS/Joomla/Mambo Repozytorium plików');
if (!defined('_DOWN_TITLE_ABOUT')) DEFINE('_DOWN_TITLE_ABOUT','Tytuł');
if (!defined('_DOWN_VERSION_ABOUT')) DEFINE('_DOWN_VERSION_ABOUT','Wersja');
if (!defined('_DOWN_AUTHOR_ABOUT')) DEFINE('_DOWN_AUTHOR_ABOUT','Autor');
if (!defined('_DOWN_WEBSITE_ABOUT')) DEFINE('_DOWN_WEBSITE_ABOUT','Strona');
if (!defined('_DOWN_EMAIL_ABOUT')) DEFINE('_DOWN_EMAIL_ABOUT','E-Mail');
if (!defined('_DOWN_SEL_FILE_APPROVE')) DEFINE('_DOWN_SEL_FILE_APPROVE','Wybierz plik do zatwierdzenia');
if (!defined('_DOWN_DESC_SMALL')) DEFINE('_DOWN_DESC_SMALL','Krótki opis:');
if (!defined('_DOWN_DESC_SMALL_MAX')) DEFINE('_DOWN_DESC_SMALL_MAX','Maksymalnie 150 znaków');
if (!defined('_DOWN_AUTO_SHORT')) DEFINE('_DOWN_AUTO_SHORT','Wygeneruj krótki opis:');
if (!defined('_DOWN_LICENSE')) DEFINE('_DOWN_LICENSE','Licencja:');
if (!defined('_DOWN_LICENSE_AGREE')) DEFINE('_DOWN_LICENSE_AGREE','Musisz zaakceptować licencję:');
if (!defined('_DOWN_LEECH_WARN')) DEFINE('_DOWN_LEECH_WARN','Twoja sesja nie została zaakceptowana i zaczęły obowiązywać procedury Anty-Leeching.');
if (!defined('_DOWN_LICENSE_WARN')) DEFINE('_DOWN_LICENSE_WARN','Proszę przeczytać/zaakceptowac licencję pliku.');
if (!defined('_DOWN_LICENSE_CHECKBOX')) DEFINE('_DOWN_LICENSE_CHECKBOX','Zgadzam się na powyższe warunki.');
if (!defined('_DOWN_DATE_FORMAT')) DEFINE("_DOWN_DATE_FORMAT","%d %B %Y"); //Uses PHP's strftime Command Format
if (!defined('_DOWN_FILE_NOTFOUND')) DEFINE('_DOWN_FILE_NOTFOUND','nie znaleziono pliku');
if (!defined('_DOWN_ACCESS_GROUP')) DEFINE('_DOWN_ACCESS_GROUP','Grupa z pozwoleniami:');
if (!defined('_DOWN_THUMB_WRONG_TYPE')) DEFINE('_DOWN_THUMB_WRONG_TYPE','<h3>Obrazek miniaturki musi być plikiem png, jpg lub jpeg</h3>');
if (!defined('_DOWN_EXTENSION_IN_TITLE')) DEFINE('_DOWN_EXTENSION_IN_TITLE','Rozszerzony tytuł');
if (!defined('_DOWN_INHERIT')) DEFINE('_DOWN_INHERIT','dziedziczenie');
if (!defined('_DOWN_FORCE_INHERIT')) DEFINE('_DOWN_FORCE_INHERIT','Wymuś dziedziczenie poleceń oznaczonych gwiazdką');
if (!defined('_DOWN_EXT_IN_TITLE')) DEFINE('_DOWN_EXT_IN_TITLE','Rozszerzenie w tytule');
if (!defined('_DOWN_BULK_ADD_FILES')) DEFINE('_DOWN_BULK_ADD_FILES','zbiorowe dodanie plików z określonej lokalizacji');
if (!defined('_DOWN_NO_AVAILABLE_FILES')) DEFINE('_DOWN_NO_AVAILABLE_FILES','Pliki niedostępne');
if (!defined('_DOWN_ABS_PATH_TO_FILES')) DEFINE('_DOWN_ABS_PATH_TO_FILES','Ścieżka absolutna do plików:');
if (!defined('_DOWN_ACCEPTABLE_EXTENSIONS')) DEFINE('_DOWN_ACCEPTABLE_EXTENSIONS','Akceptowane rozszerzenia (oddzielone przecinkami):');
if (!defined('_DOWN_EXTENSION_IN_TITLE')) DEFINE('_DOWN_EXTENSION_IN_TITLE','Rozszerzenie dołączone do tytułu:');
if (!defined('_DOWN_DOWNLOAD_TEXT_BOX')) DEFINE('_DOWN_DOWNLOAD_TEXT_BOX','Okno z tekstem widoczne podczas pobierania');
if (!defined('_DOWN_MAIN_PREAMBLE')) DEFINE('_DOWN_MAIN_PREAMBLE', 'Tekst na stonie głównej');
if (!defined('_DOWN_PRUNE_LOG')) DEFINE('_DOWN_PRUNE_LOG','Skróć plik z logami');
if (!defined('_DOWN_LOGFILE_CUTOFF_DATE')) DEFINE('_DOWN_LOGFILE_CUTOFF_DATE','Wpisz datę, przed którą zostaną skasowane wszystkie wpisy w pliku z logami:');
if (!defined('_DOWN_PRESS_SAVE_ACTIVATE')) DEFINE('_DOWN_PRESS_SAVE_ACTIVATE','następnie wciśnij "Zapisz" aby aktywować.');
if (!defined('_DOWN_METHOD_NOT_PRESENT')) DEFINE('_DOWN_METHOD_NOT_PRESENT','Błąd %s komponentu: próba użycia nieistniejącej metody %s w %s');
if (!defined('_DOWN_CLASS_NOT_PRESENT')) DEFINE('_DOWN_CLASS_NOT_PRESENT','Błąd %s komponentu: próba użycia nieistniejącej klasy %s');
if (!defined('_DOWN_NO_UPLOAD_TO_FILES')) DEFINE('_DOWN_NO_UPLOAD_TO_FILES','Nie można wczytać hurtowo do kontenera ze ścieżka dostępu');
if (!defined('_DOWN_COUNTS_RECALCULATED')) DEFINE('_DOWN_COUNTS_RECALCULATED','Przeliczono pobrania dla plików i folderów');
if (!defined('_DOWN_COUNTS_RESET')) DEFINE('_DOWN_COUNTS_RESET','Wyzerowano ilość pobrań plików');
if (!defined('_DOWN_OLD_LOG_REMOVED')) DEFINE('_DOWN_OLD_LOG_REMOVED','Wpisy w pliku z logami wcześniejszymi niż %s zostały usunięte.');
if (!defined('_DOWN_NONE_MISSING')) DEFINE('_DOWN_NONE_MISSING','Brak zagubionych plików');
if (!defined('_DOWN_BLOB_NOCHUNKS')) DEFINE('_DOWN_BLOB_NOCHUNKS',' - BLOB TABLE posiada 0 części');
if (!defined('_DOWN_CHUNKS_DISCREPANCY')) DEFINE('_DOWN_CHUNKS_DISCREPANCY',' - BLOB TABLE ma %s części, info z pliku: %s');
if (!defined('_DOWN_PLAINTEXT_DISCREPANCY')) DEFINE('_DOWN_PLAINTEXT_DISCREPANCY',' - PLAIN TEXT TABLE posiada %s wpisów, powinien być dokładnie 1');
if (!defined('_DOWN_NOT_FOUND_HERE')) DEFINE('_DOWN_NOT_FOUND_HERE',' - NIE ZNALEZIONO W TEJ LOKACJI<br />');
if (!defined('_DOWN_LOCAL_NO_URL')) DEFINE('_DOWN_LOCAL_NO_URL','PLIK NIE ZNAJDUJE SIĘ LOKALNIE, A NIE WPISANO ADRESU URL');
if (!defined('_DOWN_NOT_VALID_BR')) DEFINE('_DOWN_NOT_VALID_BR',' - NIE SPRAWDZONO POPRAWNOŚCI<br />');
if (!defined('_DOWN_NO_RELEVANT_THUMB')) DEFINE('_DOWN_NO_RELEVANT_THUMB',' - brak istotnych plików - wykonano usuwanie.<br />');
if (!defined('_DOWN_THUMB_NOT_BELONG')) DEFINE('_DOWN_THUMB_NOT_BELONG','%s w lokalizacji %s plik nie przynależy - wykonano usuwanie.<br />');
if (!defined('_DOWN_THUMB_NOT_IN_DB')) DEFINE('_DOWN_THUMB_NOT_IN_DB',' - brak wpisów w bazie - wykonano usuwanie.<br />');
if (!defined('_DOWN_THUMB_OK')) DEFINE('_DOWN_THUMB_OK','Nie znaleziono problemu z plikami miniaturek');
if (!defined('_DOWN_DB_CONVERT_OK')) DEFINE('_DOWN_DB_CONVERT_OK','Konwersja bazy danych wykonana.  Pliki wypisane powyżej są błędne.');
if (!defined('_DOWN_ADD_NUMBER_FILES')) DEFINE('_DOWN_ADD_NUMBER_FILES','Dodaj ilość plików');
if (!defined('_DOWN_DISPLAY_NUMBER')) DEFINE('_DOWN_DISPLAY_NUMBER','Wyświetl #');
if (!defined('_DOWN_SEARCH_COLON')) DEFINE('_DOWN_SEARCH_COLON','Szukaj:');
if (!defined('_DOWN_SHOW_DESCENDANTS')) DEFINE('_DOWN_SHOW_DESCENDANTS','Pokaż malejąco: ');
if (!defined('_DOWN_CLICK_TO_VISIT')) DEFINE('_DOWN_CLICK_TO_VISIT','Kliknij aby odwiedzić stronę');
if (!defined('_DOWN_CONTAINERS')) DEFINE('_DOWN_CONTAINERS','Zawartość');
if (!defined('_DOWN_UP_PLAIN_TEXT')) DEFINE('_DOWN_UP_PLAIN_TEXT','Magazynować plik jako czysty tekst?');
if (!defined('_GLOBAL')) DEFINE('_GLOBAL','Globalne');
if (!defined('_DOWN_KEYWORDS')) DEFINE('_DOWN_KEYWORDS', 'Słowa kluczowe:');
if (!defined('_DOWN_WINDOW_TITLE')) DEFINE('_DOWN_WINDOW_TITLE','Tekst na pasku tytułowym przeglądarki:');
if (!defined('_DOWN_EDITOR_GROUP')) DEFINE('_DOWN_EDITOR_GROUP','Grupa edytujących:');
if (!defined('_DOWN_AUTO_FOR_ADMIN')) DEFINE('_DOWN_AUTO_FOR_ADMIN','Auto-zatwierdzanie dla Admina:');
if (!defined('_DOWN_AUTO_FOR_USERS')) DEFINE('_DOWN_AUTO_FOR_USERS','Auto-zatwierdzanie dla Użytkowników:');
if (!defined('_DOWN_AUTO_USER_GROUP')) DEFINE('_DOWN_AUTO_USER_GROUP','Auto-zatwierdzanie grupy użytkowników:');
if (!defined('_DOWN_CONTAINER_CASCADE')) DEFINE('_DOWN_CONTAINER_CASCADE','Zastosuj do wszystkich podfolderów:');
if (!defined('_DOWN_THANK_YOU')) DEFINE('_DOWN_THANK_YOU','Dziekujemy za pobranie ');
if (!defined('_DOWN_WAIT_OR_CLICK')) DEFINE('_DOWN_WAIT_OR_CLICK','Jeśli pobieranie nie rozpocznie się automatycznie za parę sekund, kliknij odnośnik Pobierz powyżej');
if (!defined('_DOWN_UPDATE_THUMBNAILS')) DEFINE('_DOWN_UPDATE_THUMBNAILS','Uaktualnij miniaturkę');
if (!defined('_DOWN_DELETE_THUMBNAIL')) DEFINE('_DOWN_DELETE_THUMBNAIL','Skasuj miniaturkę');
if (!defined('_DOWN_SUBMIT_NEW_THUMBNAIL')) DEFINE('_DOWN_SUBMIT_NEW_THUMBNAIL','Wczytaj nową miniaturkę');
if (!defined('_DOWN_NOT_LOGGED_UPLOAD')) DEFINE('_DOWN_NOT_LOGGED_UPLOAD','Nie masz uprawnień aby wczytywać.  Zaloguj się lub zarejestruj.');
if (!defined('_DOWN_NOT_LOGGED_COMMENT')) DEFINE('_DOWN_NOT_LOGGED_COMMENT','Nie masz uprawnień aby komentować.  Zaloguj się lub zarejestruj.');
if (!defined('_DOWN_NOT_LOGGED_VOTE')) DEFINE('_DOWN_NOT_LOGGED_VOTE','Nie masz uprawnień aby głosować.  Zaloguj się lub zarejestruj.');
if (!defined('_DOWN_COMMENT_NL')) DEFINE('_DOWN_COMMENT_NL','Zaloguj się lub zarejestruj, aby dodać komentarz');

// Define some summaries for tables
if (!defined('_TABLE_SUMMARY_GENHEAD')) DEFINE ('_TABLE_SUMMARY_GENHEAD', 'Lista kategorii dostępna oraz ilość plików w każdej kategorii.');
if (!defined('_TABLE_SUMMARY_ADDMANYFILES')) DEFINE ('_TABLE_SUMMARY_ADDMANYFILES', 'Ta tabela pozwoli ci wybrać wiele plików do wczytania.');
if (!defined('_DOWNLOAD_UPLOAD_TITLE')) DEFINE('_DOWNLOAD_UPLOAD_TITLE','Wczytaj plik');
if (!defined('_HEAD')) DEFINE('_HEAD','Wczytaj plik');
if (!defined('_FILE')) DEFINE('_FILE','Wczytaj plik:');
if (!defined('_CLOSE')) DEFINE('_CLOSE','Zamknij');
if (!defined('_SENDFILE')) DEFINE('_SENDFILE','Wyślij plik');
if (!defined('_ERR1')) DEFINE('_ERR1','Ten plik nie został określony.');
if (!defined('_ERR2')) DEFINE('_ERR2','Atak uploadu plików');
if (!defined('_ERR3')) DEFINE('_ERR3','Plik który usiłowałeś wczytać ma zerową długość!');
if (!defined('_ERR4')) DEFINE('_ERR4','Usiłowałeś wczytać plik z zabronionym rozszerzeniem!');
if (!defined('_ERR5')) DEFINE('_ERR5','Plik który usiłowałeś wczytać przekracza wymagany rozmiar ');
if (!defined('_ERR6')) DEFINE('_ERR6','W bazie danych isnieje już plik o takiej nazwie. Proszę podaj inną nazwę.');
if (!defined('_ERR7')) DEFINE('_ERR7','Katalog do wczytywania jest aktualnie pełny.');
if (!defined('_ERR8')) DEFINE('_ERR8','Musisz być administratorem lub zarejestrowanym użytkownikiem aby wczytywać pliki.');
if (!defined('_ERR9')) DEFINE('_ERR9','Przekroczyłeś swój dzienny limit wczytań.');
if (!defined('_ERR10')) DEFINE('_ERR10','Wczytywanie przez użytkowników nie jest dozwolone.');
if (!defined('_ERR11')) DEFINE('_ERR11','Zapis pliku z kodem nie powiódł się ');
if (!defined('_UP_SUCCESS')) DEFINE('_UP_SUCCESS','Wczytywanie pliku zakończono sukcesem!');
if (!defined('_UPLOAD_URL_LOCK')) DEFINE('_UPLOAD_URL_LOCK','-Plik wczytany pomyślnie-');
if (!defined('_WARNING1')) DEFINE('_WARNING1','Ścieżka do plików zmieniła się - UWAGA nie przeniesiono plików');
if (!defined('_WARNING2')) DEFINE('_WARNING2','Określona ścieżka do plików nie istnieje - Stwórz nową : ');
if (!defined('_APPROVE')) DEFINE('_APPROVE','Zatwierdź');
if (!defined('_CANCEL')) DEFINE('_CANCEL','Anuluj');
if (!defined('_DOWN_MISSING_TITLE')) DEFINE('_DOWN_MISSING_TITLE','Zagubione pliki');
if (!defined('_MBT_GROUP_MANAGER')) DEFINE('_MBT_GROUP_MANAGER','Zarządzanie grupami');
if (!defined('_MBT_GROUP_FILTER')) DEFINE('_MBT_GROUP_FILTER','Filtowanie po nazwie');
if (!defined('_MBT_GROUP_GROUP')) DEFINE('_MBT_GROUP_GROUP','Grupa');
if (!defined('_MBT_GROUP_DESCRIPTION')) DEFINE('_MBT_GROUP_DESCRIPTION','Opis');
if (!defined('_MBT_GROUP_EMAIL')) DEFINE('_MBT_GROUP_EMAIL','Email do grupy');
if (!defined('_MBT_GROUP_ADD')) DEFINE('_MBT_GROUP_ADD','Dodaj grupę');
if (!defined('_MBT_GROUP_EDIT')) DEFINE('_MBT_GROUP_EDIT','Edytuj groupę');
if (!defined('_MBT_GROUP_NAME')) DEFINE('_MBT_GROUP_NAME','Nazwa');
if (!defined('_MBT_GROUP_AVAI_USER')) DEFINE('_MBT_GROUP_AVAI_USER','Dostępni użytkownicy');
if (!defined('_MBT_GROUP_SEL_USER')) DEFINE('_MBT_GROUP_SEL_USER','Członkostwo w grupie');
if (!defined('_MBT_GROUP_MEMBERS')) DEFINE('_MBT_GROUP_MEMBERS','Członkowie');
if (!defined('_MBT_GROUP_SUBJECT')) DEFINE('_MBT_GROUP_SUBJECT','Temat');
if (!defined('_MBT_GROUP_MESSAGE')) DEFINE('_MBT_GROUP_MESSAGE','Wiadomość');
if (!defined('_MBT_GROUP_SEND')) DEFINE('_MBT_GROUP_SEND','Wyślij');
if (!defined('_MBT_GROUP_MISS_SUB')) DEFINE('_MBT_GROUP_MISS_SUB','Wpisz temat');
if (!defined('_MBT_GROUP_MISS_MSG')) DEFINE('_MBT_GROUP_MISS_MSG','Wpisz wiadomość');
if (!defined('_MBT_GROUP_MISS_GROUP')) DEFINE('_MBT_GROUP_MISS_GROUP','Wpisz nazwę grupy');
if (!defined('_MBT_GROUP_SEND_ADMIN')) DEFINE('_MBT_GROUP_SEND_ADMIN','Tylko administratorzy mają uprawnienia do wysyłania poczty!');
if (!defined('_MBT_GROUP_SEND_NOTARGET')) DEFINE('_MBT_GROUP_SEND_NOTARGET','Nie ma adresu email w grupie');
if (!defined('_MBT_GROUP_SEND_OK')) DEFINE('_MBT_GROUP_SEND_OK','Poczta wysłana do');
if (!defined('_MBT_GROUP_SEND_USERS')) DEFINE('_MBT_GROUP_SEND_USERS','Użytkownicy');


// Recent additions 3.56
if (!defined('_DOWN_EDIT_CLASSIFICATION')) DEFINE ('_DOWN_EDIT_CLASSIFICATION', 'Edit Classification');
if (!defined('_DOWN_CLASSIFICATION')) DEFINE ('_DOWN_CLASSIFICATION', 'Classification');
if (!defined('_DOWN_CONTAINER_PUBLISHED')) DEFINE ('_DOWN_CONTAINER_PUBLISHED', 'Container successfully published');
if (!defined('_DOWN_CONTAINERS_PUBLISHED')) DEFINE ('_DOWN_CONTAINERS_PUBLISHED', 'Containers successfully published');
if (!defined('_DOWN_CONTAINER_UNPUBLISHED')) DEFINE ('_DOWN_CONTAINER_UNPUBLISHED', 'Container successfully unpublished');
if (!defined('_DOWN_CONTAINERS_UNPUBLISHED')) DEFINE ('_DOWN_CONTAINERS_UNPUBLISHED', 'Containers successfully unpublished');
if (!defined('_DOWN_CONTAINER_SAVED')) DEFINE ('_DOWN_CONTAINER_SAVED', 'Container saved successfully');
if (!defined('_DOWN_CONTAINER_DELETED')) DEFINE ('_DOWN_CONTAINER_DELETED', 'Container deleted successfully');
if (!defined('_DOWN_CONTAINERS_DELETED')) DEFINE ('_DOWN_CONTAINERS_DELETED', 'Containers deleted successfully');
if (!defined('_DOWN_FILE_PUBLISHED')) DEFINE ('_DOWN_FILE_PUBLISHED', 'File successfully published');
if (!defined('_DOWN_FILES_PUBLISHED')) DEFINE ('_DOWN_FILES_PUBLISHED', 'Files successfully published');
if (!defined('_DOWN_FILE_UNPUBLISHED')) DEFINE ('_DOWN_FILE_UNPUBLISHED', 'File successfully unpublished');
if (!defined('_DOWN_FILES_UNPUBLISHED')) DEFINE ('_DOWN_FILES_UNPUBLISHED', 'Files successfully unpublished');
if (!defined('_DOWN_FILE_SAVED')) DEFINE ('_DOWN_FILE_SAVED', 'File saved successfully');
if (!defined('_DOWN_FILE_DELETED')) DEFINE ('_DOWN_FILE_DELETED', 'File deleted successfully');
if (!defined('_DOWN_FILES_DELETED')) DEFINE ('_DOWN_FILES_DELETED', 'Files deleted successfully');
if (!defined('_DOWN_FILE_LOCALISED')) DEFINE ('_DOWN_FILE_LOCALISED', 'File localised successfully');
if (!defined('_DOWN_GROUP_MEMBER_SAVED')) DEFINE ('_DOWN_GROUP_MEMBER_SAVED', 'Group member added successfully');
if (!defined('_DOWN_GROUP_MEMBERS_SAVED')) DEFINE ('_DOWN_GROUP_MEMBERS_SAVED', 'Group members added successfully');
if (!defined('_DOWN_GROUP_MEMBER_DELETED')) DEFINE ('_DOWN_GROUP_MEMBER_DELETED', 'Member removed successfully');
if (!defined('_DOWN_GROUP_MEMBERS_DELETED')) DEFINE ('_DOWN_GROUP_MEMBERS_DELETED', 'Members removed successfully');
if (!defined('_DOWN_GROUP_DELETED')) DEFINE ('_DOWN_GROUP_DELETED', 'Group deleted successfully');
if (!defined('_DOWN_GROUPS_DELETED')) DEFINE ('_DOWN_GROUPS_DELETED', 'Groups deleted successfully');
if (!defined('_DOWN_ORPHAN_SINGLE_DONE')) DEFINE('_DOWN_ORPHAN_SINGLE_DONE','File Orphan Deleted');
if (!defined('_DOWN_CLASSIFICATION_PUBLISHED')) DEFINE ('_DOWN_CLASSIFICATION_PUBLISHED', 'Classification successfully published');
if (!defined('_DOWN_CLASSIFICATIONS_PUBLISHED')) DEFINE ('_DOWN_CLASSIFICATIONS_PUBLISHED', 'Classifications successfully published');
if (!defined('_DOWN_CLASSIFICATION_UNPUBLISHED')) DEFINE ('_DOWN_CLASSIFICATION_UNPUBLISHED', 'Classification successfully unpublished');
if (!defined('_DOWN_CLASSIFICATIONS_UNPUBLISHED')) DEFINE ('_DOWN_CLASSIFICATIONS_UNPUBLISHED', 'Classifications successfully unpublished');
if (!defined('_DOWN_CLASSIFICATION_SAVED')) DEFINE ('_DOWN_CLASSIFICATION_SAVED', 'Classification saved successfully');
if (!defined('_DOWN_CLASSIFICATION_DELETED')) DEFINE ('_DOWN_CLASSIFICATION_DELETED', 'Classification deleted successfully');
if (!defined('_DOWN_CLASSIFICATIONS_DELETED')) DEFINE ('_DOWN_CLASSIFICATIONS_DELETED', 'Classifications deleted successfully');
if (!defined('_DOWN_MISSING_DELETED')) DEFINE ('_DOWN_MISSING_DELETED', 'Missing file deleted successfully');
if (!defined('_DOWN_MISSINGS_DELETED')) DEFINE ('_DOWN_MISSINGS_DELETED', 'Missing files deleted successfully');
if (!defined('_SUBMIT_FILE_BUTTON_ADV')) DEFINE('_SUBMIT_FILE_BUTTON_ADV','AddFile');