<?php

/**************************************************************
* This file is part of Remository
* Copyright (c) 2006-17 Martin Brampton
* 
* License: GNU General Public License version 2 or later; see LICENSE.txt
* 
* For support and other information, visit http://remository.com
* To contact Martin Brampton, write to martin@remository.com
*
* Remository started life as the psx-dude script by psx-dude@psx-dude.net
* It was enhanced by Matt Smith up to version 2.10
* Since then development has been primarily by Martin Brampton,
* with contributions from other people gratefully accepted
*/

defined('_JEXEC') or die;


// These settings are dummy values to suppress errors when the language file is used in a context where the real values have not been set
if (!isset($Large_Text_Len)) $Large_Text_Len = 500;
if (!isset($Small_Text_Len)) $Small_Text_Len = 150;
if (!isset($mosConfig_sitename)) $mosConfig_sitename = 'Nom du site';

// Add your own definitions here, just using plain DEFINE
// e.g. define ('_DOWNLOADS_TITLE', 'The name of my Repository');
// Your definitions will override the standard ones if placed ahead of them

// Prototype for standard definitions: if (!defined('')) DEFINE ('', '');
// Additions in 3.54
if (!defined('_DOWN_CONFIRM')) DEFINE('_DOWN_CONFIRM','Confirmer');
if (!defined('_DOWN_CONFIRM_MSG')) DEFINE('_DOWN_CONFIRM_MSG','Voulez-vous continuer ?');
if (!defined('_DOWN_RENAME')) DEFINE('_DOWN_RENAME','Renommer');
if (!defined('_DOWN_CONTAINER_RENAME_INSTRUCTION')) DEFINE('_DOWN_CONTAINER_RENAME_INSTRUCTION','Note : renommer ce répertoire ne changera pas le nom du répertoire physique qui lui est associé. Pour renommer le répertoire physique, il faut se connecter à la partie backoffice.');
if (!defined('_DOWN_CONTAINER_DELETE_NOT_EMPTY')) DEFINE('_DOWN_CONTAINER_DELETE_NOT_EMPTY','Attention, ce répertoire n\'est pas vide. Tous les éléments compris dans ce répertoire seront supprimés.');
if (!defined('_DOWN_CONTAINER_DELETE_INVALID_GROUP')) DEFINE('_DOWN_CONTAINER_DELETE_INVALID_GROUP','Vous n\'avez pas les droits de suppression de cette catégorie.');
if (!defined('_DOWN_CONTAINER_UPDATE_INVALID_GROUP')) DEFINE('_DOWN_CONTAINER_UPDATE_INVALID_GROUP','Vous n\'avez pas les droits d\'édition de cette catégorie.');
if (!defined('_DOWN_SUBCONTAINER_CREATE_LABEL')) DEFINE('_DOWN_SUBCONTAINER_CREATE_LABEL','Créer une sous-catégorie');
if (!defined('_DOWN_SUBCONTAINER_CREATE_INVALID_GROUP')) DEFINE('_DOWN_SUBCONTAINER_CREATE_INVALID_GROUP','Vous n\'avez pas les droits de création de sous-catégorie dans cette catégorie.');
if (!defined('_DOWN_SUBCONTAINER_CREATE_ERR_TITLE')) DEFINE('_DOWN_SUBCONTAINER_CREATE_ERR_TITLE', 'Impossible de créer la catégorie');
if (!defined('_DOWN_SUBCONTAINER_CREATE_FOLDER_WARN01')) DEFINE('_DOWN_SUBCONTAINER_CREATE_FOLDER_WARN01','Le titre de la catégorie ne permet pas de créer un répertoire physique.');
if (!defined('_DOWN_SUBCONTAINER_CREATE_FOLDER_ERR01')) DEFINE('_DOWN_SUBCONTAINER_CREATE_FOLDER_ERR01', 'Impossible de créer le répertoire physique : le répertoire physique de la catégorie parente est introuvable.');
if (!defined('_DOWN_SUBCONTAINER_CREATE_FOLDER_ERR02')) DEFINE('_DOWN_SUBCONTAINER_CREATE_FOLDER_ERR02','Impossible de créer le répertoire physique : vérifiez les droits d\'accès. ');
if (!defined('_DOWN_CONFIG_TITLE_FRONT_OFFICE_MGT')) DEFINE('_DOWN_CONFIG_TITLE_FRONT_OFFICE_MGT','Administration depuis le front office');
if (!defined('_DOWN_CONFIG_TITLE_RIGHTS')) DEFINE('_DOWN_CONFIG_TITLE_RIGHTS','Droits');
if (!defined('_DOWN_CONFIG_TITLE_DISPLAY')) DEFINE('_DOWN_CONFIG_TITLE_DISPLAY','Affichage');
if (!defined('_DOWN_CONFIG108')) DEFINE ('_DOWN_CONFIG108', '<b>Edition des catégories</b><br />Autoriser les membres à éditer les catégories (ici cela se résume à renommer le titre) sur lesquelles ils ont le droit d\'envoyer des fichiers');
if (!defined('_DOWN_CONFIG107')) DEFINE ('_DOWN_CONFIG107', '<b>Suppression des catégories</b><br />Autoriser les membres à supprimer les catégories sur lesquelles ils ont le droit d\'envoyer des fichiers.');
if (!defined('_DOWN_CONFIG106')) DEFINE ('_DOWN_CONFIG106', '<b>Création de catégories</b><br />Autoriser les membres à créer des sous-catégories dans les catégories où ils ont le droit d\'envoyer des fichiers');


// Additions in 3.53+
if (!defined('_DOWN_UPLOAD_NEW_FOLDER')) DEFINE ('_DOWN_UPLOAD_NEW_FOLDER', 'Créez un dossier sous la sélection :');
if (!defined('_DOWN_EMAIL_NOTIFY_PREFIX')) DEFINE ('_DOWN_EMAIL_NOTIFY_PREFIX', 'Le ou les fichiers suivants peuvent vous intéresser :');
if (!defined('_DOWN_EMAIL_NOTIFY_POSTFIX')) DEFINE ('_DOWN_EMAIL_NOTIFY_POSTFIX', 'Si vous avez des questions concernant le(s) fichier(s) ci-dessous, vuillez contacter l´expéditeur.');
if (!defined('_DOWN_COULD_NOT_SEND')) DEFINE ('_DOWN_COULD_NOT_SEND', 'Impossible d´envoyer %s à %s, action non autorisée.');
if (!defined('_DOWN_EMAIL_NOTIFY')) DEFINE ('_DOWN_EMAIL_NOTIFY', 'Nous tenons à vous informer de %s que vous pouvez télécharger sur %s');
if (!defined('_DOWN_ATTEMPTING_MAIL')) DEFINE ('_DOWN_ATTEMPTING_MAIL', 'Tentative d´envoi d´e-mail %s avec %s');
if (!defined('_DOWN_LINKS_TO_FILES')) DEFINE ('_DOWN_LINKS_TO_FILES', 'Liens vers des fichiers intéressants');
if (!defined('_DOWN_EMAIL_SUCCESSFUL')) DEFINE ('_DOWN_EMAIL_SUCCESSFUL', 'Evoi d´e-mail effectué à %s');
if (!defined('_DOWN_EMAIL_FAILED')) DEFINE ('_DOWN_EMAIL_FAILED', 'Envoi d´e-mail échoué à %s sur l´adresse %s');
if (!defined('_DOWN_NOTHING_TO_DO')) DEFINE ('_DOWN_NOTHING_TO_DO', 'Rien à faire');

// Additions in 3.53
if (!defined('_DOWN_ALL_CATEGORIES')) DEFINE ('_DOWN_ALL_CATEGORIES', 'Toutes les catégories');
if (!defined('_DOWN_DETAILS')) DEFINE('_DOWN_DETAILS','Détails');
if (!defined('_DOWN_THANKS_FOR_VOTING')) DEFINE ('_DOWN_THANKS_FOR_VOTING', 'Nous vous remercions d´avoir voté');
if (!defined('_DOWN_CAST_YOUR_VOTE')) DEFINE ('_DOWN_CAST_YOUR_VOTE', 'Pourquoi ne pas voter?');
if (!defined('_DOWN_LOGIN_TO_VOTE')) DEFINE ('_DOWN_LOGIN_TO_VOTE', 'Connectez-vous pour voter');
if (!defined('_DOWN_CONFIG_EXPLAIN_5')) DEFINE ('_DOWN_CONFIG_EXPLAIN_5', 'E = Sélectionner les champs pour télécharger ou modifier des fichiers');
if (!defined('_DOWN_SEARCH_ALL_FOLDERS')) DEFINE ('_DOWN_SEARCH_ALL_FOLDERS', 'Rechercher dans tous les dossiers');
if (!defined('_DOWN_UPLOAD_BLOCKED_GROUPS')) DEFINE ('_DOWN_UPLOAD_BLOCKED_GROUPS', 'Désolé, vous ne possédez pas les droits pour envoyer des fichiers.');
if (!defined('_DOWN_NO_REMOSITORY_GROUPS')) DEFINE ('_DOWN_NO_REMOSITORY_GROUPS', 'Selon la configuration, ce sont les groupes de Joomla! qui  sont utilisés et non ceux de Remository');
if (!defined('_DOWN_POSSIBLE_DUPLICATE_NAMES')) DEFINE ('_DOWN_POSSIBLE_DUPLICATE_NAMES', 'La configuration a été sauvée avec succès mais vous devez attribuer un ID au fichier en raison d´un doublon de nom');
if (!defined('_DOWN_CONFIG105')) DEFINE ('_DOWN_CONFIG105', '<b>Ouverture des fichiers</b><br />Désactiver l´option du navigateur ouvrant par défaut les fichiers téléchargés');
if (!defined('_DOWN_CONFIG104')) DEFINE ('_DOWN_CONFIG104', '<b>Système utilisé pour les groupes</b><br />Utilisez les groupes de Joomla! au lieu de ceux de Remository.');
if (!defined('_DOWN_CONFIG103')) DEFINE ('_DOWN_CONFIG103', '<b>Téléchargement direct</b><br />Activer les téléchargements sans afficher les détails des fichiers');
if (!defined('_DOWN_CONFIG72')) DEFINE ('_DOWN_CONFIG72', '<b>Ajouter le numéro d´identifiant aux fichiers</b><br />Actualiser les noms des fichiers en ajoutant leur numéro d´identifiant');
if (!defined('_DOWN_THIS_FILE_TODAY')) DEFINE ('_DOWN_THIS_FILE_TODAY', 'Vous avez téléchargé %d fois ce fichier durant les dernières 24 heures. La limite est fixée à %d téléchargements.');
if (!defined('_DOWN_ALL_FILES_TODAY')) DEFINE ('_DOWN_ALL_FILES_TODAY', 'Vous avez téléchargé %d fichier(s) durant ces 24 dernières heures. La limite est fixée à %d téléchargements.');
if (!defined('_DOWN_YOUR_CREDITS')) DEFINE ('_DOWN_YOUR_CREDITS', 'Il vous reste %d crédit(s).');
if (!defined('_DOWN_TOO_FEW_CREDITS')) DEFINE ('_DOWN_TOO_FEW_CREDITS', 'Il ne vous reste pas assez de crédit pour le téléchargement.');
if (!defined('_DOWN_CONFIG71')) DEFINE ('_DOWN_CONFIG71', '<strong>Afficher les sous-catégories</strong><br />Afficher les sous-catégories');
if (!defined('_DOWN_PRICE_LABEL')) DEFINE ('_DOWN_PRICE_LABEL', 'Prix&nbsp;:');

// Additions in 3.52
if (!defined('_DOWN_MANY_CONTAINERS')) DEFINE('_DOWN_MANY_CONTAINERS', 'Il y a trop de catégories pour les lister en une page. Utilisez la navigation.');
if (!defined('_DOWN_DELETE_SURE')) DEFINE ('_DOWN_DELETE_SURE', 'Etes-vous sûr de vouloir effacer ce fichier?');
if (!defined('_DOWN_SEARCH_CATEGORY_SELECT')) DEFINE ('_DOWN_SEARCH_CATEGORY_SELECT', 'Choisissez les catégories à inclure');
if (!defined('_DOWN_SEARCH_FILES')) DEFINE ('_DOWN_SEARCH_FILES', 'Rechercher des fichiers');

// Additions in 3.51
if (!defined('_DOWN_NOT_ABSOLUTE')) DEFINE ('_DOWN_NOT_ABSOLUTE', 'Chemin absolu invalide');
if (!defined('_DOWN_NEW_OR_UPDATED')) DEFINE ('_DOWN_NEW_OR_UPDATED', 'Nouveau ou mise à jour de fichier');
if (!defined('_DOWN_MAIL_MESSAGE_PREFIX')) DEFINE ('_DOWN_MAIL_MESSAGE_PREFIX', "Bonjour %s\n\n");
if (!defined('_DOWN_NEW_UPDATED_MSG')) DEFINE ('_DOWN_NEW_UPDATED_MSG', 'De %s'
					."\n\nLe fichier %s a été ajouté ou mis à jour.  Le titre du fichier est %s."
					."\n\nVeuillez ne pas répondre à ce message, il vous est transmis uniquement à titre d´information\n"
					);

// Modifications in 3.51
if (!defined('_DOWN_MAIL_MSG')) DEFINE('_DOWN_MAIL_MSG','Bonjour, un nouveau fichier est soumis par $user'
                   .' sur $mosConfig_sitename .\n\n'
                   .'Rendez-vous dans la console d´administration $mosConfig_live_site/administrator/index.php pour consulter et approuver le fichier.\n\n'
                   .'Ce message vous est transmis automatiquement pour votre information\n');
if (!defined('_DOWN_MAIL_MSG_APP')) DEFINE('_DOWN_MAIL_MSG_APP','Bonjour, un nouveau fichier est soumis par $user'
                   .' sur le site Internet $mosConfig_sitename.\n\n'
                   .'Selon la configuration, sa validation n´a pas besoin d´approbation.\n\n'
                   .'Veuillez ne pas répondre à ce message, il vous est transmis uniquement à titre d´information\n');
if (!defined('_DOWN_LINK_TO_FILE')) DEFINE ('_DOWN_LINK_TO_FILE', "\n\nVous trouverez le fichier en cliquant sur le lien suivant : %s");

// Additions in 3.50
if (!defined('_DOWN_APPROVE_ROLES')) DEFINE ('_DOWN_APPROVE_ROLES', 'Groupe auto-approuvé');
if (!defined('_DOWN_ACCESS_REFUSED')) DEFINE ('_DOWN_ACCESS_REFUSED', 'Votre requète est refusée');
if (!defined('_DOWN_MAYBE_LOGIN')) DEFINE ('_DOWN_MAYBE_LOGIN', 'Veuillez vous connecter ou créer un compte.');
if (!defined('_DOWN_CONFIG70')) DEFINE ('_DOWN_CONFIG70', '<b>Toutes les catégories</b><br />Afficher l´arborescence complète dans les résultats de recherche.');
if (!defined('_DOWN_CONFIG69')) DEFINE ('_DOWN_CONFIG69', '<b>Lieu de référence pour la date</b><br />Choisissez un lieu (fuseau horaire) comme référence pour la date.');
if (!defined('_DOWN_CONFIG68')) DEFINE ('_DOWN_CONFIG68', '<b>Forcer le code langue</b><br />Forcer le code langue en ignorant celui par défaut de Joomla!');

// Additions in 3.47 to fix missed items in earlier versions
if (!defined('_DOWN_NO_FILE_RECEIVED')) DEFINE ('_DOWN_NO_FILE_RECEIVED', 'Vous avez envoyé un fichier mais il n´a pas pu être réceptionné.');
if (!defined('_DOWN_SAMPLE')) DEFINE ('_DOWN_SAMPLE', 'Exemple');
if (!defined('_DOWN_SAMPLE_DESCRIPTION')) DEFINE ('_DOWN_SAMPLE_DESCRIPTION', 'Pour des raisons de sécurité, il est fortement conseillé de supprimer ou modifier ce dossier *Exemple*');
if (!defined('_DOWN_INSTALL_DONE1')) DEFINE ('_DOWN_INSTALL_DONE1', 'Aide sur Remository</h3><p style="font-weight:normal;">Pour une prise en main de Remository, il vous est recommandé de lire le tutoriel disponible sur <a href="http://www.joomlatutos.com" target="_blank">Joomlatutos.com</a><br />Vous pouvez touver des informations complémentaires sur <a href="http://remository.com" target="_blank">le site de Remository</a></p>');
if (!defined('_DOWN_INSTALL_DONE2')) DEFINE ('_DOWN_INSTALL_DONE2', 'Forums sur Remository</h3><p style="font-weight:normal;">Vous pouvez également trouver des réponses à vos questions sur <a href="http://forum.joomla.fr" target="_blank">le forum de Joomla! FR</a> ou le <a href="http://remository.com/forum/">le forum officiel en anglais</a></p>');
if (!defined('_DOWN_INSTALL_DONE3')) DEFINE ('_DOWN_INSTALL_DONE3', 'Soutenir le projet Remository');
if (!defined('_DOWN_INSTALL_DONE4')) DEFINE ('_DOWN_INSTALL_DONE4', 'Le développement et le suivi de Remository requierent du temps et de l´argent.<br />Si vous bénéficier de revenus financiers grâce à Remository, nous vous serions reconnaissant de soutenir ce projet.<br />Vous pouvez cliquer sur le bouton ci-dessous pour effectuer un don directement...');
if (!defined('_DOWN_LOCAL_OR_REMOTE')) DEFINE ('_DOWN_LOCAL_OR_REMOTE', 'Local ou en ligne');
if (!defined('_DOWN_IS_LOCAL')) DEFINE ('_DOWN_IS_LOCAL', 'Local');
if (!defined('_DOWN_IS_REMOTE')) DEFINE ('_DOWN_IS_REMOTE', 'En ligne');
if (!defined('_DOWN_LOCALISE_REMOTE_FILE')) DEFINE ('_DOWN_LOCALISE_REMOTE_FILE', 'Rendre Local');
if (!defined('_DOWN_CANCEL_UPLOAD')) DEFINE ('_DOWN_CANCEL_UPLOAD', 'Annuler l´envoi');
if (!defined('_DOWN_NOT_YET_IMPLEMENTED')) DEFINE ('_DOWN_NOT_YET_IMPLEMENTED', 'Ajout de champs personnalisés');
if (!defined('_DOWN_ADMIN_CPANEL_CACHEPATH')) DEFINE ('_DOWN_ADMIN_CPANEL_CACHEPATH', '<span style="font-weight:normal">Chemin du cache Joomla! - Nécessaire pour le flux RSS et le contrôle d´accès:</span>');
if (!defined('_DOWN_CONFIG_EXPLAIN_4')) DEFINE ('_DOWN_CONFIG_EXPLAIN_4', 'D = Éléments affichés dans le détail du fichier');
if (!defined('_DOWN_CONFIG67')) DEFINE ('_DOWN_CONFIG67', '<b>URL relative non-SEF des profils</b><br />Activer l´URL relative non-SEF des profils avec %u quand user_ID doit être dans le lien');
if (!defined('_DOWN_CONFIG66')) DEFINE ('_DOWN_CONFIG66', '<b>Activer la fonction AEC</b><br />Activer la fonction AEC pour le contrôle des accès');
if (!defined('_DOWN_AEC_OPTION_A')) DEFINE ('_DOWN_AEC_OPTION_A', 'Appliquer juste aux groupes ci-dessous.');
if (!defined('_DOWN_AEC_OPTION_B')) DEFINE ('_DOWN_AEC_OPTION_B', 'Effacer tous, et appliquer aux groupes ci-dessous.');
if (!defined('_DOWN_AEC_OPTION_C')) DEFINE ('_DOWN_AEC_OPTION_C', 'Effacer les groupes activés, et appliquer aux groupes ci-dessous.');
if (!defined('_DOWN_CONFIG65')) DEFINE ('_DOWN_CONFIG65', '<b>Titre du composant de téléchargement</b><br />Titre affiché dans la barre de titre du navigateur à l´appel de Remository');
if (!defined('_DOWN_NEXT')) DEFINE ('_DOWN_NEXT', 'Suivant');
if (!defined('_DOWN_PREVIOUS')) DEFINE ('_DOWN_PREVIOUS', 'Précédent');
if (!defined('_DOWN_DOWNLOAD_LC')) DEFINE ('_DOWN_DOWNLOAD_LC', 'Télécharger');
if (!defined('_DOWN_EMPTY_REPOSITORY')) DEFINE ('_DOWN_EMPTY_REPOSITORY', 'Vide');
if (!defined('_DOWN_OVERVIEW_LATEST')) DEFINE ('_DOWN_OVERVIEW_LATEST', 'Dernier fichier en téléchargement');
if (!defined('_DOWN_SPECIFY_AUTHOR')) DEFINE ('_DOWN_SPECIFY_AUTHOR', 'Autre auteur');
if (!defined('_DOWN_CONFIG64')) DEFINE ('_DOWN_CONFIG64', '<b>Nombre d´auteurs</b><br />Nombre d´auteurs affichés dans la liste déroulante');
if (!defined('_DOWN_CONFIG63')) DEFINE ('_DOWN_CONFIG63', '<b>Liste des auteurs</b><br />Liste des noms d´auteurs à sélectionner, séparés par une virgule');
if (!defined('_DOWN_CONFIG62')) DEFINE ('_DOWN_CONFIG62', '<b>Longueur de description</b><br />Longueur minimum de description des fichiers, ou ignorer');
if (!defined('_DOWN_CONFIG61')) DEFINE ('_DOWN_CONFIG61', '<b>Téléchargement de vidéos</b><br />Tout le monde peut télécharger des vidéos');
if (!defined('_DOWN_CONFIG60')) DEFINE ('_DOWN_CONFIG60', '<b>Téléchargement de fichiers audio</b><br />Tout le monde peut télécharger des fichiers audio');
if (!defined('_DOWN_CONFIG59')) DEFINE ('_DOWN_CONFIG59', '<b>Alias</b><br />Alias de nom');
if (!defined('_DOWN_CONFIG58')) DEFINE ('_DOWN_CONFIG58', '<b>Nom</b><br />Nom de fichier');
if (!defined('_DOWN_PLAY')) DEFINE ('_DOWN_PLAY', 'Play');
if (!defined('_DOWN_PLAY_THANK_YOU')) DEFINE ('_DOWN_PLAY_THANK_YOU', 'Nous vous remercions de consulter ');
if (!defined('_DOWN_CONFIG57')) DEFINE ('_DOWN_CONFIG57', '<b>Extensions des fichiers vidéo</b><br />Extensions des fichiers vidéo à lire et non pas à télécharger');
if (!defined('_DOWN_CONFIG56')) DEFINE ('_DOWN_CONFIG56', '<b>Extensions des fichiers audio</b><br />Extensions des fichiers audio à lire et non pas à télécharger');
if (!defined('_DOWN_FEATURED')) DEFINE ('_DOWN_FEATURED', 'Mise en avant');
if (!defined('_DOWN_IS_FEATURED')) DEFINE ('_DOWN_IS_FEATURED', 'Fichier mis en avant');
if (!defined('_DOWN_FEATURE_START')) DEFINE ('_DOWN_FEATURE_START', 'Mis en avant le&nbsp;:');
if (!defined('_DOWN_FEATURE_END')) DEFINE ('_DOWN_FEATURE_END', 'Fin de mise en avant&nbsp;:<br />(vide = jamais)');
if (!defined('_DOWN_PUBLISH_FROM')) DEFINE ('_DOWN_PUBLISH_FROM', 'Publié à partir du&nbsp;:<br />(vide = de suite)');
if (!defined('_DOWN_PUBLISH_TO')) DEFINE ('_DOWN_PUBLISH_TO', 'Publié jusqu´au&nbsp;:<br />(vide = toujours)');
if (!defined('_DOWN_FIELD_NAME')) DEFINE ('_DOWN_FIELD_NAME', 'Nom du champ');
if (!defined('_DOWN_FIELD_TITLE')) DEFINE ('_DOWN_FIELD_TITLE', 'Titre du champ');
if (!defined('_DOWN_CUSTOM_UPLOAD')) DEFINE ('_DOWN_CUSTOM_UPLOAD', 'En envoi');
if (!defined('_DOWN_CUSTOM_LIST')) DEFINE ('_DOWN_CUSTOM_LIST', 'Liste');
if (!defined('_DOWN_CUSTOM_INFO_PAGE')) DEFINE ('_DOWN_CUSTOM_INFO_PAGE', 'Infos');
if (!defined('_DOWN_FIELD_OPTIONS')) DEFINE ('_DOWN_FIELD_OPTIONS', 'Valeurs de la liste, séparée par une virgule');
if (!defined('_DOWN_CUSTOM_INFO')) DEFINE ('_DOWN_CUSTOM_INFO', 'Le nom du champ sera utilisé dans la base de données et doit être unique pour la table de xxx_downloads_files. Le titre du champ sera utilisé pour l´afficher quand besoin.');
if (!defined('_DOWN_CUSTOM_FIELDS_TAB')) DEFINE ('_DOWN_CUSTOM_FIELDS_TAB', 'Ajouter des champs');
if (!defined('_DOWN_CUSTOM_FIELDS_HEAD')) DEFINE ('_DOWN_CUSTOM_FIELDS_HEAD', 'Champs personnalisés');
if (!defined('_DOWN_CONFIG55')) DEFINE ('_DOWN_CONFIG55', '<b>Nombre d´éléments décrits</b><br />Nombre d´éléments décrits dans la liste');
if (!defined('_DOWN_IS_VISIBLE')) DEFINE ('_DOWN_IS_VISIBLE', 'Visible');
if (!defined('_DOWN_FREQUENCY')) DEFINE ('_DOWN_FREQUENCY', 'Fréquence');
if (!defined('_DOWN_TYPE')) DEFINE ('_DOWN_TYPE', 'Type');
if (!defined('_DOWN_DESCRIPTION')) DEFINE ('_DOWN_DESCRIPTION', 'Description');
if (!defined('_DOWN_CLASSIFICATIONS')) DEFINE ('_DOWN_CLASSIFICATIONS', 'Classification / Tags');
if (!defined('_DOWN_SAVE')) DEFINE ('_DOWN_SAVE','Sauver');
if (!defined('_DOWN_FILE_STRUCTURE')) DEFINE ('_DOWN_FILE_STRUCTURE', 'Structure de fichier');
if (!defined('_DOWN_PRUNE')) DEFINE ('_DOWN_PRUNE', '/ Purger');
if (!defined('_DOWN_DELETE_MISSING')) DEFINE ('_DOWN_DELETE_MISSING', 'Effacer les fichiers');
if (!defined('_DOWN_APPLY')) DEFINE ('_DOWN_APPLY','Appliquer ');
if (!defined('_DOWN_CLASSIFICATION_NAME')) DEFINE ('_DOWN_CLASSIFICATION_NAME', 'Nom de classification');
if (!defined('_DOWN_DISPLAY_LISTS')) DEFINE ('_DOWN_DISPLAY_LISTS', 'Afficher les noms dans la liste');
if (!defined('_DOWN_NOT_PUBLISHED')) DEFINE ('_DOWN_NOT_PUBLISHED', 'Non publié');
if (!defined('_DOWN_PUBLISH')) DEFINE ('_DOWN_PUBLISH','Publier');
if (!defined('_DOWN_UNPUBLISH')) DEFINE ('_DOWN_UNPUBLISH','Dépublier');
if (!defined('_DOWN_FILE')) DEFINE ('_DOWN_FILE', 'Fichier');
if (!defined('_DOWN_ADD')) DEFINE ('_DOWN_ADD','Ajouter');
if (!defined('_DOWN_CLASSIFN')) DEFINE ('_DOWN_CLASSIFN', 'Classification');
if (!defined('_DOWN_ROLES')) DEFINE ('_DOWN_ROLES', 'Groupes&nbsp;:');
if (!defined('_DOWN_DELETE')) DEFINE ('_DOWN_DELETE','Effacer');
if (!defined('_DOWN_ADD_USERS_NEW_ROLE')) DEFINE ('_DOWN_ADD_USERS_NEW_ROLE', 'Ajouter un utilisateur dans un nouveau groupe');
if (!defined('_DOWN_ADD_MEMBERS')) DEFINE ('_DOWN_ADD_MEMBERS', 'Ajouter des membres');
if (!defined('_DOWN_ADD_LOCAL')) DEFINE ('_DOWN_ADD_LOCAL','Ajouter Fichier');
if (!defined('_DOWN_ADD_REMOTE')) DEFINE ('_DOWN_ADD_REMOTE', 'Lien sur Fichier');
if (!defined('_DOWN_EDIT_APPROVAL')) DEFINE ('_DOWN_EDIT_APPROVAL', 'Editer le fichier à approuver');
if (!defined('_DOWN_DELETE_SUBMISSION')) DEFINE ('_DOWN_DELETE_SUBMISSION', 'Effacer la soumission');
if (!defined('_DOWN_CONTAINER')) DEFINE ('_DOWN_CONTAINER', 'catégorie');
if (!defined('_DOWN_PUBLISH_FILES')) DEFINE ('_DOWN_PUBLISH_FILES', 'Publier les fichiers');
if (!defined('_DOWN_DELETE_ORPHANS')) DEFINE ('_DOWN_DELETE_ORPHANS', 'Effacer les fichiers');
if (!defined('_DOWN_ORPHAN')) DEFINE ('_DOWN_ORPHAN', 'Non classé');
if (!defined('_DOWN_MISSING')) DEFINE ('_DOWN_MISSING', 'Manquant');
if (!defined('_DOWN_ADD_USERS_ROLE')) DEFINE ('_DOWN_ADD_USERS_ROLE', 'Ajouter un utilisateur dans le groupe');
if (!defined('_DOWN_REMOVE_USERS_ROLE')) DEFINE ('_DOWN_REMOVE_USERS_ROLE', 'Supprimer un utilisateur du groupe');
if (!defined('_DOWN_PUBLISHING')) DEFINE('_DOWN_PUBLISHING','Publication');
if (!defined('_DOWN_EDIT_CONTAINER')) DEFINE ('_DOWN_EDIT_CONTAINER', 'Editer la catégorie');
if (!defined('_DOWN_REMOSITORY')) DEFINE ('_DOWN_REMOSITORY', 'Remository');
if (!defined('_DOWN_PHYSICAL_FILE')) DEFINE ('_DOWN_PHYSICAL_FILE', 'Fichier physique');
if (!defined('_DOWN_METADATA')) DEFINE ('_DOWN_METADATA', 'Métadonnées');
if (!defined('_DOWN_SHORT_DESCRIPTION')) DEFINE ('_DOWN_SHORT_DESCRIPTION', 'Description courte');
if (!defined('_DOWN_LICENSE_HEADING')) DEFINE ('_DOWN_LICENSE_HEADING', 'Licence');
if (!defined('_DOWN_ABOUT_FILE')) DEFINE ('_DOWN_ABOUT_FILE', 'Decription du fichier');
if (!defined('_DOWN_COMMENTS_HEADING')) DEFINE ('_DOWN_COMMENTS_HEADING', 'Commentaires');
if (!defined('_DOWN_STORAGE')) DEFINE ('_DOWN_STORAGE', 'Stockage');
if (!defined('_DOWN_ACCESS_CONTROL')) DEFINE ('_DOWN_ACCESS_CONTROL', 'Contrôle des accès');
if (!defined('_DOWN_DOWNLOAD_ROLES')) DEFINE('_DOWN_DOWNLOAD_ROLES','Téléchargement');
if (!defined('_DOWN_UPLOAD_ROLES')) DEFINE('_DOWN_UPLOAD_ROLES','Envoi/Soumission');
if (!defined('_DOWN_EDIT_ROLES')) DEFINE('_DOWN_EDIT_ROLES','Edition');
if (!defined('_DOWN_ADD_NEW_ROLE')) DEFINE ('_DOWN_ADD_NEW_ROLE', 'Ajouter un nouveau groupe');
// Recent additions 3.46+
if (!defined('_DOWN_DOWNLOAD_FROM')) DEFINE ('_DOWN_DOWNLOAD_FROM', 'Téléchargé par ');
if (!defined('_DOWN_UPLOAD_TO')) DEFINE ('_DOWN_UPLOAD_TO', 'Envoyé par');
if (!defined('_DOWN_EDIT_IN')) DEFINE ('_DOWN_EDIT_IN', 'Edité dans');
if (!defined('_DOWN_SUBS_EVERYTHING')) DEFINE ('_DOWN_SUBS_EVERYTHING', 'Calculer tous les téléchargements de fichier');
if (!defined('_DOWN_SUBS_COUNT_DOWNLOAD')) DEFINE ('_DOWN_SUBS_COUNT_DOWNLOAD', 'Calculer les téléchargements d´une catégorie spécifique');
if (!defined('_DOWN_SUBS_COUNT_UPLOAD')) DEFINE ('_DOWN_SUBS_COUNT_UPLOAD', 'Calculer les envois d´une catégorie spécifique');
if (!defined('_DOWN_SUBS_COUNT_DOWNLOAD_PLUS')) DEFINE ('_DOWN_SUBS_COUNT_DOWNLOAD_PLUS', 'Calculer les téléchargements d´une catégorie et ses sous-catégories');
if (!defined('_DOWN_SUBS_COUNT_UPLOAD_PLUS')) DEFINE ('_DOWN_SUBS_COUNT_UPLOAD_PLUS', 'Calculer les envois d´une catégorie et ses sous-catégories');
if (!defined('_DOWN_COUNT_DOWN')) DEFINE ('_DOWN_COUNT_DOWN', 'Utilisateur ayant droit d´effectuer les calculs de téléchargement');
if (!defined('_DOWN_COUNT_DOWN_CHILD')) DEFINE ('_DOWN_COUNT_DOWN_CHILD', 'Inclure les sous-catégories dans les calculs de téléchargement');
if (!defined('_DOWN_COUNT_UP')) DEFINE ('_DOWN_COUNT_UP', 'Utilisateur ayant droit d´effectuer les calculs d´envoi');
if (!defined('_DOWN_COUNT_UP_CHILD')) DEFINE ('_DOWN_COUNT_UP_CHILD', 'Inclure les sous-catégories dans les calculs d´envoi');
if (!defined('_DOWN_CONFIG54')) DEFINE ('_DOWN_CONFIG54', '<b>Affichage des statistiques</b><br />Restreindre l´affichage des statistiques aux administrateurs déclarés');
if (!defined('_DOWN_CONFIG53')) DEFINE ('_DOWN_CONFIG53', '<b>Afficher les statistiques</b><br />Afficher les statistiques des fichiers et des dossiers');
if (!defined('_DOWN_CONFIG52')) DEFINE ('_DOWN_CONFIG52', '<b>Afficher le pied de page</b><br />Afficher le pied de page contenant la recherche, le lien d´envoi et la signature (crédit)');
if (!defined('_DOWN_CONFIG51')) DEFINE ('_DOWN_CONFIG51', '<b>Détails des fichiers</b><br />Afficher le lien sur les détails dans la liste des fichiers');
if (!defined('_DOWN_IS_ACTIVE')) DEFINE ('_DOWN_IS_ACTIVE', 'Activer ?');
if (!defined('_DOWN_NEW_REPOSITORY')) DEFINE ('_DOWN_NEW_REPOSITORY', 'Créer un nouvel élément comme le présent');
if (!defined('_DOWN_REPOSITORY_NAME')) DEFINE ('_DOWN_REPOSITORY_NAME', 'Nom');
if (!defined('_DOWN_REPOSITORY_NUMBER')) DEFINE ('_DOWN_REPOSITORY_NUMBER', 'Numéro');
if (!defined('_DOWN_REPOSITORY_ALIAS')) DEFINE ('_DOWN_REPOSITORY_ALIAS', 'Alias');
// Recent additions 3.46
if (!defined('_DOWN_SUBTITLE')) DEFINE ('_DOWN_SUBTITLE', 'Alias pour SEF&nbsp;:');
if (!defined('_DOWN_PUBLISHER_ID')) DEFINE ('_DOWN_PUBLISHER_ID', 'ID de publication&nbsp;:');
if (!defined('_DOWN_PUBLISHED_DATE')) DEFINE ('_DOWN_PUBLISHED_DATE', 'Date de publication&nbsp;:');
if (!defined('_DOWN_ALIAS')) DEFINE ('_DOWN_ALIAS', 'Alias');
if (!defined('_DOWN_BOTH')) DEFINE ('_DOWN_BOTH', 'Racine');
if (!defined('_DOWN_CONFIG50')) DEFINE ('_DOWN_CONFIG50', '<strong>Utiliser la Navigation de Remository</strong><br />"Fil de navigation" (Pathway) permettant de suivre le parcours dans les catégories');
if (!defined('_DOWN_SEARCHING_BY')) DEFINE ('_DOWN_SEARCHING_BY', 'Rechercher par');
if (!defined('_DOWN_FILTERING_BY')) DEFINE ('_DOWN_FILTERING_BY', 'Filtrer par');
if (!defined('_DOWN_REMOVE_TERM')) DEFINE ('_DOWN_REMOVE_TERM', 'supprimer terme');
if (!defined('_DOWN_NO_FILTERS')) DEFINE ('_DOWN_NO_FILTERS', 'Aucun filtre - Tous les contenus affichés');
if (!defined('_DOWN_REVIEW_TAGS')) DEFINE ('_DOWN_REVIEW_TAGS', 'Liste des tags dans ce groupe');
if (!defined('_DOWN_NO_RESULTS_1')) DEFINE ('_DOWN_NO_RESULTS_1', 'Votre recherche ne retourne aucun résultat');
if (!defined('_DOWN_NO_RESULTS_2')) DEFINE ('_DOWN_NO_RESULTS_2', 'Vous ne trouvez pas ce que vous recherchez ?');
if (!defined('_DOWN_CONTACT_US')) DEFINE ('_DOWN_CONTACT_US', 'Contactez-nous pour une demande particulière');
if (!defined('_DOWN_ALL_CATS_RETRY')) DEFINE ('_DOWN_ALL_CATS_RETRY', 'Réessayez cette recherche avec toutes les catégories choisies?');
if (!defined('_DOWN_ADD_ALL_CATS')) DEFINE ('_DOWN_ADD_ALL_CATS', 'Ajouter toutes les catégories');
if (!defined('_DOWN_CONFIG49')) DEFINE ('_DOWN_CONFIG49', '<strong>Types de classification</strong><br />Séparer les noms par une virgule ,');

// Recent additions 3.45
if (!defined('_DOWN_GROUP_NO_NAME')) DEFINE ('_DOWN_GROUP_NO_NAME', 'Impossible de sauver le groupe ! - Veuillez lui donner un nom.');
if (!defined('_DOWN_GROUP_SAVED')) DEFINE ('_DOWN_GROUP_SAVED', 'Le groupe a été sauvé avec succès !');
if (!defined('_DOWN_CONFIG48')) DEFINE ('_DOWN_CONFIG48', '<strong>Afficher le flux RSS</strong><br />Afficher ou masquer le lien du Flux RSS');
if (!defined('_DOWN_CONFIG46')) DEFINE ('_DOWN_CONFIG46', '<strong>Affichage par extension</strong><br/>Liste des extensions qui sont visibles en téléchargement (séparés par une virgule)');
if (!defined('_DOWN_DISPLAY_NOW')) DEFINE ('_DOWN_DISPLAY_NOW', 'Afficher le fichier');
if (!defined('_DOWN_CONFIG47')) DEFINE ('_DOWN_CONFIG47', '<strong>Code d´enregistrement Scribd</strong><br />Permet d´afficher les extensions selon des ordres spécifiques');
if (!defined('')) DEFINE ('', '');
// Recent addition 3.44.1
if (!defined('_DOWN_AEC_REFUSED')) DEFINE ('_DOWN_AEC_REFUSED', 'Notre sytème indique que votre crédit de téléchargement est epuisé');
// Recent additions 3.44
if (!defined('_DOWN_FIELD')) DEFINE ('_DOWN_FIELD', 'Champ');
if (!defined('_DOWN_SEQUENCE')) DEFINE ('_DOWN_SEQUENCE', 'Ordre');
if (!defined('_DOWN_CONFIG_EXPLAIN_1')) DEFINE ('_DOWN_CONFIG_EXPLAIN_1', 'A = Éléments affichés dans la liste des fichiers');
if (!defined('_DOWN_CONFIG_EXPLAIN_2')) DEFINE ('_DOWN_CONFIG_EXPLAIN_2', 'B = Éléments affichés dans le résultat de la recherche');
if (!defined('_DOWN_CONFIG_EXPLAIN_3')) DEFINE ('_DOWN_CONFIG_EXPLAIN_3', 'C = Éléments affichés dans la liste des fichiers soumis');
// Recent additions 3.43:
if (!defined('_DOWN_ADDFILE_THUMBNAIL')) DEFINE ('_DOWN_ADDFILE_THUMBNAIL', 'Vignette %u (optionnel):');
if (!defined('_DOWN_CONFIG45')) DEFINE("_DOWN_CONFIG45","Licence par défaut</b> (Optionnel)<p><br />Le texte ci-contre sera affiché pour tous les fichiers n´ayant pas de licence spécifique</p>");
if (!defined('_DOWN_CONFIG_TITLE_LICENCE')) DEFINE('_DOWN_CONFIG_TITLE_LICENCE', 'Licence');
if (!defined('_DOWN_VISIT')) DEFINE('_DOWN_VISIT','Parcourir');
if (!defined('_DOWN_EDIT')) DEFINE('_DOWN_EDIT','Editer');
if (!defined('_DOWN_STRUCT_RECURSE_ALL')) DEFINE('_DOWN_STRUCT_RECURSE_ALL','Inclure les sous-dossiers et leurs fichiers');
if (!defined('_DOWN_STRUCT_RECURSE_DIR')) DEFINE('_DOWN_STRUCT_RECURSE_DIR','Inclure uniquement les dossiers de niveau supérieur et leurs fichiers');
if (!defined('_DOWN_STRUCT_RECURSE_NONE')) DEFINE('_DOWN_STRUCT_RECURSE_NONE','Inclure uniquement les fichiers de niveau supérieur');
if (!defined('_DOWN_STRUCT_NO_DIR')) DEFINE ('_DOWN_STRUCT_NO_DIR', 'Le répertoire spécifié n´existe pas');
if (!defined('_DOWN_ADMINISTRATOR')) DEFINE ('_DOWN_ADMINISTRATOR', 'Administrateur');
// Recent modifications 3.43:
if (!defined('_DOWN_ADMIN_ACT_ADDSTRUCTURE')) DEFINE('_DOWN_ADMIN_ACT_ADDSTRUCTURE','Ajouter depuis le serveur');
if (!defined('_DOWN_STRUCTURE_ADDED')) DEFINE('_DOWN_STRUCTURE_ADDED','Structure supplémentaire de Repository');
if (!defined('_DOWN_ADDSTRUCTURE_TITLE')) DEFINE('_DOWN_ADDSTRUCTURE_TITLE','- Ajoutez des fichiers depuis le serveur');
//
if (!defined('_REM_INTERNAL')) DEFINE('_REM_INTERNAL','Erreur interne de Remository');
if (!defined('_DOWNLOADS_TITLE')) DEFINE("_DOWNLOADS_TITLE","Téléchargement");
if (!defined('_UP_FILE')) DEFINE('_UP_FILE','Transférer un fichier');
if (!defined('_ADD_FILE_BUTTON')) DEFINE('_ADD_FILE_BUTTON','Ajouter un fichier');
if (!defined('_SUBMIT_FILE_BUTTON')) DEFINE('_SUBMIT_FILE_BUTTON','Envoyer un fichier');
if (!defined('_DOWN_ROLE_REGISTERED')) DEFINE('_DOWN_ROLE_REGISTERED','Membres');
if (!defined('_DOWN_ROLE_VISITOR')) DEFINE('_DOWN_ROLE_VISITOR','Visiteurs');
if (!defined('_DOWN_ROLE_NOBODY')) DEFINE('_DOWN_ROLE_NOBODY','Aucun');
if (!defined('_DOWN_ROLE_NONE_THESE')) DEFINE('_DOWN_ROLE_NONE_THESE','Groupe');
if (!defined('_DOWN_PAGE_TEXT')) DEFINE ('_DOWN_PAGE_TEXT', 'Page');
if (!defined('_DOWN_PAGE_SHOW_RESULTS')) DEFINE('_DOWN_PAGE_SHOW_RESULTS','Afficher les résultats ');
if (!defined('_DOWN_PAGE_SHOW_RANGE')) DEFINE('_DOWN_PAGE_SHOW_RANGE','%s à %s sur %s');
if (!defined('_SUBMIT_FILE_NOLOG')) DEFINE('_SUBMIT_FILE_NOLOG', 'Envoi de fichiers réservé aux membres');
if (!defined('_SUBMIT_FILE_NOUSER')) DEFINE('_SUBMIT_FILE_NOUSER', 'Réservé aux admins');
if (!defined('_SUBMIT_FILE_NOLIMIT')) DEFINE('_SUBMIT_FILE_NOLIMIT', 'Envoi du fichier refusé - limite atteinte');
if (!defined('_SUBMIT_FILE_NOSPACE')) DEFINE('_SUBMIT_FILE_NOSPACE', 'Envoi du fichier refusé - plus d´espace libre');
if (!defined('_SUBMIT_NO_DDIR')) DEFINE('_SUBMIT_NO_DDIR', 'Envoi du fichier refusé - répertoire download inexistant');
if (!defined('_SUBMIT_NO_UDDIR')) DEFINE('_SUBMIT_NO_UDDIR', 'Envoi du fichier refusé - répertoire down-up inexistant');
if (!defined('_SUBMIT_HEADING')) DEFINE('_SUBMIT_HEADING', 'Envoyer un fichier dans le gestionnaire de fichiers');
if (!defined('_SUBMIT_INSTRUCT1')) DEFINE('_SUBMIT_INSTRUCT1', 'Sélectionner le fichier à envoyer depuis votre ordinateur.');
if (!defined('_SUBMIT_INSTRUCT2')) DEFINE('_SUBMIT_INSTRUCT2', 'Si le fichier est stocké sur un autre serveur, saisissez l´URL du fichier, la date et sa taille.');
if (!defined('_SUBMIT_INSTRUCT3')) DEFINE('_SUBMIT_INSTRUCT3', 'Veuillez choisir le fichier à soumettre et renseigner les détails correspondant.');
if (!defined('_DOWN_FILE_SUBMIT_NOCHOICES')) DEFINE('_DOWN_FILE_SUBMIT_NOCHOICES','<p><b>Vous ne possédez pas les droits pour envoyer des fichiers.</b></p><p>Vous devez créer un compte ou contacter l´administrateur du site.</p>');
if (!defined('_SUBMIT_NEW_FILE')) DEFINE('_SUBMIT_NEW_FILE', 'Nouveau fichier&nbsp;:');
if (!defined('_SUBMIT_UPLOAD_BUTTON')) DEFINE('_SUBMIT_UPLOAD_BUTTON', 'Transférer le fichier et stocker');
if (!defined('_MAIN_DOWNLOADS')) DEFINE('_MAIN_DOWNLOADS','Index');
if (!defined('_BACK_CAT')) DEFINE('_BACK_CAT','Retour à la catégorie parente');
if (!defined('_BACK_FOLDER')) DEFINE('_BACK_FOLDER','Retour à la catégorie parente');
if (!defined('_DOWN_START')) DEFINE('_DOWN_START','Le transfert va commencer dans 2 secondes');
if (!defined('_DOWN_CLICK')) DEFINE('_DOWN_CLICK','Cliquer ici s´il ne commence pas automatiquement');
if (!defined('_INVALID_ID')) DEFINE('_INVALID_ID','ID invalide');
if (!defined('_DOWN_CATEGORY')) DEFINE('_DOWN_CATEGORY','Catégorie');
if (!defined('_DOWN_NO_PARENT')) DEFINE('_DOWN_NO_PARENT','Racine **');
if (!defined('_DOWN_FOLDER')) DEFINE('_DOWN_FOLDER','Dossier');
if (!defined('_DOWN_FOLDERS')) DEFINE('_DOWN_FOLDERS','Dossiers');
if (!defined('_DOWN_FILES')) DEFINE('_DOWN_FILES','- Fichiers');
if (!defined('_DOWN_FOLDERS_FILES')) DEFINE('_DOWN_FOLDERS_FILES','Dossiers/Fichiers');
if (!defined('_DOWN_NO_CATS')) DEFINE("_DOWN_NO_CATS","Le gestionnaire de fichier n´est pas encore configuré sur $mosConfig_sitename.<br/>&nbsp;<br/>Aucune catégorie définie.");
if (!defined('_DOWN_NO_VISITOR_CATS')) DEFINE('_DOWN_NO_VISITOR_CATS','Vous devez vous connecter pour accéder aux téléchargements');
if (!defined('_DOWN_ADMIN_FUNC')) DEFINE('_DOWN_ADMIN_FUNC','Fonctions Admin:');
if (!defined('_DOWN_ADD_CAT')) DEFINE('_DOWN_ADD_CAT','Créer une catégorie');
if (!defined('_DOWN_DEL_CAT')) DEFINE('_DOWN_DEL_CAT','Supprimer une catégorie');
if (!defined('_DOWN_EDIT_CAT')) DEFINE('_DOWN_EDIT_CAT','Editer la catégorie');
if (!defined('_DOWN_UP_NEITHER')) DEFINE('_DOWN_UP_NEITHER','Aucun');
if (!defined('_DOWN_UP_DOWNLOAD_ONLY')) DEFINE('_DOWN_UP_DOWNLOAD_ONLY','Uniquement le téléchargement');
if (!defined('_DOWN_UP_UPLOAD_ONLY')) DEFINE('_DOWN_UP_UPLOAD_ONLY','Uniquement l´envoi');
if (!defined('_DOWN_UP_BOTH')) DEFINE('_DOWN_UP_BOTH','Racine');
if (!defined('_DOWN_USERS_PERMITTED')) DEFINE('_DOWN_USERS_PERMITTED','Membres autorisés à:');
if (!defined('_DOWN_VISITORS_PERMITTED')) DEFINE('_DOWN_VISITORS_PERMITTED','Visiteurs autorisés à:');
if (!defined('_DOWN_UP_ABSOLUTE_PATH')) DEFINE('_DOWN_UP_ABSOLUTE_PATH','Chemin absolu du dossier (personnalisable)&nbsp;:');
if (!defined('_DOWN_ADD_FOLDER')) DEFINE('_DOWN_ADD_FOLDER','Créer un Dossier');
if (!defined('_DOWN_DEL_FOLDER')) DEFINE('_DOWN_DEL_FOLDER','Supprimer un Dossier');
if (!defined('_DOWN_EDIT_FOLDER')) DEFINE('_DOWN_EDIT_FOLDER','Editer un Dossier');
if (!defined('_DOWN_ADD_FILE')) DEFINE('_DOWN_ADD_FILE','Ajouter un Fichier');
if (!defined('_DOWN_DEL_FILE')) DEFINE('_DOWN_DEL_FILE','Supprimer un Fichier');
if (!defined('_DOWN_EDIT_FILE')) DEFINE('_DOWN_EDIT_FILE','Editer un Fichier');
if (!defined('_DOWN_PUB')) DEFINE('_DOWN_PUB','Publié&nbsp;:');
if (!defined('_DOWN_SUBMIT_ANOTHER')) DEFINE('_DOWN_SUBMIT_ANOTHER','Envoyer un autre fichier?');
if (!defined('_DOWN_SUBMIT_INSPECT')) DEFINE('_DOWN_SUBMIT_INSPECT','Voir le fichier envoyé?');
if (!defined('_YES')) DEFINE('_YES','Oui');
if (!defined('_NO')) DEFINE('_NO','Non');
if (!defined('_GLOBAL')) DEFINE('_GLOBAL','Global');
if (!defined('_DOWN_DESC')) DEFINE('_DOWN_DESC','Description&nbsp;:');
if (!defined('_DOWN_DOWNLOADS')) DEFINE('_DOWN_DOWNLOADS','Téléchargements&nbsp;:');
if (!defined('_DOWN_THUMBNAILS')) DEFINE('_DOWN_THUMBNAILS','Vignettes&nbsp;:');
if (!defined('_DOWN_RATING')) DEFINE('_DOWN_RATING','Evaluation&nbsp;:');
if (!defined('_DOWN_VOTES')) DEFINE('_DOWN_VOTES','Total des Votes&nbsp;:&nbsp;');
if (!defined('_DOWN_YOUR_VOTE')) DEFINE('_DOWN_YOUR_VOTE','Votre Vote&nbsp;:&nbsp;');
if (!defined('_DOWN_RATE_BUTTON')) DEFINE('_DOWN_RATE_BUTTON','Voter');
if (!defined('_DOWN_ALREADY_VOTE')) DEFINE('_DOWN_ALREADY_VOTE','Vous avez déjà voté pour ce fichier. Merci.');
if (!defined('_DOWN_FILE_TITLE')) DEFINE('_DOWN_FILE_TITLE','Nom du Fichier&nbsp;:');
if (!defined('_DOWN_FILE_TITLE_SORT')) DEFINE('_DOWN_FILE_TITLE_SORT','Nom du Fichier');
if (!defined('_DOWN_REAL_NAME')) DEFINE('_DOWN_REAL_NAME','Nom physique du Fichier&nbsp;:');
if (!defined('_DOWNLOAD')) DEFINE('_DOWNLOAD','Télécharger');
if (!defined('_DOWN_DOWNLOADS_SORT')) DEFINE('_DOWN_DOWNLOADS_SORT','Téléchargements');
if (!defined('_DOWN_SUB_BY')) DEFINE('_DOWN_SUB_BY','Envoyé par&nbsp;:');
if (!defined('_DOWN_FILE_DATE')) DEFINE('_DOWN_FILE_DATE','Date&nbsp;:');
if (!defined('_DOWN_FILE_AUTHOR')) DEFINE('_DOWN_FILE_AUTHOR','Auteur&nbsp;:');
if (!defined('_DOWN_FILE_VER')) DEFINE('_DOWN_FILE_VER','Version&nbsp;:');
if (!defined('_DOWN_FILE_SIZE')) DEFINE('_DOWN_FILE_SIZE','Taille&nbsp;:');
if (!defined('_DOWN_FILE_TYPE')) DEFINE('_DOWN_FILE_TYPE','Type&nbsp;:');
if (!defined('_DOWN_FILE_COMPANY')) DEFINE('_DOWN_FILE_COMPANY','Société&nbsp;:');
if (!defined('_DOWN_FILE_COMPANY_URL')) DEFINE('_DOWN_FILE_COMPANY_URL','Site Internet de la Société&nbsp;:');
if (!defined('_DOWN_FILE_AUTHOR_URL')) DEFINE('_DOWN_FILE_AUTHOR_URL','Site Internet de l´auteur&nbsp;:');
if (!defined('_DOWN_FILE_RELEASE_DATE')) DEFINE('_DOWN_FILE_RELEASE_DATE','Mise à jour le (DD-MM-YYYY)&nbsp;:');
if (!defined('_DOWN_FILE_STATUS')) DEFINE('_DOWN_FILE_STATUS','Statuts&nbsp;:');
if (!defined('_DOWN_FILE_LANGUAGES')) DEFINE('_DOWN_FILE_LANGUAGES','Langues&nbsp;:');
if (!defined('_DOWN_FILE_REQUIREMENTS')) DEFINE('_DOWN_FILE_REQUIREMENTS','Nécessite&nbsp;:');
if (!defined('_DOWN_FILE_OPERATING_SYSTEM')) DEFINE('_DOWN_FILE_OPERATING_SYSTEM','Système utilisé&nbsp;:');
if (!defined('_DOWN_SCREEN')) DEFINE('_DOWN_SCREEN',' Fichier image pour la miniature&nbsp;:');
if (!defined('_DOWN_SCREEN_CLICK')) DEFINE('_DOWN_SCREEN_CLICK','Cliquer pour voir l´aperçu');
if (!defined('_DOWN_NA')) DEFINE('_DOWN_NA','N/A');
if (!defined('_DOWN_CAT_NAME')) DEFINE('_DOWN_CAT_NAME','Nom de la Catégorie&nbsp;:');
if (!defined('_DOWN_SUB_BUTTON')) DEFINE('_DOWN_SUB_BUTTON','Envoyer');
if (!defined('_DOWN_ALL_DONE')) DEFINE('_DOWN_ALL_DONE','Terminé!');
if (!defined('_DOWN_NOT_AUTH')) DEFINE('_DOWN_NOT_AUTH','Envoi non permis!');
if (!defined('_DOWN_FOLDER_NAME')) DEFINE('_DOWN_FOLDER_NAME','Nom de la catégorie&nbsp;:');
if (!defined('_DOWN_FOLDER_ADD_BUT')) DEFINE('_DOWN_FOLDER_ADD_BUT','Créer une catégorie');
if (!defined('_DOWN_UP_WAIT')) DEFINE('_DOWN_UP_WAIT','Note: Tous les fichiers transférés seront vérifiés avant d´être publiés.');
if (!defined('_DOWN_AUTOAPP')) DEFINE('_DOWN_AUTOAPP','Votre fichier a été automatiquement approuvé et publié.');
if (!defined('_DOWN_APPROVE_PUB')) DEFINE('_DOWN_APPROVE_PUB','Approuver + publier');
if (!defined('_DOWN_SUGGEST_LOC')) DEFINE('_DOWN_SUGGEST_LOC','Stocker dans&nbsp;:');
if (!defined('_DOWNLOAD_URL')) DEFINE('_DOWNLOAD_URL','URL du fichier&nbsp;:');
if (!defined('_DOWN_ICON')) DEFINE('_DOWN_ICON','Icône&nbsp;:');
if (!defined('_DOWN_MOVE_FILE')) DEFINE('_DOWN_MOVE_FILE','Déplacer le fichier&nbsp;:');
if (!defined('_DOWN_MOVE_FILE_FAILED')) DEFINE('_DOWN_MOVE_FILE_FAILED','Déplacement de fichier échoué');
if (!defined('_DOWN_FILE_NEW_LOC')) DEFINE('_DOWN_FILE_NEW_LOC','Nouvel emplacement pour le fichier&nbsp;:');
if (!defined('_DOWN_AWAIT_APPROVE')) DEFINE('_DOWN_AWAIT_APPROVE','Fichiers envoyés en attente d´approbation&nbsp;:');
if (!defined('_DOWN_ADMIN_APPROVE')) DEFINE('_DOWN_ADMIN_APPROVE','Approuver les fichiers envoyés');
if (!defined('_DOWN_ID')) DEFINE('_DOWN_ID','ID');
if (!defined('_DOWN_SUBMIT_DATE')) DEFINE('_DOWN_SUBMIT_DATE','Date d´envoi&nbsp;:');
if (!defined('_DOWN_APP_SUB_BUTTON')) DEFINE('_DOWN_APP_SUB_BUTTON','Approuver le fichier envoyé');
if (!defined('_DOWN_DEL_SUB_BUTTON')) DEFINE('_DOWN_DEL_SUB_BUTTON','Supprimer le fichier');
if (!defined('_DOWN_SUB_APPROVE')) DEFINE('_DOWN_SUB_APPROVE','Le fichier envoyé a été approuvé.');
if (!defined('_DOWN_SUB_DEL')) DEFINE('_DOWN_SUB_DEL','Le fichier a été supprimé.');
if (!defined('_DOWN_NO_SUB')) DEFINE('_DOWN_NO_SUB','Plus aucun fichier envoyé à approuver.');
if (!defined('_DOWN_REV_SUB')) DEFINE('_DOWN_REV_SUB','Vérifier d´autres fichiers envoyés');
if (!defined('_DOWN_SEARCH')) DEFINE('_DOWN_SEARCH','Rechercher un fichier');
if (!defined('_DOWN_SEARCH_TEXT')) DEFINE('_DOWN_SEARCH_TEXT','Rechercher&nbsp;:');
if (!defined('_DOWN_SEARCH_FILETITLE')) DEFINE('_DOWN_SEARCH_FILETITLE','Rechercher par Titre de fichier&nbsp;:');
if (!defined('_DOWN_SEARCH_FILEDESC')) DEFINE('_DOWN_SEARCH_FILEDESC','Rechercher par Description de fichier&nbsp;:');
if (!defined('_DOWN_SEARCH_ERR')) DEFINE('_DOWN_SEARCH_ERR','Vous devez spécifier soit un Titre soit une Description de fichier pour effectuer votre recherche.');
if (!defined('_DOWN_SEARCH_NORES')) DEFINE('_DOWN_SEARCH_NORES','Aucun fichier trouvé.');
if (!defined('_DOWN_FILE_HOMEPAGE')) DEFINE('_DOWN_FILE_HOMEPAGE','Site web&nbsp;:');
if (!defined('_DOWN_UPDATE_SUB')) DEFINE('_DOWN_UPDATE_SUB','Modifier / Mettre à jour');
if (!defined('_DOWN_UP_EDIT_ID')) DEFINE('_DOWN_UP_EDIT_ID','FileID&nbsp;:');
if (!defined('_DOWN_FILE_DEL_NOTE')) DEFINE('_DOWN_FILE_DEL_NOTE','Note: L\ancien fichier a peut-être été supprimé de la base, mais il est <b>possible</b> que le fichier physique existe encore.');
if (!defined('_DOWN_SUB_DATE')) DEFINE('_DOWN_SUB_DATE','Envoyé le&nbsp;:');
if (!defined('_DOWN_SUB_DATE_SORT')) DEFINE('_DOWN_SUB_DATE_SORT','Date');
if (!defined('_DOWN_SUB_ID_SORT')) DEFINE ('_DOWN_SUB_ID_SORT', 'Expéditeur');
if (!defined('_DOWN_COMMENTS')) DEFINE('_DOWN_COMMENTS','Commentaires&nbsp;:');
if (!defined('_DOWN_YOUR_COMM')) DEFINE('_DOWN_YOUR_COMM','Votre Commentaire&nbsp;:');
if (!defined('_DOWN_LEAVE_COMM')) DEFINE('_DOWN_LEAVE_COMM','Envoyer');
if (!defined('_DOWN_FIRST_COMMENT')) DEFINE('_DOWN_FIRST_COMMENT','Soyez le premier à écrire un commentaire sur ce fichier!');
if (!defined('_DOWN_FIRST_COMMENT_NL')) DEFINE('_DOWN_FIRST_COMMENT_NL','Soyez le premier à écrire un commentaire sur ce fichier!<br />Veuillez vous identifier ou vous enregistrer.');
if (!defined('_DOWN_ALREADY_COMM')) DEFINE('_DOWN_ALREADY_COMM','Vous avez déjà commenté ce fichier.');
if (!defined('_DOWN_MAX_COMM')) DEFINE("_DOWN_MAX_COMM","<span style='font-style: normal; font-size:90%;line-height:100%'>Max: $Small_Text_Len Caractères</span>");
if (!defined('_DOWN_DESC_MAX')) DEFINE("_DOWN_DESC_MAX","Max: $Large_Text_Len Caractères");
if (!defined('_DOWN_MAIL_SUB')) DEFINE('_DOWN_MAIL_SUB','Fichier soumis dans le gestionnaire de fichiers Remository');
if (!defined('_DOWN_ORDER_BY')) DEFINE('_DOWN_ORDER_BY','Trier par&nbsp;:');
if (!defined('_DOWN_RESET')) DEFINE('_DOWN_RESET','Recalculer le nombre de Fichiers');
if (!defined('_DOWN_RESET_GO')) DEFINE('_DOWN_RESET_GO','Recalcul du nombre de Fichiers en cours...');
if (!defined('_DOWN_RESET_DONE')) DEFINE('_DOWN_RESET_DONE','Recalcul du nombre de Fichiers terminé');
if (!defined('_DOWN_FIND_ORPHANS')) DEFINE('_DOWN_FIND_ORPHANS','Trouver les fichiers orphelins');
if (!defined('_DOWN_DEL_ORPHANS')) DEFINE('_DOWN_DEL_ORPHANS','Supprimer les fichiers orphelins');
if (!defined('_DOWN_ORPHAN_SELECT')) DEFINE('_DOWN_ORPHAN_SELECT','Sélectionner');
if (!defined('_DOWN_ORPHAN_FILE_DEL')) DEFINE('_DOWN_ORPHAN_FILE_DEL','Fichier à supprimer');
if (!defined('_DOWN_ORPHAN_NODEL')) DEFINE('_DOWN_ORPHAN_NODEL','Aucun Fichier à supprimer');
if (!defined('_DOWN_ORPHAN_DONE')) DEFINE('_DOWN_ORPHAN_DONE','Fichiers Orphelins supprimés');
if (!defined('_DOWN_BAD_POST')) DEFINE('_DOWN_BAD_POST','Les paramètres n´ont pas été correctement envoyés depuis le formulaire.');
if (!defined('_DOWN_SUB_WAIT')) DEFINE('_DOWN_SUB_WAIT','Une mise à jour de fichier envoyé est déjà en attente d´approbation pour ce fichier.');
if (!defined('_DOWN_REG_ONLY')) DEFINE('_DOWN_REG_ONLY','Utilisateurs enregistrés seulement&nbsp;:');
if (!defined('_DOWN_RESTRICTED_WARN')) DEFINE('_DOWN_RESTRICTED_WARN','Désolé, cet élément est inexistant ou indisponible');
if (!defined('_DOWN_MEMBER_ONLY_WARN')) DEFINE('_DOWN_MEMBER_ONLY_WARN',"Cet emplacement est reservé à un groupe spécifique de membres.<BR />"
                             ."Veuillez contacter l´administrateur si vous souhaitez en faire partie");
if (!defined('_DOWN_REG_ONLY_WARN')) DEFINE("_DOWN_REG_ONLY_WARN","Cet emplacement est réservé aux utilisateurs enregistrés.<BR />" 
                             ."Veuillez vous identifier ou vous <a href='index.php?option=com_user&task=register'>enregistrer</a>.");
if (!defined('_DOWN_COUNT_EXCEEDED')) DEFINE('_DOWN_COUNT_EXCEEDED',"Désolé, vous avez atteint votre limite de téléchargement autorisé");
if (!defined('_DOWN_COUNT_EXCEEDED_FILE')) DEFINE('_DOWN_COUNT_EXCEEDED_FILE',"Désolé, vous avez atteint votre limite de téléchargement autorisé pour ce dossier");
if (!defined('_DOWN_NO_FILEN')) DEFINE('_DOWN_NO_FILEN','Veuillez saisir un nom de fichier');
if (!defined('_DOWN_MINI_SCREEN_PROMPT')) DEFINE('_DOWN_MINI_SCREEN_PROMPT','Afficher une miniature dans la liste des fichiers&nbsp;:');
if (!defined('_DOWN_SEL_LOC_PROMPT')) DEFINE('_DOWN_SEL_LOC_PROMPT','Sélectionner un emplacement');
if (!defined('_DOWN_ALL_LOC_PROMPT')) DEFINE('_DOWN_ALL_LOC_PROMPT','Tous les emplacements');
if (!defined('_DOWN_SEL_CAT_DEL')) DEFINE('_DOWN_SEL_CAT_DEL','Sélectionner la catégorie à supprimer');
if (!defined('_DOWN_NO_CAT_DEF')) DEFINE('_DOWN_NO_CAT_DEF','Aucune catégorie définie');
if (!defined('_DOWN_PUB_PROMPT')) DEFINE('_DOWN_PUB_PROMPT','Sélectionner une catégorie pour ');
if (!defined('_DOWN_SEL_FILE_DEL')) DEFINE('_DOWN_SEL_FILE_DEL','Sélectionner un fichier à supprimer');
if (!defined('_DOWN_CONFIG_COMP')) DEFINE('_DOWN_CONFIG_COMP','Les détails de la configuration ont été mis à jour!');
if (!defined('_DOWN_CONFIG_ERR')) DEFINE("_DOWN_CONFIG_ERR","Une erreur s´est produite!\nImpossible d\écrire dans le fichier de configuration!");
if (!defined('_DOWN_CATS')) DEFINE('_DOWN_CATS','Catégories');
if (!defined('_DOWN_PARENT_CAT')) DEFINE('_DOWN_PARENT_CAT','Catégorie principale');
if (!defined('_DOWN_PARENT_FOLDER')) DEFINE('_DOWN_PARENT_FOLDER','Catégorie parente');
if (!defined('_DOWN_PUB1')) DEFINE('_DOWN_PUB1','Publié');
if (!defined('_DOWN_RECORDS')) DEFINE('_DOWN_RECORDS','Fichier(s)');
if (!defined('_DOWN_ACCESS')) DEFINE('_DOWN_ACCESS','Accès');
if (!defined('_DOWN_GROUP')) DEFINE('_DOWN_GROUP','Groupe');
if (!defined('_DOWN_FILE_SYSTEM')) DEFINE('_DOWN_FILE_SYSTEM','Répertoire physique');
if (!defined('_DOWN_FILE_SYSTEM_OK')) DEFINE('_DOWN_FILE_SYSTEM_OK','Répertoire physique - OK');
if (!defined('_DOWN_DIRECTORY_NON_EXISTENT')) DEFINE('_DOWN_DIRECTORY_NON_EXISTENT','Attention, répertoire inexistant');
if (!defined('_DOWN_NOT_WRITEABLE')) DEFINE('_DOWN_NOT_WRITEABLE','Attention, répertoire en lecture seule');
if (!defined('_DOWN_WRITEABLE')) DEFINE('_DOWN_WRITEABLE','- Répertoire en écriture : OK');
if (!defined('_DOWN_DATABASE')) DEFINE('_DOWN_DATABASE','Base de données');
if (!defined('_DOWN_ADMIN_CPANEL_STORE')) DEFINE ('_DOWN_ADMIN_CPANEL_STORE','<span style="font-weight:normal">Stockage par défaut des nouveaux fichiers&nbsp;:</span>');
if (!defined('_DOWN_ADMIN_CPANEL_FILESTORE')) DEFINE ('_DOWN_ADMIN_CPANEL_FILESTORE','<span style="font-weight:normal">Répertoire par défaut des fichiers à télécharger&nbsp;:</span>');
if (!defined('_DOWN_ADMIN_CPANEL_UPLOADS')) DEFINE ('_DOWN_ADMIN_CPANEL_UPLOADS','<span style="font-weight:normal">Répertoire par défaut des fichiers envoyés&nbsp;:</span>');
if (!defined('_DOWN_CPANEL_RETURN')) DEFINE ('_DOWN_CPANEL_RETURN','Panneau de Contrôle');
if (!defined('_DOWN_CPANEL_SUB_BASIC')) DEFINE ('_DOWN_CPANEL_SUB_BASIC','Gestion générale');
if (!defined('_DOWN_CPANEL_SUB_FILES')) DEFINE ('_DOWN_CPANEL_SUB_FILES','Gestion des fichiers');
if (!defined('_DOWN_CPANEL_SUB_HKEEP')) DEFINE ('_DOWN_CPANEL_SUB_HKEEP','Gestion des compteurs');
if (!defined('_DOWN_CPANEL_SUB_UTILS')) DEFINE ('_DOWN_CPANEL_SUB_UTILS','Utilitaires');
if (!defined('_DOWN_CPANEL_SUB_INFO')) DEFINE ('_DOWN_CPANEL_SUB_INFO','Informations');
if (!defined('_DOWN_ADMIN_ACT_CONTAINERS')) DEFINE('_DOWN_ADMIN_ACT_CONTAINERS','Gestion des catégories');
if (!defined('_DOWN_ADMIN_ACT_FILES')) DEFINE('_DOWN_ADMIN_ACT_FILES','Gestion des fichiers');
if (!defined('_DOWN_ADMIN_ACT_GROUPS')) DEFINE('_DOWN_ADMIN_ACT_GROUPS','Gestion des groupes');
if (!defined('_DOWN_ADMIN_ACT_UPLOADS')) DEFINE('_DOWN_ADMIN_ACT_UPLOADS','Approuver les envois');
if (!defined('_DOWN_ADMIN_ACT_CONFIG')) DEFINE('_DOWN_ADMIN_ACT_CONFIG','Configuration générale');
if (!defined('_DOWN_ADMIN_ACT_UNLINKED')) DEFINE('_DOWN_ADMIN_ACT_UNLINKED','Fichiers non classés');
if (!defined('_DOWN_ADMIN_ACT_FTP')) DEFINE('_DOWN_ADMIN_ACT_FTP','Ajouter des fichiers sur le serveur');
if (!defined('_DOWN_ADMIN_ACT_MISSING')) DEFINE('_DOWN_ADMIN_ACT_MISSING','Lister les fichiers rompus');
if (!defined('_DOWN_ADMIN_ACT_COUNTS')) DEFINE('_DOWN_ADMIN_ACT_COUNTS','Recalculer les téléchargements');
if (!defined('_DOWN_ADMIN_ACT_DOWNLOADS')) DEFINE('_DOWN_ADMIN_ACT_DOWNLOADS','Réinitialiser les compteurs');
if (!defined('_DOWN_ADMIN_ACT_PRUNE')) DEFINE('_DOWN_ADMIN_ACT_PRUNE','Réinitialiser selon une date');
if (!defined('_DOWN_ADMIN_ACT_THUMBS')) DEFINE('_DOWN_ADMIN_ACT_THUMBS','Vérifier les liens des miniatures');
if (!defined('_DOWN_ADMIN_ACT_DBCONVERT')) DEFINE('_DOWN_ADMIN_ACT_DBCONVERT','Mise à jour BD depuis 3.20');
if (!defined('_DOWN_ADMIN_ACT_DBCONVERT2')) DEFINE('_DOWN_ADMIN_ACT_DBCONVERT2','Mise à jour BD depuis 3.40');
if (!defined('_DOWN_ADMIN_ACT_STATS')) DEFINE('_DOWN_ADMIN_ACT_STATS','Afficher les statistiques');
if (!defined('_DOWN_ADMIN_ACT_ABOUT')) DEFINE('_DOWN_ADMIN_ACT_ABOUT','A propos de Remository');
if (!defined('_DOWN_ADMIN_ACT_SUPPORT')) DEFINE('_DOWN_ADMIN_ACT_SUPPORT','Support et Développement');
if (!defined('_DOWN_MOST_DOWNLOADED')) DEFINE('_DOWN_MOST_DOWNLOADED','Plus téléchargé');
if (!defined('_DOWN_MOST_DOWNLOADED_LONG')) DEFINE('_DOWN_MOST_DOWNLOADED_LONG','Fichier le plus téléchargé');
if (!defined('_DOWN_POPULAR')) DEFINE ('_DOWN_POPULAR','Fichiers populaires');
if (!defined('_DOWN_POPULAR_LONG')) DEFINE ('_DOWN_POPULAR_LONG','Fichiers les plus téléchargés ces %s derniers jours');
if (!defined('_DOWN_NEWEST')) DEFINE ('_DOWN_NEWEST','Derniers fichiers');
if (!defined('_DOWN_NEWEST_LONG')) DEFINE ('_DOWN_NEWEST_LONG','Derniers fichiers soumis');
if (!defined('_DOWN_VISITORS')) DEFINE('_DOWN_VISITORS','Visiteurs');
if (!defined('_DOWN_REG_USERS')) DEFINE('_DOWN_REG_USERS','Membres');
if (!defined('_DOWN_OTHER_USERS')) DEFINE ('_DOWN_OTHER_USERS', 'Groupes');
if (!defined('_DOWN_STORAGE_STATUS')) DEFINE ('_DOWN_STORAGE_STATUS','Statut de stockage');
if (!defined('_DOWN_ALL_REGISTERED')) DEFINE('_DOWN_ALL_REGISTERED','Tous les membres');
if (!defined('_DOWN_REG_ONLY_TITLE')) DEFINE('_DOWN_REG_ONLY_TITLE','Utilisateurs Enregistrés seulement');
if (!defined('_DOWN_PUBLIC_TITLE')) DEFINE('_DOWN_PUBLIC_TITLE','Public');
if (!defined('_DOWN_APPROVE_TITLE')) DEFINE('_DOWN_APPROVE_TITLE','- Fichiers à approuver');
if (!defined('_DOWN_DATE')) DEFINE('_DOWN_DATE','Date');
if (!defined('_DOWN_NAME_TITLE')) DEFINE('_DOWN_NAME_TITLE','Nom');
if (!defined('_DOWN_CONFIG_TITLE')) DEFINE('_DOWN_CONFIG_TITLE','Configuration générale');
if (!defined('_DOWN_CONFIG_TITLE1')) DEFINE('_DOWN_CONFIG_TITLE1','Chemins et divers');
if (!defined('_DOWN_CONFIG_TITLE2')) DEFINE('_DOWN_CONFIG_TITLE2','Permissions');
if (!defined('_DOWN_CONFIG_TITLE3')) DEFINE('_DOWN_CONFIG_TITLE3','Texte de téléchargement');
if (!defined('_DOWN_CONFIG_TITLE4')) DEFINE('_DOWN_CONFIG_TITLE4','Configuration de mise en page');
if (!defined('_DOWN_CONFIG_TITLE_PREAMBLE')) DEFINE('_DOWN_CONFIG_TITLE_PREAMBLE','Intro');
if (!defined('_DOWN_CONFIG1')) DEFINE("_DOWN_CONFIG1","<b>Styles CSS des lignes d´une table</b><br/>Style CSS des couleurs alternées des lignes d´une table - Deux valeurs séparées par une virgule");
if (!defined('_DOWN_CONFIG2')) DEFINE("_DOWN_CONFIG2","<b>Styles CSS des titres</b><br/>Style CSS des titres de page et dans le panneau d´administration");
if (!defined('_DOWN_CONFIG3')) DEFINE("_DOWN_CONFIG3","URL de stockage des fichiers<br/>URL du dossier de stockage des fichiers - Pas de slash à la fin");
if (!defined('_DOWN_CONFIG4')) DEFINE("_DOWN_CONFIG4","<b>Stockage des fichiers</b><br/>Chemin de stockage des fichiers - Pas de slash / à la fin");
if (!defined('_DOWN_CONFIG5')) DEFINE("_DOWN_CONFIG5","<b>Stockage des soumissions</b><br/>Chemin de stockage des fichiers soumis par les membres en frontal du site<br />Pas de slash / à la fin");
if (!defined('_DOWN_CONFIG6')) DEFINE("_DOWN_CONFIG6","<b>Taille/Poids maximum des fichiers envoyés</b><br/>Taille maximum autorisée pour l´envoi de fichiers envoyés (en Ko).");
if (!defined('_DOWN_CONFIG7')) DEFINE("_DOWN_CONFIG7","<b>Nombre maximum d´envois par jour pour un simple utilisateur</b><br/>Nombre maximum d´envois autorisés par jour pour un simple utilisateur (pas de limite pour l'Admin)");
if (!defined('_DOWN_CONFIG8')) DEFINE("_DOWN_CONFIG8","<b>Taille du dossier d´envoi</b><br/>Taille maximum du dossier de stockage des fichiers envoyés, en Kb");
if (!defined('_DOWN_CONFIG9')) DEFINE("_DOWN_CONFIG9","<b>Extensions autorisées</b><br/>Liste des extensions de fichier autorisées d´envoi (les séparer par des virgules)");
if (!defined('_DOWN_CONFIG10')) DEFINE("_DOWN_CONFIG10","<b>Tags Description</b><br/>Tags HTML autorisés pour la description des fichierss (Liste séparée par des virgules)");
if (!defined('_DOWN_CONFIG11')) DEFINE("_DOWN_CONFIG11","<b>Remplacement de fichiers</b><br/>Autoriser les nouveaux fichiers à écraser les fichiers existants");
if (!defined('_DOWN_CONFIG12')) DEFINE("_DOWN_CONFIG12","<b>Soumission de fichiers</b><br/>Autoriser les membres à soumettre des fichiers (Doivent être approuvés par l'Administrateur)");
if (!defined('_DOWN_CONFIG13')) DEFINE("_DOWN_CONFIG13","<b>Edition des fichiers</b><br/>Autoriser les membres à éditer les fichiers qu'ils ont envoyés (Doivent être à nouveau approuvés par l'administrateur)");
if (!defined('_DOWN_CONFIG14')) DEFINE("_DOWN_CONFIG14","<b>Envoi de fichiers</b><br/>Autoriser les membres à envoyer des fichiers - Les fichiers devront être approuvés par l'Administrateur");
if (!defined('_DOWN_CONFIG15')) DEFINE("_DOWN_CONFIG15","<b>Commentaires</b><br/>Autoriser les membres à écrire des commentaires sur les fichiers");
if (!defined('_DOWN_CONFIG16')) DEFINE("_DOWN_CONFIG16","<b>Envoi d´e-mails d´ information</b><br/>Envoyer un e-mail de notification à l'administrateur ou aux adresses e-mail spécifiées quand un utilisateur envoie un nouveau fichier");
if (!defined('_DOWN_CONFIG17')) DEFINE("_DOWN_CONFIG17","<b>Adresses e-mail</b><br/>Adresses e-mail alternatives pour la notification d'envoi de fichiers. Si ce champ n'est pas rempli, l'e-mail de l'administrateur sera utilisé (separez par un point-virgule)");
if (!defined('_DOWN_CONFIG18')) DEFINE("_DOWN_CONFIG18","<b>Nom de l´expéditeur</b><br/>Nom alternatif de l'expéditeur des notifications de fichier envoyé");
if (!defined('_DOWN_CONFIG19')) DEFINE("_DOWN_CONFIG19","<b>Image d'en-tête</b><br/>Image d'en-tête de page et du panneau d'administration");
if (!defined('_DOWN_CONFIG20')) DEFINE("_DOWN_CONFIG20","<b>Anti-Leach:</b><br/>Cacher les noms de fichiers pour éviter l'accès direct aux fichiers");
if (!defined('_DOWN_CONFIG21')) DEFINE("_DOWN_CONFIG21","<b>Description longue</b><br/>Nombre maximum de caractères autorisés pour la description longue");
if (!defined('_DOWN_CONFIG22')) DEFINE("_DOWN_CONFIG22","<b>Description courte</b><br/>Nombre maximum de caractères autorisés pour la description courte");
if (!defined('_DOWN_CONFIG23')) DEFINE("_DOWN_CONFIG23","<b>Largeur de la vignette</b><br/>Largeur en pixels de la vignette de description du fichier");
if (!defined('_DOWN_CONFIG24')) DEFINE("_DOWN_CONFIG24","<b>Hauteur de la vignette</b><br/>Hauteur en pixels de la vignette de description du fichier");
if (!defined('_DOWN_CONFIG25')) DEFINE("_DOWN_CONFIG25","<b>Votes des fichiers</b><br/>Autoriser les Membres à voter pour les fichiers");
if (!defined('_DOWN_CONFIG26')) DEFINE("_DOWN_CONFIG26","<b>Approbation des envois d'un administrateur</b><br/>Approuver et publier automatiquement les fichiers envoyés par l´Administrateur");
if (!defined('_DOWN_CONFIG27')) DEFINE("_DOWN_CONFIG27","<b>Approbation des envois d'un membre</b><br/>Approuver et publier automatiquement les fichiers envoyés par les Membres");
if (!defined('_DOWN_CONFIG28')) DEFINE("_DOWN_CONFIG28","<b>Téléchargement depuis les listes</b><br/>Autoriser le téléchargement des fichiers depuis les catégories/dossiers");
if (!defined('_DOWN_CONFIG29')) DEFINE("_DOWN_CONFIG29","<b>Envoi de fichiers pour tous</b><br/>Tous les utilisateurs peuvent envoyer des fichiers (Dossier spécifique d´envoi)");
if (!defined('_DOWN_CONFIG30')) DEFINE("_DOWN_CONFIG30","<b>Nombre de favoris autorisés</b><br/>Nombre de favoris que les utilisateurs peuvent sélectionner");
if (!defined('_DOWN_CONFIG31')) DEFINE("_DOWN_CONFIG31","<b>Format de la date</b><br/>Format de la date dans Remository  (PHP date function)");
if (!defined('_DOWN_CONFIG32')) DEFINE("_DOWN_CONFIG32","<b>Version par défaut</b><br/>Valeur par défaut de la version pour les nouveaux fichiers envoyés");
if (!defined('_DOWN_CONFIG33')) DEFINE('_DOWN_CONFIG33','<b>Afficher toutes les catégories pour tous</b><br/>Les utilisateurs peuvent voir toutes les catégories, y compris celles contenant des fichiers qui leur sont interdit de télécharger');
if (!defined('_DOWN_CONFIG34')) DEFINE('_DOWN_CONFIG34','<b>Afficher tous les fichiers pour tous</b><br/>Les utilisateurs peuvent voir tous les fichiers, y compris ceux qu´ils ne peuvent télécharger');
if (!defined('_DOWN_CONFIG35')) DEFINE('_DOWN_CONFIG35','<b>Nombre de vignettes</b><br/>Nombre maximum de vignettes de description; 0 pour n´afficher que le lien');
if (!defined('_DOWN_CONFIG36')) DEFINE("_DOWN_CONFIG36","<b>Largeur de l´image grand format</b><br/>Largeur en pixels de l'image grand format (affichage en popup)");
if (!defined('_DOWN_CONFIG37')) DEFINE("_DOWN_CONFIG37","<b>Hauteur de l´image grand format</b><br/>Hauteur en pixels de l'image grand format (affichage en popup)");
if (!defined('_DOWN_CONFIG38')) DEFINE("_DOWN_CONFIG38","<b>Images grand format en popup</b><br/>Afficher les images grand format en fenêtre pop-up");
if (!defined('_DOWN_CONFIG39')) DEFINE("_DOWN_CONFIG39","<b>Fichiers dans la base de données</b><br/>Les fichiers sont stockés par encodage dans la base de données");
if (!defined('_DOWN_CONFIG40')) DEFINE("_DOWN_CONFIG40","<b>Nombre maximum de téléchargements par jour pour un simple utilisateur</b><br/>Nombre maximum de téléchargements quotidiens autorisés par utilisateur (pas de limite pour l'Admin)");
if (!defined('_DOWN_CONFIG41')) DEFINE("_DOWN_CONFIG41","<b>Nombre maximum de téléchargements d´un fichier par jour</b><br/>Nombre maximum de téléchargements quotidiens autorisés sur un fichier (pas de limite pour l'Admin)");
if (!defined('_DOWN_CONFIG42')) DEFINE("_DOWN_CONFIG42","<b>Suppression de fichiers</b><br/>Autoriser l'expediteur d'un fichier à le supprimer (l'administrateur peut supprimer tous les fichiers)");
if (!defined('_DOWN_CONFIG43')) DEFINE('_DOWN_CONFIG43','<b>Création de vignettes</b><br/>Création automatique d´une vignettes lors de l´envoi d´une image de description');
if (!defined('_DOWN_CONFIG44')) DEFINE("_DOWN_CONFIG44","<b>Nombre maximum de téléchargements par jour pour un Membre</b><br/>Nombre maximum de téléchargements quotidiens autorisés par Membre (pas de limite pour l'Admin)");
if (!defined('_DOWN_STATS_TITLE')) DEFINE('_DOWN_STATS_TITLE','- Statistiques');
if (!defined('_DOWN_TOP_TITLE')) DEFINE('_DOWN_TOP_TITLE','Top');
if (!defined('_DOWN_RATED_TITLE')) DEFINE('_DOWN_RATED_TITLE','Evaluations');
if (!defined('_DOWN_VOTED_ON')) DEFINE('_DOWN_VOTED_ON','Votes');
if (!defined('_DOWN_VOTES_TITLE')) DEFINE('_DOWN_VOTES_TITLE','Votes');
if (!defined('_DOWN_RATING_TITLE')) DEFINE('_DOWN_RATING_TITLE','Evaluation');
if (!defined('_DOWN_ABOUT')) DEFINE('_DOWN_ABOUT','- Informations');
if (!defined('_DOWN_SUPPORT')) DEFINE('_DOWN_SUPPORT','- Support et Développement');
if (!defined('_DOWN_ABOUT_DESCRIBE')) DEFINE('_DOWN_ABOUT_DESCRIBE','Remository - Joomla/Mambo OpenSource - Gestionnaire de téléchargement');
if (!defined('_DOWN_TITLE_ABOUT')) DEFINE('_DOWN_TITLE_ABOUT','Titre');
if (!defined('_DOWN_VERSION_ABOUT')) DEFINE('_DOWN_VERSION_ABOUT','Version');
if (!defined('_DOWN_AUTHOR_ABOUT')) DEFINE('_DOWN_AUTHOR_ABOUT','Auteur');
if (!defined('_DOWN_WEBSITE_ABOUT')) DEFINE('_DOWN_WEBSITE_ABOUT','Site Web');
if (!defined('_DOWN_EMAIL_ABOUT')) DEFINE('_DOWN_EMAIL_ABOUT','E-mail');
if (!defined('_DOWN_SEL_FILE_APPROVE')) DEFINE('_DOWN_SEL_FILE_APPROVE','Sélectionner un fichier à approuver');
if (!defined('_DOWN_DESC_SMALL')) DEFINE('_DOWN_DESC_SMALL','Description&nbsp;:');
if (!defined('_DOWN_DESC_SMALL_MAX')) DEFINE('_DOWN_DESC_SMALL_MAX','Max: 150 caractères');
if (!defined('_DOWN_AUTO_SHORT')) DEFINE('_DOWN_AUTO_SHORT','Autogénérer la description courte&nbsp;:');
if (!defined('_DOWN_LICENSE')) DEFINE('_DOWN_LICENSE','Licence&nbsp;:');
if (!defined('_DOWN_LICENSE_AGREE')) DEFINE('_DOWN_LICENSE_AGREE','Soumis à accord de Licence&nbsp;:');
if (!defined('_DOWN_LEECH_WARN')) DEFINE('_DOWN_LEECH_WARN','Votre session n´a pas été validée et des mesure d´anti-leach sont en vigueur.');
if (!defined('_DOWN_LICENSE_WARN')) DEFINE('_DOWN_LICENSE_WARN','Veuillez lire et accepter la licence avant de procéder au téléchargement.');
if (!defined('_DOWN_LICENSE_CHECKBOX')) DEFINE('_DOWN_LICENSE_CHECKBOX','J´accepte les termes ci-dessous.');
if (!defined('_DOWN_DATE_FORMAT')) DEFINE("_DOWN_DATE_FORMAT","%d %B %Y"); //Uses PHP's strftime Command Format
if (!defined('_DOWN_FILE_NOTFOUND')) DEFINE('_DOWN_FILE_NOTFOUND','Fichier Non Trouvé');
if (!defined('_DOWN_ACCESS_GROUP')) DEFINE('_DOWN_ACCESS_GROUP','Groupe autorisé&nbsp;:');
if (!defined('_DOWN_THUMB_WRONG_TYPE')) DEFINE('_DOWN_THUMB_WRONG_TYPE','<h3>les images miniatures doivent être en format png, jpg ou jpeg</h3>');
if (!defined('_DOWN_EXTENSION_IN_TITLE')) DEFINE('_DOWN_EXTENSION_IN_TITLE','Extension dans le titre');
if (!defined('_DOWN_INHERIT')) DEFINE('_DOWN_INHERIT','Appliquer ces réglages aux sous-catégories&nbsp;:<br />'); 
if (!defined('_DOWN_FORCE_INHERIT')) DEFINE('_DOWN_FORCE_INHERIT','Appliquer les paramêtres aux sous-catégories');
if (!defined('_DOWN_EXT_IN_TITLE')) DEFINE('_DOWN_EXT_IN_TITLE','Extension dans le titre');
if (!defined('_DOWN_BULK_ADD_FILES')) DEFINE('_DOWN_BULK_ADD_FILES','Ajouter les fichiers du dossier de soumission');
if (!defined('_DOWN_NO_AVAILABLE_FILES')) DEFINE('_DOWN_NO_AVAILABLE_FILES','Fichier non autorisé');
if (!defined('_DOWN_ABS_PATH_TO_FILES')) DEFINE('_DOWN_ABS_PATH_TO_FILES','Chemin absolu des fichiers&nbsp;:');
if (!defined('_DOWN_ACCEPTABLE_EXTENSIONS')) DEFINE('_DOWN_ACCEPTABLE_EXTENSIONS','Extensions autorisées (séparées par une virgule)&nbsp;:');
if (!defined('_DOWN_EXTENSION_IN_TITLE')) DEFINE('_DOWN_EXTENSION_IN_TITLE','Extension dans le titre');
if (!defined('_DOWN_DOWNLOAD_TEXT_BOX')) DEFINE('_DOWN_DOWNLOAD_TEXT_BOX','<p>Information de téléchargement</p></b><p>Informations affichée lors du téléchargement ou de la lecture des fichiers.<br />Il est possible d´incorporer des scripts tels que la Pub Google Adsens affichée par défaut grâce au sript ci-contre.</p><p><b>Pour effacer la pub, supprimez le contenu du champ !</b></p>');
if (!defined('_DOWN_MAIN_PREAMBLE')) DEFINE('_DOWN_MAIN_PREAMBLE', 'Texte de la page principale');
if (!defined('_DOWN_PRUNE_LOG')) DEFINE('_DOWN_PRUNE_LOG','- Réinitialiser les compteurs selon une date');
if (!defined('_DOWN_LOGFILE_CUTOFF_DATE')) DEFINE('_DOWN_LOGFILE_CUTOFF_DATE','Entrer une date pour effacer uniquement les enregistrements qui lui sont antérieurs:');
if (!defined('_DOWN_PRESS_SAVE_ACTIVATE')) DEFINE('_DOWN_PRESS_SAVE_ACTIVATE','Cliquez ensuite sur "Sauver".');
if (!defined('_DOWN_METHOD_NOT_PRESENT')) DEFINE('_DOWN_METHOD_NOT_PRESENT','Erreur %s du composant: tentative d´emploi d´une méthode inexistante %s dans %s');
if (!defined('_DOWN_CLASS_NOT_PRESENT')) DEFINE('_DOWN_CLASS_NOT_PRESENT','Erreur %s du composant: tentative d´emploi de la classe %s inexistante');
if (!defined('_DOWN_NO_UPLOAD_TO_FILES')) DEFINE('_DOWN_NO_UPLOAD_TO_FILES','Vous ne pouvez pas envoyer plusieurs fichiers');
if (!defined('_DOWN_COUNTS_RECALCULATED')) DEFINE('_DOWN_COUNTS_RECALCULATED','Nombre de téléchargements recalculé !');
if (!defined('_DOWN_COUNTS_RESET')) DEFINE('_DOWN_COUNTS_RESET','Suppression des enregistrements des compteurs effectuée !');
if (!defined('_DOWN_OLD_LOG_REMOVED')) DEFINE('_DOWN_OLD_LOG_REMOVED','Tous les enregistrements de fichiers téléchargés antérieurs au %s ont été supprimés !');
if (!defined('_DOWN_NONE_MISSING')) DEFINE('_DOWN_NONE_MISSING','Aucun fichier');
if (!defined('_DOWN_BLOB_NOCHUNKS')) DEFINE('_DOWN_BLOB_NOCHUNKS',' - La liste des tables indique 0');
if (!defined('_DOWN_CHUNKS_DISCREPANCY')) DEFINE('_DOWN_CHUNKS_DISCREPANCY',' - La liste des tables indique %s, le fichier indique %s');
if (!defined('_DOWN_PLAINTEXT_DISCREPANCY')) DEFINE('_DOWN_PLAINTEXT_DISCREPANCY',' - La liste des textes d´information  a des entrées %s, ils doivent être sur 1');
if (!defined('_DOWN_NOT_FOUND_HERE')) DEFINE('_DOWN_NOT_FOUND_HERE',' - Aucune résultat dans ce dossier<br/>');
if (!defined('_DOWN_LOCAL_NO_URL')) DEFINE('_DOWN_LOCAL_NO_URL','Fichier absent en local et aucune URL spécifiée');
if (!defined('_DOWN_NOT_VALID_BR')) DEFINE('_DOWN_NOT_VALID_BR',' - Non Valide!<br/>');
if (!defined('_DOWN_NO_RELEVANT_THUMB')) DEFINE('_DOWN_NO_RELEVANT_THUMB',' - Aucun fichier correspondant<br/>');
if (!defined('_DOWN_THUMB_NOT_BELONG')) DEFINE('_DOWN_THUMB_NOT_BELONG','%s dans le dossier %s ne donne aucun résultat.<br/>');
if (!defined('_DOWN_THUMB_NOT_IN_DB')) DEFINE('_DOWN_THUMB_NOT_IN_DB',' - Aucun enregistrement dans la base de données<br/>');
if (!defined('_DOWN_THUMB_OK')) DEFINE('_DOWN_THUMB_OK','Aucun problème de correspondance d´images miniatures');
if (!defined('_DOWN_DB_CONVERT_OK')) DEFINE('_DOWN_DB_CONVERT_OK','Correction de la base de données terminée.<br />Tous les éléments ci-dessous étaient incorrects.');
if (!defined('_DOWN_ADD_NUMBER_FILES')) DEFINE('_DOWN_ADD_NUMBER_FILES','Ajouter plusieurs fichiers');
if (!defined('_DOWN_DISPLAY_NUMBER')) DEFINE('_DOWN_DISPLAY_NUMBER','Affichage #');
if (!defined('_DOWN_SEARCH_COLON')) DEFINE('_DOWN_SEARCH_COLON','Rechercher&nbsp;:');
if (!defined('_DOWN_SHOW_DESCENDANTS')) DEFINE('_DOWN_SHOW_DESCENDANTS','Affichage descendants: ');
if (!defined('_DOWN_CLICK_TO_VISIT')) DEFINE('_DOWN_CLICK_TO_VISIT','Cliquer pour visiter le site');
if (!defined('_DOWN_CONTAINERS')) DEFINE('_DOWN_CONTAINERS','- Catégories');
if (!defined('_DOWN_UP_PLAIN_TEXT')) DEFINE('_DOWN_UP_PLAIN_TEXT','Coder les fichiers dans la base de données ?');
if (!defined('_GLOBAL')) DEFINE('_GLOBAL','Global');
if (!defined('_DOWN_KEYWORDS')) DEFINE('_DOWN_KEYWORDS', 'Mots clés&nbsp;:');
if (!defined('_DOWN_WINDOW_TITLE')) DEFINE('_DOWN_WINDOW_TITLE','Titre de la fenêtre&nbsp;:');
if (!defined('_DOWN_EDITOR_GROUP')) DEFINE('_DOWN_EDITOR_GROUP','Groupe Editeurs&nbsp;:');
if (!defined('_DOWN_AUTO_FOR_ADMIN')) DEFINE('_DOWN_AUTO_FOR_ADMIN','Auto-approuver pour Admin&nbsp;:');
if (!defined('_DOWN_AUTO_FOR_USERS')) DEFINE('_DOWN_AUTO_FOR_USERS','Auto-approuver pour Membres&nbsp;:');
if (!defined('_DOWN_AUTO_USER_GROUP')) DEFINE('_DOWN_AUTO_USER_GROUP','Auto-approuver pour Groupe Editeurs&nbsp;:');
if (!defined('_DOWN_CONTAINER_CASCADE')) DEFINE('_DOWN_CONTAINER_CASCADE','Appliquer aux sous-catégories&nbsp;:');
if (!defined('_DOWN_THANK_YOU')) DEFINE('_DOWN_THANK_YOU','<hr>Téléchargement:</br > ');
if (!defined('_DOWN_WAIT_OR_CLICK')) DEFINE('_DOWN_WAIT_OR_CLICK','<hr><p>Si le téléchargement ne démarre pas après 5 secondes, veuillez cliquer sur le lien "Télécharger"</p>');
if (!defined('_DOWN_UPDATE_THUMBNAILS')) DEFINE('_DOWN_UPDATE_THUMBNAILS','Gestion des vignettes');
if (!defined('_DOWN_DELETE_THUMBNAIL')) DEFINE('_DOWN_DELETE_THUMBNAIL','Effacer les vignettes');
if (!defined('_DOWN_SUBMIT_NEW_THUMBNAIL')) DEFINE('_DOWN_SUBMIT_NEW_THUMBNAIL','Envoyer une nouvelle vignette');
if (!defined('_DOWN_NOT_LOGGED_UPLOAD')) DEFINE('_DOWN_NOT_LOGGED_UPLOAD','Vous ne pouvez pas envoyer de fichiers sans vous enregistrer ou vous connecter.');
if (!defined('_DOWN_NOT_LOGGED_COMMENT')) DEFINE('_DOWN_NOT_LOGGED_COMMENT','Vous ne pouvez pas écrire de commentaires sans vous enregistrer ou vous connecter.');
if (!defined('_DOWN_NOT_LOGGED_VOTE')) DEFINE('_DOWN_NOT_LOGGED_VOTE','Vous ne pouvez pas voter sans vous enregistrer ou vous connecter.');
if (!defined('_DOWN_COMMENT_NL')) DEFINE('_DOWN_COMMENT_NL','Veuillez vous enregistrer ou vous connecter pour écrire un commentaire');

// Define some summaries for tables
if (!defined('_TABLE_SUMMARY_GENHEAD')) DEFINE ('_TABLE_SUMMARY_GENHEAD', 'Liste des catégories de téléchargement disponibles et du nombre de fichiers dans chaque catégorie.');
if (!defined('_TABLE_SUMMARY_ADDMANYFILES')) DEFINE ('_TABLE_SUMMARY_ADDMANYFILES', 'Ce tableau vous permet de choisir plusieurs fichiers à envoyer.');
if (!defined('_DOWNLOAD_UPLOAD_TITLE')) DEFINE('_DOWNLOAD_UPLOAD_TITLE','Envoi de fichier');
if (!defined('_HEAD')) DEFINE('_HEAD','Envoyer un Fichier');
if (!defined('_FILE')) DEFINE('_FILE','Envoyer un Fichier&nbsp;:');
if (!defined('_CLOSE')) DEFINE('_CLOSE','Fermer');
if (!defined('_SENDFILE')) DEFINE('_SENDFILE','Envoyer le Fichier');
if (!defined('_ERR1')) DEFINE('_ERR1','Nom de Fichier inexistant');
if (!defined('_ERR2')) DEFINE('_ERR2','Attaque par envoi de fichier');
if (!defined('_ERR3')) DEFINE('_ERR3','La taille du fichier que vous avez tenté d´envoyer est nulle!');
if (!defined('_ERR4')) DEFINE('_ERR4','Vous avez tenté d´envoyer un fichier dont l´extension n´est pas autorisée!');
if (!defined('_ERR5')) DEFINE('_ERR5','La taille du fichier que vous avez voulu envoyer dépasse la limite de ');
if (!defined('_ERR6')) DEFINE('_ERR6','Le fichier que vous avez voulu envoyer existe . Vous devez donner un autre nom pour ce fichier.');
if (!defined('_ERR7')) DEFINE('_ERR7','Le dossier de stockage des fichiers a atteint sa limite. Veuillez la modifier dans la configuration');
if (!defined('_ERR8')) DEFINE('_ERR8','Vous devez avoir le statut Admin ou Utilisateur Membre pour pouvoir envoyer un fichier.');
if (!defined('_ERR9')) DEFINE('_ERR9','Le nombre maximum de fichiers que vous pouvez envoyer par jour est atteint.');
if (!defined('_ERR10')) DEFINE('_ERR10','Les utilisateurs non Membres ne peuvent pas envoyer des fichiers.');
if (!defined('_ERR11')) DEFINE('_ERR11','L´envoi du fichier n´ a pas abouti, avec le code erreur ');
if (!defined('_UP_SUCCESS')) DEFINE('_UP_SUCCESS','L´envoi du fichier a abouti!');
if (!defined('_UPLOAD_URL_LOCK')) DEFINE('_UPLOAD_URL_LOCK','-Fichier Envoyé-');
if (!defined('_WARNING1')) DEFINE('_WARNING1','Le chemin du dossier a été modifié. Vous ne pouvez pas déplacer le fichier.');
if (!defined('_WARNING2')) DEFINE('_WARNING2','Le dossier spécifier est inexistant. Vous devez le créer.');
if (!defined('_APPROVE')) DEFINE('_APPROVE','Approuver');
if (!defined('_CANCEL')) DEFINE('_CANCEL','Annuler');
if (!defined('_DOWN_MISSING_TITLE')) DEFINE('_DOWN_MISSING_TITLE','- Fichiers Rompus');
if (!defined('_MBT_GROUP_MANAGER')) DEFINE('_MBT_GROUP_MANAGER','Remository - Groupes');
if (!defined('_MBT_GROUP_FILTER')) DEFINE('_MBT_GROUP_FILTER','Filtrer par Nom');
if (!defined('_MBT_GROUP_GROUP')) DEFINE('_MBT_GROUP_GROUP','Groupe');
if (!defined('_MBT_GROUP_DESCRIPTION')) DEFINE('_MBT_GROUP_DESCRIPTION','Description du groupe');
if (!defined('_MBT_GROUP_EMAIL')) DEFINE('_MBT_GROUP_EMAIL','E-mail au groupe');
if (!defined('_MBT_GROUP_ADD')) DEFINE('_MBT_GROUP_ADD','Ajouter un Groupe');
if (!defined('_MBT_GROUP_EDIT')) DEFINE('_MBT_GROUP_EDIT','Editer le Groupe');
if (!defined('_MBT_GROUP_NAME')) DEFINE('_MBT_GROUP_NAME','Nom');
if (!defined('_MBT_GROUP_AVAI_USER')) DEFINE('_MBT_GROUP_AVAI_USER','Membres diponibles');
if (!defined('_MBT_GROUP_SEL_USER')) DEFINE('_MBT_GROUP_SEL_USER','Membres dans ce groupe');
if (!defined('_MBT_GROUP_MEMBERS')) DEFINE('_MBT_GROUP_MEMBERS','Membres');
if (!defined('_MBT_GROUP_SUBJECT')) DEFINE('_MBT_GROUP_SUBJECT','Sujet');
if (!defined('_MBT_GROUP_MESSAGE')) DEFINE('_MBT_GROUP_MESSAGE','Message');
if (!defined('_MBT_GROUP_SEND')) DEFINE('_MBT_GROUP_SEND','Envoyer');
if (!defined('_MBT_GROUP_MISS_SUB')) DEFINE('_MBT_GROUP_MISS_SUB','Veuillez insérer un sujet');
if (!defined('_MBT_GROUP_MISS_MSG')) DEFINE('_MBT_GROUP_MISS_MSG','Veuillez insérer un message');
if (!defined('_MBT_GROUP_MISS_GROUP')) DEFINE('_MBT_GROUP_MISS_GROUP','Veuillez insérer le nom du groupe');
if (!defined('_MBT_GROUP_SEND_ADMIN')) DEFINE('_MBT_GROUP_SEND_ADMIN','Seul les administrateurs peuvent envoyer des e-mails!');
if (!defined('_MBT_GROUP_SEND_NOTARGET')) DEFINE('_MBT_GROUP_SEND_NOTARGET','Aucune adresse e-mail dans ce groupe');
if (!defined('_MBT_GROUP_SEND_OK')) DEFINE('_MBT_GROUP_SEND_OK','L´e-mail a été envoyé à');
if (!defined('_MBT_GROUP_SEND_USERS')) DEFINE('_MBT_GROUP_SEND_USERS','Membres');

// if (!defined('_MBT_ADD_MEMBERS')) DEFINE('_MBT_ADD_MEMBERS','Ajouter des Membres');
// if (!defined('_DOWN_ADD_URL')) DEFINE ('_DOWN_ADD_URL','Ajouter URL');
//if (!defined('_DOWN_CONTROL_PANEL')) DEFINE ('_DOWN_CONTROL_PANEL','Panneau de Contrôle');


// Recent additions 3.56
if (!defined('_DOWN_EDIT_CLASSIFICATION')) DEFINE ('_DOWN_EDIT_CLASSIFICATION', 'Edit Classification');
if (!defined('_DOWN_CLASSIFICATION')) DEFINE ('_DOWN_CLASSIFICATION', 'Classification');
if (!defined('_DOWN_CONTAINER_PUBLISHED')) DEFINE ('_DOWN_CONTAINER_PUBLISHED', 'Container successfully published');
if (!defined('_DOWN_CONTAINERS_PUBLISHED')) DEFINE ('_DOWN_CONTAINERS_PUBLISHED', 'Containers successfully published');
if (!defined('_DOWN_CONTAINER_UNPUBLISHED')) DEFINE ('_DOWN_CONTAINER_UNPUBLISHED', 'Container successfully unpublished');
if (!defined('_DOWN_CONTAINERS_UNPUBLISHED')) DEFINE ('_DOWN_CONTAINERS_UNPUBLISHED', 'Containers successfully unpublished');
if (!defined('_DOWN_CONTAINER_SAVED')) DEFINE ('_DOWN_CONTAINER_SAVED', 'Container saved successfully');
if (!defined('_DOWN_CONTAINER_DELETED')) DEFINE ('_DOWN_CONTAINER_DELETED', 'Container deleted successfully');
if (!defined('_DOWN_CONTAINERS_DELETED')) DEFINE ('_DOWN_CONTAINERS_DELETED', 'Containers deleted successfully');
if (!defined('_DOWN_FILE_PUBLISHED')) DEFINE ('_DOWN_FILE_PUBLISHED', 'File successfully published');
if (!defined('_DOWN_FILES_PUBLISHED')) DEFINE ('_DOWN_FILES_PUBLISHED', 'Files successfully published');
if (!defined('_DOWN_FILE_UNPUBLISHED')) DEFINE ('_DOWN_FILE_UNPUBLISHED', 'File successfully unpublished');
if (!defined('_DOWN_FILES_UNPUBLISHED')) DEFINE ('_DOWN_FILES_UNPUBLISHED', 'Files successfully unpublished');
if (!defined('_DOWN_FILE_SAVED')) DEFINE ('_DOWN_FILE_SAVED', 'File saved successfully');
if (!defined('_DOWN_FILE_DELETED')) DEFINE ('_DOWN_FILE_DELETED', 'File deleted successfully');
if (!defined('_DOWN_FILES_DELETED')) DEFINE ('_DOWN_FILES_DELETED', 'Files deleted successfully');
if (!defined('_DOWN_FILE_LOCALISED')) DEFINE ('_DOWN_FILE_LOCALISED', 'File localised successfully');
if (!defined('_DOWN_GROUP_MEMBER_SAVED')) DEFINE ('_DOWN_GROUP_MEMBER_SAVED', 'Group member added successfully');
if (!defined('_DOWN_GROUP_MEMBERS_SAVED')) DEFINE ('_DOWN_GROUP_MEMBERS_SAVED', 'Group members added successfully');
if (!defined('_DOWN_GROUP_MEMBER_DELETED')) DEFINE ('_DOWN_GROUP_MEMBER_DELETED', 'Member removed successfully');
if (!defined('_DOWN_GROUP_MEMBERS_DELETED')) DEFINE ('_DOWN_GROUP_MEMBERS_DELETED', 'Members removed successfully');
if (!defined('_DOWN_GROUP_DELETED')) DEFINE ('_DOWN_GROUP_DELETED', 'Group deleted successfully');
if (!defined('_DOWN_GROUPS_DELETED')) DEFINE ('_DOWN_GROUPS_DELETED', 'Groups deleted successfully');
if (!defined('_DOWN_ORPHAN_SINGLE_DONE')) DEFINE('_DOWN_ORPHAN_SINGLE_DONE','File Orphan Deleted');
if (!defined('_DOWN_CLASSIFICATION_PUBLISHED')) DEFINE ('_DOWN_CLASSIFICATION_PUBLISHED', 'Classification successfully published');
if (!defined('_DOWN_CLASSIFICATIONS_PUBLISHED')) DEFINE ('_DOWN_CLASSIFICATIONS_PUBLISHED', 'Classifications successfully published');
if (!defined('_DOWN_CLASSIFICATION_UNPUBLISHED')) DEFINE ('_DOWN_CLASSIFICATION_UNPUBLISHED', 'Classification successfully unpublished');
if (!defined('_DOWN_CLASSIFICATIONS_UNPUBLISHED')) DEFINE ('_DOWN_CLASSIFICATIONS_UNPUBLISHED', 'Classifications successfully unpublished');
if (!defined('_DOWN_CLASSIFICATION_SAVED')) DEFINE ('_DOWN_CLASSIFICATION_SAVED', 'Classification saved successfully');
if (!defined('_DOWN_CLASSIFICATION_DELETED')) DEFINE ('_DOWN_CLASSIFICATION_DELETED', 'Classification deleted successfully');
if (!defined('_DOWN_CLASSIFICATIONS_DELETED')) DEFINE ('_DOWN_CLASSIFICATIONS_DELETED', 'Classifications deleted successfully');
if (!defined('_DOWN_MISSING_DELETED')) DEFINE ('_DOWN_MISSING_DELETED', 'Missing file deleted successfully');
if (!defined('_DOWN_MISSINGS_DELETED')) DEFINE ('_DOWN_MISSINGS_DELETED', 'Missing files deleted successfully');
if (!defined('_SUBMIT_FILE_BUTTON_ADV')) DEFINE('_SUBMIT_FILE_BUTTON_ADV','AddFile');