<?php

/**************************************************************
* This file is part of Remository
* Copyright (c) 2006-17 Martin Brampton
* 
* License: GNU General Public License version 2 or later; see LICENSE.txt
* 
* For support and other information, visit http://remository.com
* To contact Martin Brampton, write to martin@remository.com
*
* Remository started life as the psx-dude script by psx-dude@psx-dude.net
* It was enhanced by Matt Smith up to version 2.10
* Since then development has been primarily by Martin Brampton,
* with contributions from other people gratefully accepted
*/

defined('_JEXEC') or die;


// These settings are dummy values to suppress errors when the language file 
// is used in a context where the real values have not been set

if (!isset($Large_Text_Len)) $Large_Text_Len = 500;
if (!isset($Small_Text_Len)) $Small_Text_Len = 150;
if (!isset($mosConfig_sitename)) $mosConfig_sitename = 'Site Name';

// Remository 3.52 Catalan UTF-8
// Traducció per Jose M. - Novembre 2009

// Add your own definitions here, just using plain DEFINE
// e.g. define ('_DOWNLOADS_TITLE', 'The name of my Repository');
// Your definitions will override the standard ones if placed ahead of them

// Prototype for standard definitions: if (!defined('')) DEFINE ('', '');

// Additions in 3.52
if (!defined('_DOWN_MANY_CONTAINERS')) DEFINE('_DOWN_MANY_CONTAINERS', 'Massa contenidors en la llista - si us plau navegui a través dels enllaços dels contenidors');
if (!defined('_DOWN_DELETE_SURE')) DEFINE ('_DOWN_DELETE_SURE', 'Segur que vols esborrar aquest arxiu?');
if (!defined('_DOWN_SEARCH_CATEGORY_SELECT')) DEFINE ('_DOWN_SEARCH_CATEGORY_SELECT', 'Selecciona les categories a incloure');
if (!defined('_DOWN_SEARCH_FILES')) DEFINE ('_DOWN_SEARCH_FILES', 'Cercar arxius');

// Additions in 3.51
if (!defined('_DOWN_NOT_ABSOLUTE')) DEFINE ('_DOWN_NOT_ABSOLUTE', 'Ruta absoluta invàlida');
if (!defined('_DOWN_NEW_OR_UPDATED')) DEFINE ('_DOWN_NEW_OR_UPDATED', 'Nou o arxiu actualitzat');
if (!defined('_DOWN_NEW_FILE_COMMENT')) DEFINE ('_DOWN_NEW_FILE_COMMENT', 'Nou comentari per l´arxiu');
if (!defined('_DOWN_MAIL_MESSAGE_PREFIX')) DEFINE ('_DOWN_MAIL_MESSAGE_PREFIX', "Hola %s\n\n");
if (!defined('_DOWN_NEW_UPDATED_MSG')) DEFINE ('_DOWN_NEW_UPDATED_MSG', 
					"En %s s´ha afegit o actualitzat un arxiu. El títol de l´arxiu és %s."
					."\n\nSi us plau, no respongui aquest missatge, s´ha generat amb l´únic propòsit d´informar-li\n"
					);
if (!defined('_DOWN_NEW_COMMENT_MSG')) DEFINE ('_DOWN_NEW_COMMENT_MSG', 
					"En %s s´ha fet un nou comentari sobre un arxiu. El títol de l´arxiu és %s.  "
					."El comentari l´ha fet %s i es:\n\n%s"
					."\n\nSi us plau, no respongui aquest missatge, s´ha generat amb l´únic propòsit d´informar-li\n"
					);

// Modifications in 3.51
if (!defined('_DOWN_MAIL_MSG')) DEFINE('_DOWN_MAIL_MSG','Hola, %s ha fet un nou enviament'
                   ." pel lloc web %s.\n"
                   ."Si us plau, connecti´s com administrador per a veure i aprovar l´enviament.\n\n"
                   ."Si us plau, no respongui aquest missatge, s´ha generat amb l´únic propòsit dinformar-li\n");
if (!defined('_DOWN_MAIL_MSG_APP')) DEFINE('_DOWN_MAIL_MSG_APP','Hola, ´%s ha realitzat un nou enviament'
                   ." pel lloc web %s.\n"
                   ."D´acord amb les opcions de configuració, ha estat auto-aprovat.\n\n"
                   ."Si us plau, no respongui aquest missatge, s´ha generat amb l´únic propòsit d´informar-li\n");
if (!defined('_DOWN_LINK_TO_FILE')) DEFINE ('_DOWN_LINK_TO_FILE', "\n\nPots trobar l´arxiu en %s");
if (!defined('_DOWN_LINK_TO_CONTAINER')) DEFINE ('_DOWN_LINK_TO_CONTAINER', "\n\nPots trobar el contenidor en %s");

// Additions in 3.50
if (!defined('_DOWN_APPROVE_ROLES')) DEFINE ('_DOWN_APPROVE_ROLES', 'Regles Auto-aprovació');
if (!defined('_DOWN_ACCESS_REFUSED')) DEFINE ('_DOWN_ACCESS_REFUSED', 'Ho sento, la teva petició ha estat denegada');
if (!defined('_DOWN_MAYBE_LOGIN')) DEFINE ('_DOWN_MAYBE_LOGIN', 'Potser necessites registrar-te, o crear un compte.');
if (!defined('_DOWN_CONFIG70')) DEFINE ('_DOWN_CONFIG70', 'Show_all_containers: <br /><em>(Mostrar la ruta completa en els resultats de la cerca)</em>');
if (!defined('_DOWN_CONFIG69')) DEFINE ('_DOWN_CONFIG69', 'Set_date_locale: <br /><em>(Escull una configuració regional pel format de la data)</em>');
if (!defined('_DOWN_CONFIG68')) DEFINE ('_DOWN_CONFIG68', 'Force_Language: <br /><em>(Forçar el codi de l´idioma amb aquest valor, ignora el CMS)</em>');

// Additions in 3.47 to fix missed items in earlier versions
if (!defined('_DOWN_NO_FILE_RECEIVED')) DEFINE ('_DOWN_NO_FILE_RECEIVED', 'Ha intentat pujar un arxiu però no s´ha rebut cap.');
if (!defined('_DOWN_SAMPLE')) DEFINE ('_DOWN_SAMPLE', 'Mostra');
if (!defined('_DOWN_SAMPLE_DESCRIPTION')) DEFINE ('_DOWN_SAMPLE_DESCRIPTION', 'Reemplaçar o modificar aquest contenidor de mostra segons sigui necessari');
if (!defined('_DOWN_INSTALL_DONE1')) DEFINE ('_DOWN_INSTALL_DONE1', 'Es recomana encaridament que faci un cop d´ull a les notes de llançament (Release notes) en l´arxiu read_me.txt');
if (!defined('_DOWN_INSTALL_DONE2')) DEFINE ('_DOWN_INSTALL_DONE2', 'Pot trobar més informació en el <a href="http://remository.com">lloc web de Remository</a>.');
if (!defined('_DOWN_INSTALL_DONE3')) DEFINE ('_DOWN_INSTALL_DONE3', 'Mantingui Remository');
if (!defined('_DOWN_INSTALL_DONE4')) DEFINE ('_DOWN_INSTALL_DONE4', 'Desenvolupar i mantenir Remository porta temps i diners.'
		.' Si està obtenint benefici econòmic '
		.' amb el seu ús, per favor consideri fer una donació per a donar suport al projecte.'
		.' Faci clic en el botó a continuació per a efectuar un pagament immediat:');
if (!defined('_DOWN_LOCAL_OR_REMOTE')) DEFINE ('_DOWN_LOCAL_OR_REMOTE', 'Local o Remot');
if (!defined('_DOWN_IS_LOCAL')) DEFINE ('_DOWN_IS_LOCAL', 'Local');
if (!defined('_DOWN_IS_REMOTE')) DEFINE ('_DOWN_IS_REMOTE', 'Remot');
if (!defined('_DOWN_LOCALISE_REMOTE_FILE')) DEFINE ('_DOWN_LOCALISE_REMOTE_FILE', 'Fer local');
if (!defined('_DOWN_CANCEL_UPLOAD')) DEFINE ('_DOWN_CANCEL_UPLOAD', 'Cancel·lar pujada');
if (!defined('_DOWN_NOT_YET_IMPLEMENTED')) DEFINE ('_DOWN_NOT_YET_IMPLEMENTED', 'AQUESTA FUNCIONALITAT ENCARA NO HA ESTAT IMPLEMENTADA	');
if (!defined('_DOWN_ADMIN_CPANEL_CACHEPATH')) DEFINE ('_DOWN_ADMIN_CPANEL_CACHEPATH', 'Ruta a la memòria cau del CMS - important pel RSS i el control d´accés:');
if (!defined('_DOWN_CONFIG_EXPLAIN_4')) DEFINE ('_DOWN_CONFIG_EXPLAIN_4', 'D = Camps que se mostrara en la pàgina d´informació detallada de l´arxiu');
if (!defined('_DOWN_CONFIG67')) DEFINE ('_DOWN_CONFIG67', '<b>Profile_URI:</b> <br /><em>(URI no-SEF relativa al perfil amb %u on la ID d´usuario hauria d´estar)</em>');
if (!defined('_DOWN_CONFIG66')) DEFINE ('_DOWN_CONFIG66', '<b>Activate_AEC:</b> <br /><em>(Activar integració amb AEC pel control d´accés)</em>');
if (!defined('_DOWN_AEC_OPTION_A')) DEFINE ('_DOWN_AEC_OPTION_A', 'Aplicar només al grupo (o grups) a continuació.');
if (!defined('_DOWN_AEC_OPTION_B')) DEFINE ('_DOWN_AEC_OPTION_B', 'Esborrar TOT, i a continuació aplicar següent(s) grup(s).');
if (!defined('_DOWN_AEC_OPTION_C')) DEFINE ('_DOWN_AEC_OPTION_C', 'Esborrar grup establert en l´aplicació, i a continuació aplicar el grupo(s) següents.');
if (!defined('_DOWN_CONFIG65')) DEFINE ('_DOWN_CONFIG65', '<b>Home_Page_Title:</b><br /><em>(Entrada de la barra de títol del navegador per la pàgina principal del contenidor)</em>');
if (!defined('_DOWN_NEXT')) DEFINE ('_DOWN_NEXT', 'Següent');
if (!defined('_DOWN_PREVIOUS')) DEFINE ('_DOWN_PREVIOUS', 'Anterior');
if (!defined('_DOWN_DOWNLOAD_LC')) DEFINE ('_DOWN_DOWNLOAD_LC', 'Descarregar');
if (!defined('_DOWN_EMPTY_REPOSITORY')) DEFINE ('_DOWN_EMPTY_REPOSITORY', 'Buidar contenidor');
if (!defined('_DOWN_OVERVIEW_LATEST')) DEFINE ('_DOWN_OVERVIEW_LATEST', 'Últims arxius en el contenidor');
if (!defined('_DOWN_SPECIFY_AUTHOR')) DEFINE ('_DOWN_SPECIFY_AUTHOR', 'Un altre autor');
if (!defined('_DOWN_CONFIG64')) DEFINE ('_DOWN_CONFIG64', '<b>Author_Threshold:</b><br /><em>(Llistats d´autor mínimo a incloure en la llista desplegable)</em>');
if (!defined('_DOWN_CONFIG63')) DEFINE ('_DOWN_CONFIG63', '<b>Main_Authors:</b><br /><em>(Llista d´autors seleccionables, separats per coma)</em>');
if (!defined('_DOWN_CONFIG62')) DEFINE ('_DOWN_CONFIG62', '<b>Min_Comment_length:</b><br /><em>(Longitut mínima per un comentari de un arxiu, o ignorar-lo)</em>');
if (!defined('_DOWN_CONFIG61')) DEFINE ('_DOWN_CONFIG61', '<b>Video_Download:</b><br /><em>(Permetre la descàrrega d´arxius de vídeo)</em>');
if (!defined('_DOWN_CONFIG60')) DEFINE ('_DOWN_CONFIG60', '<b>Audio_Download:</b><br /><em>(Permetre la descàrrega d´arxius d´audi)</em>');
if (!defined('_DOWN_CONFIG59')) DEFINE ('_DOWN_CONFIG59', '<b>Alias:</b><br /><em>(Alies del contenidor)</em>');
if (!defined('_DOWN_CONFIG58')) DEFINE ('_DOWN_CONFIG58', '<b>Name:</b><br /><em>(Nom del contenidor)</em>');
if (!defined('_DOWN_PLAY')) DEFINE ('_DOWN_PLAY', 'Reproduir');
if (!defined('_DOWN_PLAY_THANK_YOU')) DEFINE ('_DOWN_PLAY_THANK_YOU', 'Gràcies per reproduir ');
if (!defined('_DOWN_CONFIG57')) DEFINE ('_DOWN_CONFIG57', '<b>Extensions d´arxius de vídeo:</b><br /><em>(Arxius de vídeo que seran reproduïts, no descarregats)</em>');
if (!defined('_DOWN_CONFIG56')) DEFINE ('_DOWN_CONFIG56', '<b>Extensions d´arxius d´audio:</b><br /><em>(Arxius d´audi que seran reproduïts, no descarregats)</em>');
if (!defined('_DOWN_FEATURED')) DEFINE ('_DOWN_FEATURED', 'Destacat');
if (!defined('_DOWN_IS_FEATURED')) DEFINE ('_DOWN_IS_FEATURED', 'Arxiu destacat:');
if (!defined('_DOWN_FEATURE_START')) DEFINE ('_DOWN_FEATURE_START', 'Data inici:');
if (!defined('_DOWN_FEATURE_END')) DEFINE ('_DOWN_FEATURE_END', 'Data finalització (en blanc = per sempre)');
if (!defined('_DOWN_PUBLISH_FROM')) DEFINE ('_DOWN_PUBLISH_FROM', 'Publicar des de:');
if (!defined('_DOWN_PUBLISH_TO')) DEFINE ('_DOWN_PUBLISH_TO', 'Publicar fins (en blanc = per sempre):');
if (!defined('_DOWN_FIELD_NAME')) DEFINE ('_DOWN_FIELD_NAME', 'Nom del camp');
if (!defined('_DOWN_FIELD_TITLE')) DEFINE ('_DOWN_FIELD_TITLE', 'Títol del camp');
if (!defined('_DOWN_CUSTOM_UPLOAD')) DEFINE ('_DOWN_CUSTOM_UPLOAD', 'En la pujada');
if (!defined('_DOWN_CUSTOM_LIST')) DEFINE ('_DOWN_CUSTOM_LIST', 'En la llista de l´arxiu');
if (!defined('_DOWN_CUSTOM_INFO_PAGE')) DEFINE ('_DOWN_CUSTOM_INFO_PAGE', 'En la pàgina d´informació');
if (!defined('_DOWN_FIELD_OPTIONS')) DEFINE ('_DOWN_FIELD_OPTIONS', 'Limitar valors als d´aquesta llista (sep. per coma)');
if (!defined('_DOWN_CUSTOM_INFO')) DEFINE ('_DOWN_CUSTOM_INFO', 'El nom del camp sera usat en la base de dades i ha de ser únic per la taula xxx_downloads_files.  El títol del campo sera usat per etiquetar-lo quan sigui usat.');
if (!defined('_DOWN_CUSTOM_FIELDS_TAB')) DEFINE ('_DOWN_CUSTOM_FIELDS_TAB', 'Afegir camps');
if (!defined('_DOWN_CUSTOM_FIELDS_HEAD')) DEFINE ('_DOWN_CUSTOM_FIELDS_HEAD', 'Camps personalitzats');
if (!defined('_DOWN_CONFIG55')) DEFINE ('_DOWN_CONFIG55', '<b>Featured_Number:</b><br /><em>(Número d´elements a ser destacats)</em>');
if (!defined('_DOWN_IS_VISIBLE')) DEFINE ('_DOWN_IS_VISIBLE', 'Visible?');
if (!defined('_DOWN_FREQUENCY')) DEFINE ('_DOWN_FREQUENCY', 'Freqüència ');
if (!defined('_DOWN_TYPE')) DEFINE ('_DOWN_TYPE', 'Tipus');
if (!defined('_DOWN_DESCRIPTION')) DEFINE ('_DOWN_DESCRIPTION', 'Descripció');
if (!defined('_DOWN_CLASSIFICATIONS')) DEFINE ('_DOWN_CLASSIFICATIONS', 'Classificacions');
if (!defined('_DOWN_SAVE')) DEFINE ('_DOWN_SAVE', 'Guardar');
if (!defined('_DOWN_FILE_STRUCTURE')) DEFINE ('_DOWN_FILE_STRUCTURE', 'Estructura d´arxiu');
if (!defined('_DOWN_PRUNE')) DEFINE ('_DOWN_PRUNE', '- purgar');
if (!defined('_DOWN_DELETE_MISSING')) DEFINE ('_DOWN_DELETE_MISSING', 'Esborrar arxius que falten');
if (!defined('_DOWN_APPLY')) DEFINE ('_DOWN_APPLY', 'Aplicar');
if (!defined('_DOWN_CLASSIFICATION_NAME')) DEFINE ('_DOWN_CLASSIFICATION_NAME', 'Nom de la classificació');
if (!defined('_DOWN_DISPLAY_LISTS')) DEFINE ('_DOWN_DISPLAY_LISTS', 'Mostrar nom en les llistes:');
if (!defined('_DOWN_NOT_PUBLISHED')) DEFINE ('_DOWN_NOT_PUBLISHED', 'No publicat');
if (!defined('_DOWN_PUBLISH')) DEFINE ('_DOWN_PUBLISH', 'Publicar');
if (!defined('_DOWN_UNPUBLISH')) DEFINE ('_DOWN_UNPUBLISH', 'Despublicar');
if (!defined('_DOWN_FILE')) DEFINE ('_DOWN_FILE', 'Arxiu');
if (!defined('_DOWN_ADD')) DEFINE ('_DOWN_ADD', 'Afegir');
if (!defined('_DOWN_CLASSIFN')) DEFINE ('_DOWN_CLASSIFN', 'Classif´n');
if (!defined('_DOWN_ROLES')) DEFINE ('_DOWN_ROLES', 'rols:');
if (!defined('_DOWN_DELETE')) DEFINE ('_DOWN_DELETE', 'Esborrar');
if (!defined('_DOWN_ADD_USERS_NEW_ROLE')) DEFINE ('_DOWN_ADD_USERS_NEW_ROLE', 'Afegir usuaris al nou rol');
if (!defined('_DOWN_ADD_MEMBERS')) DEFINE ('_DOWN_ADD_MEMBERS', 'Afegir membres');
if (!defined('_DOWN_ADD_LOCAL')) DEFINE ('_DOWN_ADD_LOCAL', 'Afegir local');
if (!defined('_DOWN_ADD_REMOTE')) DEFINE ('_DOWN_ADD_REMOTE', 'Afegir remot');
if (!defined('_DOWN_EDIT_APPROVAL')) DEFINE ('_DOWN_EDIT_APPROVAL', 'Editar aprovació');
if (!defined('_DOWN_DELETE_SUBMISSION')) DEFINE ('_DOWN_DELETE_SUBMISSION', 'Esborrar enviament');
if (!defined('_DOWN_CONTAINER')) DEFINE ('_DOWN_CONTAINER', 'Contenidor');
if (!defined('_DOWN_PUBLISH_FILES')) DEFINE ('_DOWN_PUBLISH_FILES', 'Publicar arxius');
if (!defined('_DOWN_DELETE_ORPHANS')) DEFINE ('_DOWN_DELETE_ORPHANS', 'Esborrar orfes');
if (!defined('_DOWN_ORPHAN')) DEFINE ('_DOWN_ORPHAN', 'Orfe');
if (!defined('_DOWN_MISSING')) DEFINE ('_DOWN_MISSING', 'Falta');
if (!defined('_DOWN_ADD_USERS_ROLE')) DEFINE ('_DOWN_ADD_USERS_ROLE', 'Afegir usuaris al rol');
if (!defined('_DOWN_REMOVE_USERS_ROLE')) DEFINE ('_DOWN_REMOVE_USERS_ROLE', 'Eliminar usuaris del rol');
if (!defined('_DOWN_PUBLISHING')) DEFINE ('_DOWN_PUBLISHING', 'Publicant');
if (!defined('_DOWN_EDIT_CONTAINER')) DEFINE ('_DOWN_EDIT_CONTAINER', 'Editar contenidor');
if (!defined('_DOWN_REMOSITORY')) DEFINE ('_DOWN_REMOSITORY', 'Remository');
if (!defined('_DOWN_PHYSICAL_FILE')) DEFINE ('_DOWN_PHYSICAL_FILE', 'Arxiu físic');
if (!defined('_DOWN_METADATA')) DEFINE ('_DOWN_METADATA', 'Metadades');
if (!defined('_DOWN_SHORT_DESCRIPTION')) DEFINE ('_DOWN_SHORT_DESCRIPTION', 'Descripció curta');
if (!defined('_DOWN_LICENSE_HEADING')) DEFINE ('_DOWN_LICENSE_HEADING', 'Llicència');
if (!defined('_DOWN_ABOUT_FILE')) DEFINE ('_DOWN_ABOUT_FILE', 'Quant a l´arxiu');
if (!defined('_DOWN_COMMENTS_HEADING')) DEFINE ('_DOWN_COMMENTS_HEADING', 'Comentaris');
if (!defined('_DOWN_STORAGE')) DEFINE ('_DOWN_STORAGE', 'Enmagatzament');
if (!defined('_DOWN_ACCESS_CONTROL')) DEFINE ('_DOWN_ACCESS_CONTROL', 'Control d´accés');
if (!defined('_DOWN_DOWNLOAD_ROLES')) DEFINE ('_DOWN_DOWNLOAD_ROLES', 'Rols de descàrrega');
if (!defined('_DOWN_UPLOAD_ROLES')) DEFINE ('_DOWN_UPLOAD_ROLES', 'Rols de pujada');
if (!defined('_DOWN_EDIT_ROLES')) DEFINE ('_DOWN_EDIT_ROLES', 'Editar rols');
if (!defined('_DOWN_ADD_NEW_ROLE')) DEFINE ('_DOWN_ADD_NEW_ROLE', 'Afegir nou rol:');
// Recent additions 3.46+
if (!defined('_DOWN_DOWNLOAD_FROM')) DEFINE ('_DOWN_DOWNLOAD_FROM', 'Descarregar des de');
if (!defined('_DOWN_UPLOAD_TO')) DEFINE ('_DOWN_UPLOAD_TO', 'Pujar a');
if (!defined('_DOWN_EDIT_IN')) DEFINE ('_DOWN_EDIT_IN', 'Editar en');
if (!defined('_DOWN_SUBS_EVERYTHING')) DEFINE ('_DOWN_SUBS_EVERYTHING', 'Comptar totes les descàrregues d´arxius');
if (!defined('_DOWN_SUBS_COUNT_DOWNLOAD')) DEFINE ('_DOWN_SUBS_COUNT_DOWNLOAD', 'Comptar les descàrregues d´un contenidor especifíc');
if (!defined('_DOWN_SUBS_COUNT_UPLOAD')) DEFINE ('_DOWN_SUBS_COUNT_UPLOAD', 'Comptar les pujades a un contenidor específic');
if (!defined('_DOWN_SUBS_COUNT_DOWNLOAD_PLUS')) DEFINE ('_DOWN_SUBS_COUNT_DOWNLOAD_PLUS', 'Comptar les descàrregues d´un contenidor i els seus descendents (subcontenidors)');
if (!defined('_DOWN_SUBS_COUNT_UPLOAD_PLUS')) DEFINE ('_DOWN_SUBS_COUNT_UPLOAD_PLUS', 'Comptar les pujades d´un contenidor i els seus descendents (subcontenidors)');
if (!defined('_DOWN_COUNT_DOWN')) DEFINE ('_DOWN_COUNT_DOWN', 'Gestor de suscriptors per comptar les descàrregues');
if (!defined('_DOWN_COUNT_DOWN_CHILD')) DEFINE ('_DOWN_COUNT_DOWN_CHILD', 'Incloure els descendents en recompte de descàrregues');
if (!defined('_DOWN_COUNT_UP')) DEFINE ('_DOWN_COUNT_UP', 'Gestor de suscriptors per comptar les pujades');
if (!defined('_DOWN_COUNT_UP_CHILD')) DEFINE ('_DOWN_COUNT_UP_CHILD', 'Incloure els descendents en el recompte de pujades');
if (!defined('_DOWN_CONFIG54')) DEFINE ('_DOWN_CONFIG54', '<b>Count_Down:</b><br /><em>(Restringir totes les descàrregues usant el gestor de suscriptors)</em>');
if (!defined('_DOWN_CONFIG53')) DEFINE ('_DOWN_CONFIG53', '<b>Show_File_Folder_Counts:</b><br /><em>(Mostrar recompte en arxiu i carpeta)</em>');
if (!defined('_DOWN_CONFIG52')) DEFINE ('_DOWN_CONFIG52', '<b>Show_Footer:</b><br /><em>(Mostrar el peu de Remository (Cercar/Enviar/Crédits))</em>');
if (!defined('_DOWN_CONFIG51')) DEFINE ('_DOWN_CONFIG51', '<b>Allow_File_Info:</b><br /><em>(Enllaç a informació detallada de l´arxiu des de la llista d´arxius)</em>');
if (!defined('_DOWN_IS_ACTIVE')) DEFINE ('_DOWN_IS_ACTIVE', 'Actiu?');
if (!defined('_DOWN_NEW_REPOSITORY')) DEFINE ('_DOWN_NEW_REPOSITORY', 'Crear un nou contenidor com l´actual');
if (!defined('_DOWN_REPOSITORY_NAME')) DEFINE ('_DOWN_REPOSITORY_NAME', 'Nom del contenidor');
if (!defined('_DOWN_REPOSITORY_NUMBER')) DEFINE ('_DOWN_REPOSITORY_NUMBER', 'Número del contenidor');
if (!defined('_DOWN_REPOSITORY_ALIAS')) DEFINE ('_DOWN_REPOSITORY_ALIAS', 'Alies del contenidor');
// Recent additions 3.46
if (!defined('_DOWN_SUBTITLE')) DEFINE ('_DOWN_SUBTITLE', 'Subtítol de l´arxiu:');
if (!defined('_DOWN_PUBLISHER_ID')) DEFINE ('_DOWN_PUBLISHER_ID', 'ID del publicador:');
if (!defined('_DOWN_PUBLISHED_DATE')) DEFINE ('_DOWN_PUBLISHED_DATE', 'Data de publicació:');
if (!defined('_DOWN_ALIAS')) DEFINE ('_DOWN_ALIAS', 'Alies');
if (!defined('_DOWN_BOTH')) DEFINE ('_DOWN_BOTH', 'Ambdues');
if (!defined('_DOWN_CONFIG50')) DEFINE ('_DOWN_CONFIG50', '<b>Usar ´breadcrumb´ de Remository (pathway)</b>');
if (!defined('_DOWN_SEARCHING_BY')) DEFINE ('_DOWN_SEARCHING_BY', 'Cercar per');
if (!defined('_DOWN_FILTERING_BY')) DEFINE ('_DOWN_FILTERING_BY', 'Filtrar per');
if (!defined('_DOWN_REMOVE_TERM')) DEFINE ('_DOWN_REMOVE_TERM', 'Eliminar terme');
if (!defined('_DOWN_NO_FILTERS')) DEFINE ('_DOWN_NO_FILTERS', 'Cap filtre actiu - es mostren tots els registres');
if (!defined('_DOWN_REVIEW_TAGS')) DEFINE ('_DOWN_REVIEW_TAGS', 'Revisar etiquetes en el grup');
if (!defined('_DOWN_NO_RESULTS_1')) DEFINE ('_DOWN_NO_RESULTS_1', 'Disculpi, la seva cerca no ha trobat cap resultat.');
if (!defined('_DOWN_NO_RESULTS_2')) DEFINE ('_DOWN_NO_RESULTS_2', 'No pot trobar el que busca?');
if (!defined('_DOWN_CONTACT_US')) DEFINE ('_DOWN_CONTACT_US', 'Contacti amb nosaltres i digui´ns quin és el que busca.');
if (!defined('_DOWN_ALL_CATS_RETRY')) DEFINE ('_DOWN_ALL_CATS_RETRY', 'Tornar a intentar aquesta búsqueda amb totes les categories seleccionades?');
if (!defined('_DOWN_ADD_ALL_CATS')) DEFINE ('_DOWN_ADD_ALL_CATS', 'Afegir totes les categories');
if (!defined('_DOWN_CONFIG49')) DEFINE ('_DOWN_CONFIG49', '<b>Tipus de classificació:</b><br /><em>(valors separats per coma)</em>');

// Recent additions 3.45
if (!defined('_DOWN_GROUP_NO_NAME')) DEFINE ('_DOWN_GROUP_NO_NAME', 'Grup no guardat - sense nom');
if (!defined('_DOWN_GROUP_SAVED')) DEFINE ('_DOWN_GROUP_SAVED', 'El grup s´ha guardat');
if (!defined('_DOWN_CONFIG48')) DEFINE ('_DOWN_CONFIG48', '<b>Mostrar feeds RSS</b>');
if (!defined('_DOWN_CONFIG46')) DEFINE ('_DOWN_CONFIG46', '<b>ExtsDisplay:</b><br/><i>(Extensions que poden mostrar-se online (Llista separada per coma))</i>');
if (!defined('_DOWN_DISPLAY_NOW')) DEFINE ('_DOWN_DISPLAY_NOW', 'Mostrar aquest arxiu ara');
if (!defined('_DOWN_CONFIG47')) DEFINE ('_DOWN_CONFIG47', '<b>Clau per publicar en Scribd</b>');
if (!defined('')) DEFINE ('', '');
// Recent addition 3.44.1
if (!defined('_DOWN_AEC_REFUSED')) DEFINE ('_DOWN_AEC_REFUSED', 'Segon AEC ha arribat al seu límit de descàrregues.');

// Recent additions 3.44
if (!defined('_DOWN_FIELD')) DEFINE ('_DOWN_FIELD', 'Camp');
if (!defined('_DOWN_SEQUENCE')) DEFINE ('_DOWN_SEQUENCE', 'Ordenació');
if (!defined('_DOWN_CONFIG_EXPLAIN_1')) DEFINE ('_DOWN_CONFIG_EXPLAIN_1', 'A = Camps per a la llista de fitxers');
if (!defined('_DOWN_CONFIG_EXPLAIN_2')) DEFINE ('_DOWN_CONFIG_EXPLAIN_2', 'B = Camps per als resultats de cerca');
if (!defined('_DOWN_CONFIG_EXPLAIN_3')) DEFINE ('_DOWN_CONFIG_EXPLAIN_3', 'C = Camps per als resultats de múltiples pujades');
if (!defined('_DOWN_ADDFILE_THUMBNAIL')) DEFINE ('_DOWN_ADDFILE_THUMBNAIL', 'Miniatura %u (opcional):');
if (!defined('_DOWN_CONFIG45')) DEFINE('_DOWN_CONFIG45',"Default_Licence:<br/><i>(Opcional - s´utilitzarà per a qualsevol element que no tingui llicència)</i>");
if (!defined('_DOWN_CONFIG_TITLE_LICENCE')) DEFINE('_DOWN_CONFIG_TITLE_LICENCE', 'Llicència');
if (!defined('_DOWN_VISIT')) DEFINE('_DOWN_VISIT','Visita');
if (!defined('_DOWN_EDIT')) DEFINE('_DOWN_EDIT','Edita');
if (!defined('_DOWN_STRUCT_RECURSE_ALL')) DEFINE('_DOWN_STRUCT_RECURSE_ALL','Inclou tots els subdirectoris i els seus fitxers');
if (!defined('_DOWN_STRUCT_RECURSE_DIR')) DEFINE('_DOWN_STRUCT_RECURSE_DIR','Inclou només fitxers i directoris de primer nivell');
if (!defined('_DOWN_STRUCT_RECURSE_NONE')) DEFINE('_DOWN_STRUCT_RECURSE_NONE','Inclou només fitxers del primer nivell');
if (!defined('_DOWN_STRUCT_NO_DIR')) DEFINE ('_DOWN_STRUCT_NO_DIR', 'El directori especificat no existeix');
if (!defined('_DOWN_ADMINISTRATOR')) DEFINE ('_DOWN_ADMINISTRATOR', 'Administrador');
if (!defined('_DOWN_ADMIN_ACT_ADDSTRUCTURE')) DEFINE('_DOWN_ADMIN_ACT_ADDSTRUCTURE','Afegeix fitxers que ja són al servidor');
if (!defined('_DOWN_STRUCTURE_ADDED')) DEFINE('_DOWN_STRUCTURE_ADDED','Fitxers afegits al repositori');
if (!defined('_DOWN_ADDSTRUCTURE_TITLE')) DEFINE('_DOWN_ADDSTRUCTURE_TITLE','afegeix fitxers que ja són al servidor');
if (!defined('_REM_INTERNAL')) DEFINE('_REM_INTERNAL','Error intern del Remository');
if (!defined("_DOWNLOADS_TITLE")) DEFINE("_DOWNLOADS_TITLE","Descàrregues de $mosConfig_sitename");
if (!defined('_UP_FILE')) DEFINE('_UP_FILE','Puja un fitxer');
if (!defined('_ADD_FILE_BUTTON')) DEFINE('_ADD_FILE_BUTTON','Afegeix un fitxer');
if (!defined('_SUBMIT_FILE_BUTTON')) DEFINE('_SUBMIT_FILE_BUTTON','Envia un fitxer');
if (!defined('_DOWN_ROLE_REGISTERED')) DEFINE('_DOWN_ROLE_REGISTERED','Registrat');
if (!defined('_DOWN_ROLE_VISITOR')) DEFINE('_DOWN_ROLE_VISITOR','Visitant');
if (!defined('_DOWN_ROLE_NOBODY')) DEFINE('_DOWN_ROLE_NOBODY','Ningú');
if (!defined('_DOWN_ROLE_NONE_THESE')) DEFINE('_DOWN_ROLE_NONE_THESE','Cap dels anteriors');
if (!defined('_DOWN_PAGE_TEXT')) DEFINE('_DOWN_PAGE_TEXT', 'Pàgina');
if (!defined('_DOWN_PAGE_SHOW_RESULTS')) DEFINE('_DOWN_PAGE_SHOW_RESULTS','Mostra resultats ');
if (!defined('_DOWN_PAGE_SHOW_RANGE')) DEFINE('_DOWN_PAGE_SHOW_RANGE','%s a %s de %s');
if (!defined('_SUBMIT_FILE_NOLOG')) DEFINE('_SUBMIT_FILE_NOLOG', 'Enviament denegat - no esteu conectat');
if (!defined('_SUBMIT_FILE_NOUSER')) DEFINE('_SUBMIT_FILE_NOUSER', 'Enviament denegat - només administradors');
if (!defined('_SUBMIT_FILE_NOLIMIT')) DEFINE('_SUBMIT_FILE_NOLIMIT', 'Enviament denegat - heu arribat al límit');
if (!defined('_SUBMIT_FILE_NOSPACE')) DEFINE('_SUBMIT_FILE_NOSPACE', 'Enviament denegat - no queda espai');
if (!defined('_SUBMIT_NO_DDIR')) DEFINE('_SUBMIT_NO_DDIR', 'Enviament denegat - no hi ha directori de descàrrega');
if (!defined('_SUBMIT_NO_UDDIR')) DEFINE('_SUBMIT_NO_UDDIR', 'Enviament denegat - no hi ha directori de pujada/baixada');
if (!defined('_SUBMIT_HEADING')) DEFINE('_SUBMIT_HEADING', 'Puja un arxiu per a descàrrega');
if (!defined('_SUBMIT_INSTRUCT1')) DEFINE('_SUBMIT_INSTRUCT1', 'Per un nou arxiu, trieu el fitxer a carregar.');
if (!defined('_SUBMIT_INSTRUCT2')) DEFINE('_SUBMIT_INSTRUCT2', 'Si l´allotjareu en una altra destinació, introduïu la URL de l´arxiu i la resta de detalls.');
if (!defined('_SUBMIT_INSTRUCT3')) DEFINE('_SUBMIT_INSTRUCT3', 'Trieu l´arxiu a carregar, i ompliu la resta de dades rellevants.');
if (!defined('_DOWN_FILE_SUBMIT_NOCHOICES')) DEFINE('_DOWN_FILE_SUBMIT_NOCHOICES','No teniu permís per a carregar - contacteu amb el webmestre.');
if (!defined('_SUBMIT_NEW_FILE')) DEFINE('_SUBMIT_NEW_FILE', 'Arxiu nou');
if (!defined('_SUBMIT_UPLOAD_BUTTON')) DEFINE('_SUBMIT_UPLOAD_BUTTON', 'Carrega l´arxiu &amp; Desa');
if (!defined('_MAIN_DOWNLOADS')) DEFINE('_MAIN_DOWNLOADS','Pàgina principal de descàrregues');
if (!defined('_BACK_CAT')) DEFINE('_BACK_CAT','Retorna a la categoria original');
if (!defined('_BACK_FOLDER')) DEFINE('_BACK_FOLDER','Retorna a la carpeta original');
if (!defined('_DOWN_START')) DEFINE('_DOWN_START','La descàrrega començarà d´aquí a 2 seg.');
if (!defined('_DOWN_CLICK')) DEFINE('_DOWN_CLICK','Feu clic aquí si no comença.');
if (!defined('_INVALID_ID')) DEFINE('_INVALID_ID','IDentificador invàlid');
if (!defined('_DOWN_CATEGORY')) DEFINE('_DOWN_CATEGORY','Categoria');
if (!defined('_DOWN_NO_PARENT')) DEFINE('_DOWN_NO_PARENT','No hi ha element pare - nivell superior');
if (!defined('_DOWN_FOLDER')) DEFINE('_DOWN_FOLDER','Carpeta');
if (!defined('_DOWN_FOLDERS')) DEFINE('_DOWN_FOLDERS','Carpetes');
if (!defined('_DOWN_FILES')) DEFINE('_DOWN_FILES','Arxius');
if (!defined('_DOWN_FOLDERS_FILES')) DEFINE('_DOWN_FOLDERS_FILES','Carpetes/Fitxers');
if (!defined("_DOWN_NO_CATS")) DEFINE("_DOWN_NO_CATS","Descàrregues no establertes per <i>$mosConfig_sitename</i>.<br/>&nbsp;<br/>Sense categories definides.");
if (!defined('_DOWN_NO_VISITOR_CATS')) DEFINE('_DOWN_NO_VISITOR_CATS','La secció de descàrregues no és accessible als visitant. Si us plau, connecteu-vos.');
if (!defined('_DOWN_ADMIN_FUNC')) DEFINE('_DOWN_ADMIN_FUNC','Funcions d´administrador:');
if (!defined('_DOWN_ADD_CAT')) DEFINE('_DOWN_ADD_CAT','Afegeix categoria');
if (!defined('_DOWN_DEL_CAT')) DEFINE('_DOWN_DEL_CAT','Elimina categoria');
if (!defined('_DOWN_EDIT_CAT')) DEFINE('_DOWN_EDIT_CAT','Edita categoria');
if (!defined('_DOWN_UP_NEITHER')) DEFINE('_DOWN_UP_NEITHER','Ni uns ni altres');
if (!defined('_DOWN_UP_DOWNLOAD_ONLY')) DEFINE('_DOWN_UP_DOWNLOAD_ONLY','Només descàrregues');
if (!defined('_DOWN_UP_UPLOAD_ONLY')) DEFINE('_DOWN_UP_UPLOAD_ONLY','Només càrregues');
if (!defined('_DOWN_UP_BOTH')) DEFINE('_DOWN_UP_BOTH','Ambdós');
if (!defined('_DOWN_USERS_PERMITTED')) DEFINE('_DOWN_USERS_PERMITTED','Usuaris permesos a:');
if (!defined('_DOWN_VISITORS_PERMITTED')) DEFINE('_DOWN_VISITORS_PERMITTED','Visitants permesos a:');
if (!defined('_DOWN_UP_ABSOLUTE_PATH')) DEFINE('_DOWN_UP_ABSOLUTE_PATH','Ruta absoluta (opcional):');
if (!defined('_DOWN_ADD_FOLDER')) DEFINE('_DOWN_ADD_FOLDER','Afegeix carpeta');
if (!defined('_DOWN_DEL_FOLDER')) DEFINE('_DOWN_DEL_FOLDER','Elimina carpeta');
if (!defined('_DOWN_EDIT_FOLDER')) DEFINE('_DOWN_EDIT_FOLDER','Edita carpeta');
if (!defined('_DOWN_ADD_FILE')) DEFINE('_DOWN_ADD_FILE','Afegeix arxiu');
if (!defined('_DOWN_DEL_FILE')) DEFINE('_DOWN_DEL_FILE','Elimina arxiu');
if (!defined('_DOWN_EDIT_FILE')) DEFINE('_DOWN_EDIT_FILE','Edita arxiu');
if (!defined('_DOWN_PUB')) DEFINE('_DOWN_PUB','Publicat:');
if (!defined('_DOWN_SUBMIT_ANOTHER')) DEFINE('_DOWN_SUBMIT_ANOTHER','Voleu carregar un altre fitxer ara?');
if (!defined('_DOWN_SUBMIT_INSPECT')) DEFINE('_DOWN_SUBMIT_INSPECT','Voleu veure el fitxer acabat de carregar?');
if (!defined('_YES')) DEFINE('_YES','Sí');
if (!defined('_NO')) DEFINE('_NO','No');
if (!defined('_GLOBAL')) DEFINE('_GLOBAL','Global');
if (!defined('_DOWN_DESC')) DEFINE('_DOWN_DESC','Descripció:');
if (!defined('_DOWN_DOWNLOADS')) DEFINE('_DOWN_DOWNLOADS','Descàrregues:');
if (!defined('_DOWN_THUMBNAILS')) DEFINE('_DOWN_THUMBNAILS','Miniatures:');
if (!defined('_DOWN_RATING')) DEFINE('_DOWN_RATING','Puntuació:');
if (!defined('_DOWN_VOTES')) DEFINE('_DOWN_VOTES','Vots totals:');
if (!defined('_DOWN_YOUR_VOTE')) DEFINE('_DOWN_YOUR_VOTE','El teu vot:');
if (!defined('_DOWN_RATE_BUTTON')) DEFINE('_DOWN_RATE_BUTTON','Avalua');
if (!defined('_DOWN_ALREADY_VOTE')) DEFINE('_DOWN_ALREADY_VOTE','Ja heu votat per aquest arxiu. Gràcies.');
if (!defined('_DOWN_FILE_TITLE')) DEFINE('_DOWN_FILE_TITLE','Títol de l´arxiu:');
if (!defined('_DOWN_FILE_TITLE_SORT')) DEFINE('_DOWN_FILE_TITLE_SORT','Títol arxiu');
if (!defined('_DOWN_REAL_NAME')) DEFINE('_DOWN_REAL_NAME','Nom físic de l´arxiu:');
if (!defined('_DOWNLOAD')) DEFINE('_DOWNLOAD','Descàrrega');
if (!defined('_DOWN_DOWNLOADS_SORT')) DEFINE('_DOWN_DOWNLOADS_SORT','Descàrregues');
if (!defined('_DOWN_SUB_BY')) DEFINE('_DOWN_SUB_BY','Enviat per:');
if (!defined('_DOWN_FILE_DATE')) DEFINE('_DOWN_FILE_DATE','Data de l´arxiu:');
if (!defined('_DOWN_FILE_AUTHOR')) DEFINE('_DOWN_FILE_AUTHOR','Autor de l´arxiu:');
if (!defined('_DOWN_FILE_VER')) DEFINE('_DOWN_FILE_VER','Versió de l´arxiu:');
if (!defined('_DOWN_FILE_SIZE')) DEFINE('_DOWN_FILE_SIZE','Mida de l´arxiu:');
if (!defined('_DOWN_FILE_TYPE')) DEFINE('_DOWN_FILE_TYPE','Tipus d´arxiu:');
if (!defined('_DOWN_FILE_COMPANY')) DEFINE('_DOWN_FILE_COMPANY','Empresa:');
if (!defined('_DOWN_FILE_COMPANY_URL')) DEFINE('_DOWN_FILE_COMPANY_URL','URL de l´empresa:');
if (!defined('_DOWN_FILE_AUTHOR_URL')) DEFINE('_DOWN_FILE_AUTHOR_URL','Autor del lloc web:');
if (!defined('_DOWN_FILE_RELEASE_DATE')) DEFINE('_DOWN_FILE_RELEASE_DATE','Data llançament (dd-mm-aaaa):');
if (!defined('_DOWN_FILE_STATUS')) DEFINE('_DOWN_FILE_STATUS','Estat:');
if (!defined('_DOWN_FILE_LANGUAGES')) DEFINE('_DOWN_FILE_LANGUAGES','Idiomes suportats:');
if (!defined('_DOWN_FILE_REQUIREMENTS')) DEFINE('_DOWN_FILE_REQUIREMENTS','Requisits:');
if (!defined('_DOWN_FILE_OPERATING_SYSTEM')) DEFINE('_DOWN_FILE_OPERATING_SYSTEM','Sistema operatiu:');
if (!defined('_DOWN_SCREEN')) DEFINE('_DOWN_SCREEN','Captura de pantalla:');
if (!defined('_DOWN_SCREEN_CLICK')) DEFINE('_DOWN_SCREEN_CLICK','Feu clic per veure');
if (!defined('_DOWN_NA')) DEFINE('_DOWN_NA','N/A');
if (!defined('_DOWN_CAT_NAME')) DEFINE('_DOWN_CAT_NAME','Nom categoria:');
if (!defined('_DOWN_SUB_BUTTON')) DEFINE('_DOWN_SUB_BUTTON','Buscar');
if (!defined('_DOWN_ALL_DONE')) DEFINE('_DOWN_ALL_DONE','Fet!');
if (!defined('_DOWN_NOT_AUTH')) DEFINE('_DOWN_NOT_AUTH','Sense autorització!');
if (!defined('_DOWN_FOLDER_NAME')) DEFINE('_DOWN_FOLDER_NAME','Nom carpeta:');
if (!defined('_DOWN_FOLDER_ADD_BUT')) DEFINE('_DOWN_FOLDER_ADD_BUT','Afegeix carpeta');
if (!defined('_DOWN_UP_WAIT')) DEFINE('_DOWN_UP_WAIT','Nota: tots els enviaments es revisaran abans de publicar-se.');
if (!defined('_DOWN_AUTOAPP')) DEFINE('_DOWN_AUTOAPP','El vostre arxiu s´ha aprovat i publicat automàticament.');
if (!defined('_DOWN_APPROVE_PUB')) DEFINE('_DOWN_APPROVE_PUB','Aprova i publica');
if (!defined('_DOWN_SUGGEST_LOC')) DEFINE('_DOWN_SUGGEST_LOC','Suggereix ubicació');
if (!defined('_DOWNLOAD_URL')) DEFINE('_DOWNLOAD_URL','Descàrrega URL:');
if (!defined('_DOWN_ICON')) DEFINE('_DOWN_ICON','Icona:');
if (!defined('_DOWN_MOVE_FILE')) DEFINE('_DOWN_MOVE_FILE','Mou l´arxiu:');
if (!defined('_DOWN_MOVE_FILE_FAILED')) DEFINE('_DOWN_MOVE_FILE_FAILED','No s´ha pogut moure l´arxiu');
if (!defined('_DOWN_FILE_NEW_LOC')) DEFINE('_DOWN_FILE_NEW_LOC','Nova ubicació de l´arxiu:');
if (!defined('_DOWN_AWAIT_APPROVE')) DEFINE('_DOWN_AWAIT_APPROVE','Arxius enviats a l´espera d´aprovació:');
if (!defined('_DOWN_ADMIN_APPROVE')) DEFINE('_DOWN_ADMIN_APPROVE','Aprova els enviats');
if (!defined('_DOWN_ID')) DEFINE('_DOWN_ID','ID');
if (!defined('_DOWN_SUBMIT_DATE')) DEFINE('_DOWN_SUBMIT_DATE','Data enviament:');
if (!defined('_DOWN_APP_SUB_BUTTON')) DEFINE('_DOWN_APP_SUB_BUTTON','Aprova enviat');
if (!defined('_DOWN_DEL_SUB_BUTTON')) DEFINE('_DOWN_DEL_SUB_BUTTON','Elimina enviat');
if (!defined('_DOWN_SUB_APPROVE')) DEFINE('_DOWN_SUB_APPROVE','L´enviament s´ha aprovat.');
if (!defined('_DOWN_SUB_DEL')) DEFINE('_DOWN_SUB_DEL','L´enviament s´ha eliminat.');
if (!defined('_DOWN_NO_SUB')) DEFINE('_DOWN_NO_SUB','No hi ha més enviats per revisar.');
if (!defined('_DOWN_REV_SUB')) DEFINE('_DOWN_REV_SUB','Revisa més arxius enviats');
if (!defined('_DOWN_SEARCH')) DEFINE('_DOWN_SEARCH','Cerca descàrrega');
if (!defined('_DOWN_SEARCH_TEXT')) DEFINE('_DOWN_SEARCH_TEXT','Cerca:');
if (!defined('_DOWN_SEARCH_FILETITLE')) DEFINE('_DOWN_SEARCH_FILETITLE','Cerca als títols de les descàrregues:');
if (!defined('_DOWN_SEARCH_FILEDESC')) DEFINE('_DOWN_SEARCH_FILEDESC','Cerca a les descripcions de les descàrregues:');
if (!defined('_DOWN_SEARCH_ERR')) DEFINE('_DOWN_SEARCH_ERR','Heu d´especificar Títol i Descripció de l´arxiu per buscar, també amb text.');
if (!defined('_DOWN_SEARCH_NORES')) DEFINE('_DOWN_SEARCH_NORES','No s´ha trobat cap arxiu.');
if (!defined('_DOWN_FILE_HOMEPAGE')) DEFINE('_DOWN_FILE_HOMEPAGE','Pàgina d´arxiu:');
if (!defined('_DOWN_UPDATE_SUB')) DEFINE('_DOWN_UPDATE_SUB','Actualitza arxiu enviat');
if (!defined('_DOWN_UP_EDIT_ID')) DEFINE('_DOWN_UP_EDIT_ID','ID d´arxiu:');
if (!defined('_DOWN_FILE_DEL_NOTE')) DEFINE('_DOWN_FILE_DEL_NOTE','Nota: el llistat de l´arxiu s´ha eliminat de la base de dades, però l´arxiu <b>pot</b> existir encara. Si us plau, reviseu el seu directori.');
if (!defined('_DOWN_SUB_DATE')) DEFINE('_DOWN_SUB_DATE','Enviat el:');
if (!defined('_DOWN_SUB_DATE_SORT')) DEFINE('_DOWN_SUB_DATE_SORT','Data enviament');
if (!defined('_DOWN_SUB_ID_SORT')) DEFINE('_DOWN_SUB_ID_SORT', 'Autor');
if (!defined('_DOWN_COMMENTS')) DEFINE('_DOWN_COMMENTS','Comentaris:');
if (!defined('_DOWN_YOUR_COMM')) DEFINE('_DOWN_YOUR_COMM','El vostre comentari:');
if (!defined('_DOWN_LEAVE_COMM')) DEFINE('_DOWN_LEAVE_COMM','Deixa un comentari');
if (!defined('_DOWN_FIRST_COMMENT')) DEFINE('_DOWN_FIRST_COMMENT','Sigueu el primer a comentar aquest arxiu!');
if (!defined('_DOWN_FIRST_COMMENT_NL')) DEFINE('_DOWN_FIRST_COMMENT_NL','Sigueu el primer a comentar. Entreu o registreu-vos.');
if (!defined('_DOWN_ALREADY_COMM')) DEFINE('_DOWN_ALREADY_COMM','Ja heu comentat aquest arxiu.');
if (!defined("_DOWN_MAX_COMM")) DEFINE("_DOWN_MAX_COMM","Màx: $Small_Text_Len caràcters");
if (!defined("_DOWN_DESC_MAX")) DEFINE("_DOWN_DESC_MAX","Màx: $Large_Text_Len caràcters");
if (!defined('_DOWN_MAIL_SUB')) DEFINE('_DOWN_MAIL_SUB','Nous enviaments de descàrregues');
if (!defined('_DOWN_MAIL_MSG')) DEFINE('_DOWN_MAIL_MSG','Hola, l´usuari $user_full ha enviat una descàrrega'
                   .' pel lloc $mosConfig_sitename.\n'
                   .'Si us plau entreu a $mosConfig_live_site/administrator/index.php com a administrador per veure i aprovar aquest enviament.\n\n'
                   .'No respongueu aquest missatge ja que ha estat generat automàticament i és només per informar\n');
if (!defined('_DOWN_MAIL_MSG_APP')) DEFINE('_DOWN_MAIL_MSG_APP','Hola, l´usuari $user_full ha enviat una descàrrega'
                   .' pel lloc $mosConfig_sitename.\n'
                   .'D´acord amb les opcions de configuració, s´ha aprovat automàticament.\n\n'
                   .'No respongueu a aquest missatge ja que ha estat generat automàticament i és només per informar\n');
if (!defined('_DOWN_ORDER_BY')) DEFINE('_DOWN_ORDER_BY','Ordena per :');
if (!defined('_DOWN_RESET')) DEFINE('_DOWN_RESET','Recalcula el nombre d´arxius');
if (!defined('_DOWN_RESET_GO')) DEFINE('_DOWN_RESET_GO','S´està recalculant el nombre d´arxius...');
if (!defined('_DOWN_RESET_DONE')) DEFINE('_DOWN_RESET_DONE','Recàlcul d´arxius completats');
if (!defined('_DOWN_FIND_ORPHANS')) DEFINE('_DOWN_FIND_ORPHANS','Busca arxius orfes');
if (!defined('_DOWN_DEL_ORPHANS')) DEFINE('_DOWN_DEL_ORPHANS','Elimina els arxius orfes');
if (!defined('_DOWN_ORPHAN_SELECT')) DEFINE('_DOWN_ORPHAN_SELECT','Sel·lecciona');
if (!defined('_DOWN_ORPHAN_FILE_DEL')) DEFINE('_DOWN_ORPHAN_FILE_DEL','Arxiu per eliminar');
if (!defined('_DOWN_ORPHAN_NODEL')) DEFINE('_DOWN_ORPHAN_NODEL','No hi ha arxius per eliminar');
if (!defined('_DOWN_ORPHAN_DONE')) DEFINE('_DOWN_ORPHAN_DONE','Els arxius orfes han estat eliminats');
if (!defined('_DOWN_BAD_POST')) DEFINE('_DOWN_BAD_POST','Els paràmentres no s´han enviat correctament.');
if (!defined('_DOWN_SUB_WAIT')) DEFINE('_DOWN_SUB_WAIT','Un enviament ja està en revisió per aquest arxiu.');
if (!defined('_DOWN_REG_ONLY')) DEFINE('_DOWN_REG_ONLY','Només usuaris registrats:');
if (!defined('_DOWN_RESTRICTED_WARN')) DEFINE('_DOWN_RESTRICTED_WARN','Aquesta àrea no existeix o no es troba disponible');
if (!defined('_DOWN_MEMBER_ONLY_WARN')) DEFINE('_DOWN_MEMBER_ONLY_WARN',"Aquesta localització és només per a Membres del Grup.<BR />"
                             ."Si us plau, contacteu amb l'administrador del grup corresponent.");
if (!defined("_DOWN_REG_ONLY_WARN")) DEFINE("_DOWN_REG_ONLY_WARN","Aquesta localització és només per a Usuaris Registrats.<BR />"
                             ."Si us plau, entreu o <a href='index.php?option=com_registration&task=register'>Registreu-vos</a>.");
if (!defined('_DOWN_COUNT_EXCEEDED')) DEFINE('_DOWN_COUNT_EXCEEDED',"Heu arribat al vostre límit de descàrregues");
if (!defined('_DOWN_COUNT_EXCEEDED_FILE')) DEFINE('_DOWN_COUNT_EXCEEDED_FILE',"Heu arribat al límit de descàrregues per aquest fitxer");
if (!defined('_DOWN_NO_FILEN')) DEFINE('_DOWN_NO_FILEN','Heu d´introduïr un títol per l´arxiu');
if (!defined('_DOWN_MINI_SCREEN_PROMPT')) DEFINE('_DOWN_MINI_SCREEN_PROMPT','Mostra la captura de pantalla:');
if (!defined('_DOWN_SEL_LOC_PROMPT')) DEFINE('_DOWN_SEL_LOC_PROMPT','Tria ubicació');
if (!defined('_DOWN_ALL_LOC_PROMPT')) DEFINE('_DOWN_ALL_LOC_PROMPT','Totes les ubicacions');
if (!defined('_DOWN_SEL_CAT_DEL')) DEFINE('_DOWN_SEL_CAT_DEL','Tria una categoria per eliminar');
if (!defined('_DOWN_NO_CAT_DEF')) DEFINE('_DOWN_NO_CAT_DEF','No hi ha categories definides');
if (!defined('_DOWN_PUB_PROMPT')) DEFINE('_DOWN_PUB_PROMPT','Tria una categoria per a ');
if (!defined('_DOWN_SEL_FILE_DEL')) DEFINE('_DOWN_SEL_FILE_DEL','Tria un arxiu per eliminar'); 
if (!defined('_DOWN_CONFIG_COMP')) DEFINE('_DOWN_CONFIG_COMP','S´han actualitzat els detalls de la configuració.');
if (!defined("_DOWN_CONFIG_ERR")) DEFINE("_DOWN_CONFIG_ERR","S´ha produït un error.\nNo es pot obrir l´arxiu de configuració per escriptura.");
if (!defined('_DOWN_CATS')) DEFINE('_DOWN_CATS','Categories');
if (!defined('_DOWN_PARENT_CAT')) DEFINE('_DOWN_PARENT_CAT','Categoria pare');
if (!defined('_DOWN_PARENT_FOLDER')) DEFINE('_DOWN_PARENT_FOLDER','Carpeta');
if (!defined('_DOWN_PUB1')) DEFINE('_DOWN_PUB1','Publicat');
if (!defined('_DOWN_RECORDS')) DEFINE('_DOWN_RECORDS','Documents');
if (!defined('_DOWN_ACCESS')) DEFINE('_DOWN_ACCESS','Accés');
if (!defined('_DOWN_GROUP')) DEFINE('_DOWN_GROUP','Grup');
if (!defined('_DOWN_FILE_SYSTEM')) DEFINE('_DOWN_FILE_SYSTEM','Sistema de fitxers');
if (!defined('_DOWN_FILE_SYSTEM_OK')) DEFINE('_DOWN_FILE_SYSTEM_OK','Sistema de fitxers - Correcte');
if (!defined('_DOWN_DIRECTORY_NON_EXISTENT')) DEFINE('_DOWN_DIRECTORY_NON_EXISTENT','El directori no existeix');
if (!defined('_DOWN_NOT_WRITEABLE')) DEFINE('_DOWN_NOT_WRITEABLE','No es pot escriure al directori');
if (!defined('_DOWN_WRITEABLE')) DEFINE('_DOWN_WRITEABLE','Es pot escriure al directori');
if (!defined('_DOWN_DATABASE')) DEFINE('_DOWN_DATABASE','Base de dades');
if (!defined('_DOWN_ADMIN_CPANEL_STORE')) DEFINE('_DOWN_ADMIN_CPANEL_STORE','Emmagatzemament per defecte dels nous contenidors:');
if (!defined('_DOWN_ADMIN_CPANEL_FILESTORE')) DEFINE ('_DOWN_ADMIN_CPANEL_FILESTORE','Emmagatzemament de fitxers per defecte:');
if (!defined('_DOWN_ADMIN_CPANEL_UPLOADS')) DEFINE ('_DOWN_ADMIN_CPANEL_UPLOADS','Àrea per a les pujades:');
if (!defined('_DOWN_CPANEL_RETURN')) DEFINE ('_DOWN_CPANEL_RETURN','Panell de control');
if (!defined('_DOWN_CPANEL_SUB_BASIC')) DEFINE ('_DOWN_CPANEL_SUB_BASIC','Gestió bàsica');
if (!defined('_DOWN_CPANEL_SUB_FILES')) DEFINE ('_DOWN_CPANEL_SUB_FILES','Gestió de fitxers');
if (!defined('_DOWN_CPANEL_SUB_HKEEP')) DEFINE ('_DOWN_CPANEL_SUB_HKEEP','Manteniment');
if (!defined('_DOWN_CPANEL_SUB_UTILS')) DEFINE ('_DOWN_CPANEL_SUB_UTILS','Utilitats');
if (!defined('_DOWN_CPANEL_SUB_INFO')) DEFINE ('_DOWN_CPANEL_SUB_INFO','Informació');
if (!defined('_DOWN_ADMIN_ACT_CONTAINERS')) DEFINE('_DOWN_ADMIN_ACT_CONTAINERS','Gestió de contenidors');
if (!defined('_DOWN_ADMIN_ACT_FILES')) DEFINE('_DOWN_ADMIN_ACT_FILES','Gestió de fitxers');
if (!defined('_DOWN_ADMIN_ACT_GROUPS')) DEFINE('_DOWN_ADMIN_ACT_GROUPS','Gestió de grups');
if (!defined('_DOWN_ADMIN_ACT_UPLOADS')) DEFINE('_DOWN_ADMIN_ACT_UPLOADS','Aprova les pujades');
if (!defined('_DOWN_ADMIN_ACT_CONFIG')) DEFINE('_DOWN_ADMIN_ACT_CONFIG','Configuració');
if (!defined('_DOWN_ADMIN_ACT_UNLINKED')) DEFINE('_DOWN_ADMIN_ACT_UNLINKED','Gestiona els fitxers orfes o sense enllaç');
if (!defined('_DOWN_ADMIN_ACT_FTP')) DEFINE('_DOWN_ADMIN_ACT_FTP','Afegeix arxius en massa des del servidor');
if (!defined('_DOWN_ADMIN_ACT_MISSING')) DEFINE('_DOWN_ADMIN_ACT_MISSING','Anomena els fitxers desapareguts');
if (!defined('_DOWN_ADMIN_ACT_COUNTS')) DEFINE('_DOWN_ADMIN_ACT_COUNTS','Torna a comptar els fitxers');
if (!defined('_DOWN_ADMIN_ACT_DOWNLOADS')) DEFINE('_DOWN_ADMIN_ACT_DOWNLOADS','Reinicia els comptadors de descàrrega');
if (!defined('_DOWN_ADMIN_ACT_PRUNE')) DEFINE('_DOWN_ADMIN_ACT_PRUNE','Neteja el registre');
if (!defined('_DOWN_ADMIN_ACT_THUMBS')) DEFINE('_DOWN_ADMIN_ACT_THUMBS','Comprova la integritat de les miniatures');
if (!defined('_DOWN_ADMIN_ACT_DBCONVERT')) DEFINE('_DOWN_ADMIN_ACT_DBCONVERT','Converteix una BD anterior al 3.20');
if (!defined('_DOWN_ADMIN_ACT_DBCONVERT2')) DEFINE('_DOWN_ADMIN_ACT_DBCONVERT2','Converteix una BD anterior al 3.40');
if (!defined('_DOWN_ADMIN_ACT_STATS')) DEFINE('_DOWN_ADMIN_ACT_STATS','Estadístiques');
if (!defined('_DOWN_ADMIN_ACT_ABOUT')) DEFINE('_DOWN_ADMIN_ACT_ABOUT','Quant al Remository...');
if (!defined('_DOWN_ADMIN_ACT_SUPPORT')) DEFINE('_DOWN_ADMIN_ACT_SUPPORT','Suport i Programació');
if (!defined('_DOWN_MOST_DOWNLOADED')) DEFINE('_DOWN_MOST_DOWNLOADED','Més descarregat');
if (!defined('_DOWN_MOST_DOWNLOADED_LONG')) DEFINE('_DOWN_MOST_DOWNLOADED_LONG','Fitxers amb el comptador de descàrregues més alt');
if (!defined('_DOWN_POPULAR')) DEFINE ('_DOWN_POPULAR','Fitxers populars');
if (!defined('_DOWN_POPULAR_LONG')) DEFINE ('_DOWN_POPULAR_LONG','Fitxers més descarregats en els últims %s dies');
if (!defined('_DOWN_NEWEST')) DEFINE ('_DOWN_NEWEST','Fitxers recents');
if (!defined('_DOWN_NEWEST_LONG')) DEFINE ('_DOWN_NEWEST_LONG','Últim fitxer del repositori');
if (!defined('_DOWN_VISITORS')) DEFINE('_DOWN_VISITORS','Visitants');
if (!defined('_DOWN_REG_USERS')) DEFINE ('_DOWN_REG_USERS','Usuaris registrats');
if (!defined('_DOWN_OTHER_USERS')) DEFINE ('_DOWN_OTHER_USERS', 'Altres usuaris');
if (!defined('_DOWN_STORAGE_STATUS')) DEFINE ('_DOWN_STORAGE_STATUS','Estat d´emmagatzemament');
if (!defined('_DOWN_ALL_REGISTERED')) DEFINE('_DOWN_ALL_REGISTERED','Només usuaris registrats');
if (!defined('_DOWN_REG_ONLY_TITLE')) DEFINE('_DOWN_REG_ONLY_TITLE','Només registrats');
if (!defined('_DOWN_PUBLIC_TITLE')) DEFINE('_DOWN_PUBLIC_TITLE','Públic');
if (!defined('_DOWN_APPROVE_TITLE')) DEFINE('_DOWN_APPROVE_TITLE','Arxius per aprovar');
if (!defined('_DOWN_DATE')) DEFINE('_DOWN_DATE','Data');
if (!defined('_DOWN_NAME_TITLE')) DEFINE('_DOWN_NAME_TITLE','Nom');
if (!defined('_DOWN_CONFIG_TITLE')) DEFINE('_DOWN_CONFIG_TITLE','Configuració');
if (!defined('_DOWN_CONFIG_TITLE1')) DEFINE('_DOWN_CONFIG_TITLE1','Rutes i miscel·lània');
if (!defined('_DOWN_CONFIG_TITLE2')) DEFINE('_DOWN_CONFIG_TITLE2','Permisos');
if (!defined('_DOWN_CONFIG_TITLE3')) DEFINE('_DOWN_CONFIG_TITLE3','Text de descàrrega');
if (!defined('_DOWN_CONFIG_TITLE4')) DEFINE('_DOWN_CONFIG_TITLE4','Configura les pàgines');
if (!defined('_DOWN_CONFIG_TITLE_PREAMBLE')) DEFINE('_DOWN_CONFIG_TITLE_PREAMBLE','Introducció');
if (!defined("_DOWN_CONFIG1")) DEFINE("_DOWN_CONFIG1","TabClass:<br/><i>(MOS CSS Colors de la fila que s´alternen (dos valors separats per una coma)</i>");
if (!defined("_DOWN_CONFIG2")) DEFINE("_DOWN_CONFIG2","TabHeader:<br/><i>(MOS CSS Capçalera de la pàgina i fons del panell d'administració)</i>");
if (!defined("_DOWN_CONFIG3")) DEFINE("_DOWN_CONFIG3","Web_Down_Path:<br/><i>(Ruta al directori de descàrregues - Webs - Sense barra inclinada)</i>");
if (!defined("_DOWN_CONFIG4")) DEFINE("_DOWN_CONFIG4","Down_Path:<br/><i>(Ruta al directori de descàrregues - Arxius - Sense barra inclinada)</i>");
if (!defined("_DOWN_CONFIG5")) DEFINE("_DOWN_CONFIG5","Up_Path:<br/><i>(Ruta al directori d´arxius enviats - Sense barra inclinada)</i>");
if (!defined("_DOWN_CONFIG6")) DEFINE("_DOWN_CONFIG6","MaxSize:<br/><i>(Tamany màxim dels arxius enviats en Kb's)</i>");
if (!defined("_DOWN_CONFIG7")) DEFINE("_DOWN_CONFIG7","Max_Up_Per_Day:<br/><i>(Nombre màxim d´arxius enviats permesos per usuari al dia (administrador il·limitat))</i>");
if (!defined("_DOWN_CONFIG8")) DEFINE("_DOWN_CONFIG8","Max_Up_Dir_Space:<br/><i>(Tamany màxim aprovat al directori de pujades en Kb's)</i>");
if (!defined("_DOWN_CONFIG9")) DEFINE("_DOWN_CONFIG9","ExtsOk:<br/><i>(Extensions aprovades pels arxius enviats (separador de llista, la coma))</i>");
if (!defined("_DOWN_CONFIG10")) DEFINE("_DOWN_CONFIG10","Allowed_Desc_Tags:<br/><i>(Etiquetes HTML permeses pels arxius de descàrregues. (separador de llista, la coma))</i>");
if (!defined("_DOWN_CONFIG11")) DEFINE("_DOWN_CONFIG11","Allow_Up_Overwrite:<br/><i>(Permet que els nous arxius enviats sobreescriguin els arxius existents)</i>");
if (!defined("_DOWN_CONFIG12")) DEFINE("_DOWN_CONFIG12","Allow_User_Sub:<br/><i>(Permet que els usuaris enviïn arxius - els arxius hauran de ser aprovats per l´administrador)</i>");
if (!defined("_DOWN_CONFIG13")) DEFINE("_DOWN_CONFIG13","Allow_User_Edit:<br/><i>(Permet que els usuaris corregeixin els arxius que han enviat - tots els arxius necessitaran ser reaprovats per l´administrador)</i>");
if (!defined("_DOWN_CONFIG14")) DEFINE("_DOWN_CONFIG14","Allow_User_Up:<br/><i>(Permet que els usuaris pengin arxius - tots els arxius necessitaran ser aprovats per l´administrador)</i>");
if (!defined("_DOWN_CONFIG15")) DEFINE("_DOWN_CONFIG15","Allow_Comments:<br/><i>(Permet que els usuaris pugin comentar els arxius)</i>");
if (!defined("_DOWN_CONFIG16")) DEFINE("_DOWN_CONFIG16","Send_Sub_Mail:<br/><i>(Envia un correu a l´administrador (o al suplent) quan un usuari pengi un arxiu)</i>");
if (!defined("_DOWN_CONFIG17")) DEFINE("_DOWN_CONFIG17","Sub_Mail_Alt_Addr:<br/><i>(Adreça de correu alternativa per enviar els avisos d´arxius penjats, sino, s´usarà el correu de l´administrador)</i>");
if (!defined("_DOWN_CONFIG18")) DEFINE("_DOWN_CONFIG18","Sub_Mail_Alt_Name:<br/><i>(Títol alternatiu per les notificacions de d´arxius penjats)</i>");
if (!defined("_DOWN_CONFIG19")) DEFINE("_DOWN_CONFIG19","HeaderPic:<br/><i>(Gràfic de la capçalera)</i>");
if (!defined("_DOWN_CONFIG20")) DEFINE("_DOWN_CONFIG20","Anti-Leach:<br/><i>(Màscara d´arxiu per a prevenir un enllaç directe)</i>");
if (!defined("_DOWN_CONFIG21")) DEFINE("_DOWN_CONFIG21","Large_Text_Len:<br/><i>(Longitud màxim dels camps de text grans (Descripció/Licència))</i>");
if (!defined("_DOWN_CONFIG22")) DEFINE("_DOWN_CONFIG22","Small_Text_Len:<br/><i>(Longitud màxim dels camps de text petits)</i>");
if (!defined("_DOWN_CONFIG23")) DEFINE("_DOWN_CONFIG23","Small_Image_Width:<br/><i>(Amplada de les imatges petites)</i>");
if (!defined("_DOWN_CONFIG24")) DEFINE("_DOWN_CONFIG24","Small_Image_Height:<br/><i>(Alçada de les imatges petites)</i>");
if (!defined("_DOWN_CONFIG25")) DEFINE("_DOWN_CONFIG25","Allow_Votes:<br/><i>(Permet que els usuaris votin els arxius)</i>");
if (!defined("_DOWN_CONFIG26")) DEFINE("_DOWN_CONFIG26","Enable_Admin_Autoapp:<br/><i>(Els arxius carregats per l´administrador que s´aproven i publiquen automàticament)</i>");
if (!defined("_DOWN_CONFIG27")) DEFINE("_DOWN_CONFIG27","Enable_User_Autoapp:<br/><i>(Els arxius carregats pels usuaris registrats s´aproven i publiquen automàticament)</i>");
if (!defined("_DOWN_CONFIG28")) DEFINE("_DOWN_CONFIG28","Enable_List_Downloads:<br/><i>(Permet les descàrregues de la llista d´arxius categories/directoris)</i>");
if (!defined("_DOWN_CONFIG29")) DEFINE("_DOWN_CONFIG29","Permet que els usuaris enviïn els seus arxius remotament:<br/><i>(Arxius que es troben en algun lloc)</i>");
if (!defined("_DOWN_CONFIG30")) DEFINE("_DOWN_CONFIG30","Favourites_Max:<br/><i>(Permet que els usuaris registrin els seus arxius preferits)</i>");
if (!defined("_DOWN_CONFIG31")) DEFINE("_DOWN_CONFIG31","Date_Format:<br/><i>(Ajustar el format de les dates de descàrrega - paràmetre 1 de la funció de la data en PHP)</i>");
if (!defined("_DOWN_CONFIG32")) DEFINE("_DOWN_CONFIG32","Default_Version:<br/><i>(Valor per defecte a donar a l´arxiu enviat)</i>");
if (!defined('_DOWN_CONFIG33')) DEFINE('_DOWN_CONFIG33','See_Containers_no_download:<br/><i>(Permet als usuaris veure les categories/carpetes que no es poden descarregar)</i>');
if (!defined('_DOWN_CONFIG34')) DEFINE('_DOWN_CONFIG34','See_Files_no_download:<br/><i>(Permet als usuaris veure els fitxers que no es poden descarregar)</i>');
if (!defined('_DOWN_CONFIG35')) DEFINE('_DOWN_CONFIG35','Max_Thumbnails:<br/><i>(Nombre màxim de miniatures a emmagatzemar; 0 per només URL)</i>');
if (!defined("_DOWN_CONFIG36")) DEFINE("_DOWN_CONFIG36","Large_Image_Width:<br/><i>(Amplada de captura de pantala gran)</i>");
if (!defined("_DOWN_CONFIG37")) DEFINE("_DOWN_CONFIG37","Large_Image_Height:<br/><i>(Alçada de captura de pantalla gran)</i>");
if (!defined("_DOWN_CONFIG38")) DEFINE("_DOWN_CONFIG38","Permet mostrar imatges grans:<br/><i>(Finestra emergent de captura de pantalla)</i>");
if (!defined("_DOWN_CONFIG39")) DEFINE("_DOWN_CONFIG39","Emmagatzema els fitxers a la base de dades, per defecte");
if (!defined("_DOWN_CONFIG40")) DEFINE("_DOWN_CONFIG40","Max_Down_Per_Day:<br/><i>(Nombre màxim de descàrregues permeses a un usuari en un dia (L´administrador ho té il·limitat))</i>");
if (!defined("_DOWN_CONFIG41")) DEFINE("_DOWN_CONFIG41","Max_Down_File_Day:<br/><i>(Nombre màxim de descàrregues permeses d´un mateix fitxer a un usuari en un dia (L´administrador ho té il·limitat))</i>");
if (!defined("_DOWN_CONFIG42")) DEFINE("_DOWN_CONFIG42","Allow_User_Delete:<br/><i>(Qui ha enviat el fitxer també el pot esborrar)</i>");
if (!defined('_DOWN_CONFIG43')) DEFINE('_DOWN_CONFIG43','Make_Auto_Thumbnail:<br/><i>(Crear automàticament miniatures per fitxers d´imatge)</i>');
if (!defined("_DOWN_CONFIG44")) DEFINE("_DOWN_CONFIG44","Max_Down_Reg_Day:<br/><i>(Nombre màxim de descàrregues permeses d´un usuari registrat en un dia (L´administrador ho té il·limitat))</i>");
if (!defined('_DOWN_STATS_TITLE')) DEFINE('_DOWN_STATS_TITLE','Estats');
if (!defined('_DOWN_TOP_TITLE')) DEFINE('_DOWN_TOP_TITLE','Top');
if (!defined('_DOWN_RATED_TITLE')) DEFINE('_DOWN_RATED_TITLE','Clasificació');
if (!defined('_DOWN_VOTED_ON')) DEFINE('_DOWN_VOTED_ON','Vot a');
if (!defined('_DOWN_VOTES_TITLE')) DEFINE('_DOWN_VOTES_TITLE','Vots');
if (!defined('_DOWN_RATING_TITLE')) DEFINE('_DOWN_RATING_TITLE','Puntuació');
if (!defined('_DOWN_ABOUT')) DEFINE('_DOWN_ABOUT','Quant a');
if (!defined('_DOWN_SUPPORT')) DEFINE('_DOWN_SUPPORT','Suport');
if (!defined('_DOWN_ABOUT_DESCRIBE')) DEFINE('_DOWN_ABOUT_DESCRIBE','Remository - Un repositori per a Joomla/MamboOpenSource 4.5+');
if (!defined('_DOWN_TITLE_ABOUT')) DEFINE('_DOWN_TITLE_ABOUT','Títol');
if (!defined('_DOWN_VERSION_ABOUT')) DEFINE('_DOWN_VERSION_ABOUT','Versió');
if (!defined('_DOWN_AUTHOR_ABOUT')) DEFINE('_DOWN_AUTHOR_ABOUT','Autor');
if (!defined('_DOWN_WEBSITE_ABOUT')) DEFINE('_DOWN_WEBSITE_ABOUT','Lloc web');
if (!defined('_DOWN_EMAIL_ABOUT')) DEFINE('_DOWN_EMAIL_ABOUT','E-mail');
if (!defined('_DOWN_SEL_FILE_APPROVE')) DEFINE('_DOWN_SEL_FILE_APPROVE','Tria un fitxer per aprovar'); 
if (!defined('_DOWN_DESC_SMALL')) DEFINE('_DOWN_DESC_SMALL','Descripció:');
if (!defined('_DOWN_DESC_SMALL_MAX')) DEFINE('_DOWN_DESC_SMALL_MAX','Màx: 150 caràcters');
if (!defined('_DOWN_AUTO_SHORT')) DEFINE('_DOWN_AUTO_SHORT','Autogenera breu descripció:');
if (!defined('_DOWN_LICENSE')) DEFINE('_DOWN_LICENSE','Llicència:');
if (!defined('_DOWN_LICENSE_AGREE')) DEFINE('_DOWN_LICENSE_AGREE','Heu d´acceptar la llicència:');
if (!defined('_DOWN_LEECH_WARN')) DEFINE('_DOWN_LEECH_WARN','La vostra sessió no és vàlida i les mesures de seguretat encara són vigents.');
if (!defined('_DOWN_LICENSE_WARN')) DEFINE('_DOWN_LICENSE_WARN','Si us plau, llegiu i accepteu la llicència abans de començar la descàrrega.');
if (!defined('_DOWN_LICENSE_CHECKBOX')) DEFINE('_DOWN_LICENSE_CHECKBOX','Esctic d´acord amb els termes especificats.');
if (!defined("_DOWN_DATE_FORMAT")) DEFINE("_DOWN_DATE_FORMAT","%d %B %Y"); //Uses PHP's strftime Command Format
if (!defined('_DOWN_FILE_NOTFOUND')) DEFINE('_DOWN_FILE_NOTFOUND','No s´ha trobat l´arxiu');
if (!defined('_DOWN_ACCESS_GROUP')) DEFINE('_DOWN_ACCESS_GROUP','Grup permès:');
if (!defined('_DOWN_THUMB_WRONG_TYPE')) DEFINE('_DOWN_THUMB_WRONG_TYPE','<h3>Les miniuatures han de ser png, jpg o jpeg</h3>');
if (!defined('_DOWN_EXTENSION_IN_TITLE')) DEFINE('_DOWN_EXTENSION_IN_TITLE','Extensió al títol');
if (!defined('_DOWN_INHERIT')) DEFINE('_DOWN_INHERIT','Herència dels contenidors fills?');
if (!defined('_DOWN_FORCE_INHERIT')) DEFINE('_DOWN_FORCE_INHERIT','Força els fills a heredar-ho');
if (!defined('_DOWN_EXT_IN_TITLE')) DEFINE('_DOWN_EXT_IN_TITLE','Extensió al títol');
if (!defined('_DOWN_BULK_ADD_FILES')) DEFINE('_DOWN_BULK_ADD_FILES','afegeix fitxers en massa des del directori de descàrregues');
if (!defined('_DOWN_NO_AVAILABLE_FILES')) DEFINE('_DOWN_NO_AVAILABLE_FILES','No hi ha arxius disponibles');
if (!defined('_DOWN_ABS_PATH_TO_FILES')) DEFINE('_DOWN_ABS_PATH_TO_FILES','Camí absolut als fitxers:');
if (!defined('_DOWN_ACCEPTABLE_EXTENSIONS')) DEFINE('_DOWN_ACCEPTABLE_EXTENSIONS','Extensions acceptables (separades per comes):');
if (!defined('_DOWN_EXTENSION_IN_TITLE')) DEFINE('_DOWN_EXTENSION_IN_TITLE','Extensió inclosa al títol:');
if (!defined('_DOWN_DOWNLOAD_TEXT_BOX')) DEFINE('_DOWN_DOWNLOAD_TEXT_BOX','Caixa de text de descàrrega');
if (!defined('_DOWN_PRUNE_LOG')) DEFINE('_DOWN_PRUNE_LOG','Neteja el fitxer de registre');
if (!defined('_DOWN_LOGFILE_CUTOFF_DATE')) DEFINE('_DOWN_LOGFILE_CUTOFF_DATE','Introduïu la data abans de la qual s´eliminaran les entrades al fitxer de registre::');
if (!defined('_DOWN_PRESS_SAVE_ACTIVATE')) DEFINE('_DOWN_PRESS_SAVE_ACTIVATE','llavors premeu "Desa" per activar.');
if (!defined('_DOWN_METHOD_NOT_PRESENT')) DEFINE('_DOWN_METHOD_NOT_PRESENT','Error del component %s: s´ha produït un intent d´utilitzar el mètode inexistent %s a %s');
if (!defined('_DOWN_CLASS_NOT_PRESENT')) DEFINE('_DOWN_CLASS_NOT_PRESENT','Error del component %s: s´ha produït un intent d´utilitzar la classe inexistent %s');
if (!defined('_DOWN_NO_UPLOAD_TO_FILES')) DEFINE('_DOWN_NO_UPLOAD_TO_FILES','No es pot pujar en massa cap a un contenidor amb camí de fitxer');
if (!defined('_DOWN_COUNTS_RECALCULATED')) DEFINE('_DOWN_COUNTS_RECALCULATED','Nombre de fitxers i carpetes recalculat');
if (!defined('_DOWN_COUNTS_RESET')) DEFINE('_DOWN_COUNTS_RESET','Reinicia els comptadors de descàrrega');
if (!defined('_DOWN_OLD_LOG_REMOVED')) DEFINE('_DOWN_OLD_LOG_REMOVED','S´han eliminat les entrades al registre anteriors a %s.');
if (!defined('_DOWN_NONE_MISSING')) DEFINE('_DOWN_NONE_MISSING','No falten fitxers');
if (!defined('_DOWN_BLOB_NOCHUNKS')) DEFINE('_DOWN_BLOB_NOCHUNKS',' - LA TAULA NO TÉ CAP PART');
if (!defined('_DOWN_CHUNKS_DISCREPANCY')) DEFINE('_DOWN_CHUNKS_DISCREPANCY',' - LA TAULA TÉ %s PARTS, PERÒ EL FITXER DIU %s');
if (!defined('_DOWN_PLAINTEXT_DISCREPANCY')) DEFINE('_DOWN_PLAINTEXT_DISCREPANCY',' - LA TAULA DE TEXT PLA TÉ %s ENTRADES, HAURIA DE SER EXACTAMENT 1');
if (!defined('_DOWN_NOT_FOUND_HERE')) DEFINE('_DOWN_NOT_FOUND_HERE',' - NO S´HA TROBAT EN AQUESTA LOCALITZACIÓ<br/>');
if (!defined('_DOWN_LOCAL_NO_URL')) DEFINE('_DOWN_LOCAL_NO_URL','EL FITXER NO ÉS LOCAL, PERÒ NO S´HA ESPECIFICAT UNA URL');
if (!defined('_DOWN_NOT_VALID_BR')) DEFINE('_DOWN_NOT_VALID_BR',' - NO VALIDAT<br/>');
if (!defined('_DOWN_NO_RELEVANT_THUMB')) DEFINE('_DOWN_NO_RELEVANT_THUMB',' - no hi ha fitxers rellevants - s´ha intentat eliminar-ho.<br/>');
if (!defined('_DOWN_THUMB_NOT_BELONG')) DEFINE('_DOWN_THUMB_NOT_BELONG','%s en el directori %s el fitxer no hi pertany - s´ha intentat eliminar-ho.<br/>');
if (!defined('_DOWN_THUMB_NOT_IN_DB')) DEFINE('_DOWN_THUMB_NOT_IN_DB',' - no hi ha coincidència amb la base de dades - s´ha intentat eliminar-ho.<br/>');
if (!defined('_DOWN_THUMB_OK')) DEFINE('_DOWN_THUMB_OK','No hi ha problemes amb les miniatures');
if (!defined('_DOWN_STRUCTURE_ADDED')) DEFINE('_DOWN_STRUCTURE_ADDED','S´ha afegit una estructura al repositori');
if (!defined('_DOWN_DB_CONVERT_OK')) DEFINE('_DOWN_DB_CONVERT_OK','La conversió de la base de dades ha finalitzat. Qualsevol fitxer esmentat a dalt era invàlid.');
if (!defined('_DOWN_ADD_NUMBER_FILES')) DEFINE('_DOWN_ADD_NUMBER_FILES','Afegeix un nombre de fitxers:');
if (!defined('_DOWN_DISPLAY_NUMBER')) DEFINE('_DOWN_DISPLAY_NUMBER','Mostra´n #');
if (!defined('_DOWN_SEARCH_COLON')) DEFINE('_DOWN_SEARCH_COLON','Cerca:');
if (!defined('_DOWN_SHOW_DESCENDANTS')) DEFINE('_DOWN_SHOW_DESCENDANTS','Mostra els descendents: ');
if (!defined('_DOWN_CLICK_TO_VISIT')) DEFINE('_DOWN_CLICK_TO_VISIT','Feu clic per visitar el lloc');
if (!defined('_DOWN_CONTAINERS')) DEFINE('_DOWN_CONTAINERS','Contenidors');
if (!defined('_DOWN_UP_PLAIN_TEXT')) DEFINE('_DOWN_UP_PLAIN_TEXT','Els fitxer es poden emmagatzemar com a text pla?');
if (!defined('_GLOBAL')) DEFINE('_GLOBAL','Global');
if (!defined('_DOWN_KEYWORDS')) DEFINE('_DOWN_KEYWORDS', 'Paraules clau:');
if (!defined('_DOWN_WINDOW_TITLE')) DEFINE('_DOWN_WINDOW_TITLE','Títol de finestra:');
if (!defined('_DOWN_EDITOR_GROUP')) DEFINE('_DOWN_EDITOR_GROUP','Grup de l´Editor:');
if (!defined('_DOWN_AUTO_FOR_ADMIN')) DEFINE('_DOWN_AUTO_FOR_ADMIN','Aprova automàticament per l´administrador:');
if (!defined('_DOWN_AUTO_FOR_USERS')) DEFINE('_DOWN_AUTO_FOR_USERS','Aprova automàticament pels usuaris:');
if (!defined('_DOWN_AUTO_USER_GROUP')) DEFINE('_DOWN_AUTO_USER_GROUP','Aprova automàticament pel grup d´usuaris:');
if (!defined('_DOWN_CONTAINER_CASCADE')) DEFINE('_DOWN_CONTAINER_CASCADE','Aplica a totes les carpetes fill:');
if (!defined('_DOWN_THANK_YOU')) DEFINE('_DOWN_THANK_YOU','Gràcies per descarregar ');
if (!defined('_DOWN_WAIT_OR_CLICK')) DEFINE('_DOWN_WAIT_OR_CLICK','Si la descàrrega no comença automàticament en uns segons, feu clic a l´enllaç de descàrrega');
if (!defined('_DOWN_UPDATE_THUMBNAILS')) DEFINE('_DOWN_UPDATE_THUMBNAILS','Puja miniatures');
if (!defined('_DOWN_DELETE_THUMBNAIL')) DEFINE('_DOWN_DELETE_THUMBNAIL','Elimina la miniatura');
if (!defined('_DOWN_SUBMIT_NEW_THUMBNAIL')) DEFINE('_DOWN_SUBMIT_NEW_THUMBNAIL','Envia una nova miniatura');
if (!defined('_DOWN_NOT_LOGGED_UPLOAD')) DEFINE('_DOWN_NOT_LOGGED_UPLOAD','No podeu pujar arxius. Si us plau, entreu o registreu-vos.');
if (!defined('_DOWN_NOT_LOGGED_COMMENT')) DEFINE('_DOWN_NOT_LOGGED_COMMENT','No podeu comentar els fitxers. Si us plau, entreu o registreu-vos.');
if (!defined('_DOWN_NOT_LOGGED_VOTE')) DEFINE('_DOWN_NOT_LOGGED_VOTE','No podeu votar. Si us plau, entreu o registreu-vos.');
if (!defined('_DOWN_COMMENT_NL')) DEFINE('_DOWN_COMMENT_NL','Si us plau, entreu o registreu-vos per deixar el vostre comentari');

// Define some summaries for tables
if (!defined('_TABLE_SUMMARY_GENHEAD')) DEFINE ('_TABLE_SUMMARY_GENHEAD', 'Llistat de les categories de descàrrega disponibles i el nombre de fitxers a cada categoria.');
if (!defined('_TABLE_SUMMARY_ADDMANYFILES')) DEFINE ('_TABLE_SUMMARY_ADDMANYFILES', 'Aquesta taula us permet triar uns quants fitxers per pujar.');
// /components/com_remository/com_remository_upload.php
if (!defined('_DOWNLOAD_UPLOAD_TITLE')) DEFINE('_DOWNLOAD_UPLOAD_TITLE','Enviar un arxiu');
if (!defined('_HEAD')) DEFINE('_HEAD','Capsalera');
if (!defined('_FILE')) DEFINE('_FILE','Envia el fitxer:');
if (!defined('_CLOSE')) DEFINE('_CLOSE','Tanca');
if (!defined('_SENDFILE')) DEFINE('_SENDFILE','Envia el fitxer');
if (!defined('_ERR1')) DEFINE('_ERR1','Aquest fitxer no s´ha especificat.');
if (!defined('_ERR2')) DEFINE('_ERR2','S´ha produït un atac d´enviament d´arxius');
if (!defined('_ERR3')) DEFINE('_ERR3','L´arxiu enviat no té cap mida; no té contingut.');
if (!defined('_ERR4')) DEFINE('_ERR4','L´arxiu enviat conté una extensió o sufix no permès.');
if (!defined('_ERR5')) DEFINE('_ERR5','L´arxiu enviat exedeix el tamany màxim de ');
if (!defined('_ERR6')) DEFINE('_ERR6','L´arxiu enviat ja existeix. Si us plau, especifiqueu un nou títol.');
if (!defined('_ERR7')) DEFINE('_ERR7','L´espai de descàrregues actualment és ple.');
if (!defined('_ERR8')) DEFINE('_ERR8','Només poden carregar arxius un administrador o un usuari registrat.');
if (!defined('_ERR9')) DEFINE('_ERR9','Heu arribat al límit diari de càrrega d´arxius.');
if (!defined('_ERR10')) DEFINE('_ERR10','Enviar arxius per usuaris no està permès.');
if (!defined('_ERR11')) DEFINE('_ERR11','L´enviament de l´arxiu ha fallat per un error en el codi ');
if (!defined('_UP_SUCCESS')) DEFINE('_UP_SUCCESS','S´ha enviat l´arxiu amb èxit.');
if (!defined('_UPLOAD_URL_LOCK')) DEFINE('_UPLOAD_URL_LOCK','-Arxiu enviat-');
if (!defined('_WARNING1')) DEFINE('_WARNING1','EL camí pels fitxers ha canviat - Els fitxers no s´han mogut');
if (!defined('_WARNING2')) DEFINE('_WARNING2','El camí especificat no existeix - Creeu-ne un de nou : ');
if (!defined('_APPROVE')) DEFINE('_APPROVE','Aprova');
if (!defined('_CANCEL')) DEFINE('_CANCEL','Cancel·la');
if (!defined('_DOWN_MISSING_TITLE')) DEFINE('_DOWN_MISSING_TITLE','Fitxers que falten');
if (!defined('_DOWN_ADDSTRUCTURE_TITLE')) DEFINE('_DOWN_ADDSTRUCTURE_TITLE','afegeix tota l´estructura');
if (!defined('_MBT_GROUP_MANAGER')) DEFINE('_MBT_GROUP_MANAGER','Gestor del grup');
if (!defined('_MBT_GROUP_FILTER')) DEFINE('_MBT_GROUP_FILTER','Filtra per nom');
if (!defined('_MBT_GROUP_GROUP')) DEFINE('_MBT_GROUP_GROUP','Grup');
if (!defined('_MBT_GROUP_DESCRIPTION')) DEFINE('_MBT_GROUP_DESCRIPTION','Descripció');
if (!defined('_MBT_GROUP_EMAIL')) DEFINE('_MBT_GROUP_EMAIL','Correu electrònic');
if (!defined('_MBT_GROUP_ADD')) DEFINE('_MBT_GROUP_ADD','Afegeix un grup');
if (!defined('_MBT_GROUP_EDIT')) DEFINE('_MBT_GROUP_EDIT','Edita el grup');
if (!defined('_MBT_GROUP_NAME')) DEFINE('_MBT_GROUP_NAME','Nom');
if (!defined('_MBT_GROUP_AVAI_USER')) DEFINE('_MBT_GROUP_AVAI_USER','Usuaris disponbiles');
if (!defined('_MBT_GROUP_SEL_USER')) DEFINE('_MBT_GROUP_SEL_USER','Membres del grup');
if (!defined('_MBT_GROUP_MEMBERS')) DEFINE('_MBT_GROUP_MEMBERS','Membres');
if (!defined('_MBT_GROUP_SUBJECT')) DEFINE('_MBT_GROUP_SUBJECT','Tema');
if (!defined('_MBT_GROUP_MESSAGE')) DEFINE('_MBT_GROUP_MESSAGE','Missatge');
if (!defined('_MBT_GROUP_SEND')) DEFINE('_MBT_GROUP_SEND','Envia');
if (!defined('_MBT_GROUP_MISS_SUB')) DEFINE('_MBT_GROUP_MISS_SUB','Si us plau, introduïu un tema');
if (!defined('_MBT_GROUP_MISS_MSG')) DEFINE('_MBT_GROUP_MISS_MSG','Si us plau, introduïu un missatge');
if (!defined('_MBT_GROUP_MISS_GROUP')) DEFINE('_MBT_GROUP_MISS_GROUP','Si us plau, introduïu el nom del grup');
if (!defined('_MBT_GROUP_SEND_ADMIN')) DEFINE('_MBT_GROUP_SEND_ADMIN','Només els administradors poden enviar correus electrònics');
if (!defined('_MBT_GROUP_SEND_NOTARGET')) DEFINE('_MBT_GROUP_SEND_NOTARGET','No hi ha adreça de destí pel grup');
if (!defined('_MBT_GROUP_SEND_OK')) DEFINE('_MBT_GROUP_SEND_OK','El correu s´ha enviat');
if (!defined('_MBT_GROUP_SEND_USERS')) DEFINE('_MBT_GROUP_SEND_USERS','Usuaris');

// Recent additions 3.56
if (!defined('_DOWN_EDIT_CLASSIFICATION')) DEFINE ('_DOWN_EDIT_CLASSIFICATION', 'Edit Classification');
if (!defined('_DOWN_CLASSIFICATION')) DEFINE ('_DOWN_CLASSIFICATION', 'Classification');
if (!defined('_DOWN_CONTAINER_PUBLISHED')) DEFINE ('_DOWN_CONTAINER_PUBLISHED', 'Container successfully published');
if (!defined('_DOWN_CONTAINERS_PUBLISHED')) DEFINE ('_DOWN_CONTAINERS_PUBLISHED', 'Containers successfully published');
if (!defined('_DOWN_CONTAINER_UNPUBLISHED')) DEFINE ('_DOWN_CONTAINER_UNPUBLISHED', 'Container successfully unpublished');
if (!defined('_DOWN_CONTAINERS_UNPUBLISHED')) DEFINE ('_DOWN_CONTAINERS_UNPUBLISHED', 'Containers successfully unpublished');
if (!defined('_DOWN_CONTAINER_SAVED')) DEFINE ('_DOWN_CONTAINER_SAVED', 'Container saved successfully');
if (!defined('_DOWN_CONTAINER_DELETED')) DEFINE ('_DOWN_CONTAINER_DELETED', 'Container deleted successfully');
if (!defined('_DOWN_CONTAINERS_DELETED')) DEFINE ('_DOWN_CONTAINERS_DELETED', 'Containers deleted successfully');
if (!defined('_DOWN_FILE_PUBLISHED')) DEFINE ('_DOWN_FILE_PUBLISHED', 'File successfully published');
if (!defined('_DOWN_FILES_PUBLISHED')) DEFINE ('_DOWN_FILES_PUBLISHED', 'Files successfully published');
if (!defined('_DOWN_FILE_UNPUBLISHED')) DEFINE ('_DOWN_FILE_UNPUBLISHED', 'File successfully unpublished');
if (!defined('_DOWN_FILES_UNPUBLISHED')) DEFINE ('_DOWN_FILES_UNPUBLISHED', 'Files successfully unpublished');
if (!defined('_DOWN_FILE_SAVED')) DEFINE ('_DOWN_FILE_SAVED', 'File saved successfully');
if (!defined('_DOWN_FILE_DELETED')) DEFINE ('_DOWN_FILE_DELETED', 'File deleted successfully');
if (!defined('_DOWN_FILES_DELETED')) DEFINE ('_DOWN_FILES_DELETED', 'Files deleted successfully');
if (!defined('_DOWN_FILE_LOCALISED')) DEFINE ('_DOWN_FILE_LOCALISED', 'File localised successfully');
if (!defined('_DOWN_GROUP_MEMBER_SAVED')) DEFINE ('_DOWN_GROUP_MEMBER_SAVED', 'Group member added successfully');
if (!defined('_DOWN_GROUP_MEMBERS_SAVED')) DEFINE ('_DOWN_GROUP_MEMBERS_SAVED', 'Group members added successfully');
if (!defined('_DOWN_GROUP_MEMBER_DELETED')) DEFINE ('_DOWN_GROUP_MEMBER_DELETED', 'Member removed successfully');
if (!defined('_DOWN_GROUP_MEMBERS_DELETED')) DEFINE ('_DOWN_GROUP_MEMBERS_DELETED', 'Members removed successfully');
if (!defined('_DOWN_GROUP_DELETED')) DEFINE ('_DOWN_GROUP_DELETED', 'Group deleted successfully');
if (!defined('_DOWN_GROUPS_DELETED')) DEFINE ('_DOWN_GROUPS_DELETED', 'Groups deleted successfully');
if (!defined('_DOWN_ORPHAN_SINGLE_DONE')) DEFINE('_DOWN_ORPHAN_SINGLE_DONE','File Orphan Deleted');
if (!defined('_DOWN_CLASSIFICATION_PUBLISHED')) DEFINE ('_DOWN_CLASSIFICATION_PUBLISHED', 'Classification successfully published');
if (!defined('_DOWN_CLASSIFICATIONS_PUBLISHED')) DEFINE ('_DOWN_CLASSIFICATIONS_PUBLISHED', 'Classifications successfully published');
if (!defined('_DOWN_CLASSIFICATION_UNPUBLISHED')) DEFINE ('_DOWN_CLASSIFICATION_UNPUBLISHED', 'Classification successfully unpublished');
if (!defined('_DOWN_CLASSIFICATIONS_UNPUBLISHED')) DEFINE ('_DOWN_CLASSIFICATIONS_UNPUBLISHED', 'Classifications successfully unpublished');
if (!defined('_DOWN_CLASSIFICATION_SAVED')) DEFINE ('_DOWN_CLASSIFICATION_SAVED', 'Classification saved successfully');
if (!defined('_DOWN_CLASSIFICATION_DELETED')) DEFINE ('_DOWN_CLASSIFICATION_DELETED', 'Classification deleted successfully');
if (!defined('_DOWN_CLASSIFICATIONS_DELETED')) DEFINE ('_DOWN_CLASSIFICATIONS_DELETED', 'Classifications deleted successfully');
if (!defined('_DOWN_MISSING_DELETED')) DEFINE ('_DOWN_MISSING_DELETED', 'Missing file deleted successfully');
if (!defined('_DOWN_MISSINGS_DELETED')) DEFINE ('_DOWN_MISSINGS_DELETED', 'Missing files deleted successfully');
if (!defined('_SUBMIT_FILE_BUTTON_ADV')) DEFINE('_SUBMIT_FILE_BUTTON_ADV','AddFile');