<?php

/**************************************************************
* This file is part of Remository
* Copyright (c) 2006-17 Martin Brampton
* 
* License: GNU General Public License version 2 or later; see LICENSE.txt
* 
* For support and other information, visit http://remository.com
* To contact Martin Brampton, write to martin@remository.com
*
* Remository started life as the psx-dude script by psx-dude@psx-dude.net
* It was enhanced by Matt Smith up to version 2.10
* Since then development has been primarily by Martin Brampton,
* with contributions from other people gratefully accepted
*/

defined('_JEXEC') or die;

// These settings are dummy values to suppress errors when the language file is used in a context where the real values have not been set
if (!isset($Large_Text_Len)) $Large_Text_Len = 500;
if (!isset($Small_Text_Len)) $Small_Text_Len = 150;
if (!isset($mosConfig_sitename)) $mosConfig_sitename = 'Site Name';

// Add your own definitions here, just using plain DEFINE
// e.g. define ('_DOWNLOADS_TITLE', 'The name of my Repository');
// Your definitions will override the standard ones if placed ahead of them

// Prototype for standard definitions: if (!defined('')) DEFINE ('', '');
//
// Note that the definition of _DOWN_NEW_UPDATED_MSG changed in version 3.54.07
// 
// Additions in 3.58
if (!defined('_DOWN_SUBCONTAINER_IMAGE')) DEFINE('_DOWN_SUBCONTAINER_IMAGE','Optional image for custom displays:');
if (!defined('_DOWN_SUBCONTAINER_LIST_IMAGE')) DEFINE('_DOWN_SUBCONTAINER_LIST_IMAGE','Optional image');
if (!defined('_DOWN_SUBCONTAINER_IMAGE_TYPE_WARNING')) DEFINE('_DOWN_SUBCONTAINER_IMAGE_TYPE_WARNING','Container image uploading failed! It must be png, jpg or jpeg');
if (!defined('_DOWN_SUBCONTAINER_IMAGE_DELETE')) DEFINE('_DOWN_SUBCONTAINER_IMAGE_DELETE','Delete this Image');
if (!defined('_DOWN_SUBCONTAINER_IMAGE_DELETE_MESSAGE')) DEFINE('_DOWN_SUBCONTAINER_IMAGE_DELETE_MESSAGE','Container image deleted successfully');
// Additions in 3.54
if (!defined('_DOWN_CONFIRM')) DEFINE('_DOWN_CONFIRM','Confirm');
if (!defined('_DOWN_CONFIRM_MSG')) DEFINE('_DOWN_CONFIRM_MSG','Do you want to go further ?');
if (!defined('_DOWN_RENAME')) DEFINE('_DOWN_RENAME','Rename');
if (!defined('_DOWN_CONTAINER_RENAME_INSTRUCTION')) DEFINE('_DOWN_CONTAINER_RENAME_INSTRUCTION','Important : container name editing will not change its physical folder. Physical folder name editing is only available in backoffice.');
if (!defined('_DOWN_CONTAINER_DELETE_NOT_EMPTY')) DEFINE('_DOWN_CONTAINER_DELETE_NOT_EMPTY','Beware, this category is not empty. Every files and sub-category will also be deleted.');
if (!defined('_DOWN_CONTAINER_DELETE_INVALID_GROUP')) DEFINE('_DOWN_CONTAINER_DELETE_INVALID_GROUP','You don\'t have the delete rights on this category.');
if (!defined('_DOWN_CONTAINER_UPDATE_INVALID_GROUP')) DEFINE('_DOWN_CONTAINER_UPDATE_INVALID_GROUP','You don\'t have the edit rights on this category.');
if (!defined('_DOWN_SUBCONTAINER_CREATE_LABEL')) DEFINE('_DOWN_SUBCONTAINER_CREATE_LABEL','Add a sub-category');
if (!defined('_DOWN_SUBCONTAINER_CREATE_INVALID_GROUP')) DEFINE('_DOWN_SUBCONTAINER_CREATE_INVALID_GROUP','You don\'t have the rights to create sub-categories in this category.');
if (!defined('_DOWN_SUBCONTAINER_CREATE_ERR_TITLE')) DEFINE('_DOWN_SUBCONTAINER_CREATE_ERR_TITLE', 'The category can\'t be created');
if (!defined('_DOWN_SUBCONTAINER_CREATE_FOLDER_WARN01')) DEFINE('_DOWN_SUBCONTAINER_CREATE_FOLDER_WARN01','The chosen title is invalid : no physical folder can be created from that.');
if (!defined('_DOWN_SUBCONTAINER_CREATE_FOLDER_ERR01')) DEFINE('_DOWN_SUBCONTAINER_CREATE_FOLDER_ERR01','Physical folder can\'t be created : parent category physical folder can\'t be found.');
if (!defined('_DOWN_SUBCONTAINER_CREATE_FOLDER_ERR02')) DEFINE('_DOWN_SUBCONTAINER_CREATE_FOLDER_ERR02','Physical folder can\'t be created : please check the rights on the physical folders. ');
if (!defined('_DOWN_CONFIG_TITLE_FRONT_OFFICE_MGT')) DEFINE('_DOWN_CONFIG_TITLE_FRONT_OFFICE_MGT','Front office administration');
if (!defined('_DOWN_CONFIG_TITLE_RIGHTS')) DEFINE('_DOWN_CONFIG_TITLE_RIGHTS','Rights management');
if (!defined('_DOWN_CONFIG_TITLE_DISPLAY')) DEFINE('_DOWN_CONFIG_TITLE_DISPLAY','Display management');
if (!defined('_DOWN_CONFIG108')) DEFINE ('_DOWN_CONFIG108', 'Allow_Container_Edit: <br /><em>Allow Users to edit (in this case, just title renaming) the categories they have upload rights on</em>');
if (!defined('_DOWN_CONFIG107')) DEFINE ('_DOWN_CONFIG107', 'Allow_Container_Delete: <br /><em>Allow Users to delete the categories they have upload rights on. </em>');
if (!defined('_DOWN_CONFIG106')) DEFINE ('_DOWN_CONFIG106', 'Allow_Container_Add: <br /><em>Allow Users to add sub-categories in the categories they have upload rights on</em>');

// Additions in 3.53+
if (!defined('_DOWN_UPLOAD_NEW_FOLDER')) DEFINE ('_DOWN_UPLOAD_NEW_FOLDER', 'Create folder under selected:');
if (!defined('_DOWN_EMAIL_NOTIFY_PREFIX')) DEFINE ('_DOWN_EMAIL_NOTIFY_PREFIX', 'The following file(s) may be of interest to you:');
if (!defined('_DOWN_EMAIL_NOTIFY_POSTFIX')) DEFINE ('_DOWN_EMAIL_NOTIFY_POSTFIX', 'If you have queries about the file(s) above, please contact the sender.');
if (!defined('_DOWN_COULD_NOT_SEND')) DEFINE ('_DOWN_COULD_NOT_SEND', 'Could not send %s to %s, not permitted.');
if (!defined('_DOWN_EMAIL_NOTIFY')) DEFINE ('_DOWN_EMAIL_NOTIFY', 'I should like to notify you of %s and you can download it at %s');
if (!defined('_DOWN_ATTEMPTING_MAIL')) DEFINE ('_DOWN_ATTEMPTING_MAIL', 'Attempting to mail %s with %s');
if (!defined('_DOWN_LINKS_TO_FILES')) DEFINE ('_DOWN_LINKS_TO_FILES', 'Links to files of interest');
if (!defined('_DOWN_EMAIL_SUCCESSFUL')) DEFINE ('_DOWN_EMAIL_SUCCESSFUL', 'Email sent successfully to %s');
if (!defined('_DOWN_EMAIL_FAILED')) DEFINE ('_DOWN_EMAIL_FAILED', 'Attempt to send email to %s at email %s failed');
if (!defined('_DOWN_NOTHING_TO_DO')) DEFINE ('_DOWN_NOTHING_TO_DO', 'Nothing to do');

// Additions in 3.53
if (!defined('_DOWN_ALL_CATEGORIES')) DEFINE ('_DOWN_ALL_CATEGORIES', 'All Categories');
if (!defined('_DOWN_THANKS_FOR_VOTING')) DEFINE ('_DOWN_THANKS_FOR_VOTING', 'Thank you for voting');
if (!defined('_DOWN_CAST_YOUR_VOTE')) DEFINE ('_DOWN_CAST_YOUR_VOTE', 'Why not cast your vote?');
if (!defined('_DOWN_LOGIN_TO_VOTE')) DEFINE ('_DOWN_LOGIN_TO_VOTE', 'Log in to cast your vote');
if (!defined('_DOWN_CONFIG_EXPLAIN_5')) DEFINE ('_DOWN_CONFIG_EXPLAIN_5', 'E = Select fields for uploading or amending files');
if (!defined('_DOWN_SEARCH_ALL_FOLDERS')) DEFINE ('_DOWN_SEARCH_ALL_FOLDERS', 'Search All Folders');
if (!defined('_DOWN_UPLOAD_BLOCKED_GROUPS')) DEFINE ('_DOWN_UPLOAD_BLOCKED_GROUPS', 'Sorry, you have not been granted upload facilities at present.');
if (!defined('_DOWN_NO_REMOSITORY_GROUPS')) DEFINE ('_DOWN_NO_REMOSITORY_GROUPS', 'Remository Groups are not available - Configuration says to use CMS Groups');
if (!defined('_DOWN_POSSIBLE_DUPLICATE_NAMES')) DEFINE ('_DOWN_POSSIBLE_DUPLICATE_NAMES', 'Configuration saved, but file ID required because of duplicate file names');
if (!defined('_DOWN_CONFIG105')) DEFINE ('_DOWN_CONFIG105', 'Download_Browser_Save: <br /><em>(Disable the browser default action of opening a downloaded file.)</em>');
if (!defined('_DOWN_CONFIG104')) DEFINE ('_DOWN_CONFIG104', 'Use_CMS_Groups: <br /><em>(Use the CMS groups for access control instead of Remository groups.)</em>');
if (!defined('_DOWN_CONFIG103')) DEFINE ('_DOWN_CONFIG103', 'Immediate_Download: <br /><em>(Skip file information page, go straight to download.)</em>');
if (!defined('_DOWN_CONFIG72')) DEFINE ('_DOWN_CONFIG72', 'Real_With_ID: <br /><em>(Actual file names on disk to be made unique by inserting file ID number.)</em>');
if (!defined('_DOWN_DETAILS')) DEFINE('_DOWN_DETAILS','Details');
if (!defined('_DOWN_THIS_FILE_TODAY')) DEFINE ('_DOWN_THIS_FILE_TODAY', 'You have downloaded this file %d times in the last 24 hours, limit is %d.');
if (!defined('_DOWN_ALL_FILES_TODAY')) DEFINE ('_DOWN_ALL_FILES_TODAY', 'Your file downloads total %d in the last 24 hours, limit is %d.');
if (!defined('_DOWN_YOUR_CREDITS')) DEFINE ('_DOWN_YOUR_CREDITS', 'You currently have %d credits available.');
if (!defined('_DOWN_TOO_FEW_CREDITS')) DEFINE ('_DOWN_TOO_FEW_CREDITS', 'Too few credits for download.');
if (!defined('_DOWN_CONFIG71')) DEFINE ('_DOWN_CONFIG71', 'Show_SubCategories: <br /><em>(Show children categories under parents categories.)</em>');
if (!defined('_DOWN_PRICE_LABEL')) DEFINE ('_DOWN_PRICE_LABEL', 'Price:');

// Additions in 3.52
if (!defined('_DOWN_MANY_CONTAINERS')) DEFINE('_DOWN_MANY_CONTAINERS', 'Too many containers for list - please navigate through container links');
if (!defined('_DOWN_DELETE_SURE')) DEFINE ('_DOWN_DELETE_SURE', 'Are you sure that you want to delete this file?');
if (!defined('_DOWN_SEARCH_CATEGORY_SELECT')) DEFINE ('_DOWN_SEARCH_CATEGORY_SELECT', 'Choose which categories to include');
if (!defined('_DOWN_SEARCH_FILES')) DEFINE ('_DOWN_SEARCH_FILES', 'Search for files');

// Additions in 3.51
if (!defined('_DOWN_NOT_ABSOLUTE')) DEFINE ('_DOWN_NOT_ABSOLUTE', 'Invalid absolute path');
if (!defined('_DOWN_NEW_OR_UPDATED')) DEFINE ('_DOWN_NEW_OR_UPDATED', 'New or updated file');
if (!defined('_DOWN_NEW_FILE_COMMENT')) DEFINE ('_DOWN_NEW_FILE_COMMENT', 'New comment on file');
if (!defined('_DOWN_MAIL_MESSAGE_PREFIX')) DEFINE ('_DOWN_MAIL_MESSAGE_PREFIX', "Hello %s\n\n");
if (!defined('_DOWN_NEW_UPDATED_MSG')) DEFINE ('_DOWN_NEW_UPDATED_MSG',
					"At %s a file has been added or updated.  The file title is %s.  The file name is %s."
					."\n\nPlease do not respond to this message as it is automatically generated and is for information purposes only\n"
					);
if (!defined('_DOWN_NEW_COMMENT_MSG')) DEFINE ('_DOWN_NEW_COMMENT_MSG',
					"At %s a new comment has been made about a file.  The file title is %s.  "
					."The new comment was made by %s and is:\n\n%s"
					."\n\nPlease do not respond to this message as it is automatically generated and is for information purposes only\n"
					);

// Modifications in 3.51
if (!defined('_DOWN_MAIL_MSG')) DEFINE('_DOWN_MAIL_MSG','Hello a new user Downloads submission has been submitted by %s'
                   ." for the %s website.\n"
                   ."Please login as an administrator to view and approve this submission.\n\n"
                   ."Please do not respond to this message as it is automatically generated and is for information purposes only\n");
if (!defined('_DOWN_MAIL_MSG_APP')) DEFINE('_DOWN_MAIL_MSG_APP','Hello a new user Downloads submission has been submitted by %s'
                   ." for the %s website.\n"
                   ."In accordance with the configuration options, it has been auto-appproved.\n\n"
                   ."Please do not respond to this message as it is automatically generated and is for information purposes only\n");
if (!defined('_DOWN_LINK_TO_FILE')) DEFINE ('_DOWN_LINK_TO_FILE', "\n\nYou can find the file at %s");
if (!defined('_DOWN_LINK_TO_CONTAINER')) DEFINE ('_DOWN_LINK_TO_CONTAINER', "\n\nYou can find the container at %s");

// Additions in 3.50
if (!defined('_DOWN_APPROVE_ROLES')) DEFINE ('_DOWN_APPROVE_ROLES', 'Auto Approve Roles');
if (!defined('_DOWN_ACCESS_REFUSED')) DEFINE ('_DOWN_ACCESS_REFUSED', 'Sorry, your request is refused');
if (!defined('_DOWN_MAYBE_LOGIN')) DEFINE ('_DOWN_MAYBE_LOGIN', 'Maybe you need to login, or register an account.');
if (!defined('_DOWN_CONFIG70')) DEFINE ('_DOWN_CONFIG70', 'Show_all_containers: <br /><em>(In search results, show the whole container path)</em>');
if (!defined('_DOWN_CONFIG69')) DEFINE ('_DOWN_CONFIG69', 'Set_date_locale: <br /><em>(Choose a locale setting for date handling)</em>');
if (!defined('_DOWN_CONFIG68')) DEFINE ('_DOWN_CONFIG68', 'Force_Language: <br /><em>(Force the language code to this value, ignore the CMS)</em>');

// Additions in 3.47 to fix missed items in earlier versions
if (!defined('_DOWN_NO_FILE_RECEIVED')) DEFINE ('_DOWN_NO_FILE_RECEIVED', 'Although you may have attempted a file upload, no file was received.');
if (!defined('_DOWN_SAMPLE')) DEFINE ('_DOWN_SAMPLE', 'Sample');
if (!defined('_DOWN_SAMPLE_DESCRIPTION')) DEFINE ('_DOWN_SAMPLE_DESCRIPTION', 'Replace or modify this demonstration container as required');
if (!defined('_DOWN_INSTALL_DONE1')) DEFINE ('_DOWN_INSTALL_DONE1', 'If you have installed Remository for the first time, the install process
	will have created a sample folder and inserted an extra item in your main menu.  You can modify or delete these according to your needs.
	You should now be ready to use Remository - you could start by uploading a file either from the user side (look for an icon with the text
	"Submit File" on the first Remository page) or from the admin side by going to Manage Files and selecting the "Add Local" toolbar item.
	You are strongly recommended to look at the Release notes in <a href="%s">read_me.txt</a>');
if (!defined('_DOWN_INSTALL_DONE2')) DEFINE ('_DOWN_INSTALL_DONE2', 'More information can be found at <a href="http://remository.com">the Remository web site</a>.');
if (!defined('_DOWN_INSTALL_DONE3')) DEFINE ('_DOWN_INSTALL_DONE3', 'Support Remository');
if (!defined('_DOWN_INSTALL_DONE4')) DEFINE ('_DOWN_INSTALL_DONE4', 'Developing and maintaining Remository takes a lot of time and a certain amount of'
		.' money to provide a development environment.  If you are gaining financial benefit'
		.' from your use of Remository, please consider making a donation to support the project.'
		.' Click on the button below to make an immediate payment:');
if (!defined('_DOWN_LOCAL_OR_REMOTE')) DEFINE ('_DOWN_LOCAL_OR_REMOTE', 'Local or Remote');
if (!defined('_DOWN_IS_LOCAL')) DEFINE ('_DOWN_IS_LOCAL', 'Local');
if (!defined('_DOWN_IS_REMOTE')) DEFINE ('_DOWN_IS_REMOTE', 'Remote');
if (!defined('_DOWN_LOCALISE_REMOTE_FILE')) DEFINE ('_DOWN_LOCALISE_REMOTE_FILE', 'Make local');
if (!defined('_DOWN_CANCEL_UPLOAD')) DEFINE ('_DOWN_CANCEL_UPLOAD', 'Cancel');
if (!defined('_DOWN_NOT_YET_IMPLEMENTED')) DEFINE ('_DOWN_NOT_YET_IMPLEMENTED', 'THIS FEATURE NOT YET IMPLEMENTED');
if (!defined('_DOWN_ADMIN_CPANEL_CACHEPATH')) DEFINE ('_DOWN_ADMIN_CPANEL_CACHEPATH', 'CMS cache path - important for RSS and access control:');
if (!defined('_DOWN_CONFIG_EXPLAIN_4')) DEFINE ('_DOWN_CONFIG_EXPLAIN_4', 'D = Select fields for file detailed information page');
if (!defined('_DOWN_CONFIG67')) DEFINE ('_DOWN_CONFIG67', 'Profile_URI: <br /><em>(Relative non-SEF URI to profile with %u where user ID should be)</em>');
if (!defined('_DOWN_CONFIG66')) DEFINE ('_DOWN_CONFIG66', 'Activate_AEC: <br /><em>(Activate AEC integration for access control)</em>');
if (!defined('_DOWN_AEC_OPTION_A')) DEFINE ('_DOWN_AEC_OPTION_A', 'Just apply group(s) below.');
if (!defined('_DOWN_AEC_OPTION_B')) DEFINE ('_DOWN_AEC_OPTION_B', 'Delete ALL, then apply group(s) below.');
if (!defined('_DOWN_AEC_OPTION_C')) DEFINE ('_DOWN_AEC_OPTION_C', 'Delete Group Set on Application, then apply group(s) below.');
if (!defined('_DOWN_CONFIG65')) DEFINE ('_DOWN_CONFIG65', 'Home_Page_Title:<br /><em>(The browser titlebar entry for the main repository page)</em>');
if (!defined('_DOWN_NEXT')) DEFINE ('_DOWN_NEXT', 'Next');
if (!defined('_DOWN_PREVIOUS')) DEFINE ('_DOWN_PREVIOUS', 'Previous');
if (!defined('_DOWN_DOWNLOAD_LC')) DEFINE ('_DOWN_DOWNLOAD_LC', 'download');
if (!defined('_DOWN_EMPTY_REPOSITORY')) DEFINE ('_DOWN_EMPTY_REPOSITORY', 'Empty Repository');
if (!defined('_DOWN_OVERVIEW_LATEST')) DEFINE ('_DOWN_OVERVIEW_LATEST', 'Latest Files in the Repository');
if (!defined('_DOWN_SPECIFY_AUTHOR')) DEFINE ('_DOWN_SPECIFY_AUTHOR', 'Another author');
if (!defined('_DOWN_CONFIG64')) DEFINE ('_DOWN_CONFIG64', 'Author_Threshold:<br /><em>(Minimum author listings to be included in drop down list)</em>');
if (!defined('_DOWN_CONFIG63')) DEFINE ('_DOWN_CONFIG63', 'Main_Authors:<br /><em>(List of authors for selection, comma separated)</em>');
if (!defined('_DOWN_CONFIG62')) DEFINE ('_DOWN_CONFIG62', 'Min_Comment_length:<br /><em>(Minimum length for a comment on a file, or ignored)</em>');
if (!defined('_DOWN_CONFIG61')) DEFINE ('_DOWN_CONFIG61', 'Video_Download:<br /><em>(Allow download of video files)</em>');
if (!defined('_DOWN_CONFIG60')) DEFINE ('_DOWN_CONFIG60', 'Audio_Download:<br /><em>(Allow download of audio files)</em>');
if (!defined('_DOWN_CONFIG59')) DEFINE ('_DOWN_CONFIG59', 'Alias:<br /><em>(Repository alias)</em>');
if (!defined('_DOWN_CONFIG58')) DEFINE ('_DOWN_CONFIG58', 'Name:<br /><em>(Repository name)</em>');
if (!defined('_DOWN_PLAY')) DEFINE ('_DOWN_PLAY', 'Play');
if (!defined('_DOWN_PLAY_THANK_YOU')) DEFINE ('_DOWN_PLAY_THANK_YOU', 'Thank you for playing ');
if (!defined('_DOWN_CONFIG57')) DEFINE ('_DOWN_CONFIG57', 'Video File Extensions:<br /><em>(Video files to be played, not downloaded)</em>');
if (!defined('_DOWN_CONFIG56')) DEFINE ('_DOWN_CONFIG56', 'Audio File Extensions:<br /><em>(Audio files to be played, not downloaded)</em>');
if (!defined('_DOWN_FEATURED')) DEFINE ('_DOWN_FEATURED', 'Featured');
if (!defined('_DOWN_IS_FEATURED')) DEFINE ('_DOWN_IS_FEATURED', 'File is featured:');
if (!defined('_DOWN_FEATURE_START')) DEFINE ('_DOWN_FEATURE_START', 'Start date:');
if (!defined('_DOWN_FEATURE_END')) DEFINE ('_DOWN_FEATURE_END', 'End date (blank = forever)');
if (!defined('_DOWN_PUBLISH_FROM')) DEFINE ('_DOWN_PUBLISH_FROM', 'Publish from:');
if (!defined('_DOWN_PUBLISH_TO')) DEFINE ('_DOWN_PUBLISH_TO', 'Publish to (blank = forever):');
if (!defined('_DOWN_FIELD_NAME')) DEFINE ('_DOWN_FIELD_NAME', 'Field Name');
if (!defined('_DOWN_FIELD_TITLE')) DEFINE ('_DOWN_FIELD_TITLE', 'Field Title');
if (!defined('_DOWN_CUSTOM_UPLOAD')) DEFINE ('_DOWN_CUSTOM_UPLOAD', 'In upload');
if (!defined('_DOWN_CUSTOM_LIST')) DEFINE ('_DOWN_CUSTOM_LIST', 'In file list');
if (!defined('_DOWN_CUSTOM_INFO_PAGE')) DEFINE ('_DOWN_CUSTOM_INFO_PAGE', 'In info page');
if (!defined('_DOWN_FIELD_OPTIONS')) DEFINE ('_DOWN_FIELD_OPTIONS', 'Limit values to this comma separated list');
if (!defined('_DOWN_CUSTOM_INFO')) DEFINE ('_DOWN_CUSTOM_INFO', 'Field name will be used in the database and must be unique for the xxx_downloads_files table.  Field title will be used to label the field when it is used.');
if (!defined('_DOWN_CUSTOM_FIELDS_TAB')) DEFINE ('_DOWN_CUSTOM_FIELDS_TAB', 'Add fields');
if (!defined('_DOWN_CUSTOM_FIELDS_HEAD')) DEFINE ('_DOWN_CUSTOM_FIELDS_HEAD', 'Custom fields');
if (!defined('_DOWN_CONFIG55')) DEFINE ('_DOWN_CONFIG55', 'Featured_Number:<br /><em>(Number of items to be featured)</em>');
if (!defined('_DOWN_IS_VISIBLE')) DEFINE ('_DOWN_IS_VISIBLE', 'Visible?');
if (!defined('_DOWN_FREQUENCY')) DEFINE ('_DOWN_FREQUENCY', 'Frequency');
if (!defined('_DOWN_TYPE')) DEFINE ('_DOWN_TYPE', 'Type');
if (!defined('_DOWN_DESCRIPTION')) DEFINE ('_DOWN_DESCRIPTION', 'Description');
if (!defined('_DOWN_CLASSIFICATIONS')) DEFINE ('_DOWN_CLASSIFICATIONS', 'Classifications');
if (!defined('_DOWN_SAVE')) DEFINE ('_DOWN_SAVE', 'Save');
if (!defined('_DOWN_FILE_STRUCTURE')) DEFINE ('_DOWN_FILE_STRUCTURE', 'File Structure');
if (!defined('_DOWN_PRUNE')) DEFINE ('_DOWN_PRUNE', '- prune');
if (!defined('_DOWN_DELETE_MISSING')) DEFINE ('_DOWN_DELETE_MISSING', 'Delete Missing Files');
if (!defined('_DOWN_APPLY')) DEFINE ('_DOWN_APPLY', 'Apply');
if (!defined('_DOWN_CLASSIFICATION_NAME')) DEFINE ('_DOWN_CLASSIFICATION_NAME', 'Classification name');
if (!defined('_DOWN_DISPLAY_LISTS')) DEFINE ('_DOWN_DISPLAY_LISTS', 'Display name in lists:');
if (!defined('_DOWN_NOT_PUBLISHED')) DEFINE ('_DOWN_NOT_PUBLISHED', 'Not Published');
if (!defined('_DOWN_PUBLISH')) DEFINE ('_DOWN_PUBLISH', 'Publish');
if (!defined('_DOWN_UNPUBLISH')) DEFINE ('_DOWN_UNPUBLISH', 'Unpublish');
if (!defined('_DOWN_FILE')) DEFINE ('_DOWN_FILE', 'File');
if (!defined('_DOWN_ADD')) DEFINE ('_DOWN_ADD', 'Add');
if (!defined('_DOWN_CLASSIFN')) DEFINE ('_DOWN_CLASSIFN', 'Classification');
if (!defined('_DOWN_ROLES')) DEFINE ('_DOWN_ROLES', 'roles:');
if (!defined('_DOWN_DELETE')) DEFINE ('_DOWN_DELETE', 'Delete');
if (!defined('_DOWN_ADD_USERS_NEW_ROLE')) DEFINE ('_DOWN_ADD_USERS_NEW_ROLE', 'Add users to new role');
if (!defined('_DOWN_ADD_MEMBERS')) DEFINE ('_DOWN_ADD_MEMBERS', 'Add Members');
if (!defined('_DOWN_ADD_LOCAL')) DEFINE ('_DOWN_ADD_LOCAL', 'Add Local');
if (!defined('_DOWN_ADD_REMOTE')) DEFINE ('_DOWN_ADD_REMOTE', 'Add Remote');
if (!defined('_DOWN_EDIT_APPROVAL')) DEFINE ('_DOWN_EDIT_APPROVAL', 'Edit Approval');
if (!defined('_DOWN_DELETE_SUBMISSION')) DEFINE ('_DOWN_DELETE_SUBMISSION', 'Delete Submission');
if (!defined('_DOWN_CONTAINER')) DEFINE ('_DOWN_CONTAINER', 'Container');
if (!defined('_DOWN_PUBLISH_FILES')) DEFINE ('_DOWN_PUBLISH_FILES', 'Publish Files');
if (!defined('_DOWN_DELETE_ORPHANS')) DEFINE ('_DOWN_DELETE_ORPHANS', 'Delete Orphans');
if (!defined('_DOWN_ORPHAN')) DEFINE ('_DOWN_ORPHAN', 'Orphan');
if (!defined('_DOWN_MISSING')) DEFINE ('_DOWN_MISSING', 'Missing');
if (!defined('_DOWN_ADD_USERS_ROLE')) DEFINE ('_DOWN_ADD_USERS_ROLE', 'Add users to role');
if (!defined('_DOWN_REMOVE_USERS_ROLE')) DEFINE ('_DOWN_REMOVE_USERS_ROLE', 'Remove users from role');
if (!defined('_DOWN_PUBLISHING')) DEFINE ('_DOWN_PUBLISHING', 'Publishing');
if (!defined('_DOWN_EDIT_CONTAINER')) DEFINE ('_DOWN_EDIT_CONTAINER', 'Edit Container');
if (!defined('_DOWN_REMOSITORY')) DEFINE ('_DOWN_REMOSITORY', 'Remository');
if (!defined('_DOWN_PHYSICAL_FILE')) DEFINE ('_DOWN_PHYSICAL_FILE', 'Physical file');
if (!defined('_DOWN_METADATA')) DEFINE ('_DOWN_METADATA', 'Metadata');
if (!defined('_DOWN_SHORT_DESCRIPTION')) DEFINE ('_DOWN_SHORT_DESCRIPTION', 'Short Description');
if (!defined('_DOWN_LICENSE_HEADING')) DEFINE ('_DOWN_LICENSE_HEADING', 'License');
if (!defined('_DOWN_ABOUT_FILE')) DEFINE ('_DOWN_ABOUT_FILE', 'About the file');
if (!defined('_DOWN_COMMENTS_HEADING')) DEFINE ('_DOWN_COMMENTS_HEADING', 'Comments');
if (!defined('_DOWN_STORAGE')) DEFINE ('_DOWN_STORAGE', 'Storage');
if (!defined('_DOWN_ACCESS_CONTROL')) DEFINE ('_DOWN_ACCESS_CONTROL', 'Access Control');
if (!defined('_DOWN_DOWNLOAD_ROLES')) DEFINE ('_DOWN_DOWNLOAD_ROLES', 'Download Roles');
if (!defined('_DOWN_UPLOAD_ROLES')) DEFINE ('_DOWN_UPLOAD_ROLES', 'Upload Roles');
if (!defined('_DOWN_EDIT_ROLES')) DEFINE ('_DOWN_EDIT_ROLES', 'Edit Roles');
if (!defined('_DOWN_ADD_NEW_ROLE')) DEFINE ('_DOWN_ADD_NEW_ROLE', 'Add new role:');
// Recent additions 3.46+
if (!defined('_DOWN_DOWNLOAD_FROM')) DEFINE ('_DOWN_DOWNLOAD_FROM', 'Download from');
if (!defined('_DOWN_UPLOAD_TO')) DEFINE ('_DOWN_UPLOAD_TO', 'Upload to');
if (!defined('_DOWN_EDIT_IN')) DEFINE ('_DOWN_EDIT_IN', 'Edit in');
if (!defined('_DOWN_SUBS_EVERYTHING')) DEFINE ('_DOWN_SUBS_EVERYTHING', 'Count all file downloads');
if (!defined('_DOWN_SUBS_COUNT_DOWNLOAD')) DEFINE ('_DOWN_SUBS_COUNT_DOWNLOAD', 'Count specific container downloads');
if (!defined('_DOWN_SUBS_COUNT_UPLOAD')) DEFINE ('_DOWN_SUBS_COUNT_UPLOAD', 'Count specific container uploads');
if (!defined('_DOWN_SUBS_COUNT_DOWNLOAD_PLUS')) DEFINE ('_DOWN_SUBS_COUNT_DOWNLOAD_PLUS', 'Count container and descendants downloads');
if (!defined('_DOWN_SUBS_COUNT_UPLOAD_PLUS')) DEFINE ('_DOWN_SUBS_COUNT_UPLOAD_PLUS', 'Count container and descendants uploads');
if (!defined('_DOWN_COUNT_DOWN')) DEFINE ('_DOWN_COUNT_DOWN', 'Subscriber manager to count downloads');
if (!defined('_DOWN_COUNT_DOWN_CHILD')) DEFINE ('_DOWN_COUNT_DOWN_CHILD', 'Include descendants in download counting');
if (!defined('_DOWN_COUNT_UP')) DEFINE ('_DOWN_COUNT_UP', 'Subscriber manager to count uploads');
if (!defined('_DOWN_COUNT_UP_CHILD')) DEFINE ('_DOWN_COUNT_UP_CHILD', 'Include descendants in upload counting');
if (!defined('_DOWN_CONFIG54')) DEFINE ('_DOWN_CONFIG54', 'Count_Down:<br /><em>(Restrict all downloads using subscriber manager)</em>');
if (!defined('_DOWN_CONFIG53')) DEFINE ('_DOWN_CONFIG53', 'Show_File_Folder_Counts:<br /><em>(Show File and Folder Counts)</em>');
if (!defined('_DOWN_CONFIG52')) DEFINE ('_DOWN_CONFIG52', 'Show_Footer:<br /><em>(Show Remository Footer (Search/Submit/Credit))</em>');
if (!defined('_DOWN_CONFIG51')) DEFINE ('_DOWN_CONFIG51', 'Allow_File_Info:<br /><em>(Link to detailed file information from file list)</em>');
if (!defined('_DOWN_IS_ACTIVE')) DEFINE ('_DOWN_IS_ACTIVE', 'Active?');
if (!defined('_DOWN_NEW_REPOSITORY')) DEFINE ('_DOWN_NEW_REPOSITORY', 'Create a new repository like the current one');
if (!defined('_DOWN_REPOSITORY_NAME')) DEFINE ('_DOWN_REPOSITORY_NAME', 'Repository name');
if (!defined('_DOWN_REPOSITORY_NUMBER')) DEFINE ('_DOWN_REPOSITORY_NUMBER', 'Repository number');
if (!defined('_DOWN_REPOSITORY_ALIAS')) DEFINE ('_DOWN_REPOSITORY_ALIAS', 'Repository alias');
// Recent additions 3.46
if (!defined('_DOWN_SUBTITLE')) DEFINE ('_DOWN_SUBTITLE', 'File subtitle:');
if (!defined('_DOWN_PUBLISHER_ID')) DEFINE ('_DOWN_PUBLISHER_ID', 'Publisher ID:');
if (!defined('_DOWN_PUBLISHED_DATE')) DEFINE ('_DOWN_PUBLISHED_DATE', 'Published Date:');
if (!defined('_DOWN_ALIAS')) DEFINE ('_DOWN_ALIAS', 'Alias');
if (!defined('_DOWN_BOTH')) DEFINE ('_DOWN_BOTH', 'Both');
if (!defined('_DOWN_CONFIG50')) DEFINE ('_DOWN_CONFIG50', 'Remository_Pathway:<br /><em>(Use Remository bread crumb (pathway))</em>');
if (!defined('_DOWN_SEARCHING_BY')) DEFINE ('_DOWN_SEARCHING_BY', 'Searching by');
if (!defined('_DOWN_FILTERING_BY')) DEFINE ('_DOWN_FILTERING_BY', 'Filtering by');
if (!defined('_DOWN_REMOVE_TERM')) DEFINE ('_DOWN_REMOVE_TERM', 'remove term');
if (!defined('_DOWN_NO_FILTERS')) DEFINE ('_DOWN_NO_FILTERS', 'No filters in effect - all items retrieved');
if (!defined('_DOWN_REVIEW_TAGS')) DEFINE ('_DOWN_REVIEW_TAGS', 'Review tags in the group');
if (!defined('_DOWN_NO_RESULTS_1')) DEFINE ('_DOWN_NO_RESULTS_1', 'Sorry, your search returned no results.');
if (!defined('_DOWN_NO_RESULTS_2')) DEFINE ('_DOWN_NO_RESULTS_2', 'Can\'t find what you want?');
if (!defined('_DOWN_CONTACT_US')) DEFINE ('_DOWN_CONTACT_US', 'Contact us to discuss what you are looking for.');
if (!defined('_DOWN_ALL_CATS_RETRY')) DEFINE ('_DOWN_ALL_CATS_RETRY', 'Retry this search with all categories selected?');
if (!defined('_DOWN_ADD_ALL_CATS')) DEFINE ('_DOWN_ADD_ALL_CATS', 'Add all categories');
if (!defined('_DOWN_CONFIG49')) DEFINE ('_DOWN_CONFIG49', 'Classification_Types:<br /><em>(Classification types (comma separated))</em>');

// Recent additions 3.45
if (!defined('_DOWN_GROUP_NO_NAME')) DEFINE ('_DOWN_GROUP_NO_NAME', 'Group not saved - no name');
if (!defined('_DOWN_GROUP_SAVED')) DEFINE ('_DOWN_GROUP_SAVED', 'Group has been saved');
if (!defined('_DOWN_CONFIG48')) DEFINE ('_DOWN_CONFIG48', 'Show_RSS_feeds:<br /><em>(Show RSS feeds)</em>');
if (!defined('_DOWN_CONFIG46')) DEFINE ('_DOWN_CONFIG46', 'ExtsDisplay:<br /><em>(Extensions that can be displayed online (Comma Separated List))</em>');
if (!defined('_DOWN_DISPLAY_NOW')) DEFINE ('_DOWN_DISPLAY_NOW', 'Display this file now');
if (!defined('_DOWN_CONFIG47')) DEFINE ('_DOWN_CONFIG47', 'Scribd:<br /><em>(Scribd publishing key)</em>');
if (!defined('')) DEFINE ('', '');
// Recent addition 3.44.1
if (!defined('_DOWN_AEC_REFUSED')) DEFINE ('_DOWN_AEC_REFUSED', 'Sorry, AEC says that your download limit is exhausted');
// Recent additions 3.44
if (!defined('_DOWN_FIELD')) DEFINE ('_DOWN_FIELD', 'Field');
if (!defined('_DOWN_SEQUENCE')) DEFINE ('_DOWN_SEQUENCE', 'Sequence');
if (!defined('_DOWN_CONFIG_EXPLAIN_1')) DEFINE ('_DOWN_CONFIG_EXPLAIN_1', 'A = Select fields for file list in container');
if (!defined('_DOWN_CONFIG_EXPLAIN_2')) DEFINE ('_DOWN_CONFIG_EXPLAIN_2', 'B = Select fields for results of search');
if (!defined('_DOWN_CONFIG_EXPLAIN_3')) DEFINE ('_DOWN_CONFIG_EXPLAIN_3', 'C = Select fields for results of multiple file upload');
// Recent additions 3.43:
if (!defined('_DOWN_ADDFILE_THUMBNAIL')) DEFINE ('_DOWN_ADDFILE_THUMBNAIL', 'Thumbnail %u (optional):');
if (!defined('_DOWN_CONFIG45')) DEFINE("_DOWN_CONFIG45","Default_Licence:<br /><em>(Optional - if present will be used for every item not having a specific licence)</em>");
if (!defined('_DOWN_CONFIG_TITLE_LICENCE')) DEFINE('_DOWN_CONFIG_TITLE_LICENCE', 'Licence');
if (!defined('_DOWN_VISIT')) DEFINE('_DOWN_VISIT','Visit');
if (!defined('_DOWN_EDIT')) DEFINE('_DOWN_EDIT','Edit');
if (!defined('_DOWN_STRUCT_RECURSE_ALL')) DEFINE('_DOWN_STRUCT_RECURSE_ALL','Include all subdirectories and their files');
if (!defined('_DOWN_STRUCT_RECURSE_DIR')) DEFINE('_DOWN_STRUCT_RECURSE_DIR','Include only top level files and directories');
if (!defined('_DOWN_STRUCT_RECURSE_NONE')) DEFINE('_DOWN_STRUCT_RECURSE_NONE','Include only top level files');
if (!defined('_DOWN_STRUCT_NO_DIR')) DEFINE ('_DOWN_STRUCT_NO_DIR', 'The specified directory does not exist');
if (!defined('_DOWN_ADMINISTRATOR')) DEFINE ('_DOWN_ADMINISTRATOR', 'Administrator');
// Recent modifications 3.43:
if (!defined('_DOWN_ADMIN_ACT_ADDSTRUCTURE')) DEFINE('_DOWN_ADMIN_ACT_ADDSTRUCTURE','Add files already on server');
if (!defined('_DOWN_STRUCTURE_ADDED')) DEFINE('_DOWN_STRUCTURE_ADDED','Files added to repository');
if (!defined('_DOWN_ADDSTRUCTURE_TITLE')) DEFINE('_DOWN_ADDSTRUCTURE_TITLE','add files already on server');
//
if (!defined('_REM_INTERNAL')) DEFINE('_REM_INTERNAL','Remository Internal Error');
if (!defined('_DOWNLOADS_TITLE')) DEFINE('_DOWNLOADS_TITLE',"$mosConfig_sitename :: File Repository");
if (!defined('_UP_FILE')) DEFINE('_UP_FILE','Upload File');
if (!defined('_ADD_FILE_BUTTON')) DEFINE('_ADD_FILE_BUTTON','Add File');
if (!defined('_SUBMIT_FILE_BUTTON')) DEFINE('_SUBMIT_FILE_BUTTON','Submit');
if (!defined('_DOWN_ROLE_REGISTERED')) DEFINE('_DOWN_ROLE_REGISTERED','Registered');
if (!defined('_DOWN_ROLE_VISITOR')) DEFINE('_DOWN_ROLE_VISITOR','Public');
if (!defined('_DOWN_ROLE_NOBODY')) DEFINE('_DOWN_ROLE_NOBODY','Nobody');
if (!defined('_DOWN_ROLE_NONE_THESE')) DEFINE('_DOWN_ROLE_NONE_THESE','None of these');
if (!defined('_DOWN_PAGE_TEXT')) DEFINE ('_DOWN_PAGE_TEXT', 'Page');
if (!defined('_DOWN_PAGE_SHOW_RESULTS')) DEFINE('_DOWN_PAGE_SHOW_RESULTS','Show results ');
if (!defined('_DOWN_PAGE_SHOW_RANGE')) DEFINE('_DOWN_PAGE_SHOW_RANGE','%s to %s of %s');
if (!defined('_SUBMIT_FILE_NOLOG')) DEFINE('_SUBMIT_FILE_NOLOG', 'Submit denied - not logged in');
if (!defined('_SUBMIT_FILE_NOUSER')) DEFINE('_SUBMIT_FILE_NOUSER', 'Submit denied - admin only');
if (!defined('_SUBMIT_FILE_NOLIMIT')) DEFINE('_SUBMIT_FILE_NOLIMIT', 'Submit denied - limit reached');
if (!defined('_SUBMIT_FILE_NOSPACE')) DEFINE('_SUBMIT_FILE_NOSPACE', 'Submit denied - no space left');
if (!defined('_SUBMIT_NO_DDIR')) DEFINE('_SUBMIT_NO_DDIR', 'Submit denied - no download dir');
if (!defined('_SUBMIT_NO_UDDIR')) DEFINE('_SUBMIT_NO_UDDIR', 'Submit denied - no down-up dir');
if (!defined('_SUBMIT_HEADING')) DEFINE('_SUBMIT_HEADING', 'Upload File for Repository');
if (!defined('_SUBMIT_INSTRUCT1')) DEFINE('_SUBMIT_INSTRUCT1', 'EITHER browse your computer and select a file you wish to upload from your computer for sharing.');
if (!defined('_SUBMIT_INSTRUCT2')) DEFINE('_SUBMIT_INSTRUCT2', 'OR if the file exists elsewhere on the net, enter the URL for that file and other details.');
if (!defined('_SUBMIT_INSTRUCT3')) DEFINE('_SUBMIT_INSTRUCT3', 'Please choose the file to be submitted, and complete the relevant details.');
if (!defined('_DOWN_FILE_SUBMIT_NOCHOICES')) DEFINE('_DOWN_FILE_SUBMIT_NOCHOICES','You have no permitted upload categories - please refer to the webmaster');
if (!defined('_SUBMIT_NEW_FILE')) DEFINE('_SUBMIT_NEW_FILE', 'New File');
if (!defined('_SUBMIT_UPLOAD_BUTTON')) DEFINE('_SUBMIT_UPLOAD_BUTTON', 'Upload File &amp; Store');
if (!defined('_MAIN_DOWNLOADS')) DEFINE('_MAIN_DOWNLOADS','Main Repository Page');
if (!defined('_BACK_CAT')) DEFINE('_BACK_CAT','Back to Parent Category');
if (!defined('_BACK_FOLDER')) DEFINE('_BACK_FOLDER','Back to Parent Folder');
if (!defined('_DOWN_START')) DEFINE('_DOWN_START','Your download will start in 2 seconds');
if (!defined('_DOWN_CLICK')) DEFINE('_DOWN_CLICK','Click here if it doesn\'t start');
if (!defined('_INVALID_ID')) DEFINE('_INVALID_ID','Invalid ID');
if (!defined('_DOWN_CATEGORY')) DEFINE('_DOWN_CATEGORY','Category');
if (!defined('_DOWN_NO_PARENT')) DEFINE('_DOWN_NO_PARENT','No parent - top level **');
if (!defined('_DOWN_FOLDER')) DEFINE('_DOWN_FOLDER','Folder');
if (!defined('_DOWN_FOLDERS')) DEFINE('_DOWN_FOLDERS','Folders');
if (!defined('_DOWN_FILES')) DEFINE('_DOWN_FILES','Files');
if (!defined('_DOWN_FOLDERS_FILES')) DEFINE('_DOWN_FOLDERS_FILES','Folders/Files');
if (!defined('_DOWN_NO_CATS')) DEFINE('_DOWN_NO_CATS',"The Repository has not yet been established for <em>$mosConfig_sitename</em>.<br />&nbsp;<br />No Categories Defined.");
if (!defined('_DOWN_NO_VISITOR_CATS')) DEFINE('_DOWN_NO_VISITOR_CATS','Sorry, the Repository is not available to casual visitors - please login');
if (!defined('_DOWN_ADMIN_FUNC')) DEFINE('_DOWN_ADMIN_FUNC','Admin Functions:');
if (!defined('_DOWN_ADD_CAT')) DEFINE('_DOWN_ADD_CAT','Add Category');
if (!defined('_DOWN_DEL_CAT')) DEFINE('_DOWN_DEL_CAT','Delete Category');
if (!defined('_DOWN_EDIT_CAT')) DEFINE('_DOWN_EDIT_CAT','Edit Category');
if (!defined('_DOWN_UP_NEITHER')) DEFINE('_DOWN_UP_NEITHER','Neither');
if (!defined('_DOWN_UP_DOWNLOAD_ONLY')) DEFINE('_DOWN_UP_DOWNLOAD_ONLY','Download Only');
if (!defined('_DOWN_UP_UPLOAD_ONLY')) DEFINE('_DOWN_UP_UPLOAD_ONLY','Upload Only');
if (!defined('_DOWN_UP_BOTH')) DEFINE('_DOWN_UP_BOTH','Both');
if (!defined('_DOWN_USERS_PERMITTED')) DEFINE('_DOWN_USERS_PERMITTED','Users permitted to:');
if (!defined('_DOWN_VISITORS_PERMITTED')) DEFINE('_DOWN_VISITORS_PERMITTED','Public permitted to:');
if (!defined('_DOWN_UP_ABSOLUTE_PATH')) DEFINE('_DOWN_UP_ABSOLUTE_PATH','Absolute path (optional):');
if (!defined('_DOWN_ADD_FOLDER')) DEFINE('_DOWN_ADD_FOLDER','Add Folder');
if (!defined('_DOWN_DEL_FOLDER')) DEFINE('_DOWN_DEL_FOLDER','Delete Folder');
if (!defined('_DOWN_EDIT_FOLDER')) DEFINE('_DOWN_EDIT_FOLDER','Edit Folder');
if (!defined('_DOWN_ADD_FILE')) DEFINE('_DOWN_ADD_FILE','Add File');
if (!defined('_DOWN_DEL_FILE')) DEFINE('_DOWN_DEL_FILE','Delete File');
if (!defined('_DOWN_EDIT_FILE')) DEFINE('_DOWN_EDIT_FILE','Edit File');
if (!defined('_DOWN_PUB')) DEFINE('_DOWN_PUB','Published:');
if (!defined('_DOWN_SUBMIT_ANOTHER')) DEFINE('_DOWN_SUBMIT_ANOTHER','Submit another file now?');
if (!defined('_DOWN_SUBMIT_INSPECT')) DEFINE('_DOWN_SUBMIT_INSPECT','View the file just submitted?');
if (!defined('_YES')) DEFINE('_YES','Yes');
if (!defined('_NO')) DEFINE('_NO','No');
if (!defined('_GLOBAL')) DEFINE('_GLOBAL','Global');
if (!defined('_DOWN_DESC')) DEFINE('_DOWN_DESC','Description:');
if (!defined('_DOWN_DOWNLOADS')) DEFINE('_DOWN_DOWNLOADS','Downloads:');
if (!defined('_DOWN_THUMBNAILS')) DEFINE('_DOWN_THUMBNAILS','Thumbnails:');
if (!defined('_DOWN_RATING')) DEFINE('_DOWN_RATING','Rating:');
if (!defined('_DOWN_VOTES')) DEFINE('_DOWN_VOTES','Total Votes:');
if (!defined('_DOWN_YOUR_VOTE')) DEFINE('_DOWN_YOUR_VOTE','Your Vote:');
if (!defined('_DOWN_RATE_BUTTON')) DEFINE('_DOWN_RATE_BUTTON','Rate');
if (!defined('_DOWN_ALREADY_VOTE')) DEFINE('_DOWN_ALREADY_VOTE','You aleady voted for this download. Thank you.');
if (!defined('_DOWN_FILE_TITLE')) DEFINE('_DOWN_FILE_TITLE','File Title:');
if (!defined('_DOWN_FILE_TITLE_SORT')) DEFINE('_DOWN_FILE_TITLE_SORT','File Title');
if (!defined('_DOWN_REAL_NAME')) DEFINE('_DOWN_REAL_NAME','File physical name:');
if (!defined('_DOWNLOAD')) DEFINE('_DOWNLOAD','Download');
if (!defined('_DOWN_DOWNLOADS_SORT')) DEFINE('_DOWN_DOWNLOADS_SORT','Downloads');
if (!defined('_DOWN_SUB_BY')) DEFINE('_DOWN_SUB_BY','Submitted By:');
if (!defined('_DOWN_FILE_DATE')) DEFINE('_DOWN_FILE_DATE','File Date:');
if (!defined('_DOWN_FILE_AUTHOR')) DEFINE('_DOWN_FILE_AUTHOR','File Author:');
if (!defined('_DOWN_FILE_VER')) DEFINE('_DOWN_FILE_VER','File Version:');
if (!defined('_DOWN_FILE_SIZE')) DEFINE('_DOWN_FILE_SIZE','File Size:');
if (!defined('_DOWN_FILE_TYPE')) DEFINE('_DOWN_FILE_TYPE','File Type:');
if (!defined('_DOWN_FILE_COMPANY')) DEFINE('_DOWN_FILE_COMPANY','Company:');
if (!defined('_DOWN_FILE_COMPANY_URL')) DEFINE('_DOWN_FILE_COMPANY_URL','Company web site URL:');
if (!defined('_DOWN_FILE_AUTHOR_URL')) DEFINE('_DOWN_FILE_AUTHOR_URL','Author web site URL:');
if (!defined('_DOWN_FILE_RELEASE_DATE')) DEFINE('_DOWN_FILE_RELEASE_DATE','Release date (YYYY-MM-DD):');
if (!defined('_DOWN_FILE_STATUS')) DEFINE('_DOWN_FILE_STATUS','Status:');
if (!defined('_DOWN_FILE_LANGUAGES')) DEFINE('_DOWN_FILE_LANGUAGES','Supported languages:');
if (!defined('_DOWN_FILE_REQUIREMENTS')) DEFINE('_DOWN_FILE_REQUIREMENTS','Requirements:');
if (!defined('_DOWN_FILE_OPERATING_SYSTEM')) DEFINE('_DOWN_FILE_OPERATING_SYSTEM','Operating system:');
if (!defined('_DOWN_SCREEN')) DEFINE('_DOWN_SCREEN','Screenshot:');
if (!defined('_DOWN_SCREEN_CLICK')) DEFINE('_DOWN_SCREEN_CLICK','Click to View');
if (!defined('_DOWN_NA')) DEFINE('_DOWN_NA','N/A');
if (!defined('_DOWN_CAT_NAME')) DEFINE('_DOWN_CAT_NAME','Category Name:');
if (!defined('_DOWN_SUB_BUTTON')) DEFINE('_DOWN_SUB_BUTTON','Go');
if (!defined('_DOWN_ALL_DONE')) DEFINE('_DOWN_ALL_DONE','All Done!');
if (!defined('_DOWN_NOT_AUTH')) DEFINE('_DOWN_NOT_AUTH','Not Authorized!');
if (!defined('_DOWN_FOLDER_NAME')) DEFINE('_DOWN_FOLDER_NAME','Folder Name:');
if (!defined('_DOWN_FOLDER_ADD_BUT')) DEFINE('_DOWN_FOLDER_ADD_BUT','Add Folder');
if (!defined('_DOWN_UP_WAIT')) DEFINE('_DOWN_UP_WAIT','Please Note: All Uploads will be reviewed prior to Publishing.');
if (!defined('_DOWN_AUTOAPP')) DEFINE('_DOWN_AUTOAPP','Your file was automatically approved and published.');
if (!defined('_DOWN_APPROVE_PUB')) DEFINE('_DOWN_APPROVE_PUB','Approve + publish');
if (!defined('_DOWN_SUGGEST_LOC')) DEFINE('_DOWN_SUGGEST_LOC','Suggest Location:');
if (!defined('_DOWNLOAD_URL')) DEFINE('_DOWNLOAD_URL','Download URL:');
if (!defined('_DOWN_ICON')) DEFINE('_DOWN_ICON','Icon:');
if (!defined('_DOWN_MOVE_FILE')) DEFINE('_DOWN_MOVE_FILE','Move the File:');
if (!defined('_DOWN_MOVE_FILE_FAILED')) DEFINE('_DOWN_MOVE_FILE_FAILED','File move failed');
if (!defined('_DOWN_FILE_NEW_LOC')) DEFINE('_DOWN_FILE_NEW_LOC','New Location for File:');
if (!defined('_DOWN_AWAIT_APPROVE')) DEFINE('_DOWN_AWAIT_APPROVE','File Submissions Awaiting Approval:');
if (!defined('_DOWN_ADMIN_APPROVE')) DEFINE('_DOWN_ADMIN_APPROVE','Approve Submissions');
if (!defined('_DOWN_ID')) DEFINE('_DOWN_ID','ID');
if (!defined('_DOWN_SUBMIT_DATE')) DEFINE('_DOWN_SUBMIT_DATE','Submitted Date:');
if (!defined('_DOWN_APP_SUB_BUTTON')) DEFINE('_DOWN_APP_SUB_BUTTON','Approve Submission');
if (!defined('_DOWN_DEL_SUB_BUTTON')) DEFINE('_DOWN_DEL_SUB_BUTTON','Delete Submission');
if (!defined('_DOWN_SUB_APPROVE')) DEFINE('_DOWN_SUB_APPROVE','The Submission has been approved.');
if (!defined('_DOWN_SUB_DEL')) DEFINE('_DOWN_SUB_DEL','The Submission has been deleted.');
if (!defined('_DOWN_NO_SUB')) DEFINE('_DOWN_NO_SUB','No more submissions to approve.');
if (!defined('_DOWN_REV_SUB')) DEFINE('_DOWN_REV_SUB','Review More Submissions');
if (!defined('_DOWN_SEARCH')) DEFINE('_DOWN_SEARCH','Search Repository');
if (!defined('_DOWN_SEARCH_TEXT')) DEFINE('_DOWN_SEARCH_TEXT','Search For:');
if (!defined('_DOWN_SEARCH_FILETITLE')) DEFINE('_DOWN_SEARCH_FILETITLE','Search File Titles:');
if (!defined('_DOWN_SEARCH_FILEDESC')) DEFINE('_DOWN_SEARCH_FILEDESC','Search File Descriptions:');
if (!defined('_DOWN_SEARCH_ERR')) DEFINE('_DOWN_SEARCH_ERR','You must specify at least one search field, along with the search text.');
if (!defined('_DOWN_SEARCH_NORES')) DEFINE('_DOWN_SEARCH_NORES','No Files Found.');
if (!defined('_DOWN_FILE_HOMEPAGE')) DEFINE('_DOWN_FILE_HOMEPAGE','File HomePage:');
if (!defined('_DOWN_UPDATE_SUB')) DEFINE('_DOWN_UPDATE_SUB','Update Submission');
if (!defined('_DOWN_UP_EDIT_ID')) DEFINE('_DOWN_UP_EDIT_ID','FileID:');
if (!defined('_DOWN_FILE_DEL_NOTE')) DEFINE('_DOWN_FILE_DEL_NOTE','Note: The Old File listing was removed from the DB, but the physical file <b>may</b> still exist.');
if (!defined('_DOWN_SUB_DATE')) DEFINE('_DOWN_SUB_DATE','Submitted On:');
if (!defined('_DOWN_SUB_DATE_SORT')) DEFINE('_DOWN_SUB_DATE_SORT','Submit Date');
if (!defined('_DOWN_SUB_ID_SORT')) DEFINE ('_DOWN_SUB_ID_SORT', 'Submitter');
if (!defined('_DOWN_COMMENTS')) DEFINE('_DOWN_COMMENTS','Comments:');
if (!defined('_DOWN_YOUR_COMM')) DEFINE('_DOWN_YOUR_COMM','Your Comment:');
if (!defined('_DOWN_LEAVE_COMM')) DEFINE('_DOWN_LEAVE_COMM','Leave Comment');
if (!defined('_DOWN_FIRST_COMMENT')) DEFINE('_DOWN_FIRST_COMMENT','Be the first to commment on this file!');
if (!defined('_DOWN_FIRST_COMMENT_NL')) DEFINE('_DOWN_FIRST_COMMENT_NL','Be the first to comment!  Please sign in or register.');
if (!defined('_DOWN_ALREADY_COMM')) DEFINE('_DOWN_ALREADY_COMM','You already commented on this file.');
if (!defined('_DOWN_MAX_COMM')) DEFINE("_DOWN_MAX_COMM","Max: $Small_Text_Len Chars");
if (!defined('_DOWN_DESC_MAX')) DEFINE("_DOWN_DESC_MAX","Max: $Large_Text_Len Chars");
if (!defined('_DOWN_MAIL_SUB')) DEFINE('_DOWN_MAIL_SUB','New Remository Downloads Submission');
if (!defined('_DOWN_ORDER_BY')) DEFINE('_DOWN_ORDER_BY','Order By :');
if (!defined('_DOWN_RESET')) DEFINE('_DOWN_RESET','Recalculate File Counts');
if (!defined('_DOWN_RESET_GO')) DEFINE('_DOWN_RESET_GO','Recalculating File Counts...');
if (!defined('_DOWN_RESET_DONE')) DEFINE('_DOWN_RESET_DONE','Recalculation of File Counts Complete');
if (!defined('_DOWN_FIND_ORPHANS')) DEFINE('_DOWN_FIND_ORPHANS','Find File Orphans');
if (!defined('_DOWN_DEL_ORPHANS')) DEFINE('_DOWN_DEL_ORPHANS','Delete File Orphans');
if (!defined('_DOWN_ORPHAN_SELECT')) DEFINE('_DOWN_ORPHAN_SELECT','Select');
if (!defined('_DOWN_ORPHAN_FILE_DEL')) DEFINE('_DOWN_ORPHAN_FILE_DEL','File to Delete');
if (!defined('_DOWN_ORPHAN_NODEL')) DEFINE('_DOWN_ORPHAN_NODEL','No Files to Delete');
if (!defined('_DOWN_ORPHAN_DONE')) DEFINE('_DOWN_ORPHAN_DONE','File Orphans Deleted');
if (!defined('_DOWN_BAD_POST')) DEFINE('_DOWN_BAD_POST','The settings have not been propely sent from the form.');
if (!defined('_DOWN_SUB_WAIT')) DEFINE('_DOWN_SUB_WAIT','An updated submission is already awaiting approval for this file.');
if (!defined('_DOWN_REG_ONLY')) DEFINE('_DOWN_REG_ONLY','Registered Users Only:');
if (!defined('_DOWN_RESTRICTED_WARN')) DEFINE('_DOWN_RESTRICTED_WARN','Sorry, this area is non-existent or unavailable');
if (!defined('_DOWN_MEMBER_ONLY_WARN')) DEFINE('_DOWN_MEMBER_ONLY_WARN',"This location is for Group Members Only.<br />"
                             ."Please refer to administrator about groups that can access ");
if (!defined('_DOWN_REG_ONLY_WARN')) DEFINE("_DOWN_REG_ONLY_WARN","This location is for Registered Users Only.<br />"
                             ."Perhaps you need to login or register.");
if (!defined('_DOWN_COUNT_EXCEEDED')) DEFINE('_DOWN_COUNT_EXCEEDED',"Sorry, your download limit has been reached");
if (!defined('_DOWN_COUNT_EXCEEDED_FILE')) DEFINE('_DOWN_COUNT_EXCEEDED_FILE',"Sorry, your download limit has been reached for this file");
if (!defined('_DOWN_NO_FILEN')) DEFINE('_DOWN_NO_FILEN','Please Enter a Filename');
if (!defined('_DOWN_MINI_SCREEN_PROMPT')) DEFINE('_DOWN_MINI_SCREEN_PROMPT','Show Mini ScreenShot on Filelist:');
if (!defined('_DOWN_SEL_LOC_PROMPT')) DEFINE('_DOWN_SEL_LOC_PROMPT','Select Location');
if (!defined('_DOWN_ALL_LOC_PROMPT')) DEFINE('_DOWN_ALL_LOC_PROMPT','All Locations');
if (!defined('_DOWN_SEL_CAT_DEL')) DEFINE('_DOWN_SEL_CAT_DEL','Select a category to delete');
if (!defined('_DOWN_NO_CAT_DEF')) DEFINE('_DOWN_NO_CAT_DEF','No Categories Defined');
if (!defined('_DOWN_PUB_PROMPT')) DEFINE('_DOWN_PUB_PROMPT','Select a category to ');
if (!defined('_DOWN_SEL_FILE_DEL')) DEFINE('_DOWN_SEL_FILE_DEL','Select a file to delete');
if (!defined('_DOWN_CONFIG_COMP')) DEFINE('_DOWN_CONFIG_COMP','The configuration details have been updated!');
if (!defined('_DOWN_CONFIG_ERR')) DEFINE("_DOWN_CONFIG_ERR","An Error Has Occurred!\nUnable to open config file to write!");
if (!defined('_DOWN_CATS')) DEFINE('_DOWN_CATS','Categories');
if (!defined('_DOWN_PARENT_CAT')) DEFINE('_DOWN_PARENT_CAT','Parent Category');
if (!defined('_DOWN_PARENT_FOLDER')) DEFINE('_DOWN_PARENT_FOLDER','Parent Folder');
if (!defined('_DOWN_PUB1')) DEFINE('_DOWN_PUB1','Published');
if (!defined('_DOWN_RECORDS')) DEFINE('_DOWN_RECORDS','Records');
if (!defined('_DOWN_ACCESS')) DEFINE('_DOWN_ACCESS','Access');
if (!defined('_DOWN_GROUP')) DEFINE('_DOWN_GROUP','Group');
if (!defined('_DOWN_FILE_SYSTEM')) DEFINE('_DOWN_FILE_SYSTEM','File System');
if (!defined('_DOWN_FILE_SYSTEM_OK')) DEFINE('_DOWN_FILE_SYSTEM_OK','File System - OK');
if (!defined('_DOWN_DIRECTORY_NON_EXISTENT')) DEFINE('_DOWN_DIRECTORY_NON_EXISTENT','Non-existent directory');
if (!defined('_DOWN_NOT_WRITEABLE')) DEFINE('_DOWN_NOT_WRITEABLE','Directory not writeable');
if (!defined('_DOWN_WRITEABLE')) DEFINE('_DOWN_WRITEABLE','Directory writeable');
if (!defined('_DOWN_DATABASE')) DEFINE('_DOWN_DATABASE','Database');
if (!defined('_DOWN_ADMIN_CPANEL_STORE')) DEFINE ('_DOWN_ADMIN_CPANEL_STORE','Default storage for new containers:');
if (!defined('_DOWN_ADMIN_CPANEL_FILESTORE')) DEFINE ('_DOWN_ADMIN_CPANEL_FILESTORE','Default file system store:');
if (!defined('_DOWN_ADMIN_CPANEL_UPLOADS')) DEFINE ('_DOWN_ADMIN_CPANEL_UPLOADS','Upload holding area:');
if (!defined('_DOWN_CPANEL_RETURN')) DEFINE ('_DOWN_CPANEL_RETURN','Control Panel');
if (!defined('_DOWN_CPANEL_SUB_BASIC')) DEFINE ('_DOWN_CPANEL_SUB_BASIC','Basic Management');
if (!defined('_DOWN_CPANEL_SUB_FILES')) DEFINE ('_DOWN_CPANEL_SUB_FILES','File Handling');
if (!defined('_DOWN_CPANEL_SUB_HKEEP')) DEFINE ('_DOWN_CPANEL_SUB_HKEEP','Housekeeping');
if (!defined('_DOWN_CPANEL_SUB_UTILS')) DEFINE ('_DOWN_CPANEL_SUB_UTILS','Utilities');
if (!defined('_DOWN_CPANEL_SUB_INFO')) DEFINE ('_DOWN_CPANEL_SUB_INFO','Information');
if (!defined('_DOWN_ADMIN_ACT_CONTAINERS')) DEFINE('_DOWN_ADMIN_ACT_CONTAINERS','Manage containers');
if (!defined('_DOWN_ADMIN_ACT_FILES')) DEFINE('_DOWN_ADMIN_ACT_FILES','Manage files');
if (!defined('_DOWN_ADMIN_ACT_GROUPS')) DEFINE('_DOWN_ADMIN_ACT_GROUPS','Manage groups');
if (!defined('_DOWN_ADMIN_ACT_UPLOADS')) DEFINE('_DOWN_ADMIN_ACT_UPLOADS','Approve uploads');
if (!defined('_DOWN_ADMIN_ACT_CONFIG')) DEFINE('_DOWN_ADMIN_ACT_CONFIG','Configuration');
if (!defined('_DOWN_ADMIN_ACT_UNLINKED')) DEFINE('_DOWN_ADMIN_ACT_UNLINKED','Handle unlinked files/orphans');
if (!defined('_DOWN_ADMIN_ACT_FTP')) DEFINE('_DOWN_ADMIN_ACT_FTP','Bulk add files from server');
if (!defined('_DOWN_ADMIN_ACT_MISSING')) DEFINE('_DOWN_ADMIN_ACT_MISSING','List missing files');
if (!defined('_DOWN_ADMIN_ACT_COUNTS')) DEFINE('_DOWN_ADMIN_ACT_COUNTS','Recalculate file counts');
if (!defined('_DOWN_ADMIN_ACT_DOWNLOADS')) DEFINE('_DOWN_ADMIN_ACT_DOWNLOADS','Set all download counts zero');
if (!defined('_DOWN_ADMIN_ACT_PRUNE')) DEFINE('_DOWN_ADMIN_ACT_PRUNE','Remove old log file entries');
if (!defined('_DOWN_ADMIN_ACT_THUMBS')) DEFINE('_DOWN_ADMIN_ACT_THUMBS','Check thumbnail integrity');
if (!defined('_DOWN_ADMIN_ACT_DBCONVERT')) DEFINE('_DOWN_ADMIN_ACT_DBCONVERT','Convert pre 3.20 database');
if (!defined('_DOWN_ADMIN_ACT_DBCONVERT2')) DEFINE('_DOWN_ADMIN_ACT_DBCONVERT2','Convert pre 3.40 database');
if (!defined('_DOWN_ADMIN_ACT_STATS')) DEFINE('_DOWN_ADMIN_ACT_STATS','Statistics');
if (!defined('_DOWN_ADMIN_ACT_ABOUT')) DEFINE('_DOWN_ADMIN_ACT_ABOUT','About Remository');
if (!defined('_DOWN_ADMIN_ACT_SUPPORT')) DEFINE('_DOWN_ADMIN_ACT_SUPPORT','Support and Development');
if (!defined('_DOWN_MOST_DOWNLOADED')) DEFINE('_DOWN_MOST_DOWNLOADED','Most downloaded');
if (!defined('_DOWN_MOST_DOWNLOADED_LONG')) DEFINE('_DOWN_MOST_DOWNLOADED_LONG','Files with the highest download count');
if (!defined('_DOWN_POPULAR')) DEFINE ('_DOWN_POPULAR','Popular Files');
if (!defined('_DOWN_POPULAR_LONG')) DEFINE ('_DOWN_POPULAR_LONG','Files most downloaded in the last %s days');
if (!defined('_DOWN_NEWEST')) DEFINE ('_DOWN_NEWEST','Recent Files');
if (!defined('_DOWN_NEWEST_LONG')) DEFINE ('_DOWN_NEWEST_LONG','Latest from our file repository');
if (!defined('_DOWN_VISITORS')) DEFINE('_DOWN_VISITORS','Public');
if (!defined('_DOWN_REG_USERS')) DEFINE ('_DOWN_REG_USERS','Registered Users');
if (!defined('_DOWN_OTHER_USERS')) DEFINE ('_DOWN_OTHER_USERS', 'Other Users');
if (!defined('_DOWN_STORAGE_STATUS')) DEFINE ('_DOWN_STORAGE_STATUS','Storage Status');
if (!defined('_DOWN_ALL_REGISTERED')) DEFINE('_DOWN_ALL_REGISTERED','All Registered Users');
if (!defined('_DOWN_REG_ONLY_TITLE')) DEFINE('_DOWN_REG_ONLY_TITLE','Registered Only');
if (!defined('_DOWN_PUBLIC_TITLE')) DEFINE('_DOWN_PUBLIC_TITLE','Public');
if (!defined('_DOWN_APPROVE_TITLE')) DEFINE('_DOWN_APPROVE_TITLE','Files For Approval');
if (!defined('_DOWN_DATE')) DEFINE('_DOWN_DATE','Date');
if (!defined('_DOWN_NAME_TITLE')) DEFINE('_DOWN_NAME_TITLE','Name');
if (!defined('_DOWN_CONFIG_TITLE')) DEFINE('_DOWN_CONFIG_TITLE','Config');
if (!defined('_DOWN_CONFIG_TITLE1')) DEFINE('_DOWN_CONFIG_TITLE1','Paths/misc');
if (!defined('_DOWN_CONFIG_TITLE2')) DEFINE('_DOWN_CONFIG_TITLE2','Choices');
if (!defined('_DOWN_CONFIG_TITLE3')) DEFINE('_DOWN_CONFIG_TITLE3','D/L text');
if (!defined('_DOWN_CONFIG_TITLE4')) DEFINE('_DOWN_CONFIG_TITLE4','Customize');
if (!defined('_DOWN_CONFIG_TITLE_PREAMBLE')) DEFINE('_DOWN_CONFIG_TITLE_PREAMBLE','Intro');
if (!defined('_DOWN_CONFIG1')) DEFINE("_DOWN_CONFIG1","TabClass:<br /><em>(MOS CSS alternating row colors (Two Comma Separated Values))</em>");
if (!defined('_DOWN_CONFIG2')) DEFINE("_DOWN_CONFIG2","TabHeader:<br /><em>(MOS CSS Page header and Admin panel background)</em>");
if (!defined('_DOWN_CONFIG3')) DEFINE("_DOWN_CONFIG3","Web_Down_Path:<br /><em>(Downloads Storage Path - Web - NO Trailing Slash)</em>");
if (!defined('_DOWN_CONFIG4')) DEFINE("_DOWN_CONFIG4","Down_Path:<br /><em>(Downloads Storage Path - File - NO Trailing Slash)</em>");
if (!defined('_DOWN_CONFIG5')) DEFINE("_DOWN_CONFIG5","Up_Path:<br /><em>(Upload Storage Path File - NO Trailing Slash)</em>");
if (!defined('_DOWN_CONFIG6')) DEFINE("_DOWN_CONFIG6","MaxSize:<br /><em>(Max Upload filesize allowed in kB's)</em>");
if (!defined('_DOWN_CONFIG7')) DEFINE("_DOWN_CONFIG7","Max_Up_Per_Day:<br /><em>(Max Number of Uploads allowed for a User in a day (Admin is unlimited))</em>");
if (!defined('_DOWN_CONFIG8')) DEFINE("_DOWN_CONFIG8","Max_Up_Dir_Space:<br /><em>(Max Upload Directory Space Available in kB's)</em>");
if (!defined('_DOWN_CONFIG9')) DEFINE("_DOWN_CONFIG9","ExtsOk:<br /><em>(Allowed extensions for Uploads (Comma Separated List))</em>");
if (!defined('_DOWN_CONFIG10')) DEFINE("_DOWN_CONFIG10","Allowed_Desc_Tags:<br /><em>(Allowed File Desc HTML Tags (Comma Separated List))</em>");
if (!defined('_DOWN_CONFIG11')) DEFINE("_DOWN_CONFIG11","Allow_Up_Overwrite:<br /><em>(Allow new uploads to overwrite existing files)</em>");
if (!defined('_DOWN_CONFIG12')) DEFINE("_DOWN_CONFIG12","Allow_User_Sub:<br /><em>(Allow Users to Submit Files - Files Will Need to Be Approved by Admin)</em>");
if (!defined('_DOWN_CONFIG13')) DEFINE("_DOWN_CONFIG13","Allow_User_Edit:<br /><em>(Allow Users to Edit Their Submitted Files - Files Will Need to Be Re-Approved by Admin)</em>");
if (!defined('_DOWN_CONFIG14')) DEFINE("_DOWN_CONFIG14","Allow_User_Up:<br /><em>(Allow Users to Upload Files - Files Will Need to Be Approved by Admin)</em>");
if (!defined('_DOWN_CONFIG15')) DEFINE("_DOWN_CONFIG15","Allow_Comments:<br /><em>(Allow Users to leave comments on Files)</em>");
if (!defined('_DOWN_CONFIG16')) DEFINE("_DOWN_CONFIG16","Send_Sub_Mail:<br /><em>(Send an Email to the admin (or alternate) when a user submits a file)</em>");
if (!defined('_DOWN_CONFIG17')) DEFINE("_DOWN_CONFIG17","Sub_Mail_Alt_Addr:<br /><em>(Alternate Email address to send notices of submits to, otherwise admin email will be used)</em>");
if (!defined('_DOWN_CONFIG18')) DEFINE("_DOWN_CONFIG18","Sub_Mail_Alt_Name:<br /><em>(Alternate Recipient name for submit notices)</em>");
if (!defined('_DOWN_CONFIG19')) DEFINE("_DOWN_CONFIG19","HeaderPic:<br /><em>(Header Graphic)</em>");
if (!defined('_DOWN_CONFIG20')) DEFINE("_DOWN_CONFIG20","Anti-Leach:<br /><em>(Hide files to prevent direct linking)</em>");
if (!defined('_DOWN_CONFIG21')) DEFINE("_DOWN_CONFIG21","Large_Text_Len:<br /><em>(Max Stored Length of Large Text Fields (Desc/License))</em>");
if (!defined('_DOWN_CONFIG22')) DEFINE("_DOWN_CONFIG22","Small_Text_Len:<br /><em>(Max Stored Length of Small Input/Text Fields)</em>");
if (!defined('_DOWN_CONFIG23')) DEFINE("_DOWN_CONFIG23","Small_Image_Width:<br /><em>(Small Screenshot Width)</em>");
if (!defined('_DOWN_CONFIG24')) DEFINE("_DOWN_CONFIG24","Small_Image_Height:<br /><em>(Small Screenshot Height)</em>");
if (!defined('_DOWN_CONFIG25')) DEFINE("_DOWN_CONFIG25","Allow_Votes:<br /><em>(Allow Users to leave votes on Files)</em>");
if (!defined('_DOWN_CONFIG26')) DEFINE("_DOWN_CONFIG26","Enable_Admin_Autoapp:<br /><em>(Uploads by ADMIN to be automatically approved and published)</em>");
if (!defined('_DOWN_CONFIG27')) DEFINE("_DOWN_CONFIG27","Enable_User_Autoapp:<br /><em>(Uploads by registered users auto approved and published)</em>");
if (!defined('_DOWN_CONFIG28')) DEFINE("_DOWN_CONFIG28","Enable_List_Downloads:<br /><em>(Allow downloads from lists of files in category/folder)</em>");
if (!defined('_DOWN_CONFIG29')) DEFINE("_DOWN_CONFIG29","Allow users to submit remote files:<br /><em>(Files that are hosted somewhere else)</em>");
if (!defined('_DOWN_CONFIG30')) DEFINE("_DOWN_CONFIG30","Favourites_Max:<br /><em>(Allow Users to record this many favourite files)</em>");
if (!defined('_DOWN_CONFIG31')) DEFINE("_DOWN_CONFIG31","Date_Format:<br /><em>(Format for Remository dates - PHP date function parameter 1)</em>");
if (!defined('_DOWN_CONFIG32')) DEFINE("_DOWN_CONFIG32","Default_Version:<br /><em>(Default value to give file version on new submission)</em>");
if (!defined('_DOWN_CONFIG33')) DEFINE('_DOWN_CONFIG33','See_Containers_no_download:<br /><em>(Allow users to see categories/folders where they cannot download)</em>');
if (!defined('_DOWN_CONFIG34')) DEFINE('_DOWN_CONFIG34','See_Files_no_download:<br /><em>(Allow users to see files they cannot download)</em>');
if (!defined('_DOWN_CONFIG35')) DEFINE('_DOWN_CONFIG35','Max_Thumbnails:<br /><em>(Maximum thumbnail images to be stored; 0 for URL only)</em>');
if (!defined('_DOWN_CONFIG36')) DEFINE("_DOWN_CONFIG36","Large_Image_Width:<br /><em>(Large Screenshot Width)</em>");
if (!defined('_DOWN_CONFIG37')) DEFINE("_DOWN_CONFIG37","Large_Image_Height:<br /><em>(Large Screenshot Height)</em>");
if (!defined('_DOWN_CONFIG38')) DEFINE("_DOWN_CONFIG38","Allow Large Image Display:<br /><em>(Large Screenshot popup window)</em>");
if (!defined('_DOWN_CONFIG39')) DEFINE("_DOWN_CONFIG39","Use_Database:<br /><em>(Store files in database, by default)</em>");
if (!defined('_DOWN_CONFIG40')) DEFINE("_DOWN_CONFIG40","Max_Down_Per_Day:<br /><em>(Max Number of Downloads allowed for a User in a day (Admin is unlimited))</em>");
if (!defined('_DOWN_CONFIG41')) DEFINE("_DOWN_CONFIG41","Max_Down_File_Day:<br /><em>(Max Downloads of one file allowed per User per day (Admin is unlimited))</em>");
if (!defined('_DOWN_CONFIG42')) DEFINE("_DOWN_CONFIG42","Allow_User_Delete:<br /><em>(Is file submitter allowed to delete the file?)</em>");
if (!defined('_DOWN_CONFIG43')) DEFINE('_DOWN_CONFIG43','Make_Auto_Thumbnail:<br /><em>(Automatically create thumbnails for image files)</em>');
if (!defined('_DOWN_CONFIG44')) DEFINE("_DOWN_CONFIG44","Max_Down_Reg_Day:<br /><em>(Max Number of Downloads allowed for a Registered User in a day (Admin is unlimited))</em>");
if (!defined('_DOWN_STATS_TITLE')) DEFINE('_DOWN_STATS_TITLE','Stats');
if (!defined('_DOWN_TOP_TITLE')) DEFINE('_DOWN_TOP_TITLE','Top');
if (!defined('_DOWN_RATED_TITLE')) DEFINE('_DOWN_RATED_TITLE','Rated');
if (!defined('_DOWN_VOTED_ON')) DEFINE('_DOWN_VOTED_ON','Voted On');
if (!defined('_DOWN_VOTES_TITLE')) DEFINE('_DOWN_VOTES_TITLE','Votes');
if (!defined('_DOWN_RATING_TITLE')) DEFINE('_DOWN_RATING_TITLE','Rating');
if (!defined('_DOWN_ABOUT')) DEFINE('_DOWN_ABOUT','About');
if (!defined('_DOWN_SUPPORT')) DEFINE('_DOWN_SUPPORT','Support');
if (!defined('_DOWN_ABOUT_DESCRIBE')) DEFINE('_DOWN_ABOUT_DESCRIBE','Remository - An Aliro/Joomla File Repository');
if (!defined('_DOWN_TITLE_ABOUT')) DEFINE('_DOWN_TITLE_ABOUT','Title');
if (!defined('_DOWN_VERSION_ABOUT')) DEFINE('_DOWN_VERSION_ABOUT','Version');
if (!defined('_DOWN_AUTHOR_ABOUT')) DEFINE('_DOWN_AUTHOR_ABOUT','Author');
if (!defined('_DOWN_WEBSITE_ABOUT')) DEFINE('_DOWN_WEBSITE_ABOUT','WebSite');
if (!defined('_DOWN_EMAIL_ABOUT')) DEFINE('_DOWN_EMAIL_ABOUT','EMail');
if (!defined('_DOWN_SEL_FILE_APPROVE')) DEFINE('_DOWN_SEL_FILE_APPROVE','Select a file to approve');
if (!defined('_DOWN_DESC_SMALL')) DEFINE('_DOWN_DESC_SMALL','Short Description:');
if (!defined('_DOWN_DESC_SMALL_MAX')) DEFINE('_DOWN_DESC_SMALL_MAX','Max: 150 Chars');
if (!defined('_DOWN_AUTO_SHORT')) DEFINE('_DOWN_AUTO_SHORT','Autogenerate Short Desc:');
if (!defined('_DOWN_LICENSE')) DEFINE('_DOWN_LICENSE','License:');
if (!defined('_DOWN_LICENSE_AGREE')) DEFINE('_DOWN_LICENSE_AGREE','Must Agree to License:');
if (!defined('_DOWN_LEECH_WARN')) DEFINE('_DOWN_LEECH_WARN','Your session was not validated and anti-leach measures are in effect.');
if (!defined('_DOWN_LICENSE_WARN')) DEFINE('_DOWN_LICENSE_WARN','Please read/accept license to download.');
if (!defined('_DOWN_LICENSE_CHECKBOX')) DEFINE('_DOWN_LICENSE_CHECKBOX','I agree to the above terms.');
if (!defined('_DOWN_DATE_FORMAT')) DEFINE("_DOWN_DATE_FORMAT","%d %B %Y"); //Uses PHP's strftime Command Format
if (!defined('_DOWN_FILE_NOTFOUND')) DEFINE('_DOWN_FILE_NOTFOUND','File Not Found');
if (!defined('_DOWN_ACCESS_GROUP')) DEFINE('_DOWN_ACCESS_GROUP','Permitted group:');
if (!defined('_DOWN_THUMB_WRONG_TYPE')) DEFINE('_DOWN_THUMB_WRONG_TYPE','<h3>Thumbnail images must be png, jpg or jpeg</h3>');
if (!defined('_DOWN_EXTENSION_IN_TITLE')) DEFINE('_DOWN_EXTENSION_IN_TITLE','Extension in title');
if (!defined('_DOWN_INHERIT')) DEFINE('_DOWN_INHERIT','Descendant containers to inherit?');
if (!defined('_DOWN_FORCE_INHERIT')) DEFINE('_DOWN_FORCE_INHERIT','Force children to inherit starred');
if (!defined('_DOWN_EXT_IN_TITLE')) DEFINE('_DOWN_EXT_IN_TITLE','Extension in title');
if (!defined('_DOWN_BULK_ADD_FILES')) DEFINE('_DOWN_BULK_ADD_FILES','bulk add files from download directory');
if (!defined('_DOWN_NO_AVAILABLE_FILES')) DEFINE('_DOWN_NO_AVAILABLE_FILES','No available files');
if (!defined('_DOWN_ABS_PATH_TO_FILES')) DEFINE('_DOWN_ABS_PATH_TO_FILES','Absolute path to files:');
if (!defined('_DOWN_ACCEPTABLE_EXTENSIONS')) DEFINE('_DOWN_ACCEPTABLE_EXTENSIONS','Acceptable extensions (comma separated):');
if (!defined('_DOWN_EXTENSION_IN_TITLE')) DEFINE('_DOWN_EXTENSION_IN_TITLE','Extension included in title:');
if (!defined('_DOWN_DOWNLOAD_TEXT_BOX')) DEFINE('_DOWN_DOWNLOAD_TEXT_BOX','Download Text Box</b>&nbsp;<br>
	<i>description:</i><br>This text appears when an authorized user requests the download page.  Typically this is used for notices, ads, etc.  HTML / javascript entries are allowed - an example google adblock entry is included as a sample. Feel free to replace to suit your needs, or leave the sample adblock to support remository development.<b>');
if (!defined('_DOWN_MAIN_PREAMBLE')) DEFINE('_DOWN_MAIN_PREAMBLE', 'Text for main page');
if (!defined('_DOWN_PRUNE_LOG')) DEFINE('_DOWN_PRUNE_LOG','Prune the log file');
if (!defined('_DOWN_LOGFILE_CUTOFF_DATE')) DEFINE('_DOWN_LOGFILE_CUTOFF_DATE','Please enter the date before which all log file entries are to be deleted:');
if (!defined('_DOWN_PRESS_SAVE_ACTIVATE')) DEFINE('_DOWN_PRESS_SAVE_ACTIVATE','then press "Save" to activate.');
if (!defined('_DOWN_METHOD_NOT_PRESENT')) DEFINE('_DOWN_METHOD_NOT_PRESENT','Component %s error: attempt to use non-existent method %s in %s');
if (!defined('_DOWN_CLASS_NOT_PRESENT')) DEFINE('_DOWN_CLASS_NOT_PRESENT','Component %s error: attempt to use non-existent class %s');
if (!defined('_DOWN_NO_UPLOAD_TO_FILES')) DEFINE('_DOWN_NO_UPLOAD_TO_FILES','Cannot bulk upload to a container with a filepath');
if (!defined('_DOWN_COUNTS_RECALCULATED')) DEFINE('_DOWN_COUNTS_RECALCULATED','File and folder counts recalculated');
if (!defined('_DOWN_COUNTS_RESET')) DEFINE('_DOWN_COUNTS_RESET','File download counts reset');
if (!defined('_DOWN_OLD_LOG_REMOVED')) DEFINE('_DOWN_OLD_LOG_REMOVED','Log file entries earlier than %s removed.');
if (!defined('_DOWN_NONE_MISSING')) DEFINE('_DOWN_NONE_MISSING','No missing files');
if (!defined('_DOWN_BLOB_NOCHUNKS')) DEFINE('_DOWN_BLOB_NOCHUNKS',' - BLOB TABLE HAS 0 CHUNKS');
if (!defined('_DOWN_CHUNKS_DISCREPANCY')) DEFINE('_DOWN_CHUNKS_DISCREPANCY',' - BLOB TABLE HAS %s CHUNKS, FILE SAYS %s');
if (!defined('_DOWN_PLAINTEXT_DISCREPANCY')) DEFINE('_DOWN_PLAINTEXT_DISCREPANCY',' - PLAIN TEXT TABLE HAS %s ENTRIES, SHOULD BE EXACTLY 1');
if (!defined('_DOWN_NOT_FOUND_HERE')) DEFINE('_DOWN_NOT_FOUND_HERE',' - NOT FOUND AT THIS LOCATION<br />');
if (!defined('_DOWN_LOCAL_NO_URL')) DEFINE('_DOWN_LOCAL_NO_URL','FILE NOT LOCAL, BUT NO URL SPECIFIED');
if (!defined('_DOWN_NOT_VALID_BR')) DEFINE('_DOWN_NOT_VALID_BR',' - NOT VALIDATED<br />');
if (!defined('_DOWN_NO_RELEVANT_THUMB')) DEFINE('_DOWN_NO_RELEVANT_THUMB',' - no relevant files - removal attempted.<br />');
if (!defined('_DOWN_THUMB_NOT_BELONG')) DEFINE('_DOWN_THUMB_NOT_BELONG','%s in directory %s file does not belong - removal attempted.<br />');
if (!defined('_DOWN_THUMB_NOT_IN_DB')) DEFINE('_DOWN_THUMB_NOT_IN_DB',' - no match in database - removal attempted.<br />');
if (!defined('_DOWN_THUMB_OK')) DEFINE('_DOWN_THUMB_OK','No problems found with thumbnail files');
if (!defined('_DOWN_DB_CONVERT_OK')) DEFINE('_DOWN_DB_CONVERT_OK','Database conversion completed.  Any files listed above were invalid.');
if (!defined('_DOWN_ADD_NUMBER_FILES')) DEFINE('_DOWN_ADD_NUMBER_FILES','Add a number of files');
if (!defined('_DOWN_DISPLAY_NUMBER')) DEFINE('_DOWN_DISPLAY_NUMBER','Display #');
if (!defined('_DOWN_SEARCH_COLON')) DEFINE('_DOWN_SEARCH_COLON','Search');
if (!defined('_DOWN_SHOW_DESCENDANTS')) DEFINE('_DOWN_SHOW_DESCENDANTS','Show descendants: ');
if (!defined('_DOWN_CLICK_TO_VISIT')) DEFINE('_DOWN_CLICK_TO_VISIT','Click to visit site');
if (!defined('_DOWN_CONTAINERS')) DEFINE('_DOWN_CONTAINERS','Containers');
if (!defined('_DOWN_UP_PLAIN_TEXT')) DEFINE('_DOWN_UP_PLAIN_TEXT','Files are suitable for storage as plain text?');
if (!defined('_GLOBAL')) DEFINE('_GLOBAL','Global');
if (!defined('_DOWN_KEYWORDS')) DEFINE('_DOWN_KEYWORDS', 'Keywords:');
if (!defined('_DOWN_WINDOW_TITLE')) DEFINE('_DOWN_WINDOW_TITLE','Window Title:');
if (!defined('_DOWN_EDITOR_GROUP')) DEFINE('_DOWN_EDITOR_GROUP','Editor Group:');
if (!defined('_DOWN_AUTO_FOR_ADMIN')) DEFINE('_DOWN_AUTO_FOR_ADMIN','Auto-approve for Admin:');
if (!defined('_DOWN_AUTO_FOR_USERS')) DEFINE('_DOWN_AUTO_FOR_USERS','Auto-approve for Users:');
if (!defined('_DOWN_AUTO_USER_GROUP')) DEFINE('_DOWN_AUTO_USER_GROUP','Auto-approve user group:');
if (!defined('_DOWN_CONTAINER_CASCADE')) DEFINE('_DOWN_CONTAINER_CASCADE','Apply to all child folders:');
if (!defined('_DOWN_THANK_YOU')) DEFINE('_DOWN_THANK_YOU','Thank you for downloading ');
if (!defined('_DOWN_WAIT_OR_CLICK')) DEFINE('_DOWN_WAIT_OR_CLICK','If your download does not start automatically after a few seconds, please click on the Download link above');
if (!defined('_DOWN_UPDATE_THUMBNAILS')) DEFINE('_DOWN_UPDATE_THUMBNAILS','Update thumbnails');
if (!defined('_DOWN_DELETE_THUMBNAIL')) DEFINE('_DOWN_DELETE_THUMBNAIL','Delete thumbnail');
if (!defined('_DOWN_SUBMIT_NEW_THUMBNAIL')) DEFINE('_DOWN_SUBMIT_NEW_THUMBNAIL','Submit new thumbnail');
if (!defined('_DOWN_NOT_LOGGED_UPLOAD')) DEFINE('_DOWN_NOT_LOGGED_UPLOAD','Sorry, you are not permitted to upload.  Please sign in or register.');
if (!defined('_DOWN_NOT_LOGGED_COMMENT')) DEFINE('_DOWN_NOT_LOGGED_COMMENT','Sorry, you are not permitted to comment.  Please sign in or register.');
if (!defined('_DOWN_NOT_LOGGED_VOTE')) DEFINE('_DOWN_NOT_LOGGED_VOTE','Sorry, you are not permitted to vote.  Please sign in or register.');
if (!defined('_DOWN_COMMENT_NL')) DEFINE('_DOWN_COMMENT_NL','Please login or register to make your own comment');

// Define some summaries for tables
if (!defined('_TABLE_SUMMARY_GENHEAD')) DEFINE ('_TABLE_SUMMARY_GENHEAD', 'Listing of download categories available and the number of files in each category.');
if (!defined('_TABLE_SUMMARY_ADDMANYFILES')) DEFINE ('_TABLE_SUMMARY_ADDMANYFILES', 'This table allows you to select many files to upload.');
if (!defined('_DOWNLOAD_UPLOAD_TITLE')) DEFINE('_DOWNLOAD_UPLOAD_TITLE','Upload A File');
if (!defined('_HEAD')) DEFINE('_HEAD','Upload A File');
if (!defined('_FILE')) DEFINE('_FILE','Upload file:');
if (!defined('_CLOSE')) DEFINE('_CLOSE','Close');
if (!defined('_SENDFILE')) DEFINE('_SENDFILE','Send File');
if (!defined('_ERR1')) DEFINE('_ERR1','This File was unspecified.');
if (!defined('_ERR2')) DEFINE('_ERR2','File Upload Attack');
if (!defined('_ERR3')) DEFINE('_ERR3','The file you attempted to upload is zero length!');
if (!defined('_ERR4')) DEFINE('_ERR4','You attempted to upload a file with a disallowed extension!');
if (!defined('_ERR5')) DEFINE('_ERR5','The file you attempted to upload exceeded the maximum file size of ');
if (!defined('_ERR6')) DEFINE('_ERR6','The file you attempted to upload already exists. Please specify a new filename.');
if (!defined('_ERR7')) DEFINE('_ERR7','The Upload Directory is currently full.');
if (!defined('_ERR8')) DEFINE('_ERR8','You must be an Admin or Registered User to Upload.');
if (!defined('_ERR9')) DEFINE('_ERR9','You have reached your daily upload limit.');
if (!defined('_ERR10')) DEFINE('_ERR10','User Uploads are Not Allowed.');
if (!defined('_ERR11')) DEFINE('_ERR11','File upload failed with code ');
if (!defined('_UP_SUCCESS')) DEFINE('_UP_SUCCESS','File Upload Sucess!');
if (!defined('_UPLOAD_URL_LOCK')) DEFINE('_UPLOAD_URL_LOCK','-File Uploaded-');
if (!defined('_WARNING1')) DEFINE('_WARNING1','Path for files changed - WARNING files not moved');
if (!defined('_WARNING2')) DEFINE('_WARNING2','Specified file path does not exist - Create new : ');
if (!defined('_APPROVE')) DEFINE('_APPROVE','Approve');
if (!defined('_CANCEL')) DEFINE('_CANCEL','Cancel');
if (!defined('_DOWN_MISSING_TITLE')) DEFINE('_DOWN_MISSING_TITLE','Missing Files');
if (!defined('_MBT_GROUP_MANAGER')) DEFINE('_MBT_GROUP_MANAGER','Group Manager');
if (!defined('_MBT_GROUP_FILTER')) DEFINE('_MBT_GROUP_FILTER','Filter by Name');
if (!defined('_MBT_GROUP_GROUP')) DEFINE('_MBT_GROUP_GROUP','Group');
if (!defined('_MBT_GROUP_DESCRIPTION')) DEFINE('_MBT_GROUP_DESCRIPTION','Description');
if (!defined('_MBT_GROUP_EMAIL')) DEFINE('_MBT_GROUP_EMAIL','Email to group');
if (!defined('_MBT_GROUP_ADD')) DEFINE('_MBT_GROUP_ADD','Add Group');
if (!defined('_MBT_GROUP_EDIT')) DEFINE('_MBT_GROUP_EDIT','Edit Group');
if (!defined('_MBT_GROUP_NAME')) DEFINE('_MBT_GROUP_NAME','Name');
if (!defined('_MBT_GROUP_AVAI_USER')) DEFINE('_MBT_GROUP_AVAI_USER','Available users');
if (!defined('_MBT_GROUP_SEL_USER')) DEFINE('_MBT_GROUP_SEL_USER','Members in this group');
if (!defined('_MBT_GROUP_MEMBERS')) DEFINE('_MBT_GROUP_MEMBERS','Members');
if (!defined('_MBT_GROUP_SUBJECT')) DEFINE('_MBT_GROUP_SUBJECT','Subject');
if (!defined('_MBT_GROUP_MESSAGE')) DEFINE('_MBT_GROUP_MESSAGE','Message');
if (!defined('_MBT_GROUP_SEND')) DEFINE('_MBT_GROUP_SEND','Send');
if (!defined('_MBT_GROUP_MISS_SUB')) DEFINE('_MBT_GROUP_MISS_SUB','Please input Subject');
if (!defined('_MBT_GROUP_MISS_MSG')) DEFINE('_MBT_GROUP_MISS_MSG','Please input Message');
if (!defined('_MBT_GROUP_MISS_GROUP')) DEFINE('_MBT_GROUP_MISS_GROUP','Please input Name of group');
if (!defined('_MBT_GROUP_SEND_ADMIN')) DEFINE('_MBT_GROUP_SEND_ADMIN','Only administrators have permission to send email!');
if (!defined('_MBT_GROUP_SEND_NOTARGET')) DEFINE('_MBT_GROUP_SEND_NOTARGET','There is no target email in group');
if (!defined('_MBT_GROUP_SEND_OK')) DEFINE('_MBT_GROUP_SEND_OK','Mail is sent to');
if (!defined('_MBT_GROUP_SEND_USERS')) DEFINE('_MBT_GROUP_SEND_USERS','Users');

// Recent additions 3.56
if (!defined('_DOWN_EDIT_CLASSIFICATION')) DEFINE ('_DOWN_EDIT_CLASSIFICATION', 'Edit Classification');
if (!defined('_DOWN_CLASSIFICATION')) DEFINE ('_DOWN_CLASSIFICATION', 'Classification');
if (!defined('_DOWN_CONTAINER_PUBLISHED')) DEFINE ('_DOWN_CONTAINER_PUBLISHED', 'Container successfully published');
if (!defined('_DOWN_CONTAINERS_PUBLISHED')) DEFINE ('_DOWN_CONTAINERS_PUBLISHED', 'Containers successfully published');
if (!defined('_DOWN_CONTAINER_UNPUBLISHED')) DEFINE ('_DOWN_CONTAINER_UNPUBLISHED', 'Container successfully unpublished');
if (!defined('_DOWN_CONTAINERS_UNPUBLISHED')) DEFINE ('_DOWN_CONTAINERS_UNPUBLISHED', 'Containers successfully unpublished');
if (!defined('_DOWN_CONTAINER_SAVED')) DEFINE ('_DOWN_CONTAINER_SAVED', 'Container saved successfully');
if (!defined('_DOWN_CONTAINER_DELETED')) DEFINE ('_DOWN_CONTAINER_DELETED', 'Container deleted successfully');
if (!defined('_DOWN_CONTAINERS_DELETED')) DEFINE ('_DOWN_CONTAINERS_DELETED', 'Containers deleted successfully');
if (!defined('_DOWN_FILE_PUBLISHED')) DEFINE ('_DOWN_FILE_PUBLISHED', 'File successfully published');
if (!defined('_DOWN_FILES_PUBLISHED')) DEFINE ('_DOWN_FILES_PUBLISHED', 'Files successfully published');
if (!defined('_DOWN_FILE_UNPUBLISHED')) DEFINE ('_DOWN_FILE_UNPUBLISHED', 'File successfully unpublished');
if (!defined('_DOWN_FILES_UNPUBLISHED')) DEFINE ('_DOWN_FILES_UNPUBLISHED', 'Files successfully unpublished');
if (!defined('_DOWN_FILE_SAVED')) DEFINE ('_DOWN_FILE_SAVED', 'File saved successfully');
if (!defined('_DOWN_FILE_DELETED')) DEFINE ('_DOWN_FILE_DELETED', 'File deleted successfully');
if (!defined('_DOWN_FILES_DELETED')) DEFINE ('_DOWN_FILES_DELETED', 'Files deleted successfully');
if (!defined('_DOWN_FILE_LOCALISED')) DEFINE ('_DOWN_FILE_LOCALISED', 'File localised successfully');
if (!defined('_DOWN_GROUP_MEMBER_SAVED')) DEFINE ('_DOWN_GROUP_MEMBER_SAVED', 'Group member added successfully');
if (!defined('_DOWN_GROUP_MEMBERS_SAVED')) DEFINE ('_DOWN_GROUP_MEMBERS_SAVED', 'Group members added successfully');
if (!defined('_DOWN_GROUP_MEMBER_DELETED')) DEFINE ('_DOWN_GROUP_MEMBER_DELETED', 'Member removed successfully');
if (!defined('_DOWN_GROUP_MEMBERS_DELETED')) DEFINE ('_DOWN_GROUP_MEMBERS_DELETED', 'Members removed successfully');
if (!defined('_DOWN_GROUP_DELETED')) DEFINE ('_DOWN_GROUP_DELETED', 'Group deleted successfully');
if (!defined('_DOWN_GROUPS_DELETED')) DEFINE ('_DOWN_GROUPS_DELETED', 'Groups deleted successfully');
if (!defined('_DOWN_ORPHAN_SINGLE_DONE')) DEFINE('_DOWN_ORPHAN_SINGLE_DONE','File Orphan Deleted');
if (!defined('_DOWN_CLASSIFICATION_PUBLISHED')) DEFINE ('_DOWN_CLASSIFICATION_PUBLISHED', 'Classification successfully published');
if (!defined('_DOWN_CLASSIFICATIONS_PUBLISHED')) DEFINE ('_DOWN_CLASSIFICATIONS_PUBLISHED', 'Classifications successfully published');
if (!defined('_DOWN_CLASSIFICATION_UNPUBLISHED')) DEFINE ('_DOWN_CLASSIFICATION_UNPUBLISHED', 'Classification successfully unpublished');
if (!defined('_DOWN_CLASSIFICATIONS_UNPUBLISHED')) DEFINE ('_DOWN_CLASSIFICATIONS_UNPUBLISHED', 'Classifications successfully unpublished');
if (!defined('_DOWN_CLASSIFICATION_SAVED')) DEFINE ('_DOWN_CLASSIFICATION_SAVED', 'Classification saved successfully');
if (!defined('_DOWN_CLASSIFICATION_DELETED')) DEFINE ('_DOWN_CLASSIFICATION_DELETED', 'Classification deleted successfully');
if (!defined('_DOWN_CLASSIFICATIONS_DELETED')) DEFINE ('_DOWN_CLASSIFICATIONS_DELETED', 'Classifications deleted successfully');
if (!defined('_DOWN_MISSING_DELETED')) DEFINE ('_DOWN_MISSING_DELETED', 'Missing file deleted successfully');
if (!defined('_DOWN_MISSINGS_DELETED')) DEFINE ('_DOWN_MISSINGS_DELETED', 'Missing files deleted successfully');
if (!defined('_SUBMIT_FILE_BUTTON_ADV')) DEFINE('_SUBMIT_FILE_BUTTON_ADV','AddFile');