<?php

/**************************************************************
* This file is part of Remository
* Copyright (c) 2006-17 Martin Brampton
* 
* License: GNU General Public License version 2 or later; see LICENSE.txt
* 
* For support and other information, visit http://remository.com
* To contact Martin Brampton, write to martin@remository.com
*
* Remository started life as the psx-dude script by psx-dude@psx-dude.net
* It was enhanced by Matt Smith up to version 2.10
* Since then development has been primarily by Martin Brampton,
* with contributions from other people gratefully accepted
*/

defined('_JEXEC') or die;

require_once(JPATH_SITE.'/components/com_remository/remository.interface.php');

// import the list field type
jimport('joomla.form.helper');
JFormHelper::loadFieldClass('list');
 
/**
 * Remository Form Field class for the Remository component
 */
class JFormFieldRemository extends JFormFieldList
{
	/**
	 * The field type.
	 *
	 * @var		string
	 */
	protected $type = 'Remository';
 
	/**
	 * Method to get a list of options for a list input.
	 *
	 * @return	array		An array of JHtml options.
	 */
	protected function getOptions() 
	{
		// Set autoloading for Remository
		// JALoader::getInstance()->jaAutoDiscover (_CMSAPI_ABSOLUTE_PATH.'/components/com_remository/classes');

		$messages = remositoryContainerManager::getInstance()->getCategories();
		$options = array();
		if ($messages)
		{
			foreach($messages as $message) 
			{
				$options[] = JHtml::_('select.option', $message->id, $message->name);
			}
		}
		$options = array_merge(parent::getOptions(), $options);
		return $options;
	}
}

class JFormFieldRemositorysort extends JFormFieldList
{
	/**
	 * The field type.
	 *
	 * @var		string
	 */
	protected $type = 'Remository';
 
	/**
	 * Method to get a list of options for a list input.
	 *
	 * @return	array		An array of JHtml options.
	 */
	protected function getOptions() 
	{
		// Set autoloading for Remository
		// JALoader::getInstance()->jaAutoDiscover (_CMSAPI_ABSOLUTE_PATH.'/components/com_remository/classes');

		// Possible values are 1 = File ID, 2 = File title, 3 = Download count (descending), 
		// 4 = Submit date (descending), 5 = User Name (submitter), 6 = Author, 
		// 7 = rating (descending)
		$options[] = JHtml::_('select.option', 0, 'Use default');
		$options[] = JHtml::_('select.option', 1, 'File ID');
		$options[] = JHtml::_('select.option', 2, 'File Title');
		$options[] = JHtml::_('select.option', 3, 'Downloads');
		$options[] = JHtml::_('select.option', 4, 'Submit Date');
		$options[] = JHtml::_('select.option', 5, 'User Name');
		$options[] = JHtml::_('select.option', 6, 'Author');
		$options[] = JHtml::_('select.option', 7, 'Rating');
		$options = array_merge(parent::getOptions(), $options);
		return $options;
	}
}
