<?php
/**
* Remository Searchbot - Extend the standard Mambo search function to include Remository files
* @version 3.50
* @package Remository Searchbot
* @copyright (C) 2009 Black Sheep Research
* @license GNU GPL version 2
**/

// Note executable code also exists after class definition
// Check to ensure this file is not invoked directly

defined( '_VALID_MOS' ) OR defined ( '_JEXEC' ) OR die( 'Direct Access to this location is not allowed.' );

$cmsapi_addon_topdir = 'mambots/plugins';
$cmsapi_addon_tops = explode('/', $cmsapi_addon_topdir);
$cmsapi_mydir = array_reverse(explode('/', str_replace('\\', '/', __FILE__)));
do $cmsapi_shifted = array_shift($cmsapi_mydir); while (!in_array($cmsapi_shifted, $cmsapi_addon_tops));
$cmsapi_absolute_path = implode('/', array_reverse($cmsapi_mydir));

require_once($cmsapi_absolute_path.'/components/com_remository/remository.interface.php');

// error_reporting(E_ALL);

if (defined('_JOOMLA_15PLUS')) {
	jimport( 'joomla.event.plugin' );
	jimport('joomla.html.parameter');

	class plgSearchRemository extends JPlugin  {
		protected $plugin_type = 'search';
	
		// This is not required if there is nothing to be done in the constructor
		// public function plgSearchRemository ($params) {
		//	parent::__construct( $params );
		// }

		public function onSearch ($searchword, $matchtype, $order, $selector) {
			if (!empty($selector) AND !in_array('plgSearchRemository', $selector)) return array();
		 	$worker = new remository_plugin_search();
		 	return $worker->onSearch ($this->params, $searchword, $matchtype, $order);
		}
		
		public function onContentSearch ($text, $phrase='', $ordering='', $areas=null) {
			if (!empty($areas) AND !in_array('remository', $areas)) return array();
			return $this->onSearch($text, $phrase, $ordering, array());
		}
		
		public function onSearchAreas () {
			return array ('plgSearchRemository' => 'Remository');
		}	

		public function onContentSearchAreas () {
			return array('remository' => 'Remository');
		}
	}

}
else {
	global $_MAMBOTS;	
	/** Register search function inside Mambo's API */
	$_MAMBOTS->registerFunction( 'onSearch', 'botSearchRemository' );
	
	function botSearchRemository ($text, $matchtype='', $order='') {
	 	$worker = new remository_plugin_search();
		// Get parameters from Database
		$query = "SELECT params FROM #__mambots WHERE element = 'plgSearchRemository' AND folder = 'search'";
		$database = remositoryInterface::getInstance()->getDB();
		$database->setQuery($query);
		$paramstring = $database->loadResult();
		$params = new mosParameters($paramstring);
	 	return $worker->onSearch ($params, $text, $matchtype, $order);
	}
}